package software.amazon.awscdk.services.codedeploy;

/**
 * Construction properties of {@link ServerDeploymentConfig}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-08T23:43:37.926Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ServerDeploymentConfigProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Minimum number of healthy hosts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts getMinimumHealthyHosts();
    /**
     * The physical, human-readable name of the Deployment Configuration.
     * 
     * Default: a name will be auto-generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getDeploymentConfigName();

    /**
     * @return a {@link Builder} of {@link ServerDeploymentConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ServerDeploymentConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts _minimumHealthyHosts;
        @javax.annotation.Nullable
        private java.lang.String _deploymentConfigName;

        /**
         * Sets the value of MinimumHealthyHosts
         * @param value Minimum number of healthy hosts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withMinimumHealthyHosts(final software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts value) {
            this._minimumHealthyHosts = java.util.Objects.requireNonNull(value, "minimumHealthyHosts is required");
            return this;
        }
        /**
         * Sets the value of DeploymentConfigName
         * @param value The physical, human-readable name of the Deployment Configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDeploymentConfigName(@javax.annotation.Nullable final java.lang.String value) {
            this._deploymentConfigName = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServerDeploymentConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ServerDeploymentConfigProps build() {
            return new ServerDeploymentConfigProps() {
                private final software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts $minimumHealthyHosts = java.util.Objects.requireNonNull(_minimumHealthyHosts, "minimumHealthyHosts is required");
                @javax.annotation.Nullable
                private final java.lang.String $deploymentConfigName = _deploymentConfigName;

                @Override
                public software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts getMinimumHealthyHosts() {
                    return this.$minimumHealthyHosts;
                }

                @Override
                public java.lang.String getDeploymentConfigName() {
                    return this.$deploymentConfigName;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("minimumHealthyHosts", om.valueToTree(this.getMinimumHealthyHosts()));
                    if (this.getDeploymentConfigName() != null) {
                        obj.set("deploymentConfigName", om.valueToTree(this.getDeploymentConfigName()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.ServerDeploymentConfigProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Minimum number of healthy hosts.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts getMinimumHealthyHosts() {
            return this.jsiiGet("minimumHealthyHosts", software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts.class);
        }

        /**
         * The physical, human-readable name of the Deployment Configuration.
         * 
         * Default: a name will be auto-generated
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getDeploymentConfigName() {
            return this.jsiiGet("deploymentConfigName", java.lang.String.class);
        }
    }
}
