package software.amazon.awscdk.services.codedeploy.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentconfig.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.cloudformation.DeploymentConfigResource")
public class DeploymentConfigResource extends software.amazon.awscdk.Resource {
    protected DeploymentConfigResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentConfigResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::CodeDeploy::DeploymentConfig``.
     * @param parent the ``cdk.Construct`` this ``DeploymentConfigResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``DeploymentConfigResource``
     */
    public DeploymentConfigResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentConfigResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(properties)).toArray());
    }
    /**
     * Creates a new ``AWS::CodeDeploy::DeploymentConfig``.
     * @param parent the ``cdk.Construct`` this ``DeploymentConfigResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     */
    public DeploymentConfigResource(final software.amazon.awscdk.Construct parent, final java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentconfig-minimumhealthyhosts.html
     */
    public static interface MinimumHealthyHostsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentConfigResource.MinimumHealthyHostsProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentconfig-minimumhealthyhosts.html#cfn-codedeploy-deploymentconfig-minimumhealthyhosts-type
         */
        java.lang.Object getType();
        /**
         * ``DeploymentConfigResource.MinimumHealthyHostsProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentconfig-minimumhealthyhosts.html#cfn-codedeploy-deploymentconfig-minimumhealthyhosts-type
         */
        void setType(final java.lang.String value);
        /**
         * ``DeploymentConfigResource.MinimumHealthyHostsProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentconfig-minimumhealthyhosts.html#cfn-codedeploy-deploymentconfig-minimumhealthyhosts-type
         */
        void setType(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentConfigResource.MinimumHealthyHostsProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentconfig-minimumhealthyhosts.html#cfn-codedeploy-deploymentconfig-minimumhealthyhosts-value
         */
        java.lang.Object getValue();
        /**
         * ``DeploymentConfigResource.MinimumHealthyHostsProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentconfig-minimumhealthyhosts.html#cfn-codedeploy-deploymentconfig-minimumhealthyhosts-value
         */
        void setValue(final java.lang.Number value);
        /**
         * ``DeploymentConfigResource.MinimumHealthyHostsProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentconfig-minimumhealthyhosts.html#cfn-codedeploy-deploymentconfig-minimumhealthyhosts-value
         */
        void setValue(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link MinimumHealthyHostsProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``DeploymentConfigResource.MinimumHealthyHostsProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentconfig-minimumhealthyhosts.html#cfn-codedeploy-deploymentconfig-minimumhealthyhosts-type
             */
            public ValueStep withType(final java.lang.String value) {
                return new FullBuilder().withType(value);
            }
            /**
             * ``DeploymentConfigResource.MinimumHealthyHostsProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentconfig-minimumhealthyhosts.html#cfn-codedeploy-deploymentconfig-minimumhealthyhosts-type
             */
            public ValueStep withType(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withType(value);
            }

            public interface ValueStep {
                /**
                 * ``DeploymentConfigResource.MinimumHealthyHostsProperty.Value``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentconfig-minimumhealthyhosts.html#cfn-codedeploy-deploymentconfig-minimumhealthyhosts-value
                 */
                Build withValue(final java.lang.Number value);
                /**
                 * ``DeploymentConfigResource.MinimumHealthyHostsProperty.Value``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentconfig-minimumhealthyhosts.html#cfn-codedeploy-deploymentconfig-minimumhealthyhosts-value
                 */
                Build withValue(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link MinimumHealthyHostsProperty} object, initialized with the values set on this builder.
                 */
                MinimumHealthyHostsProperty build();
            }

            final class FullBuilder implements ValueStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``DeploymentConfigResource.MinimumHealthyHostsProperty.Type``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentconfig-minimumhealthyhosts.html#cfn-codedeploy-deploymentconfig-minimumhealthyhosts-type
                 */
                public ValueStep withType(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "MinimumHealthyHostsProperty#type is required");
                    this.instance._type = value;
                    return this;
                }
                /**
                 * ``DeploymentConfigResource.MinimumHealthyHostsProperty.Type``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentconfig-minimumhealthyhosts.html#cfn-codedeploy-deploymentconfig-minimumhealthyhosts-type
                 */
                public ValueStep withType(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "MinimumHealthyHostsProperty#type is required");
                    this.instance._type = value;
                    return this;
                }
                /**
                 * ``DeploymentConfigResource.MinimumHealthyHostsProperty.Value``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentconfig-minimumhealthyhosts.html#cfn-codedeploy-deploymentconfig-minimumhealthyhosts-value
                 */
                public Build withValue(final java.lang.Number value) {
                    java.util.Objects.requireNonNull(value, "MinimumHealthyHostsProperty#value is required");
                    this.instance._value = value;
                    return this;
                }
                /**
                 * ``DeploymentConfigResource.MinimumHealthyHostsProperty.Value``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentconfig-minimumhealthyhosts.html#cfn-codedeploy-deploymentconfig-minimumhealthyhosts-value
                 */
                public Build withValue(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "MinimumHealthyHostsProperty#value is required");
                    this.instance._value = value;
                    return this;
                }
                public MinimumHealthyHostsProperty build() {
                    MinimumHealthyHostsProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link MinimumHealthyHostsProperty}.
         */
        final class Jsii$Pojo implements MinimumHealthyHostsProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _type;

            public java.lang.Object getType() {
                return this._type;
            }
            public void setType(final java.lang.String value) {
                this._type = value;
            }
            public void setType(final software.amazon.awscdk.Token value) {
                this._type = value;
            }

            protected java.lang.Object _value;

            public java.lang.Object getValue() {
                return this._value;
            }
            public void setValue(final java.lang.Number value) {
                this._value = value;
            }
            public void setValue(final software.amazon.awscdk.Token value) {
                this._value = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentConfigResource.MinimumHealthyHostsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``DeploymentConfigResource.MinimumHealthyHostsProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentconfig-minimumhealthyhosts.html#cfn-codedeploy-deploymentconfig-minimumhealthyhosts-type
             */
            public java.lang.Object getType() {
                return this.jsiiGet("type", java.lang.Object.class);
            }
            /**
             * ``DeploymentConfigResource.MinimumHealthyHostsProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentconfig-minimumhealthyhosts.html#cfn-codedeploy-deploymentconfig-minimumhealthyhosts-type
             */
            public void setType(final java.lang.String value) {
                this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
            }
            /**
             * ``DeploymentConfigResource.MinimumHealthyHostsProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentconfig-minimumhealthyhosts.html#cfn-codedeploy-deploymentconfig-minimumhealthyhosts-type
             */
            public void setType(final software.amazon.awscdk.Token value) {
                this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
            }
            /**
             * ``DeploymentConfigResource.MinimumHealthyHostsProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentconfig-minimumhealthyhosts.html#cfn-codedeploy-deploymentconfig-minimumhealthyhosts-value
             */
            public java.lang.Object getValue() {
                return this.jsiiGet("value", java.lang.Object.class);
            }
            /**
             * ``DeploymentConfigResource.MinimumHealthyHostsProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentconfig-minimumhealthyhosts.html#cfn-codedeploy-deploymentconfig-minimumhealthyhosts-value
             */
            public void setValue(final java.lang.Number value) {
                this.jsiiSet("value", java.util.Objects.requireNonNull(value, "value is required"));
            }
            /**
             * ``DeploymentConfigResource.MinimumHealthyHostsProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentconfig-minimumhealthyhosts.html#cfn-codedeploy-deploymentconfig-minimumhealthyhosts-value
             */
            public void setValue(final software.amazon.awscdk.Token value) {
                this.jsiiSet("value", java.util.Objects.requireNonNull(value, "value is required"));
            }
        }
    }
}
