package software.amazon.awscdk.services.codedeploy.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.cloudformation.DeploymentGroupResource")
public class DeploymentGroupResource extends software.amazon.awscdk.Resource {
    protected DeploymentGroupResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::CodeDeploy::DeploymentGroup``.
     * @param parent the ``cdk.Construct`` this ``DeploymentGroupResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``DeploymentGroupResource``
     */
    public DeploymentGroupResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html
     */
    public static interface AlarmConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentGroupResource.AlarmConfigurationProperty.Alarms``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-alarms
         */
        java.lang.Object getAlarms();
        /**
         * ``DeploymentGroupResource.AlarmConfigurationProperty.Alarms``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-alarms
         */
        void setAlarms(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentGroupResource.AlarmConfigurationProperty.Alarms``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-alarms
         */
        void setAlarms(final java.util.List<java.lang.Object> value);
        /**
         * ``DeploymentGroupResource.AlarmConfigurationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-enabled
         */
        java.lang.Object getEnabled();
        /**
         * ``DeploymentGroupResource.AlarmConfigurationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-enabled
         */
        void setEnabled(final java.lang.Boolean value);
        /**
         * ``DeploymentGroupResource.AlarmConfigurationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-enabled
         */
        void setEnabled(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentGroupResource.AlarmConfigurationProperty.IgnorePollAlarmFailure``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-ignorepollalarmfailure
         */
        java.lang.Object getIgnorePollAlarmFailure();
        /**
         * ``DeploymentGroupResource.AlarmConfigurationProperty.IgnorePollAlarmFailure``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-ignorepollalarmfailure
         */
        void setIgnorePollAlarmFailure(final java.lang.Boolean value);
        /**
         * ``DeploymentGroupResource.AlarmConfigurationProperty.IgnorePollAlarmFailure``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-ignorepollalarmfailure
         */
        void setIgnorePollAlarmFailure(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link AlarmConfigurationProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``DeploymentGroupResource.AlarmConfigurationProperty.Alarms``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-alarms
             */
            public Builder withAlarms(final software.amazon.awscdk.Token value) {
                this.instance._alarms = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.AlarmConfigurationProperty.Alarms``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-alarms
             */
            public Builder withAlarms(final java.util.List<java.lang.Object> value) {
                this.instance._alarms = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.AlarmConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-enabled
             */
            public Builder withEnabled(final java.lang.Boolean value) {
                this.instance._enabled = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.AlarmConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-enabled
             */
            public Builder withEnabled(final software.amazon.awscdk.Token value) {
                this.instance._enabled = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.AlarmConfigurationProperty.IgnorePollAlarmFailure``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-ignorepollalarmfailure
             */
            public Builder withIgnorePollAlarmFailure(final java.lang.Boolean value) {
                this.instance._ignorePollAlarmFailure = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.AlarmConfigurationProperty.IgnorePollAlarmFailure``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-ignorepollalarmfailure
             */
            public Builder withIgnorePollAlarmFailure(final software.amazon.awscdk.Token value) {
                this.instance._ignorePollAlarmFailure = value;
                return this;
            }
            public AlarmConfigurationProperty build() {
                AlarmConfigurationProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link AlarmConfigurationProperty}.
         */
        final class Jsii$Pojo implements AlarmConfigurationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _alarms;

            public java.lang.Object getAlarms() {
                return this._alarms;
            }
            public void setAlarms(final software.amazon.awscdk.Token value) {
                this._alarms = value;
            }
            public void setAlarms(final java.util.List<java.lang.Object> value) {
                this._alarms = value;
            }

            protected java.lang.Object _enabled;

            public java.lang.Object getEnabled() {
                return this._enabled;
            }
            public void setEnabled(final java.lang.Boolean value) {
                this._enabled = value;
            }
            public void setEnabled(final software.amazon.awscdk.Token value) {
                this._enabled = value;
            }

            protected java.lang.Object _ignorePollAlarmFailure;

            public java.lang.Object getIgnorePollAlarmFailure() {
                return this._ignorePollAlarmFailure;
            }
            public void setIgnorePollAlarmFailure(final java.lang.Boolean value) {
                this._ignorePollAlarmFailure = value;
            }
            public void setIgnorePollAlarmFailure(final software.amazon.awscdk.Token value) {
                this._ignorePollAlarmFailure = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.AlarmConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``DeploymentGroupResource.AlarmConfigurationProperty.Alarms``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-alarms
             */
            @javax.annotation.Nullable
            public java.lang.Object getAlarms() {
                return this.jsiiGet("alarms", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.AlarmConfigurationProperty.Alarms``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-alarms
             */
            public void setAlarms(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("alarms", value);
            }
            /**
             * ``DeploymentGroupResource.AlarmConfigurationProperty.Alarms``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-alarms
             */
            public void setAlarms(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("alarms", value);
            }
            /**
             * ``DeploymentGroupResource.AlarmConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-enabled
             */
            @javax.annotation.Nullable
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.AlarmConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-enabled
             */
            public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("enabled", value);
            }
            /**
             * ``DeploymentGroupResource.AlarmConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-enabled
             */
            public void setEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("enabled", value);
            }
            /**
             * ``DeploymentGroupResource.AlarmConfigurationProperty.IgnorePollAlarmFailure``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-ignorepollalarmfailure
             */
            @javax.annotation.Nullable
            public java.lang.Object getIgnorePollAlarmFailure() {
                return this.jsiiGet("ignorePollAlarmFailure", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.AlarmConfigurationProperty.IgnorePollAlarmFailure``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-ignorepollalarmfailure
             */
            public void setIgnorePollAlarmFailure(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("ignorePollAlarmFailure", value);
            }
            /**
             * ``DeploymentGroupResource.AlarmConfigurationProperty.IgnorePollAlarmFailure``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-ignorepollalarmfailure
             */
            public void setIgnorePollAlarmFailure(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ignorePollAlarmFailure", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarm.html
     */
    public static interface AlarmProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentGroupResource.AlarmProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarm.html#cfn-codedeploy-deploymentgroup-alarm-name
         */
        java.lang.Object getName();
        /**
         * ``DeploymentGroupResource.AlarmProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarm.html#cfn-codedeploy-deploymentgroup-alarm-name
         */
        void setName(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.AlarmProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarm.html#cfn-codedeploy-deploymentgroup-alarm-name
         */
        void setName(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link AlarmProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``DeploymentGroupResource.AlarmProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarm.html#cfn-codedeploy-deploymentgroup-alarm-name
             */
            public Builder withName(final java.lang.String value) {
                this.instance._name = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.AlarmProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarm.html#cfn-codedeploy-deploymentgroup-alarm-name
             */
            public Builder withName(final software.amazon.awscdk.Token value) {
                this.instance._name = value;
                return this;
            }
            public AlarmProperty build() {
                AlarmProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link AlarmProperty}.
         */
        final class Jsii$Pojo implements AlarmProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _name;

            public java.lang.Object getName() {
                return this._name;
            }
            public void setName(final java.lang.String value) {
                this._name = value;
            }
            public void setName(final software.amazon.awscdk.Token value) {
                this._name = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.AlarmProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``DeploymentGroupResource.AlarmProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarm.html#cfn-codedeploy-deploymentgroup-alarm-name
             */
            @javax.annotation.Nullable
            public java.lang.Object getName() {
                return this.jsiiGet("name", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.AlarmProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarm.html#cfn-codedeploy-deploymentgroup-alarm-name
             */
            public void setName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("name", value);
            }
            /**
             * ``DeploymentGroupResource.AlarmProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarm.html#cfn-codedeploy-deploymentgroup-alarm-name
             */
            public void setName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("name", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html
     */
    public static interface AutoRollbackConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-enabled
         */
        java.lang.Object getEnabled();
        /**
         * ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-enabled
         */
        void setEnabled(final java.lang.Boolean value);
        /**
         * ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-enabled
         */
        void setEnabled(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Events``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-events
         */
        java.lang.Object getEvents();
        /**
         * ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Events``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-events
         */
        void setEvents(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Events``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-events
         */
        void setEvents(final java.util.List<java.lang.Object> value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link AutoRollbackConfigurationProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-enabled
             */
            public Builder withEnabled(final java.lang.Boolean value) {
                this.instance._enabled = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-enabled
             */
            public Builder withEnabled(final software.amazon.awscdk.Token value) {
                this.instance._enabled = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Events``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-events
             */
            public Builder withEvents(final software.amazon.awscdk.Token value) {
                this.instance._events = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Events``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-events
             */
            public Builder withEvents(final java.util.List<java.lang.Object> value) {
                this.instance._events = value;
                return this;
            }
            public AutoRollbackConfigurationProperty build() {
                AutoRollbackConfigurationProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link AutoRollbackConfigurationProperty}.
         */
        final class Jsii$Pojo implements AutoRollbackConfigurationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _enabled;

            public java.lang.Object getEnabled() {
                return this._enabled;
            }
            public void setEnabled(final java.lang.Boolean value) {
                this._enabled = value;
            }
            public void setEnabled(final software.amazon.awscdk.Token value) {
                this._enabled = value;
            }

            protected java.lang.Object _events;

            public java.lang.Object getEvents() {
                return this._events;
            }
            public void setEvents(final software.amazon.awscdk.Token value) {
                this._events = value;
            }
            public void setEvents(final java.util.List<java.lang.Object> value) {
                this._events = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.AutoRollbackConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-enabled
             */
            @javax.annotation.Nullable
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-enabled
             */
            public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("enabled", value);
            }
            /**
             * ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-enabled
             */
            public void setEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("enabled", value);
            }
            /**
             * ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Events``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-events
             */
            @javax.annotation.Nullable
            public java.lang.Object getEvents() {
                return this.jsiiGet("events", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Events``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-events
             */
            public void setEvents(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("events", value);
            }
            /**
             * ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Events``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-events
             */
            public void setEvents(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("events", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html
     */
    public static interface DeploymentProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentGroupResource.DeploymentProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-description
         */
        java.lang.Object getDescription();
        /**
         * ``DeploymentGroupResource.DeploymentProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-description
         */
        void setDescription(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.DeploymentProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-description
         */
        void setDescription(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentGroupResource.DeploymentProperty.IgnoreApplicationStopFailures``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-ignoreapplicationstopfailures
         */
        java.lang.Object getIgnoreApplicationStopFailures();
        /**
         * ``DeploymentGroupResource.DeploymentProperty.IgnoreApplicationStopFailures``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-ignoreapplicationstopfailures
         */
        void setIgnoreApplicationStopFailures(final java.lang.Boolean value);
        /**
         * ``DeploymentGroupResource.DeploymentProperty.IgnoreApplicationStopFailures``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-ignoreapplicationstopfailures
         */
        void setIgnoreApplicationStopFailures(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentGroupResource.DeploymentProperty.Revision``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision
         */
        java.lang.Object getRevision();
        /**
         * ``DeploymentGroupResource.DeploymentProperty.Revision``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision
         */
        void setRevision(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentGroupResource.DeploymentProperty.Revision``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision
         */
        void setRevision(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.RevisionLocationProperty value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link DeploymentProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``DeploymentGroupResource.DeploymentProperty.Revision``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision
             */
            public Build withRevision(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withRevision(value);
            }
            /**
             * ``DeploymentGroupResource.DeploymentProperty.Revision``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision
             */
            public Build withRevision(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.RevisionLocationProperty value) {
                return new FullBuilder().withRevision(value);
            }

            public interface Build {
                /**
                 * @return a new {@link DeploymentProperty} object, initialized with the values set on this builder.
                 */
                DeploymentProperty build();
                /**
                 * ``DeploymentGroupResource.DeploymentProperty.Description``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-description
                 */
                Build withDescription(final java.lang.String value);
                /**
                 * ``DeploymentGroupResource.DeploymentProperty.Description``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-description
                 */
                Build withDescription(final software.amazon.awscdk.Token value);
                /**
                 * ``DeploymentGroupResource.DeploymentProperty.IgnoreApplicationStopFailures``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-ignoreapplicationstopfailures
                 */
                Build withIgnoreApplicationStopFailures(final java.lang.Boolean value);
                /**
                 * ``DeploymentGroupResource.DeploymentProperty.IgnoreApplicationStopFailures``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-ignoreapplicationstopfailures
                 */
                Build withIgnoreApplicationStopFailures(final software.amazon.awscdk.Token value);
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``DeploymentGroupResource.DeploymentProperty.Description``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-description
                 */
                public Build withDescription(final java.lang.String value) {
                    this.instance._description = value;
                    return this;
                }
                /**
                 * ``DeploymentGroupResource.DeploymentProperty.Description``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-description
                 */
                public Build withDescription(final software.amazon.awscdk.Token value) {
                    this.instance._description = value;
                    return this;
                }
                /**
                 * ``DeploymentGroupResource.DeploymentProperty.IgnoreApplicationStopFailures``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-ignoreapplicationstopfailures
                 */
                public Build withIgnoreApplicationStopFailures(final java.lang.Boolean value) {
                    this.instance._ignoreApplicationStopFailures = value;
                    return this;
                }
                /**
                 * ``DeploymentGroupResource.DeploymentProperty.IgnoreApplicationStopFailures``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-ignoreapplicationstopfailures
                 */
                public Build withIgnoreApplicationStopFailures(final software.amazon.awscdk.Token value) {
                    this.instance._ignoreApplicationStopFailures = value;
                    return this;
                }
                /**
                 * ``DeploymentGroupResource.DeploymentProperty.Revision``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision
                 */
                public Build withRevision(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "DeploymentProperty#revision is required");
                    this.instance._revision = value;
                    return this;
                }
                /**
                 * ``DeploymentGroupResource.DeploymentProperty.Revision``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision
                 */
                public Build withRevision(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.RevisionLocationProperty value) {
                    java.util.Objects.requireNonNull(value, "DeploymentProperty#revision is required");
                    this.instance._revision = value;
                    return this;
                }
                public DeploymentProperty build() {
                    DeploymentProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link DeploymentProperty}.
         */
        final class Jsii$Pojo implements DeploymentProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _description;

            public java.lang.Object getDescription() {
                return this._description;
            }
            public void setDescription(final java.lang.String value) {
                this._description = value;
            }
            public void setDescription(final software.amazon.awscdk.Token value) {
                this._description = value;
            }

            protected java.lang.Object _ignoreApplicationStopFailures;

            public java.lang.Object getIgnoreApplicationStopFailures() {
                return this._ignoreApplicationStopFailures;
            }
            public void setIgnoreApplicationStopFailures(final java.lang.Boolean value) {
                this._ignoreApplicationStopFailures = value;
            }
            public void setIgnoreApplicationStopFailures(final software.amazon.awscdk.Token value) {
                this._ignoreApplicationStopFailures = value;
            }

            protected java.lang.Object _revision;

            public java.lang.Object getRevision() {
                return this._revision;
            }
            public void setRevision(final software.amazon.awscdk.Token value) {
                this._revision = value;
            }
            public void setRevision(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.RevisionLocationProperty value) {
                this._revision = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.DeploymentProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``DeploymentGroupResource.DeploymentProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-description
             */
            @javax.annotation.Nullable
            public java.lang.Object getDescription() {
                return this.jsiiGet("description", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.DeploymentProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-description
             */
            public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("description", value);
            }
            /**
             * ``DeploymentGroupResource.DeploymentProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-description
             */
            public void setDescription(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("description", value);
            }
            /**
             * ``DeploymentGroupResource.DeploymentProperty.IgnoreApplicationStopFailures``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-ignoreapplicationstopfailures
             */
            @javax.annotation.Nullable
            public java.lang.Object getIgnoreApplicationStopFailures() {
                return this.jsiiGet("ignoreApplicationStopFailures", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.DeploymentProperty.IgnoreApplicationStopFailures``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-ignoreapplicationstopfailures
             */
            public void setIgnoreApplicationStopFailures(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("ignoreApplicationStopFailures", value);
            }
            /**
             * ``DeploymentGroupResource.DeploymentProperty.IgnoreApplicationStopFailures``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-ignoreapplicationstopfailures
             */
            public void setIgnoreApplicationStopFailures(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ignoreApplicationStopFailures", value);
            }
            /**
             * ``DeploymentGroupResource.DeploymentProperty.Revision``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision
             */
            public java.lang.Object getRevision() {
                return this.jsiiGet("revision", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.DeploymentProperty.Revision``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision
             */
            public void setRevision(final software.amazon.awscdk.Token value) {
                this.jsiiSet("revision", java.util.Objects.requireNonNull(value, "revision is required"));
            }
            /**
             * ``DeploymentGroupResource.DeploymentProperty.Revision``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision
             */
            public void setRevision(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.RevisionLocationProperty value) {
                this.jsiiSet("revision", java.util.Objects.requireNonNull(value, "revision is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html
     */
    public static interface DeploymentStyleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentOption``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymentoption
         */
        java.lang.Object getDeploymentOption();
        /**
         * ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentOption``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymentoption
         */
        void setDeploymentOption(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentOption``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymentoption
         */
        void setDeploymentOption(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymenttype
         */
        java.lang.Object getDeploymentType();
        /**
         * ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymenttype
         */
        void setDeploymentType(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymenttype
         */
        void setDeploymentType(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link DeploymentStyleProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentOption``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymentoption
             */
            public Builder withDeploymentOption(final java.lang.String value) {
                this.instance._deploymentOption = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentOption``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymentoption
             */
            public Builder withDeploymentOption(final software.amazon.awscdk.Token value) {
                this.instance._deploymentOption = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymenttype
             */
            public Builder withDeploymentType(final java.lang.String value) {
                this.instance._deploymentType = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymenttype
             */
            public Builder withDeploymentType(final software.amazon.awscdk.Token value) {
                this.instance._deploymentType = value;
                return this;
            }
            public DeploymentStyleProperty build() {
                DeploymentStyleProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link DeploymentStyleProperty}.
         */
        final class Jsii$Pojo implements DeploymentStyleProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _deploymentOption;

            public java.lang.Object getDeploymentOption() {
                return this._deploymentOption;
            }
            public void setDeploymentOption(final java.lang.String value) {
                this._deploymentOption = value;
            }
            public void setDeploymentOption(final software.amazon.awscdk.Token value) {
                this._deploymentOption = value;
            }

            protected java.lang.Object _deploymentType;

            public java.lang.Object getDeploymentType() {
                return this._deploymentType;
            }
            public void setDeploymentType(final java.lang.String value) {
                this._deploymentType = value;
            }
            public void setDeploymentType(final software.amazon.awscdk.Token value) {
                this._deploymentType = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.DeploymentStyleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentOption``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymentoption
             */
            @javax.annotation.Nullable
            public java.lang.Object getDeploymentOption() {
                return this.jsiiGet("deploymentOption", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentOption``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymentoption
             */
            public void setDeploymentOption(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("deploymentOption", value);
            }
            /**
             * ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentOption``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymentoption
             */
            public void setDeploymentOption(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("deploymentOption", value);
            }
            /**
             * ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymenttype
             */
            @javax.annotation.Nullable
            public java.lang.Object getDeploymentType() {
                return this.jsiiGet("deploymentType", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymenttype
             */
            public void setDeploymentType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("deploymentType", value);
            }
            /**
             * ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymenttype
             */
            public void setDeploymentType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("deploymentType", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html
     */
    public static interface EC2TagFilterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentGroupResource.EC2TagFilterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-key
         */
        java.lang.Object getKey();
        /**
         * ``DeploymentGroupResource.EC2TagFilterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-key
         */
        void setKey(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.EC2TagFilterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-key
         */
        void setKey(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentGroupResource.EC2TagFilterProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-type
         */
        java.lang.Object getType();
        /**
         * ``DeploymentGroupResource.EC2TagFilterProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-type
         */
        void setType(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.EC2TagFilterProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-type
         */
        void setType(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentGroupResource.EC2TagFilterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-value
         */
        java.lang.Object getValue();
        /**
         * ``DeploymentGroupResource.EC2TagFilterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-value
         */
        void setValue(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.EC2TagFilterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-value
         */
        void setValue(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link EC2TagFilterProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``DeploymentGroupResource.EC2TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-key
             */
            public Builder withKey(final java.lang.String value) {
                this.instance._key = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.EC2TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-key
             */
            public Builder withKey(final software.amazon.awscdk.Token value) {
                this.instance._key = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.EC2TagFilterProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-type
             */
            public Builder withType(final java.lang.String value) {
                this.instance._type = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.EC2TagFilterProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-type
             */
            public Builder withType(final software.amazon.awscdk.Token value) {
                this.instance._type = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.EC2TagFilterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-value
             */
            public Builder withValue(final java.lang.String value) {
                this.instance._value = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.EC2TagFilterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-value
             */
            public Builder withValue(final software.amazon.awscdk.Token value) {
                this.instance._value = value;
                return this;
            }
            public EC2TagFilterProperty build() {
                EC2TagFilterProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link EC2TagFilterProperty}.
         */
        final class Jsii$Pojo implements EC2TagFilterProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _key;

            public java.lang.Object getKey() {
                return this._key;
            }
            public void setKey(final java.lang.String value) {
                this._key = value;
            }
            public void setKey(final software.amazon.awscdk.Token value) {
                this._key = value;
            }

            protected java.lang.Object _type;

            public java.lang.Object getType() {
                return this._type;
            }
            public void setType(final java.lang.String value) {
                this._type = value;
            }
            public void setType(final software.amazon.awscdk.Token value) {
                this._type = value;
            }

            protected java.lang.Object _value;

            public java.lang.Object getValue() {
                return this._value;
            }
            public void setValue(final java.lang.String value) {
                this._value = value;
            }
            public void setValue(final software.amazon.awscdk.Token value) {
                this._value = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.EC2TagFilterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``DeploymentGroupResource.EC2TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-key
             */
            @javax.annotation.Nullable
            public java.lang.Object getKey() {
                return this.jsiiGet("key", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.EC2TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-key
             */
            public void setKey(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("key", value);
            }
            /**
             * ``DeploymentGroupResource.EC2TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-key
             */
            public void setKey(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("key", value);
            }
            /**
             * ``DeploymentGroupResource.EC2TagFilterProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-type
             */
            @javax.annotation.Nullable
            public java.lang.Object getType() {
                return this.jsiiGet("type", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.EC2TagFilterProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-type
             */
            public void setType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("type", value);
            }
            /**
             * ``DeploymentGroupResource.EC2TagFilterProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-type
             */
            public void setType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("type", value);
            }
            /**
             * ``DeploymentGroupResource.EC2TagFilterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-value
             */
            @javax.annotation.Nullable
            public java.lang.Object getValue() {
                return this.jsiiGet("value", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.EC2TagFilterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-value
             */
            public void setValue(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("value", value);
            }
            /**
             * ``DeploymentGroupResource.EC2TagFilterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-value
             */
            public void setValue(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("value", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-elbinfo.html
     */
    public static interface ELBInfoProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentGroupResource.ELBInfoProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-elbinfo.html#cfn-codedeploy-deploymentgroup-elbinfo-name
         */
        java.lang.Object getName();
        /**
         * ``DeploymentGroupResource.ELBInfoProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-elbinfo.html#cfn-codedeploy-deploymentgroup-elbinfo-name
         */
        void setName(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.ELBInfoProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-elbinfo.html#cfn-codedeploy-deploymentgroup-elbinfo-name
         */
        void setName(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link ELBInfoProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``DeploymentGroupResource.ELBInfoProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-elbinfo.html#cfn-codedeploy-deploymentgroup-elbinfo-name
             */
            public Builder withName(final java.lang.String value) {
                this.instance._name = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.ELBInfoProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-elbinfo.html#cfn-codedeploy-deploymentgroup-elbinfo-name
             */
            public Builder withName(final software.amazon.awscdk.Token value) {
                this.instance._name = value;
                return this;
            }
            public ELBInfoProperty build() {
                ELBInfoProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link ELBInfoProperty}.
         */
        final class Jsii$Pojo implements ELBInfoProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _name;

            public java.lang.Object getName() {
                return this._name;
            }
            public void setName(final java.lang.String value) {
                this._name = value;
            }
            public void setName(final software.amazon.awscdk.Token value) {
                this._name = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.ELBInfoProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``DeploymentGroupResource.ELBInfoProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-elbinfo.html#cfn-codedeploy-deploymentgroup-elbinfo-name
             */
            @javax.annotation.Nullable
            public java.lang.Object getName() {
                return this.jsiiGet("name", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.ELBInfoProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-elbinfo.html#cfn-codedeploy-deploymentgroup-elbinfo-name
             */
            public void setName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("name", value);
            }
            /**
             * ``DeploymentGroupResource.ELBInfoProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-elbinfo.html#cfn-codedeploy-deploymentgroup-elbinfo-name
             */
            public void setName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("name", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html
     */
    public static interface GitHubLocationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentGroupResource.GitHubLocationProperty.CommitId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-commitid
         */
        java.lang.Object getCommitId();
        /**
         * ``DeploymentGroupResource.GitHubLocationProperty.CommitId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-commitid
         */
        void setCommitId(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.GitHubLocationProperty.CommitId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-commitid
         */
        void setCommitId(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentGroupResource.GitHubLocationProperty.Repository``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-repository
         */
        java.lang.Object getRepository();
        /**
         * ``DeploymentGroupResource.GitHubLocationProperty.Repository``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-repository
         */
        void setRepository(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.GitHubLocationProperty.Repository``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-repository
         */
        void setRepository(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link GitHubLocationProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``DeploymentGroupResource.GitHubLocationProperty.CommitId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-commitid
             */
            public RepositoryStep withCommitId(final java.lang.String value) {
                return new FullBuilder().withCommitId(value);
            }
            /**
             * ``DeploymentGroupResource.GitHubLocationProperty.CommitId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-commitid
             */
            public RepositoryStep withCommitId(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withCommitId(value);
            }

            public interface RepositoryStep {
                /**
                 * ``DeploymentGroupResource.GitHubLocationProperty.Repository``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-repository
                 */
                Build withRepository(final java.lang.String value);
                /**
                 * ``DeploymentGroupResource.GitHubLocationProperty.Repository``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-repository
                 */
                Build withRepository(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link GitHubLocationProperty} object, initialized with the values set on this builder.
                 */
                GitHubLocationProperty build();
            }

            final class FullBuilder implements RepositoryStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``DeploymentGroupResource.GitHubLocationProperty.CommitId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-commitid
                 */
                public RepositoryStep withCommitId(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "GitHubLocationProperty#commitId is required");
                    this.instance._commitId = value;
                    return this;
                }
                /**
                 * ``DeploymentGroupResource.GitHubLocationProperty.CommitId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-commitid
                 */
                public RepositoryStep withCommitId(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "GitHubLocationProperty#commitId is required");
                    this.instance._commitId = value;
                    return this;
                }
                /**
                 * ``DeploymentGroupResource.GitHubLocationProperty.Repository``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-repository
                 */
                public Build withRepository(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "GitHubLocationProperty#repository is required");
                    this.instance._repository = value;
                    return this;
                }
                /**
                 * ``DeploymentGroupResource.GitHubLocationProperty.Repository``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-repository
                 */
                public Build withRepository(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "GitHubLocationProperty#repository is required");
                    this.instance._repository = value;
                    return this;
                }
                public GitHubLocationProperty build() {
                    GitHubLocationProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link GitHubLocationProperty}.
         */
        final class Jsii$Pojo implements GitHubLocationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _commitId;

            public java.lang.Object getCommitId() {
                return this._commitId;
            }
            public void setCommitId(final java.lang.String value) {
                this._commitId = value;
            }
            public void setCommitId(final software.amazon.awscdk.Token value) {
                this._commitId = value;
            }

            protected java.lang.Object _repository;

            public java.lang.Object getRepository() {
                return this._repository;
            }
            public void setRepository(final java.lang.String value) {
                this._repository = value;
            }
            public void setRepository(final software.amazon.awscdk.Token value) {
                this._repository = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.GitHubLocationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``DeploymentGroupResource.GitHubLocationProperty.CommitId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-commitid
             */
            public java.lang.Object getCommitId() {
                return this.jsiiGet("commitId", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.GitHubLocationProperty.CommitId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-commitid
             */
            public void setCommitId(final java.lang.String value) {
                this.jsiiSet("commitId", java.util.Objects.requireNonNull(value, "commitId is required"));
            }
            /**
             * ``DeploymentGroupResource.GitHubLocationProperty.CommitId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-commitid
             */
            public void setCommitId(final software.amazon.awscdk.Token value) {
                this.jsiiSet("commitId", java.util.Objects.requireNonNull(value, "commitId is required"));
            }
            /**
             * ``DeploymentGroupResource.GitHubLocationProperty.Repository``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-repository
             */
            public java.lang.Object getRepository() {
                return this.jsiiGet("repository", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.GitHubLocationProperty.Repository``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-repository
             */
            public void setRepository(final java.lang.String value) {
                this.jsiiSet("repository", java.util.Objects.requireNonNull(value, "repository is required"));
            }
            /**
             * ``DeploymentGroupResource.GitHubLocationProperty.Repository``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-repository
             */
            public void setRepository(final software.amazon.awscdk.Token value) {
                this.jsiiSet("repository", java.util.Objects.requireNonNull(value, "repository is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html
     */
    public static interface LoadBalancerInfoProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentGroupResource.LoadBalancerInfoProperty.ElbInfoList``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-elbinfolist
         */
        java.lang.Object getElbInfoList();
        /**
         * ``DeploymentGroupResource.LoadBalancerInfoProperty.ElbInfoList``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-elbinfolist
         */
        void setElbInfoList(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentGroupResource.LoadBalancerInfoProperty.ElbInfoList``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-elbinfolist
         */
        void setElbInfoList(final java.util.List<java.lang.Object> value);
        /**
         * ``DeploymentGroupResource.LoadBalancerInfoProperty.TargetGroupInfoList``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-targetgroupinfolist
         */
        java.lang.Object getTargetGroupInfoList();
        /**
         * ``DeploymentGroupResource.LoadBalancerInfoProperty.TargetGroupInfoList``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-targetgroupinfolist
         */
        void setTargetGroupInfoList(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentGroupResource.LoadBalancerInfoProperty.TargetGroupInfoList``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-targetgroupinfolist
         */
        void setTargetGroupInfoList(final java.util.List<java.lang.Object> value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link LoadBalancerInfoProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``DeploymentGroupResource.LoadBalancerInfoProperty.ElbInfoList``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-elbinfolist
             */
            public Builder withElbInfoList(final software.amazon.awscdk.Token value) {
                this.instance._elbInfoList = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.LoadBalancerInfoProperty.ElbInfoList``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-elbinfolist
             */
            public Builder withElbInfoList(final java.util.List<java.lang.Object> value) {
                this.instance._elbInfoList = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.LoadBalancerInfoProperty.TargetGroupInfoList``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-targetgroupinfolist
             */
            public Builder withTargetGroupInfoList(final software.amazon.awscdk.Token value) {
                this.instance._targetGroupInfoList = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.LoadBalancerInfoProperty.TargetGroupInfoList``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-targetgroupinfolist
             */
            public Builder withTargetGroupInfoList(final java.util.List<java.lang.Object> value) {
                this.instance._targetGroupInfoList = value;
                return this;
            }
            public LoadBalancerInfoProperty build() {
                LoadBalancerInfoProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link LoadBalancerInfoProperty}.
         */
        final class Jsii$Pojo implements LoadBalancerInfoProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _elbInfoList;

            public java.lang.Object getElbInfoList() {
                return this._elbInfoList;
            }
            public void setElbInfoList(final software.amazon.awscdk.Token value) {
                this._elbInfoList = value;
            }
            public void setElbInfoList(final java.util.List<java.lang.Object> value) {
                this._elbInfoList = value;
            }

            protected java.lang.Object _targetGroupInfoList;

            public java.lang.Object getTargetGroupInfoList() {
                return this._targetGroupInfoList;
            }
            public void setTargetGroupInfoList(final software.amazon.awscdk.Token value) {
                this._targetGroupInfoList = value;
            }
            public void setTargetGroupInfoList(final java.util.List<java.lang.Object> value) {
                this._targetGroupInfoList = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.LoadBalancerInfoProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``DeploymentGroupResource.LoadBalancerInfoProperty.ElbInfoList``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-elbinfolist
             */
            @javax.annotation.Nullable
            public java.lang.Object getElbInfoList() {
                return this.jsiiGet("elbInfoList", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.LoadBalancerInfoProperty.ElbInfoList``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-elbinfolist
             */
            public void setElbInfoList(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("elbInfoList", value);
            }
            /**
             * ``DeploymentGroupResource.LoadBalancerInfoProperty.ElbInfoList``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-elbinfolist
             */
            public void setElbInfoList(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("elbInfoList", value);
            }
            /**
             * ``DeploymentGroupResource.LoadBalancerInfoProperty.TargetGroupInfoList``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-targetgroupinfolist
             */
            @javax.annotation.Nullable
            public java.lang.Object getTargetGroupInfoList() {
                return this.jsiiGet("targetGroupInfoList", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.LoadBalancerInfoProperty.TargetGroupInfoList``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-targetgroupinfolist
             */
            public void setTargetGroupInfoList(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("targetGroupInfoList", value);
            }
            /**
             * ``DeploymentGroupResource.LoadBalancerInfoProperty.TargetGroupInfoList``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-targetgroupinfolist
             */
            public void setTargetGroupInfoList(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("targetGroupInfoList", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html
     */
    public static interface RevisionLocationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentGroupResource.RevisionLocationProperty.GitHubLocation``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation
         */
        java.lang.Object getGitHubLocation();
        /**
         * ``DeploymentGroupResource.RevisionLocationProperty.GitHubLocation``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation
         */
        void setGitHubLocation(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentGroupResource.RevisionLocationProperty.GitHubLocation``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation
         */
        void setGitHubLocation(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.GitHubLocationProperty value);
        /**
         * ``DeploymentGroupResource.RevisionLocationProperty.RevisionType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-revisiontype
         */
        java.lang.Object getRevisionType();
        /**
         * ``DeploymentGroupResource.RevisionLocationProperty.RevisionType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-revisiontype
         */
        void setRevisionType(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.RevisionLocationProperty.RevisionType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-revisiontype
         */
        void setRevisionType(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentGroupResource.RevisionLocationProperty.S3Location``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location
         */
        java.lang.Object getS3Location();
        /**
         * ``DeploymentGroupResource.RevisionLocationProperty.S3Location``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location
         */
        void setS3Location(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentGroupResource.RevisionLocationProperty.S3Location``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location
         */
        void setS3Location(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.S3LocationProperty value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link RevisionLocationProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``DeploymentGroupResource.RevisionLocationProperty.GitHubLocation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation
             */
            public Builder withGitHubLocation(final software.amazon.awscdk.Token value) {
                this.instance._gitHubLocation = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.RevisionLocationProperty.GitHubLocation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation
             */
            public Builder withGitHubLocation(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.GitHubLocationProperty value) {
                this.instance._gitHubLocation = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.RevisionLocationProperty.RevisionType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-revisiontype
             */
            public Builder withRevisionType(final java.lang.String value) {
                this.instance._revisionType = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.RevisionLocationProperty.RevisionType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-revisiontype
             */
            public Builder withRevisionType(final software.amazon.awscdk.Token value) {
                this.instance._revisionType = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.RevisionLocationProperty.S3Location``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location
             */
            public Builder withS3Location(final software.amazon.awscdk.Token value) {
                this.instance._s3Location = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.RevisionLocationProperty.S3Location``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location
             */
            public Builder withS3Location(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.S3LocationProperty value) {
                this.instance._s3Location = value;
                return this;
            }
            public RevisionLocationProperty build() {
                RevisionLocationProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link RevisionLocationProperty}.
         */
        final class Jsii$Pojo implements RevisionLocationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _gitHubLocation;

            public java.lang.Object getGitHubLocation() {
                return this._gitHubLocation;
            }
            public void setGitHubLocation(final software.amazon.awscdk.Token value) {
                this._gitHubLocation = value;
            }
            public void setGitHubLocation(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.GitHubLocationProperty value) {
                this._gitHubLocation = value;
            }

            protected java.lang.Object _revisionType;

            public java.lang.Object getRevisionType() {
                return this._revisionType;
            }
            public void setRevisionType(final java.lang.String value) {
                this._revisionType = value;
            }
            public void setRevisionType(final software.amazon.awscdk.Token value) {
                this._revisionType = value;
            }

            protected java.lang.Object _s3Location;

            public java.lang.Object getS3Location() {
                return this._s3Location;
            }
            public void setS3Location(final software.amazon.awscdk.Token value) {
                this._s3Location = value;
            }
            public void setS3Location(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.S3LocationProperty value) {
                this._s3Location = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.RevisionLocationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``DeploymentGroupResource.RevisionLocationProperty.GitHubLocation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation
             */
            @javax.annotation.Nullable
            public java.lang.Object getGitHubLocation() {
                return this.jsiiGet("gitHubLocation", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.RevisionLocationProperty.GitHubLocation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation
             */
            public void setGitHubLocation(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("gitHubLocation", value);
            }
            /**
             * ``DeploymentGroupResource.RevisionLocationProperty.GitHubLocation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation
             */
            public void setGitHubLocation(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.GitHubLocationProperty value) {
                this.jsiiSet("gitHubLocation", value);
            }
            /**
             * ``DeploymentGroupResource.RevisionLocationProperty.RevisionType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-revisiontype
             */
            @javax.annotation.Nullable
            public java.lang.Object getRevisionType() {
                return this.jsiiGet("revisionType", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.RevisionLocationProperty.RevisionType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-revisiontype
             */
            public void setRevisionType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("revisionType", value);
            }
            /**
             * ``DeploymentGroupResource.RevisionLocationProperty.RevisionType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-revisiontype
             */
            public void setRevisionType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("revisionType", value);
            }
            /**
             * ``DeploymentGroupResource.RevisionLocationProperty.S3Location``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location
             */
            @javax.annotation.Nullable
            public java.lang.Object getS3Location() {
                return this.jsiiGet("s3Location", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.RevisionLocationProperty.S3Location``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location
             */
            public void setS3Location(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("s3Location", value);
            }
            /**
             * ``DeploymentGroupResource.RevisionLocationProperty.S3Location``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location
             */
            public void setS3Location(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.S3LocationProperty value) {
                this.jsiiSet("s3Location", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html
     */
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentGroupResource.S3LocationProperty.Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bucket
         */
        java.lang.Object getBucket();
        /**
         * ``DeploymentGroupResource.S3LocationProperty.Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bucket
         */
        void setBucket(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.S3LocationProperty.Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bucket
         */
        void setBucket(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentGroupResource.S3LocationProperty.BundleType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bundletype
         */
        java.lang.Object getBundleType();
        /**
         * ``DeploymentGroupResource.S3LocationProperty.BundleType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bundletype
         */
        void setBundleType(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.S3LocationProperty.BundleType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bundletype
         */
        void setBundleType(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentGroupResource.S3LocationProperty.ETag``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-etag
         */
        java.lang.Object getETag();
        /**
         * ``DeploymentGroupResource.S3LocationProperty.ETag``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-etag
         */
        void setETag(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.S3LocationProperty.ETag``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-etag
         */
        void setETag(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentGroupResource.S3LocationProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-key
         */
        java.lang.Object getKey();
        /**
         * ``DeploymentGroupResource.S3LocationProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-key
         */
        void setKey(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.S3LocationProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-key
         */
        void setKey(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentGroupResource.S3LocationProperty.Version``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-value
         */
        java.lang.Object getVersion();
        /**
         * ``DeploymentGroupResource.S3LocationProperty.Version``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-value
         */
        void setVersion(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.S3LocationProperty.Version``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-value
         */
        void setVersion(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link S3LocationProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``DeploymentGroupResource.S3LocationProperty.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bucket
             */
            public KeyStep withBucket(final java.lang.String value) {
                return new FullBuilder().withBucket(value);
            }
            /**
             * ``DeploymentGroupResource.S3LocationProperty.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bucket
             */
            public KeyStep withBucket(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withBucket(value);
            }

            public interface KeyStep {
                /**
                 * ``DeploymentGroupResource.S3LocationProperty.Key``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-key
                 */
                Build withKey(final java.lang.String value);
                /**
                 * ``DeploymentGroupResource.S3LocationProperty.Key``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-key
                 */
                Build withKey(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link S3LocationProperty} object, initialized with the values set on this builder.
                 */
                S3LocationProperty build();
                /**
                 * ``DeploymentGroupResource.S3LocationProperty.BundleType``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bundletype
                 */
                Build withBundleType(final java.lang.String value);
                /**
                 * ``DeploymentGroupResource.S3LocationProperty.BundleType``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bundletype
                 */
                Build withBundleType(final software.amazon.awscdk.Token value);
                /**
                 * ``DeploymentGroupResource.S3LocationProperty.ETag``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-etag
                 */
                Build withETag(final java.lang.String value);
                /**
                 * ``DeploymentGroupResource.S3LocationProperty.ETag``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-etag
                 */
                Build withETag(final software.amazon.awscdk.Token value);
                /**
                 * ``DeploymentGroupResource.S3LocationProperty.Version``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-value
                 */
                Build withVersion(final java.lang.String value);
                /**
                 * ``DeploymentGroupResource.S3LocationProperty.Version``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-value
                 */
                Build withVersion(final software.amazon.awscdk.Token value);
            }

            final class FullBuilder implements KeyStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``DeploymentGroupResource.S3LocationProperty.Bucket``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bucket
                 */
                public KeyStep withBucket(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "S3LocationProperty#bucket is required");
                    this.instance._bucket = value;
                    return this;
                }
                /**
                 * ``DeploymentGroupResource.S3LocationProperty.Bucket``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bucket
                 */
                public KeyStep withBucket(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "S3LocationProperty#bucket is required");
                    this.instance._bucket = value;
                    return this;
                }
                /**
                 * ``DeploymentGroupResource.S3LocationProperty.BundleType``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bundletype
                 */
                public Build withBundleType(final java.lang.String value) {
                    this.instance._bundleType = value;
                    return this;
                }
                /**
                 * ``DeploymentGroupResource.S3LocationProperty.BundleType``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bundletype
                 */
                public Build withBundleType(final software.amazon.awscdk.Token value) {
                    this.instance._bundleType = value;
                    return this;
                }
                /**
                 * ``DeploymentGroupResource.S3LocationProperty.ETag``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-etag
                 */
                public Build withETag(final java.lang.String value) {
                    this.instance._eTag = value;
                    return this;
                }
                /**
                 * ``DeploymentGroupResource.S3LocationProperty.ETag``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-etag
                 */
                public Build withETag(final software.amazon.awscdk.Token value) {
                    this.instance._eTag = value;
                    return this;
                }
                /**
                 * ``DeploymentGroupResource.S3LocationProperty.Key``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-key
                 */
                public Build withKey(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "S3LocationProperty#key is required");
                    this.instance._key = value;
                    return this;
                }
                /**
                 * ``DeploymentGroupResource.S3LocationProperty.Key``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-key
                 */
                public Build withKey(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "S3LocationProperty#key is required");
                    this.instance._key = value;
                    return this;
                }
                /**
                 * ``DeploymentGroupResource.S3LocationProperty.Version``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-value
                 */
                public Build withVersion(final java.lang.String value) {
                    this.instance._version = value;
                    return this;
                }
                /**
                 * ``DeploymentGroupResource.S3LocationProperty.Version``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-value
                 */
                public Build withVersion(final software.amazon.awscdk.Token value) {
                    this.instance._version = value;
                    return this;
                }
                public S3LocationProperty build() {
                    S3LocationProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link S3LocationProperty}.
         */
        final class Jsii$Pojo implements S3LocationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _bucket;

            public java.lang.Object getBucket() {
                return this._bucket;
            }
            public void setBucket(final java.lang.String value) {
                this._bucket = value;
            }
            public void setBucket(final software.amazon.awscdk.Token value) {
                this._bucket = value;
            }

            protected java.lang.Object _bundleType;

            public java.lang.Object getBundleType() {
                return this._bundleType;
            }
            public void setBundleType(final java.lang.String value) {
                this._bundleType = value;
            }
            public void setBundleType(final software.amazon.awscdk.Token value) {
                this._bundleType = value;
            }

            protected java.lang.Object _eTag;

            public java.lang.Object getETag() {
                return this._eTag;
            }
            public void setETag(final java.lang.String value) {
                this._eTag = value;
            }
            public void setETag(final software.amazon.awscdk.Token value) {
                this._eTag = value;
            }

            protected java.lang.Object _key;

            public java.lang.Object getKey() {
                return this._key;
            }
            public void setKey(final java.lang.String value) {
                this._key = value;
            }
            public void setKey(final software.amazon.awscdk.Token value) {
                this._key = value;
            }

            protected java.lang.Object _version;

            public java.lang.Object getVersion() {
                return this._version;
            }
            public void setVersion(final java.lang.String value) {
                this._version = value;
            }
            public void setVersion(final software.amazon.awscdk.Token value) {
                this._version = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.S3LocationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``DeploymentGroupResource.S3LocationProperty.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bucket
             */
            public java.lang.Object getBucket() {
                return this.jsiiGet("bucket", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.S3LocationProperty.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bucket
             */
            public void setBucket(final java.lang.String value) {
                this.jsiiSet("bucket", java.util.Objects.requireNonNull(value, "bucket is required"));
            }
            /**
             * ``DeploymentGroupResource.S3LocationProperty.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bucket
             */
            public void setBucket(final software.amazon.awscdk.Token value) {
                this.jsiiSet("bucket", java.util.Objects.requireNonNull(value, "bucket is required"));
            }
            /**
             * ``DeploymentGroupResource.S3LocationProperty.BundleType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bundletype
             */
            @javax.annotation.Nullable
            public java.lang.Object getBundleType() {
                return this.jsiiGet("bundleType", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.S3LocationProperty.BundleType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bundletype
             */
            public void setBundleType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("bundleType", value);
            }
            /**
             * ``DeploymentGroupResource.S3LocationProperty.BundleType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bundletype
             */
            public void setBundleType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("bundleType", value);
            }
            /**
             * ``DeploymentGroupResource.S3LocationProperty.ETag``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-etag
             */
            @javax.annotation.Nullable
            public java.lang.Object getETag() {
                return this.jsiiGet("eTag", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.S3LocationProperty.ETag``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-etag
             */
            public void setETag(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("eTag", value);
            }
            /**
             * ``DeploymentGroupResource.S3LocationProperty.ETag``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-etag
             */
            public void setETag(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("eTag", value);
            }
            /**
             * ``DeploymentGroupResource.S3LocationProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-key
             */
            public java.lang.Object getKey() {
                return this.jsiiGet("key", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.S3LocationProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-key
             */
            public void setKey(final java.lang.String value) {
                this.jsiiSet("key", java.util.Objects.requireNonNull(value, "key is required"));
            }
            /**
             * ``DeploymentGroupResource.S3LocationProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-key
             */
            public void setKey(final software.amazon.awscdk.Token value) {
                this.jsiiSet("key", java.util.Objects.requireNonNull(value, "key is required"));
            }
            /**
             * ``DeploymentGroupResource.S3LocationProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-value
             */
            @javax.annotation.Nullable
            public java.lang.Object getVersion() {
                return this.jsiiGet("version", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.S3LocationProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-value
             */
            public void setVersion(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("version", value);
            }
            /**
             * ``DeploymentGroupResource.S3LocationProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-value
             */
            public void setVersion(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("version", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html
     */
    public static interface TagFilterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentGroupResource.TagFilterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-key
         */
        java.lang.Object getKey();
        /**
         * ``DeploymentGroupResource.TagFilterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-key
         */
        void setKey(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.TagFilterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-key
         */
        void setKey(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentGroupResource.TagFilterProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-type
         */
        java.lang.Object getType();
        /**
         * ``DeploymentGroupResource.TagFilterProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-type
         */
        void setType(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.TagFilterProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-type
         */
        void setType(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentGroupResource.TagFilterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-value
         */
        java.lang.Object getValue();
        /**
         * ``DeploymentGroupResource.TagFilterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-value
         */
        void setValue(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.TagFilterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-value
         */
        void setValue(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link TagFilterProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``DeploymentGroupResource.TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-key
             */
            public Builder withKey(final java.lang.String value) {
                this.instance._key = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-key
             */
            public Builder withKey(final software.amazon.awscdk.Token value) {
                this.instance._key = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.TagFilterProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-type
             */
            public Builder withType(final java.lang.String value) {
                this.instance._type = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.TagFilterProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-type
             */
            public Builder withType(final software.amazon.awscdk.Token value) {
                this.instance._type = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.TagFilterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-value
             */
            public Builder withValue(final java.lang.String value) {
                this.instance._value = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.TagFilterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-value
             */
            public Builder withValue(final software.amazon.awscdk.Token value) {
                this.instance._value = value;
                return this;
            }
            public TagFilterProperty build() {
                TagFilterProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link TagFilterProperty}.
         */
        final class Jsii$Pojo implements TagFilterProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _key;

            public java.lang.Object getKey() {
                return this._key;
            }
            public void setKey(final java.lang.String value) {
                this._key = value;
            }
            public void setKey(final software.amazon.awscdk.Token value) {
                this._key = value;
            }

            protected java.lang.Object _type;

            public java.lang.Object getType() {
                return this._type;
            }
            public void setType(final java.lang.String value) {
                this._type = value;
            }
            public void setType(final software.amazon.awscdk.Token value) {
                this._type = value;
            }

            protected java.lang.Object _value;

            public java.lang.Object getValue() {
                return this._value;
            }
            public void setValue(final java.lang.String value) {
                this._value = value;
            }
            public void setValue(final software.amazon.awscdk.Token value) {
                this._value = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.TagFilterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``DeploymentGroupResource.TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-key
             */
            @javax.annotation.Nullable
            public java.lang.Object getKey() {
                return this.jsiiGet("key", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-key
             */
            public void setKey(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("key", value);
            }
            /**
             * ``DeploymentGroupResource.TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-key
             */
            public void setKey(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("key", value);
            }
            /**
             * ``DeploymentGroupResource.TagFilterProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-type
             */
            @javax.annotation.Nullable
            public java.lang.Object getType() {
                return this.jsiiGet("type", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.TagFilterProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-type
             */
            public void setType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("type", value);
            }
            /**
             * ``DeploymentGroupResource.TagFilterProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-type
             */
            public void setType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("type", value);
            }
            /**
             * ``DeploymentGroupResource.TagFilterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-value
             */
            @javax.annotation.Nullable
            public java.lang.Object getValue() {
                return this.jsiiGet("value", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.TagFilterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-value
             */
            public void setValue(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("value", value);
            }
            /**
             * ``DeploymentGroupResource.TagFilterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-value
             */
            public void setValue(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("value", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-targetgroupinfo.html
     */
    public static interface TargetGroupInfoProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentGroupResource.TargetGroupInfoProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-targetgroupinfo.html#cfn-codedeploy-deploymentgroup-targetgroupinfo-name
         */
        java.lang.Object getName();
        /**
         * ``DeploymentGroupResource.TargetGroupInfoProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-targetgroupinfo.html#cfn-codedeploy-deploymentgroup-targetgroupinfo-name
         */
        void setName(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.TargetGroupInfoProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-targetgroupinfo.html#cfn-codedeploy-deploymentgroup-targetgroupinfo-name
         */
        void setName(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link TargetGroupInfoProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``DeploymentGroupResource.TargetGroupInfoProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-targetgroupinfo.html#cfn-codedeploy-deploymentgroup-targetgroupinfo-name
             */
            public Builder withName(final java.lang.String value) {
                this.instance._name = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.TargetGroupInfoProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-targetgroupinfo.html#cfn-codedeploy-deploymentgroup-targetgroupinfo-name
             */
            public Builder withName(final software.amazon.awscdk.Token value) {
                this.instance._name = value;
                return this;
            }
            public TargetGroupInfoProperty build() {
                TargetGroupInfoProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link TargetGroupInfoProperty}.
         */
        final class Jsii$Pojo implements TargetGroupInfoProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _name;

            public java.lang.Object getName() {
                return this._name;
            }
            public void setName(final java.lang.String value) {
                this._name = value;
            }
            public void setName(final software.amazon.awscdk.Token value) {
                this._name = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.TargetGroupInfoProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``DeploymentGroupResource.TargetGroupInfoProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-targetgroupinfo.html#cfn-codedeploy-deploymentgroup-targetgroupinfo-name
             */
            @javax.annotation.Nullable
            public java.lang.Object getName() {
                return this.jsiiGet("name", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.TargetGroupInfoProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-targetgroupinfo.html#cfn-codedeploy-deploymentgroup-targetgroupinfo-name
             */
            public void setName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("name", value);
            }
            /**
             * ``DeploymentGroupResource.TargetGroupInfoProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-targetgroupinfo.html#cfn-codedeploy-deploymentgroup-targetgroupinfo-name
             */
            public void setName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("name", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html
     */
    public static interface TriggerConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentGroupResource.TriggerConfigProperty.TriggerEvents``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggerevents
         */
        java.lang.Object getTriggerEvents();
        /**
         * ``DeploymentGroupResource.TriggerConfigProperty.TriggerEvents``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggerevents
         */
        void setTriggerEvents(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentGroupResource.TriggerConfigProperty.TriggerEvents``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggerevents
         */
        void setTriggerEvents(final java.util.List<java.lang.Object> value);
        /**
         * ``DeploymentGroupResource.TriggerConfigProperty.TriggerName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggername
         */
        java.lang.Object getTriggerName();
        /**
         * ``DeploymentGroupResource.TriggerConfigProperty.TriggerName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggername
         */
        void setTriggerName(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.TriggerConfigProperty.TriggerName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggername
         */
        void setTriggerName(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentGroupResource.TriggerConfigProperty.TriggerTargetArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggertargetarn
         */
        java.lang.Object getTriggerTargetArn();
        /**
         * ``DeploymentGroupResource.TriggerConfigProperty.TriggerTargetArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggertargetarn
         */
        void setTriggerTargetArn(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.TriggerConfigProperty.TriggerTargetArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggertargetarn
         */
        void setTriggerTargetArn(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link TriggerConfigProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``DeploymentGroupResource.TriggerConfigProperty.TriggerEvents``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggerevents
             */
            public Builder withTriggerEvents(final software.amazon.awscdk.Token value) {
                this.instance._triggerEvents = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.TriggerConfigProperty.TriggerEvents``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggerevents
             */
            public Builder withTriggerEvents(final java.util.List<java.lang.Object> value) {
                this.instance._triggerEvents = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.TriggerConfigProperty.TriggerName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggername
             */
            public Builder withTriggerName(final java.lang.String value) {
                this.instance._triggerName = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.TriggerConfigProperty.TriggerName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggername
             */
            public Builder withTriggerName(final software.amazon.awscdk.Token value) {
                this.instance._triggerName = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.TriggerConfigProperty.TriggerTargetArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggertargetarn
             */
            public Builder withTriggerTargetArn(final java.lang.String value) {
                this.instance._triggerTargetArn = value;
                return this;
            }
            /**
             * ``DeploymentGroupResource.TriggerConfigProperty.TriggerTargetArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggertargetarn
             */
            public Builder withTriggerTargetArn(final software.amazon.awscdk.Token value) {
                this.instance._triggerTargetArn = value;
                return this;
            }
            public TriggerConfigProperty build() {
                TriggerConfigProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link TriggerConfigProperty}.
         */
        final class Jsii$Pojo implements TriggerConfigProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _triggerEvents;

            public java.lang.Object getTriggerEvents() {
                return this._triggerEvents;
            }
            public void setTriggerEvents(final software.amazon.awscdk.Token value) {
                this._triggerEvents = value;
            }
            public void setTriggerEvents(final java.util.List<java.lang.Object> value) {
                this._triggerEvents = value;
            }

            protected java.lang.Object _triggerName;

            public java.lang.Object getTriggerName() {
                return this._triggerName;
            }
            public void setTriggerName(final java.lang.String value) {
                this._triggerName = value;
            }
            public void setTriggerName(final software.amazon.awscdk.Token value) {
                this._triggerName = value;
            }

            protected java.lang.Object _triggerTargetArn;

            public java.lang.Object getTriggerTargetArn() {
                return this._triggerTargetArn;
            }
            public void setTriggerTargetArn(final java.lang.String value) {
                this._triggerTargetArn = value;
            }
            public void setTriggerTargetArn(final software.amazon.awscdk.Token value) {
                this._triggerTargetArn = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.TriggerConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``DeploymentGroupResource.TriggerConfigProperty.TriggerEvents``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggerevents
             */
            @javax.annotation.Nullable
            public java.lang.Object getTriggerEvents() {
                return this.jsiiGet("triggerEvents", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.TriggerConfigProperty.TriggerEvents``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggerevents
             */
            public void setTriggerEvents(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("triggerEvents", value);
            }
            /**
             * ``DeploymentGroupResource.TriggerConfigProperty.TriggerEvents``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggerevents
             */
            public void setTriggerEvents(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("triggerEvents", value);
            }
            /**
             * ``DeploymentGroupResource.TriggerConfigProperty.TriggerName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggername
             */
            @javax.annotation.Nullable
            public java.lang.Object getTriggerName() {
                return this.jsiiGet("triggerName", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.TriggerConfigProperty.TriggerName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggername
             */
            public void setTriggerName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("triggerName", value);
            }
            /**
             * ``DeploymentGroupResource.TriggerConfigProperty.TriggerName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggername
             */
            public void setTriggerName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("triggerName", value);
            }
            /**
             * ``DeploymentGroupResource.TriggerConfigProperty.TriggerTargetArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggertargetarn
             */
            @javax.annotation.Nullable
            public java.lang.Object getTriggerTargetArn() {
                return this.jsiiGet("triggerTargetArn", java.lang.Object.class);
            }
            /**
             * ``DeploymentGroupResource.TriggerConfigProperty.TriggerTargetArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggertargetarn
             */
            public void setTriggerTargetArn(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("triggerTargetArn", value);
            }
            /**
             * ``DeploymentGroupResource.TriggerConfigProperty.TriggerTargetArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggertargetarn
             */
            public void setTriggerTargetArn(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("triggerTargetArn", value);
            }
        }
    }
}
