package software.amazon.awscdk.services.codedeploy.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html
 */
public interface DeploymentGroupResourceProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.ApplicationName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-applicationname
     */
    java.lang.Object getApplicationName();
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.ApplicationName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-applicationname
     */
    void setApplicationName(final java.lang.String value);
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.ApplicationName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-applicationname
     */
    void setApplicationName(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.ServiceRoleArn``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-servicerolearn
     */
    java.lang.Object getServiceRoleArn();
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.ServiceRoleArn``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-servicerolearn
     */
    void setServiceRoleArn(final java.lang.String value);
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.ServiceRoleArn``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-servicerolearn
     */
    void setServiceRoleArn(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.AlarmConfiguration``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-alarmconfiguration
     */
    java.lang.Object getAlarmConfiguration();
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.AlarmConfiguration``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-alarmconfiguration
     */
    void setAlarmConfiguration(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.AlarmConfiguration``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-alarmconfiguration
     */
    void setAlarmConfiguration(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.AlarmConfigurationProperty value);
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.AutoRollbackConfiguration``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration
     */
    java.lang.Object getAutoRollbackConfiguration();
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.AutoRollbackConfiguration``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration
     */
    void setAutoRollbackConfiguration(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.AutoRollbackConfiguration``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration
     */
    void setAutoRollbackConfiguration(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.AutoRollbackConfigurationProperty value);
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.AutoScalingGroups``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-autoscalinggroups
     */
    java.lang.Object getAutoScalingGroups();
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.AutoScalingGroups``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-autoscalinggroups
     */
    void setAutoScalingGroups(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.AutoScalingGroups``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-autoscalinggroups
     */
    void setAutoScalingGroups(final java.util.List<java.lang.Object> value);
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.Deployment``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deployment
     */
    java.lang.Object getDeployment();
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.Deployment``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deployment
     */
    void setDeployment(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.Deployment``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deployment
     */
    void setDeployment(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.DeploymentProperty value);
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.DeploymentConfigName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentconfigname
     */
    java.lang.Object getDeploymentConfigName();
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.DeploymentConfigName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentconfigname
     */
    void setDeploymentConfigName(final java.lang.String value);
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.DeploymentConfigName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentconfigname
     */
    void setDeploymentConfigName(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.DeploymentGroupName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentgroupname
     */
    java.lang.Object getDeploymentGroupName();
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.DeploymentGroupName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentgroupname
     */
    void setDeploymentGroupName(final java.lang.String value);
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.DeploymentGroupName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentgroupname
     */
    void setDeploymentGroupName(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.DeploymentStyle``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentstyle
     */
    java.lang.Object getDeploymentStyle();
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.DeploymentStyle``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentstyle
     */
    void setDeploymentStyle(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.DeploymentStyle``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentstyle
     */
    void setDeploymentStyle(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.DeploymentStyleProperty value);
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.Ec2TagFilters``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-ec2tagfilters
     */
    java.lang.Object getEc2TagFilters();
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.Ec2TagFilters``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-ec2tagfilters
     */
    void setEc2TagFilters(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.Ec2TagFilters``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-ec2tagfilters
     */
    void setEc2TagFilters(final java.util.List<java.lang.Object> value);
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.LoadBalancerInfo``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo
     */
    java.lang.Object getLoadBalancerInfo();
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.LoadBalancerInfo``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo
     */
    void setLoadBalancerInfo(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.LoadBalancerInfo``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo
     */
    void setLoadBalancerInfo(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.LoadBalancerInfoProperty value);
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.OnPremisesInstanceTagFilters``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-onpremisesinstancetagfilters
     */
    java.lang.Object getOnPremisesInstanceTagFilters();
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.OnPremisesInstanceTagFilters``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-onpremisesinstancetagfilters
     */
    void setOnPremisesInstanceTagFilters(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.OnPremisesInstanceTagFilters``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-onpremisesinstancetagfilters
     */
    void setOnPremisesInstanceTagFilters(final java.util.List<java.lang.Object> value);
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.TriggerConfigurations``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-triggerconfigurations
     */
    java.lang.Object getTriggerConfigurations();
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.TriggerConfigurations``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-triggerconfigurations
     */
    void setTriggerConfigurations(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::CodeDeploy::DeploymentGroup.TriggerConfigurations``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-triggerconfigurations
     */
    void setTriggerConfigurations(final java.util.List<java.lang.Object> value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link DeploymentGroupResourceProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.ApplicationName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-applicationname
         */
        public ServiceRoleArnStep withApplicationName(final java.lang.String value) {
            return new FullBuilder().withApplicationName(value);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.ApplicationName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-applicationname
         */
        public ServiceRoleArnStep withApplicationName(final software.amazon.awscdk.Token value) {
            return new FullBuilder().withApplicationName(value);
        }

        public interface ServiceRoleArnStep {
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.ServiceRoleArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-servicerolearn
             */
            Build withServiceRoleArn(final java.lang.String value);
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.ServiceRoleArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-servicerolearn
             */
            Build withServiceRoleArn(final software.amazon.awscdk.Token value);
        }

        public interface Build {
            /**
             * @return a new {@link DeploymentGroupResourceProps} object, initialized with the values set on this builder.
             */
            DeploymentGroupResourceProps build();
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.AlarmConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-alarmconfiguration
             */
            Build withAlarmConfiguration(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.AlarmConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-alarmconfiguration
             */
            Build withAlarmConfiguration(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.AlarmConfigurationProperty value);
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.AutoRollbackConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration
             */
            Build withAutoRollbackConfiguration(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.AutoRollbackConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration
             */
            Build withAutoRollbackConfiguration(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.AutoRollbackConfigurationProperty value);
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.AutoScalingGroups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-autoscalinggroups
             */
            Build withAutoScalingGroups(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.AutoScalingGroups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-autoscalinggroups
             */
            Build withAutoScalingGroups(final java.util.List<java.lang.Object> value);
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.Deployment``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deployment
             */
            Build withDeployment(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.Deployment``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deployment
             */
            Build withDeployment(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.DeploymentProperty value);
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.DeploymentConfigName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentconfigname
             */
            Build withDeploymentConfigName(final java.lang.String value);
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.DeploymentConfigName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentconfigname
             */
            Build withDeploymentConfigName(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.DeploymentGroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentgroupname
             */
            Build withDeploymentGroupName(final java.lang.String value);
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.DeploymentGroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentgroupname
             */
            Build withDeploymentGroupName(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.DeploymentStyle``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentstyle
             */
            Build withDeploymentStyle(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.DeploymentStyle``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentstyle
             */
            Build withDeploymentStyle(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.DeploymentStyleProperty value);
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.Ec2TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-ec2tagfilters
             */
            Build withEc2TagFilters(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.Ec2TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-ec2tagfilters
             */
            Build withEc2TagFilters(final java.util.List<java.lang.Object> value);
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.LoadBalancerInfo``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo
             */
            Build withLoadBalancerInfo(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.LoadBalancerInfo``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo
             */
            Build withLoadBalancerInfo(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.LoadBalancerInfoProperty value);
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.OnPremisesInstanceTagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-onpremisesinstancetagfilters
             */
            Build withOnPremisesInstanceTagFilters(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.OnPremisesInstanceTagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-onpremisesinstancetagfilters
             */
            Build withOnPremisesInstanceTagFilters(final java.util.List<java.lang.Object> value);
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.TriggerConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-triggerconfigurations
             */
            Build withTriggerConfigurations(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.TriggerConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-triggerconfigurations
             */
            Build withTriggerConfigurations(final java.util.List<java.lang.Object> value);
        }

        final class FullBuilder implements ServiceRoleArnStep, Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``AWS::CodeDeploy::DeploymentGroup.ApplicationName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-applicationname
             */
            public ServiceRoleArnStep withApplicationName(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "DeploymentGroupResourceProps#applicationName is required");
                this.instance._applicationName = value;
                return this;
            }
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.ApplicationName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-applicationname
             */
            public ServiceRoleArnStep withApplicationName(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "DeploymentGroupResourceProps#applicationName is required");
                this.instance._applicationName = value;
                return this;
            }
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.ServiceRoleArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-servicerolearn
             */
            public Build withServiceRoleArn(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "DeploymentGroupResourceProps#serviceRoleArn is required");
                this.instance._serviceRoleArn = value;
                return this;
            }
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.ServiceRoleArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-servicerolearn
             */
            public Build withServiceRoleArn(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "DeploymentGroupResourceProps#serviceRoleArn is required");
                this.instance._serviceRoleArn = value;
                return this;
            }
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.AlarmConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-alarmconfiguration
             */
            public Build withAlarmConfiguration(final software.amazon.awscdk.Token value) {
                this.instance._alarmConfiguration = value;
                return this;
            }
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.AlarmConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-alarmconfiguration
             */
            public Build withAlarmConfiguration(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.AlarmConfigurationProperty value) {
                this.instance._alarmConfiguration = value;
                return this;
            }
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.AutoRollbackConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration
             */
            public Build withAutoRollbackConfiguration(final software.amazon.awscdk.Token value) {
                this.instance._autoRollbackConfiguration = value;
                return this;
            }
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.AutoRollbackConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration
             */
            public Build withAutoRollbackConfiguration(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.AutoRollbackConfigurationProperty value) {
                this.instance._autoRollbackConfiguration = value;
                return this;
            }
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.AutoScalingGroups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-autoscalinggroups
             */
            public Build withAutoScalingGroups(final software.amazon.awscdk.Token value) {
                this.instance._autoScalingGroups = value;
                return this;
            }
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.AutoScalingGroups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-autoscalinggroups
             */
            public Build withAutoScalingGroups(final java.util.List<java.lang.Object> value) {
                this.instance._autoScalingGroups = value;
                return this;
            }
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.Deployment``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deployment
             */
            public Build withDeployment(final software.amazon.awscdk.Token value) {
                this.instance._deployment = value;
                return this;
            }
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.Deployment``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deployment
             */
            public Build withDeployment(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.DeploymentProperty value) {
                this.instance._deployment = value;
                return this;
            }
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.DeploymentConfigName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentconfigname
             */
            public Build withDeploymentConfigName(final java.lang.String value) {
                this.instance._deploymentConfigName = value;
                return this;
            }
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.DeploymentConfigName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentconfigname
             */
            public Build withDeploymentConfigName(final software.amazon.awscdk.Token value) {
                this.instance._deploymentConfigName = value;
                return this;
            }
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.DeploymentGroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentgroupname
             */
            public Build withDeploymentGroupName(final java.lang.String value) {
                this.instance._deploymentGroupName = value;
                return this;
            }
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.DeploymentGroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentgroupname
             */
            public Build withDeploymentGroupName(final software.amazon.awscdk.Token value) {
                this.instance._deploymentGroupName = value;
                return this;
            }
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.DeploymentStyle``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentstyle
             */
            public Build withDeploymentStyle(final software.amazon.awscdk.Token value) {
                this.instance._deploymentStyle = value;
                return this;
            }
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.DeploymentStyle``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentstyle
             */
            public Build withDeploymentStyle(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.DeploymentStyleProperty value) {
                this.instance._deploymentStyle = value;
                return this;
            }
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.Ec2TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-ec2tagfilters
             */
            public Build withEc2TagFilters(final software.amazon.awscdk.Token value) {
                this.instance._ec2TagFilters = value;
                return this;
            }
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.Ec2TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-ec2tagfilters
             */
            public Build withEc2TagFilters(final java.util.List<java.lang.Object> value) {
                this.instance._ec2TagFilters = value;
                return this;
            }
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.LoadBalancerInfo``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo
             */
            public Build withLoadBalancerInfo(final software.amazon.awscdk.Token value) {
                this.instance._loadBalancerInfo = value;
                return this;
            }
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.LoadBalancerInfo``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo
             */
            public Build withLoadBalancerInfo(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.LoadBalancerInfoProperty value) {
                this.instance._loadBalancerInfo = value;
                return this;
            }
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.OnPremisesInstanceTagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-onpremisesinstancetagfilters
             */
            public Build withOnPremisesInstanceTagFilters(final software.amazon.awscdk.Token value) {
                this.instance._onPremisesInstanceTagFilters = value;
                return this;
            }
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.OnPremisesInstanceTagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-onpremisesinstancetagfilters
             */
            public Build withOnPremisesInstanceTagFilters(final java.util.List<java.lang.Object> value) {
                this.instance._onPremisesInstanceTagFilters = value;
                return this;
            }
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.TriggerConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-triggerconfigurations
             */
            public Build withTriggerConfigurations(final software.amazon.awscdk.Token value) {
                this.instance._triggerConfigurations = value;
                return this;
            }
            /**
             * ``AWS::CodeDeploy::DeploymentGroup.TriggerConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-triggerconfigurations
             */
            public Build withTriggerConfigurations(final java.util.List<java.lang.Object> value) {
                this.instance._triggerConfigurations = value;
                return this;
            }
            public DeploymentGroupResourceProps build() {
                DeploymentGroupResourceProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link DeploymentGroupResourceProps}.
     */
    final class Jsii$Pojo implements DeploymentGroupResourceProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.Object _applicationName;

        public java.lang.Object getApplicationName() {
            return this._applicationName;
        }
        public void setApplicationName(final java.lang.String value) {
            this._applicationName = value;
        }
        public void setApplicationName(final software.amazon.awscdk.Token value) {
            this._applicationName = value;
        }

        protected java.lang.Object _serviceRoleArn;

        public java.lang.Object getServiceRoleArn() {
            return this._serviceRoleArn;
        }
        public void setServiceRoleArn(final java.lang.String value) {
            this._serviceRoleArn = value;
        }
        public void setServiceRoleArn(final software.amazon.awscdk.Token value) {
            this._serviceRoleArn = value;
        }

        protected java.lang.Object _alarmConfiguration;

        public java.lang.Object getAlarmConfiguration() {
            return this._alarmConfiguration;
        }
        public void setAlarmConfiguration(final software.amazon.awscdk.Token value) {
            this._alarmConfiguration = value;
        }
        public void setAlarmConfiguration(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.AlarmConfigurationProperty value) {
            this._alarmConfiguration = value;
        }

        protected java.lang.Object _autoRollbackConfiguration;

        public java.lang.Object getAutoRollbackConfiguration() {
            return this._autoRollbackConfiguration;
        }
        public void setAutoRollbackConfiguration(final software.amazon.awscdk.Token value) {
            this._autoRollbackConfiguration = value;
        }
        public void setAutoRollbackConfiguration(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.AutoRollbackConfigurationProperty value) {
            this._autoRollbackConfiguration = value;
        }

        protected java.lang.Object _autoScalingGroups;

        public java.lang.Object getAutoScalingGroups() {
            return this._autoScalingGroups;
        }
        public void setAutoScalingGroups(final software.amazon.awscdk.Token value) {
            this._autoScalingGroups = value;
        }
        public void setAutoScalingGroups(final java.util.List<java.lang.Object> value) {
            this._autoScalingGroups = value;
        }

        protected java.lang.Object _deployment;

        public java.lang.Object getDeployment() {
            return this._deployment;
        }
        public void setDeployment(final software.amazon.awscdk.Token value) {
            this._deployment = value;
        }
        public void setDeployment(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.DeploymentProperty value) {
            this._deployment = value;
        }

        protected java.lang.Object _deploymentConfigName;

        public java.lang.Object getDeploymentConfigName() {
            return this._deploymentConfigName;
        }
        public void setDeploymentConfigName(final java.lang.String value) {
            this._deploymentConfigName = value;
        }
        public void setDeploymentConfigName(final software.amazon.awscdk.Token value) {
            this._deploymentConfigName = value;
        }

        protected java.lang.Object _deploymentGroupName;

        public java.lang.Object getDeploymentGroupName() {
            return this._deploymentGroupName;
        }
        public void setDeploymentGroupName(final java.lang.String value) {
            this._deploymentGroupName = value;
        }
        public void setDeploymentGroupName(final software.amazon.awscdk.Token value) {
            this._deploymentGroupName = value;
        }

        protected java.lang.Object _deploymentStyle;

        public java.lang.Object getDeploymentStyle() {
            return this._deploymentStyle;
        }
        public void setDeploymentStyle(final software.amazon.awscdk.Token value) {
            this._deploymentStyle = value;
        }
        public void setDeploymentStyle(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.DeploymentStyleProperty value) {
            this._deploymentStyle = value;
        }

        protected java.lang.Object _ec2TagFilters;

        public java.lang.Object getEc2TagFilters() {
            return this._ec2TagFilters;
        }
        public void setEc2TagFilters(final software.amazon.awscdk.Token value) {
            this._ec2TagFilters = value;
        }
        public void setEc2TagFilters(final java.util.List<java.lang.Object> value) {
            this._ec2TagFilters = value;
        }

        protected java.lang.Object _loadBalancerInfo;

        public java.lang.Object getLoadBalancerInfo() {
            return this._loadBalancerInfo;
        }
        public void setLoadBalancerInfo(final software.amazon.awscdk.Token value) {
            this._loadBalancerInfo = value;
        }
        public void setLoadBalancerInfo(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.LoadBalancerInfoProperty value) {
            this._loadBalancerInfo = value;
        }

        protected java.lang.Object _onPremisesInstanceTagFilters;

        public java.lang.Object getOnPremisesInstanceTagFilters() {
            return this._onPremisesInstanceTagFilters;
        }
        public void setOnPremisesInstanceTagFilters(final software.amazon.awscdk.Token value) {
            this._onPremisesInstanceTagFilters = value;
        }
        public void setOnPremisesInstanceTagFilters(final java.util.List<java.lang.Object> value) {
            this._onPremisesInstanceTagFilters = value;
        }

        protected java.lang.Object _triggerConfigurations;

        public java.lang.Object getTriggerConfigurations() {
            return this._triggerConfigurations;
        }
        public void setTriggerConfigurations(final software.amazon.awscdk.Token value) {
            this._triggerConfigurations = value;
        }
        public void setTriggerConfigurations(final java.util.List<java.lang.Object> value) {
            this._triggerConfigurations = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResourceProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.ApplicationName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-applicationname
         */
        public java.lang.Object getApplicationName() {
            return this.jsiiGet("applicationName", java.lang.Object.class);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.ApplicationName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-applicationname
         */
        public void setApplicationName(final java.lang.String value) {
            this.jsiiSet("applicationName", java.util.Objects.requireNonNull(value, "applicationName is required"));
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.ApplicationName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-applicationname
         */
        public void setApplicationName(final software.amazon.awscdk.Token value) {
            this.jsiiSet("applicationName", java.util.Objects.requireNonNull(value, "applicationName is required"));
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.ServiceRoleArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-servicerolearn
         */
        public java.lang.Object getServiceRoleArn() {
            return this.jsiiGet("serviceRoleArn", java.lang.Object.class);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.ServiceRoleArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-servicerolearn
         */
        public void setServiceRoleArn(final java.lang.String value) {
            this.jsiiSet("serviceRoleArn", java.util.Objects.requireNonNull(value, "serviceRoleArn is required"));
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.ServiceRoleArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-servicerolearn
         */
        public void setServiceRoleArn(final software.amazon.awscdk.Token value) {
            this.jsiiSet("serviceRoleArn", java.util.Objects.requireNonNull(value, "serviceRoleArn is required"));
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.AlarmConfiguration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-alarmconfiguration
         */
        @javax.annotation.Nullable
        public java.lang.Object getAlarmConfiguration() {
            return this.jsiiGet("alarmConfiguration", java.lang.Object.class);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.AlarmConfiguration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-alarmconfiguration
         */
        public void setAlarmConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("alarmConfiguration", value);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.AlarmConfiguration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-alarmconfiguration
         */
        public void setAlarmConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.AlarmConfigurationProperty value) {
            this.jsiiSet("alarmConfiguration", value);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.AutoRollbackConfiguration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration
         */
        @javax.annotation.Nullable
        public java.lang.Object getAutoRollbackConfiguration() {
            return this.jsiiGet("autoRollbackConfiguration", java.lang.Object.class);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.AutoRollbackConfiguration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration
         */
        public void setAutoRollbackConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("autoRollbackConfiguration", value);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.AutoRollbackConfiguration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration
         */
        public void setAutoRollbackConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.AutoRollbackConfigurationProperty value) {
            this.jsiiSet("autoRollbackConfiguration", value);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.AutoScalingGroups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-autoscalinggroups
         */
        @javax.annotation.Nullable
        public java.lang.Object getAutoScalingGroups() {
            return this.jsiiGet("autoScalingGroups", java.lang.Object.class);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.AutoScalingGroups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-autoscalinggroups
         */
        public void setAutoScalingGroups(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("autoScalingGroups", value);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.AutoScalingGroups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-autoscalinggroups
         */
        public void setAutoScalingGroups(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
            this.jsiiSet("autoScalingGroups", value);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.Deployment``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deployment
         */
        @javax.annotation.Nullable
        public java.lang.Object getDeployment() {
            return this.jsiiGet("deployment", java.lang.Object.class);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.Deployment``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deployment
         */
        public void setDeployment(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("deployment", value);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.Deployment``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deployment
         */
        public void setDeployment(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.DeploymentProperty value) {
            this.jsiiSet("deployment", value);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.DeploymentConfigName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentconfigname
         */
        @javax.annotation.Nullable
        public java.lang.Object getDeploymentConfigName() {
            return this.jsiiGet("deploymentConfigName", java.lang.Object.class);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.DeploymentConfigName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentconfigname
         */
        public void setDeploymentConfigName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("deploymentConfigName", value);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.DeploymentConfigName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentconfigname
         */
        public void setDeploymentConfigName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("deploymentConfigName", value);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.DeploymentGroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentgroupname
         */
        @javax.annotation.Nullable
        public java.lang.Object getDeploymentGroupName() {
            return this.jsiiGet("deploymentGroupName", java.lang.Object.class);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.DeploymentGroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentgroupname
         */
        public void setDeploymentGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("deploymentGroupName", value);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.DeploymentGroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentgroupname
         */
        public void setDeploymentGroupName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("deploymentGroupName", value);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.DeploymentStyle``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentstyle
         */
        @javax.annotation.Nullable
        public java.lang.Object getDeploymentStyle() {
            return this.jsiiGet("deploymentStyle", java.lang.Object.class);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.DeploymentStyle``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentstyle
         */
        public void setDeploymentStyle(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("deploymentStyle", value);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.DeploymentStyle``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentstyle
         */
        public void setDeploymentStyle(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.DeploymentStyleProperty value) {
            this.jsiiSet("deploymentStyle", value);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.Ec2TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-ec2tagfilters
         */
        @javax.annotation.Nullable
        public java.lang.Object getEc2TagFilters() {
            return this.jsiiGet("ec2TagFilters", java.lang.Object.class);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.Ec2TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-ec2tagfilters
         */
        public void setEc2TagFilters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("ec2TagFilters", value);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.Ec2TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-ec2tagfilters
         */
        public void setEc2TagFilters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
            this.jsiiSet("ec2TagFilters", value);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.LoadBalancerInfo``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo
         */
        @javax.annotation.Nullable
        public java.lang.Object getLoadBalancerInfo() {
            return this.jsiiGet("loadBalancerInfo", java.lang.Object.class);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.LoadBalancerInfo``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo
         */
        public void setLoadBalancerInfo(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("loadBalancerInfo", value);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.LoadBalancerInfo``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo
         */
        public void setLoadBalancerInfo(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.LoadBalancerInfoProperty value) {
            this.jsiiSet("loadBalancerInfo", value);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.OnPremisesInstanceTagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-onpremisesinstancetagfilters
         */
        @javax.annotation.Nullable
        public java.lang.Object getOnPremisesInstanceTagFilters() {
            return this.jsiiGet("onPremisesInstanceTagFilters", java.lang.Object.class);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.OnPremisesInstanceTagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-onpremisesinstancetagfilters
         */
        public void setOnPremisesInstanceTagFilters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("onPremisesInstanceTagFilters", value);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.OnPremisesInstanceTagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-onpremisesinstancetagfilters
         */
        public void setOnPremisesInstanceTagFilters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
            this.jsiiSet("onPremisesInstanceTagFilters", value);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.TriggerConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-triggerconfigurations
         */
        @javax.annotation.Nullable
        public java.lang.Object getTriggerConfigurations() {
            return this.jsiiGet("triggerConfigurations", java.lang.Object.class);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.TriggerConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-triggerconfigurations
         */
        public void setTriggerConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("triggerConfigurations", value);
        }
        /**
         * ``AWS::CodeDeploy::DeploymentGroup.TriggerConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-triggerconfigurations
         */
        public void setTriggerConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
            this.jsiiSet("triggerConfigurations", value);
        }
    }
}
