package software.amazon.awscdk.services.codedeploy;

/**
 * Construction properties for {@link ServerDeploymentGroup}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.5 (build 845cc48)", date = "2018-09-14T09:18:26.663Z")
public interface ServerDeploymentGroupProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The CodeDeploy EC2/on-premise Application this Deployment Group belongs to.
     * If you don't provide one, a new Application will be created.
     */
    software.amazon.awscdk.services.codedeploy.ServerApplicationRef getApplication();
    /**
     * The CodeDeploy EC2/on-premise Application this Deployment Group belongs to.
     * If you don't provide one, a new Application will be created.
     */
    void setApplication(final software.amazon.awscdk.services.codedeploy.ServerApplicationRef value);
    /**
     * The physical, human-readable name of the CodeDeploy Deployment Group.
     * @default an auto-generated name will be used
     */
    java.lang.String getDeploymentGroupName();
    /**
     * The physical, human-readable name of the CodeDeploy Deployment Group.
     * @default an auto-generated name will be used
     */
    void setDeploymentGroupName(final java.lang.String value);
    /**
     * The service Role of this Deployment Group.
     * If you don't provide one, a new Role will be created.
     */
    software.amazon.awscdk.services.iam.Role getRole();
    /**
     * The service Role of this Deployment Group.
     * If you don't provide one, a new Role will be created.
     */
    void setRole(final software.amazon.awscdk.services.iam.Role value);

    /**
     * @return a {@link Builder} of {@link ServerDeploymentGroupProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ServerDeploymentGroupProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codedeploy.ServerApplicationRef _application;
        @javax.annotation.Nullable
        private java.lang.String _deploymentGroupName;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.iam.Role _role;

        /**
         * Sets the value of Application
         * @param value The CodeDeploy EC2/on-premise Application this Deployment Group belongs to.
If you don't provide one, a new Application will be created.
         * @return {@code this}
         */
        public Builder withApplication(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.ServerApplicationRef value) {
            this._application = value;
            return this;
        }
        /**
         * Sets the value of DeploymentGroupName
         * @param value The physical, human-readable name of the CodeDeploy Deployment Group.
         * @return {@code this}
         */
        public Builder withDeploymentGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this._deploymentGroupName = value;
            return this;
        }
        /**
         * Sets the value of Role
         * @param value The service Role of this Deployment Group.
If you don't provide one, a new Role will be created.
         * @return {@code this}
         */
        public Builder withRole(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.Role value) {
            this._role = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServerDeploymentGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public ServerDeploymentGroupProps build() {
            return new ServerDeploymentGroupProps() {
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.codedeploy.ServerApplicationRef $application = _application;
                @javax.annotation.Nullable
                private java.lang.String $deploymentGroupName = _deploymentGroupName;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.iam.Role $role = _role;

                @Override
                public software.amazon.awscdk.services.codedeploy.ServerApplicationRef getApplication() {
                    return this.$application;
                }

                @Override
                public void setApplication(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.ServerApplicationRef value) {
                    this.$application = value;
                }

                @Override
                public java.lang.String getDeploymentGroupName() {
                    return this.$deploymentGroupName;
                }

                @Override
                public void setDeploymentGroupName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$deploymentGroupName = value;
                }

                @Override
                public software.amazon.awscdk.services.iam.Role getRole() {
                    return this.$role;
                }

                @Override
                public void setRole(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.Role value) {
                    this.$role = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The CodeDeploy EC2/on-premise Application this Deployment Group belongs to.
         * If you don't provide one, a new Application will be created.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codedeploy.ServerApplicationRef getApplication() {
            return this.jsiiGet("application", software.amazon.awscdk.services.codedeploy.ServerApplicationRef.class);
        }

        /**
         * The CodeDeploy EC2/on-premise Application this Deployment Group belongs to.
         * If you don't provide one, a new Application will be created.
         */
        @Override
        public void setApplication(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.ServerApplicationRef value) {
            this.jsiiSet("application", value);
        }

        /**
         * The physical, human-readable name of the CodeDeploy Deployment Group.
         * @default an auto-generated name will be used
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getDeploymentGroupName() {
            return this.jsiiGet("deploymentGroupName", java.lang.String.class);
        }

        /**
         * The physical, human-readable name of the CodeDeploy Deployment Group.
         * @default an auto-generated name will be used
         */
        @Override
        public void setDeploymentGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("deploymentGroupName", value);
        }

        /**
         * The service Role of this Deployment Group.
         * If you don't provide one, a new Role will be created.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.iam.Role getRole() {
            return this.jsiiGet("role", software.amazon.awscdk.services.iam.Role.class);
        }

        /**
         * The service Role of this Deployment Group.
         * If you don't provide one, a new Role will be created.
         */
        @Override
        public void setRole(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.Role value) {
            this.jsiiSet("role", value);
        }
    }
}
