package software.amazon.awscdk.services.codedeploy;

/**
 * Represents a reference to a CodeDeploy EC2/on-premise Deployment Group.
 * 
 * If you're managing the Deployment Group alongside the rest of your CDK resources,
 * use the {@link ServerDeploymentGroup} class.
 * 
 * If you want to reference an already existing Deployment Group,
 * or one defined in a different CDK Stack,
 * use the {@link #import} method.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.5 (build 845cc48)", date = "2018-09-14T09:18:26.663Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.ServerDeploymentGroupRef")
public abstract class ServerDeploymentGroupRef extends software.amazon.awscdk.Construct {
    protected ServerDeploymentGroupRef(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }

    /**
     * Import an EC2/on-premise Deployment Group defined either outside the CDK,
     * or in a different CDK Stack and exported using the {@link #export} method.
     * @return a Construct representing a reference to an existing Deployment Group
     * @param parent the parent Construct for this new Construct
     * @param id the logical ID of this new Construct
     * @param props the properties of the referenced Deployment Group
     */
    public static software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupRef import_(final software.amazon.awscdk.Construct parent, final java.lang.String id, final software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupRefProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupRef.class, "import", software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupRef.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    public software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupRefProps export() {
        return this.jsiiCall("export", software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupRefProps.class);
    }

    public software.amazon.awscdk.services.codedeploy.ServerApplicationRef getApplication() {
        return this.jsiiGet("application", software.amazon.awscdk.services.codedeploy.ServerApplicationRef.class);
    }

    public software.amazon.awscdk.services.codedeploy.DeploymentGroupArn getDeploymentGroupArn() {
        return this.jsiiGet("deploymentGroupArn", software.amazon.awscdk.services.codedeploy.DeploymentGroupArn.class);
    }

    public software.amazon.awscdk.services.codedeploy.DeploymentGroupName getDeploymentGroupName() {
        return this.jsiiGet("deploymentGroupName", software.amazon.awscdk.services.codedeploy.DeploymentGroupName.class);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupRef {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        @Override
        public software.amazon.awscdk.services.codedeploy.ServerApplicationRef getApplication() {
            return this.jsiiGet("application", software.amazon.awscdk.services.codedeploy.ServerApplicationRef.class);
        }

        @Override
        public software.amazon.awscdk.services.codedeploy.DeploymentGroupArn getDeploymentGroupArn() {
            return this.jsiiGet("deploymentGroupArn", software.amazon.awscdk.services.codedeploy.DeploymentGroupArn.class);
        }

        @Override
        public software.amazon.awscdk.services.codedeploy.DeploymentGroupName getDeploymentGroupName() {
            return this.jsiiGet("deploymentGroupName", software.amazon.awscdk.services.codedeploy.DeploymentGroupName.class);
        }
    }
}
