package software.amazon.awscdk.services.codedeploy.cloudformation;

/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.5 (build 845cc48)", date = "2018-09-14T09:18:26.667Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.cloudformation.DeploymentGroupResource")
public class DeploymentGroupResource extends software.amazon.awscdk.Resource {
    protected DeploymentGroupResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::CodeDeploy::DeploymentGroup``.
     * @param parent the ``cdk.Construct`` this ``DeploymentGroupResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``DeploymentGroupResource``
     */
    public DeploymentGroupResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public software.amazon.awscdk.services.codedeploy.DeploymentGroupName getRef() {
        return this.jsiiGet("ref", software.amazon.awscdk.services.codedeploy.DeploymentGroupName.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html
     */
    public static interface AlarmConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentGroupResource.AlarmConfigurationProperty.Alarms``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-alarms
         */
        java.lang.Object getAlarms();
        /**
         * ``DeploymentGroupResource.AlarmConfigurationProperty.Alarms``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-alarms
         */
        void setAlarms(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``DeploymentGroupResource.AlarmConfigurationProperty.Alarms``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-alarms
         */
        void setAlarms(final java.util.List<java.lang.Object> value);
        /**
         * ``DeploymentGroupResource.AlarmConfigurationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-enabled
         */
        java.lang.Object getEnabled();
        /**
         * ``DeploymentGroupResource.AlarmConfigurationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-enabled
         */
        void setEnabled(final java.lang.Boolean value);
        /**
         * ``DeploymentGroupResource.AlarmConfigurationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-enabled
         */
        void setEnabled(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``DeploymentGroupResource.AlarmConfigurationProperty.IgnorePollAlarmFailure``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-ignorepollalarmfailure
         */
        java.lang.Object getIgnorePollAlarmFailure();
        /**
         * ``DeploymentGroupResource.AlarmConfigurationProperty.IgnorePollAlarmFailure``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-ignorepollalarmfailure
         */
        void setIgnorePollAlarmFailure(final java.lang.Boolean value);
        /**
         * ``DeploymentGroupResource.AlarmConfigurationProperty.IgnorePollAlarmFailure``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-ignorepollalarmfailure
         */
        void setIgnorePollAlarmFailure(final software.amazon.awscdk.CloudFormationToken value);

        /**
         * @return a {@link Builder} of {@link AlarmConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AlarmConfigurationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _alarms;
            @javax.annotation.Nullable
            private java.lang.Object _enabled;
            @javax.annotation.Nullable
            private java.lang.Object _ignorePollAlarmFailure;

            /**
             * Sets the value of Alarms
             * @param value ``DeploymentGroupResource.AlarmConfigurationProperty.Alarms``
             * @return {@code this}
             */
            public Builder withAlarms(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._alarms = value;
                return this;
            }
            /**
             * Sets the value of Alarms
             * @param value ``DeploymentGroupResource.AlarmConfigurationProperty.Alarms``
             * @return {@code this}
             */
            public Builder withAlarms(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._alarms = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value ``DeploymentGroupResource.AlarmConfigurationProperty.Enabled``
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value ``DeploymentGroupResource.AlarmConfigurationProperty.Enabled``
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of IgnorePollAlarmFailure
             * @param value ``DeploymentGroupResource.AlarmConfigurationProperty.IgnorePollAlarmFailure``
             * @return {@code this}
             */
            public Builder withIgnorePollAlarmFailure(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._ignorePollAlarmFailure = value;
                return this;
            }
            /**
             * Sets the value of IgnorePollAlarmFailure
             * @param value ``DeploymentGroupResource.AlarmConfigurationProperty.IgnorePollAlarmFailure``
             * @return {@code this}
             */
            public Builder withIgnorePollAlarmFailure(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._ignorePollAlarmFailure = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AlarmConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AlarmConfigurationProperty build() {
                return new AlarmConfigurationProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $alarms = _alarms;
                    @javax.annotation.Nullable
                    private java.lang.Object $enabled = _enabled;
                    @javax.annotation.Nullable
                    private java.lang.Object $ignorePollAlarmFailure = _ignorePollAlarmFailure;

                    @Override
                    public java.lang.Object getAlarms() {
                        return this.$alarms;
                    }

                    @Override
                    public void setAlarms(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$alarms = value;
                    }

                    @Override
                    public void setAlarms(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$alarms = value;
                    }

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    @Override
                    public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$enabled = value;
                    }

                    @Override
                    public void setEnabled(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$enabled = value;
                    }

                    @Override
                    public java.lang.Object getIgnorePollAlarmFailure() {
                        return this.$ignorePollAlarmFailure;
                    }

                    @Override
                    public void setIgnorePollAlarmFailure(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$ignorePollAlarmFailure = value;
                    }

                    @Override
                    public void setIgnorePollAlarmFailure(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$ignorePollAlarmFailure = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.AlarmConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``DeploymentGroupResource.AlarmConfigurationProperty.Alarms``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-alarms
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAlarms() {
                return this.jsiiGet("alarms", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.AlarmConfigurationProperty.Alarms``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-alarms
             */
            @Override
            public void setAlarms(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("alarms", value);
            }

            /**
             * ``DeploymentGroupResource.AlarmConfigurationProperty.Alarms``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-alarms
             */
            @Override
            public void setAlarms(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("alarms", value);
            }

            /**
             * ``DeploymentGroupResource.AlarmConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-enabled
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.AlarmConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-enabled
             */
            @Override
            public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("enabled", value);
            }

            /**
             * ``DeploymentGroupResource.AlarmConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-enabled
             */
            @Override
            public void setEnabled(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("enabled", value);
            }

            /**
             * ``DeploymentGroupResource.AlarmConfigurationProperty.IgnorePollAlarmFailure``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-ignorepollalarmfailure
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIgnorePollAlarmFailure() {
                return this.jsiiGet("ignorePollAlarmFailure", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.AlarmConfigurationProperty.IgnorePollAlarmFailure``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-ignorepollalarmfailure
             */
            @Override
            public void setIgnorePollAlarmFailure(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("ignorePollAlarmFailure", value);
            }

            /**
             * ``DeploymentGroupResource.AlarmConfigurationProperty.IgnorePollAlarmFailure``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-ignorepollalarmfailure
             */
            @Override
            public void setIgnorePollAlarmFailure(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("ignorePollAlarmFailure", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarm.html
     */
    public static interface AlarmProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentGroupResource.AlarmProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarm.html#cfn-codedeploy-deploymentgroup-alarm-name
         */
        java.lang.Object getName();
        /**
         * ``DeploymentGroupResource.AlarmProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarm.html#cfn-codedeploy-deploymentgroup-alarm-name
         */
        void setName(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.AlarmProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarm.html#cfn-codedeploy-deploymentgroup-alarm-name
         */
        void setName(final software.amazon.awscdk.CloudFormationToken value);

        /**
         * @return a {@link Builder} of {@link AlarmProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AlarmProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _name;

            /**
             * Sets the value of Name
             * @param value ``DeploymentGroupResource.AlarmProperty.Name``
             * @return {@code this}
             */
            public Builder withName(@javax.annotation.Nullable final java.lang.String value) {
                this._name = value;
                return this;
            }
            /**
             * Sets the value of Name
             * @param value ``DeploymentGroupResource.AlarmProperty.Name``
             * @return {@code this}
             */
            public Builder withName(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._name = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AlarmProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AlarmProperty build() {
                return new AlarmProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $name = _name;

                    @Override
                    public java.lang.Object getName() {
                        return this.$name;
                    }

                    @Override
                    public void setName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$name = value;
                    }

                    @Override
                    public void setName(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$name = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.AlarmProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``DeploymentGroupResource.AlarmProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarm.html#cfn-codedeploy-deploymentgroup-alarm-name
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getName() {
                return this.jsiiGet("name", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.AlarmProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarm.html#cfn-codedeploy-deploymentgroup-alarm-name
             */
            @Override
            public void setName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("name", value);
            }

            /**
             * ``DeploymentGroupResource.AlarmProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarm.html#cfn-codedeploy-deploymentgroup-alarm-name
             */
            @Override
            public void setName(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("name", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html
     */
    public static interface AutoRollbackConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-enabled
         */
        java.lang.Object getEnabled();
        /**
         * ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-enabled
         */
        void setEnabled(final java.lang.Boolean value);
        /**
         * ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-enabled
         */
        void setEnabled(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Events``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-events
         */
        java.lang.Object getEvents();
        /**
         * ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Events``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-events
         */
        void setEvents(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Events``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-events
         */
        void setEvents(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link AutoRollbackConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AutoRollbackConfigurationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _enabled;
            @javax.annotation.Nullable
            private java.lang.Object _events;

            /**
             * Sets the value of Enabled
             * @param value ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Enabled``
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Enabled``
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of Events
             * @param value ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Events``
             * @return {@code this}
             */
            public Builder withEvents(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._events = value;
                return this;
            }
            /**
             * Sets the value of Events
             * @param value ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Events``
             * @return {@code this}
             */
            public Builder withEvents(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._events = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoRollbackConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AutoRollbackConfigurationProperty build() {
                return new AutoRollbackConfigurationProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $enabled = _enabled;
                    @javax.annotation.Nullable
                    private java.lang.Object $events = _events;

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    @Override
                    public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$enabled = value;
                    }

                    @Override
                    public void setEnabled(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$enabled = value;
                    }

                    @Override
                    public java.lang.Object getEvents() {
                        return this.$events;
                    }

                    @Override
                    public void setEvents(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$events = value;
                    }

                    @Override
                    public void setEvents(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$events = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.AutoRollbackConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-enabled
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-enabled
             */
            @Override
            public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("enabled", value);
            }

            /**
             * ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-enabled
             */
            @Override
            public void setEnabled(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("enabled", value);
            }

            /**
             * ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Events``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-events
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEvents() {
                return this.jsiiGet("events", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Events``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-events
             */
            @Override
            public void setEvents(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("events", value);
            }

            /**
             * ``DeploymentGroupResource.AutoRollbackConfigurationProperty.Events``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-events
             */
            @Override
            public void setEvents(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("events", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html
     */
    public static interface DeploymentProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentGroupResource.DeploymentProperty.Revision``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision
         */
        java.lang.Object getRevision();
        /**
         * ``DeploymentGroupResource.DeploymentProperty.Revision``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision
         */
        void setRevision(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``DeploymentGroupResource.DeploymentProperty.Revision``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision
         */
        void setRevision(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.RevisionLocationProperty value);
        /**
         * ``DeploymentGroupResource.DeploymentProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-description
         */
        java.lang.Object getDescription();
        /**
         * ``DeploymentGroupResource.DeploymentProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-description
         */
        void setDescription(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.DeploymentProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-description
         */
        void setDescription(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``DeploymentGroupResource.DeploymentProperty.IgnoreApplicationStopFailures``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-ignoreapplicationstopfailures
         */
        java.lang.Object getIgnoreApplicationStopFailures();
        /**
         * ``DeploymentGroupResource.DeploymentProperty.IgnoreApplicationStopFailures``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-ignoreapplicationstopfailures
         */
        void setIgnoreApplicationStopFailures(final java.lang.Boolean value);
        /**
         * ``DeploymentGroupResource.DeploymentProperty.IgnoreApplicationStopFailures``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-ignoreapplicationstopfailures
         */
        void setIgnoreApplicationStopFailures(final software.amazon.awscdk.CloudFormationToken value);

        /**
         * @return a {@link Builder} of {@link DeploymentProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link DeploymentProperty}
         */
        final class Builder {
            private java.lang.Object _revision;
            @javax.annotation.Nullable
            private java.lang.Object _description;
            @javax.annotation.Nullable
            private java.lang.Object _ignoreApplicationStopFailures;

            /**
             * Sets the value of Revision
             * @param value ``DeploymentGroupResource.DeploymentProperty.Revision``
             * @return {@code this}
             */
            public Builder withRevision(final software.amazon.awscdk.CloudFormationToken value) {
                this._revision = java.util.Objects.requireNonNull(value, "revision is required");
                return this;
            }
            /**
             * Sets the value of Revision
             * @param value ``DeploymentGroupResource.DeploymentProperty.Revision``
             * @return {@code this}
             */
            public Builder withRevision(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.RevisionLocationProperty value) {
                this._revision = java.util.Objects.requireNonNull(value, "revision is required");
                return this;
            }
            /**
             * Sets the value of Description
             * @param value ``DeploymentGroupResource.DeploymentProperty.Description``
             * @return {@code this}
             */
            public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
                this._description = value;
                return this;
            }
            /**
             * Sets the value of Description
             * @param value ``DeploymentGroupResource.DeploymentProperty.Description``
             * @return {@code this}
             */
            public Builder withDescription(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._description = value;
                return this;
            }
            /**
             * Sets the value of IgnoreApplicationStopFailures
             * @param value ``DeploymentGroupResource.DeploymentProperty.IgnoreApplicationStopFailures``
             * @return {@code this}
             */
            public Builder withIgnoreApplicationStopFailures(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._ignoreApplicationStopFailures = value;
                return this;
            }
            /**
             * Sets the value of IgnoreApplicationStopFailures
             * @param value ``DeploymentGroupResource.DeploymentProperty.IgnoreApplicationStopFailures``
             * @return {@code this}
             */
            public Builder withIgnoreApplicationStopFailures(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._ignoreApplicationStopFailures = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public DeploymentProperty build() {
                return new DeploymentProperty() {
                    private java.lang.Object $revision = java.util.Objects.requireNonNull(_revision, "revision is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $description = _description;
                    @javax.annotation.Nullable
                    private java.lang.Object $ignoreApplicationStopFailures = _ignoreApplicationStopFailures;

                    @Override
                    public java.lang.Object getRevision() {
                        return this.$revision;
                    }

                    @Override
                    public void setRevision(final software.amazon.awscdk.CloudFormationToken value) {
                        this.$revision = java.util.Objects.requireNonNull(value, "revision is required");
                    }

                    @Override
                    public void setRevision(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.RevisionLocationProperty value) {
                        this.$revision = java.util.Objects.requireNonNull(value, "revision is required");
                    }

                    @Override
                    public java.lang.Object getDescription() {
                        return this.$description;
                    }

                    @Override
                    public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                        this.$description = value;
                    }

                    @Override
                    public void setDescription(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$description = value;
                    }

                    @Override
                    public java.lang.Object getIgnoreApplicationStopFailures() {
                        return this.$ignoreApplicationStopFailures;
                    }

                    @Override
                    public void setIgnoreApplicationStopFailures(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$ignoreApplicationStopFailures = value;
                    }

                    @Override
                    public void setIgnoreApplicationStopFailures(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$ignoreApplicationStopFailures = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.DeploymentProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``DeploymentGroupResource.DeploymentProperty.Revision``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision
             */
            @Override
            public java.lang.Object getRevision() {
                return this.jsiiGet("revision", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.DeploymentProperty.Revision``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision
             */
            @Override
            public void setRevision(final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("revision", java.util.Objects.requireNonNull(value, "revision is required"));
            }

            /**
             * ``DeploymentGroupResource.DeploymentProperty.Revision``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision
             */
            @Override
            public void setRevision(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.RevisionLocationProperty value) {
                this.jsiiSet("revision", java.util.Objects.requireNonNull(value, "revision is required"));
            }

            /**
             * ``DeploymentGroupResource.DeploymentProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-description
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDescription() {
                return this.jsiiGet("description", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.DeploymentProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-description
             */
            @Override
            public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("description", value);
            }

            /**
             * ``DeploymentGroupResource.DeploymentProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-description
             */
            @Override
            public void setDescription(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("description", value);
            }

            /**
             * ``DeploymentGroupResource.DeploymentProperty.IgnoreApplicationStopFailures``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-ignoreapplicationstopfailures
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIgnoreApplicationStopFailures() {
                return this.jsiiGet("ignoreApplicationStopFailures", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.DeploymentProperty.IgnoreApplicationStopFailures``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-ignoreapplicationstopfailures
             */
            @Override
            public void setIgnoreApplicationStopFailures(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("ignoreApplicationStopFailures", value);
            }

            /**
             * ``DeploymentGroupResource.DeploymentProperty.IgnoreApplicationStopFailures``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-ignoreapplicationstopfailures
             */
            @Override
            public void setIgnoreApplicationStopFailures(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("ignoreApplicationStopFailures", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html
     */
    public static interface DeploymentStyleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentOption``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymentoption
         */
        java.lang.Object getDeploymentOption();
        /**
         * ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentOption``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymentoption
         */
        void setDeploymentOption(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentOption``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymentoption
         */
        void setDeploymentOption(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymenttype
         */
        java.lang.Object getDeploymentType();
        /**
         * ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymenttype
         */
        void setDeploymentType(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymenttype
         */
        void setDeploymentType(final software.amazon.awscdk.CloudFormationToken value);

        /**
         * @return a {@link Builder} of {@link DeploymentStyleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link DeploymentStyleProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _deploymentOption;
            @javax.annotation.Nullable
            private java.lang.Object _deploymentType;

            /**
             * Sets the value of DeploymentOption
             * @param value ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentOption``
             * @return {@code this}
             */
            public Builder withDeploymentOption(@javax.annotation.Nullable final java.lang.String value) {
                this._deploymentOption = value;
                return this;
            }
            /**
             * Sets the value of DeploymentOption
             * @param value ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentOption``
             * @return {@code this}
             */
            public Builder withDeploymentOption(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._deploymentOption = value;
                return this;
            }
            /**
             * Sets the value of DeploymentType
             * @param value ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentType``
             * @return {@code this}
             */
            public Builder withDeploymentType(@javax.annotation.Nullable final java.lang.String value) {
                this._deploymentType = value;
                return this;
            }
            /**
             * Sets the value of DeploymentType
             * @param value ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentType``
             * @return {@code this}
             */
            public Builder withDeploymentType(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._deploymentType = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentStyleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public DeploymentStyleProperty build() {
                return new DeploymentStyleProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $deploymentOption = _deploymentOption;
                    @javax.annotation.Nullable
                    private java.lang.Object $deploymentType = _deploymentType;

                    @Override
                    public java.lang.Object getDeploymentOption() {
                        return this.$deploymentOption;
                    }

                    @Override
                    public void setDeploymentOption(@javax.annotation.Nullable final java.lang.String value) {
                        this.$deploymentOption = value;
                    }

                    @Override
                    public void setDeploymentOption(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$deploymentOption = value;
                    }

                    @Override
                    public java.lang.Object getDeploymentType() {
                        return this.$deploymentType;
                    }

                    @Override
                    public void setDeploymentType(@javax.annotation.Nullable final java.lang.String value) {
                        this.$deploymentType = value;
                    }

                    @Override
                    public void setDeploymentType(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$deploymentType = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.DeploymentStyleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentOption``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymentoption
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDeploymentOption() {
                return this.jsiiGet("deploymentOption", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentOption``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymentoption
             */
            @Override
            public void setDeploymentOption(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("deploymentOption", value);
            }

            /**
             * ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentOption``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymentoption
             */
            @Override
            public void setDeploymentOption(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("deploymentOption", value);
            }

            /**
             * ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymenttype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDeploymentType() {
                return this.jsiiGet("deploymentType", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymenttype
             */
            @Override
            public void setDeploymentType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("deploymentType", value);
            }

            /**
             * ``DeploymentGroupResource.DeploymentStyleProperty.DeploymentType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymenttype
             */
            @Override
            public void setDeploymentType(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("deploymentType", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html
     */
    public static interface EC2TagFilterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentGroupResource.EC2TagFilterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-key
         */
        java.lang.Object getKey();
        /**
         * ``DeploymentGroupResource.EC2TagFilterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-key
         */
        void setKey(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.EC2TagFilterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-key
         */
        void setKey(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``DeploymentGroupResource.EC2TagFilterProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-type
         */
        java.lang.Object getType();
        /**
         * ``DeploymentGroupResource.EC2TagFilterProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-type
         */
        void setType(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.EC2TagFilterProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-type
         */
        void setType(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``DeploymentGroupResource.EC2TagFilterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-value
         */
        java.lang.Object getValue();
        /**
         * ``DeploymentGroupResource.EC2TagFilterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-value
         */
        void setValue(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.EC2TagFilterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-value
         */
        void setValue(final software.amazon.awscdk.CloudFormationToken value);

        /**
         * @return a {@link Builder} of {@link EC2TagFilterProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EC2TagFilterProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _key;
            @javax.annotation.Nullable
            private java.lang.Object _type;
            @javax.annotation.Nullable
            private java.lang.Object _value;

            /**
             * Sets the value of Key
             * @param value ``DeploymentGroupResource.EC2TagFilterProperty.Key``
             * @return {@code this}
             */
            public Builder withKey(@javax.annotation.Nullable final java.lang.String value) {
                this._key = value;
                return this;
            }
            /**
             * Sets the value of Key
             * @param value ``DeploymentGroupResource.EC2TagFilterProperty.Key``
             * @return {@code this}
             */
            public Builder withKey(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._key = value;
                return this;
            }
            /**
             * Sets the value of Type
             * @param value ``DeploymentGroupResource.EC2TagFilterProperty.Type``
             * @return {@code this}
             */
            public Builder withType(@javax.annotation.Nullable final java.lang.String value) {
                this._type = value;
                return this;
            }
            /**
             * Sets the value of Type
             * @param value ``DeploymentGroupResource.EC2TagFilterProperty.Type``
             * @return {@code this}
             */
            public Builder withType(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._type = value;
                return this;
            }
            /**
             * Sets the value of Value
             * @param value ``DeploymentGroupResource.EC2TagFilterProperty.Value``
             * @return {@code this}
             */
            public Builder withValue(@javax.annotation.Nullable final java.lang.String value) {
                this._value = value;
                return this;
            }
            /**
             * Sets the value of Value
             * @param value ``DeploymentGroupResource.EC2TagFilterProperty.Value``
             * @return {@code this}
             */
            public Builder withValue(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EC2TagFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public EC2TagFilterProperty build() {
                return new EC2TagFilterProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $key = _key;
                    @javax.annotation.Nullable
                    private java.lang.Object $type = _type;
                    @javax.annotation.Nullable
                    private java.lang.Object $value = _value;

                    @Override
                    public java.lang.Object getKey() {
                        return this.$key;
                    }

                    @Override
                    public void setKey(@javax.annotation.Nullable final java.lang.String value) {
                        this.$key = value;
                    }

                    @Override
                    public void setKey(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$key = value;
                    }

                    @Override
                    public java.lang.Object getType() {
                        return this.$type;
                    }

                    @Override
                    public void setType(@javax.annotation.Nullable final java.lang.String value) {
                        this.$type = value;
                    }

                    @Override
                    public void setType(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$type = value;
                    }

                    @Override
                    public java.lang.Object getValue() {
                        return this.$value;
                    }

                    @Override
                    public void setValue(@javax.annotation.Nullable final java.lang.String value) {
                        this.$value = value;
                    }

                    @Override
                    public void setValue(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$value = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.EC2TagFilterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``DeploymentGroupResource.EC2TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-key
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getKey() {
                return this.jsiiGet("key", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.EC2TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-key
             */
            @Override
            public void setKey(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("key", value);
            }

            /**
             * ``DeploymentGroupResource.EC2TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-key
             */
            @Override
            public void setKey(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("key", value);
            }

            /**
             * ``DeploymentGroupResource.EC2TagFilterProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-type
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getType() {
                return this.jsiiGet("type", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.EC2TagFilterProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-type
             */
            @Override
            public void setType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("type", value);
            }

            /**
             * ``DeploymentGroupResource.EC2TagFilterProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-type
             */
            @Override
            public void setType(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("type", value);
            }

            /**
             * ``DeploymentGroupResource.EC2TagFilterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-value
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getValue() {
                return this.jsiiGet("value", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.EC2TagFilterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-value
             */
            @Override
            public void setValue(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("value", value);
            }

            /**
             * ``DeploymentGroupResource.EC2TagFilterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilters.html#cfn-properties-codedeploy-deploymentgroup-ec2tagfilters-value
             */
            @Override
            public void setValue(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("value", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-elbinfo.html
     */
    public static interface ELBInfoProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentGroupResource.ELBInfoProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-elbinfo.html#cfn-codedeploy-deploymentgroup-elbinfo-name
         */
        java.lang.Object getName();
        /**
         * ``DeploymentGroupResource.ELBInfoProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-elbinfo.html#cfn-codedeploy-deploymentgroup-elbinfo-name
         */
        void setName(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.ELBInfoProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-elbinfo.html#cfn-codedeploy-deploymentgroup-elbinfo-name
         */
        void setName(final software.amazon.awscdk.CloudFormationToken value);

        /**
         * @return a {@link Builder} of {@link ELBInfoProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ELBInfoProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _name;

            /**
             * Sets the value of Name
             * @param value ``DeploymentGroupResource.ELBInfoProperty.Name``
             * @return {@code this}
             */
            public Builder withName(@javax.annotation.Nullable final java.lang.String value) {
                this._name = value;
                return this;
            }
            /**
             * Sets the value of Name
             * @param value ``DeploymentGroupResource.ELBInfoProperty.Name``
             * @return {@code this}
             */
            public Builder withName(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._name = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ELBInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ELBInfoProperty build() {
                return new ELBInfoProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $name = _name;

                    @Override
                    public java.lang.Object getName() {
                        return this.$name;
                    }

                    @Override
                    public void setName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$name = value;
                    }

                    @Override
                    public void setName(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$name = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.ELBInfoProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``DeploymentGroupResource.ELBInfoProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-elbinfo.html#cfn-codedeploy-deploymentgroup-elbinfo-name
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getName() {
                return this.jsiiGet("name", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.ELBInfoProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-elbinfo.html#cfn-codedeploy-deploymentgroup-elbinfo-name
             */
            @Override
            public void setName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("name", value);
            }

            /**
             * ``DeploymentGroupResource.ELBInfoProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-elbinfo.html#cfn-codedeploy-deploymentgroup-elbinfo-name
             */
            @Override
            public void setName(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("name", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html
     */
    public static interface GitHubLocationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentGroupResource.GitHubLocationProperty.CommitId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-commitid
         */
        java.lang.Object getCommitId();
        /**
         * ``DeploymentGroupResource.GitHubLocationProperty.CommitId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-commitid
         */
        void setCommitId(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.GitHubLocationProperty.CommitId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-commitid
         */
        void setCommitId(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``DeploymentGroupResource.GitHubLocationProperty.Repository``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-repository
         */
        java.lang.Object getRepository();
        /**
         * ``DeploymentGroupResource.GitHubLocationProperty.Repository``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-repository
         */
        void setRepository(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.GitHubLocationProperty.Repository``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-repository
         */
        void setRepository(final software.amazon.awscdk.CloudFormationToken value);

        /**
         * @return a {@link Builder} of {@link GitHubLocationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link GitHubLocationProperty}
         */
        final class Builder {
            private java.lang.Object _commitId;
            private java.lang.Object _repository;

            /**
             * Sets the value of CommitId
             * @param value ``DeploymentGroupResource.GitHubLocationProperty.CommitId``
             * @return {@code this}
             */
            public Builder withCommitId(final java.lang.String value) {
                this._commitId = java.util.Objects.requireNonNull(value, "commitId is required");
                return this;
            }
            /**
             * Sets the value of CommitId
             * @param value ``DeploymentGroupResource.GitHubLocationProperty.CommitId``
             * @return {@code this}
             */
            public Builder withCommitId(final software.amazon.awscdk.CloudFormationToken value) {
                this._commitId = java.util.Objects.requireNonNull(value, "commitId is required");
                return this;
            }
            /**
             * Sets the value of Repository
             * @param value ``DeploymentGroupResource.GitHubLocationProperty.Repository``
             * @return {@code this}
             */
            public Builder withRepository(final java.lang.String value) {
                this._repository = java.util.Objects.requireNonNull(value, "repository is required");
                return this;
            }
            /**
             * Sets the value of Repository
             * @param value ``DeploymentGroupResource.GitHubLocationProperty.Repository``
             * @return {@code this}
             */
            public Builder withRepository(final software.amazon.awscdk.CloudFormationToken value) {
                this._repository = java.util.Objects.requireNonNull(value, "repository is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GitHubLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public GitHubLocationProperty build() {
                return new GitHubLocationProperty() {
                    private java.lang.Object $commitId = java.util.Objects.requireNonNull(_commitId, "commitId is required");
                    private java.lang.Object $repository = java.util.Objects.requireNonNull(_repository, "repository is required");

                    @Override
                    public java.lang.Object getCommitId() {
                        return this.$commitId;
                    }

                    @Override
                    public void setCommitId(final java.lang.String value) {
                        this.$commitId = java.util.Objects.requireNonNull(value, "commitId is required");
                    }

                    @Override
                    public void setCommitId(final software.amazon.awscdk.CloudFormationToken value) {
                        this.$commitId = java.util.Objects.requireNonNull(value, "commitId is required");
                    }

                    @Override
                    public java.lang.Object getRepository() {
                        return this.$repository;
                    }

                    @Override
                    public void setRepository(final java.lang.String value) {
                        this.$repository = java.util.Objects.requireNonNull(value, "repository is required");
                    }

                    @Override
                    public void setRepository(final software.amazon.awscdk.CloudFormationToken value) {
                        this.$repository = java.util.Objects.requireNonNull(value, "repository is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.GitHubLocationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``DeploymentGroupResource.GitHubLocationProperty.CommitId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-commitid
             */
            @Override
            public java.lang.Object getCommitId() {
                return this.jsiiGet("commitId", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.GitHubLocationProperty.CommitId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-commitid
             */
            @Override
            public void setCommitId(final java.lang.String value) {
                this.jsiiSet("commitId", java.util.Objects.requireNonNull(value, "commitId is required"));
            }

            /**
             * ``DeploymentGroupResource.GitHubLocationProperty.CommitId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-commitid
             */
            @Override
            public void setCommitId(final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("commitId", java.util.Objects.requireNonNull(value, "commitId is required"));
            }

            /**
             * ``DeploymentGroupResource.GitHubLocationProperty.Repository``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-repository
             */
            @Override
            public java.lang.Object getRepository() {
                return this.jsiiGet("repository", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.GitHubLocationProperty.Repository``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-repository
             */
            @Override
            public void setRepository(final java.lang.String value) {
                this.jsiiSet("repository", java.util.Objects.requireNonNull(value, "repository is required"));
            }

            /**
             * ``DeploymentGroupResource.GitHubLocationProperty.Repository``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-repository
             */
            @Override
            public void setRepository(final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("repository", java.util.Objects.requireNonNull(value, "repository is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html
     */
    public static interface LoadBalancerInfoProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentGroupResource.LoadBalancerInfoProperty.ElbInfoList``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-elbinfolist
         */
        java.lang.Object getElbInfoList();
        /**
         * ``DeploymentGroupResource.LoadBalancerInfoProperty.ElbInfoList``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-elbinfolist
         */
        void setElbInfoList(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``DeploymentGroupResource.LoadBalancerInfoProperty.ElbInfoList``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-elbinfolist
         */
        void setElbInfoList(final java.util.List<java.lang.Object> value);
        /**
         * ``DeploymentGroupResource.LoadBalancerInfoProperty.TargetGroupInfoList``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-targetgroupinfolist
         */
        java.lang.Object getTargetGroupInfoList();
        /**
         * ``DeploymentGroupResource.LoadBalancerInfoProperty.TargetGroupInfoList``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-targetgroupinfolist
         */
        void setTargetGroupInfoList(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``DeploymentGroupResource.LoadBalancerInfoProperty.TargetGroupInfoList``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-targetgroupinfolist
         */
        void setTargetGroupInfoList(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link LoadBalancerInfoProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LoadBalancerInfoProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _elbInfoList;
            @javax.annotation.Nullable
            private java.lang.Object _targetGroupInfoList;

            /**
             * Sets the value of ElbInfoList
             * @param value ``DeploymentGroupResource.LoadBalancerInfoProperty.ElbInfoList``
             * @return {@code this}
             */
            public Builder withElbInfoList(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._elbInfoList = value;
                return this;
            }
            /**
             * Sets the value of ElbInfoList
             * @param value ``DeploymentGroupResource.LoadBalancerInfoProperty.ElbInfoList``
             * @return {@code this}
             */
            public Builder withElbInfoList(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._elbInfoList = value;
                return this;
            }
            /**
             * Sets the value of TargetGroupInfoList
             * @param value ``DeploymentGroupResource.LoadBalancerInfoProperty.TargetGroupInfoList``
             * @return {@code this}
             */
            public Builder withTargetGroupInfoList(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._targetGroupInfoList = value;
                return this;
            }
            /**
             * Sets the value of TargetGroupInfoList
             * @param value ``DeploymentGroupResource.LoadBalancerInfoProperty.TargetGroupInfoList``
             * @return {@code this}
             */
            public Builder withTargetGroupInfoList(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._targetGroupInfoList = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoadBalancerInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LoadBalancerInfoProperty build() {
                return new LoadBalancerInfoProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $elbInfoList = _elbInfoList;
                    @javax.annotation.Nullable
                    private java.lang.Object $targetGroupInfoList = _targetGroupInfoList;

                    @Override
                    public java.lang.Object getElbInfoList() {
                        return this.$elbInfoList;
                    }

                    @Override
                    public void setElbInfoList(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$elbInfoList = value;
                    }

                    @Override
                    public void setElbInfoList(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$elbInfoList = value;
                    }

                    @Override
                    public java.lang.Object getTargetGroupInfoList() {
                        return this.$targetGroupInfoList;
                    }

                    @Override
                    public void setTargetGroupInfoList(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$targetGroupInfoList = value;
                    }

                    @Override
                    public void setTargetGroupInfoList(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$targetGroupInfoList = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.LoadBalancerInfoProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``DeploymentGroupResource.LoadBalancerInfoProperty.ElbInfoList``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-elbinfolist
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getElbInfoList() {
                return this.jsiiGet("elbInfoList", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.LoadBalancerInfoProperty.ElbInfoList``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-elbinfolist
             */
            @Override
            public void setElbInfoList(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("elbInfoList", value);
            }

            /**
             * ``DeploymentGroupResource.LoadBalancerInfoProperty.ElbInfoList``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-elbinfolist
             */
            @Override
            public void setElbInfoList(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("elbInfoList", value);
            }

            /**
             * ``DeploymentGroupResource.LoadBalancerInfoProperty.TargetGroupInfoList``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-targetgroupinfolist
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTargetGroupInfoList() {
                return this.jsiiGet("targetGroupInfoList", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.LoadBalancerInfoProperty.TargetGroupInfoList``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-targetgroupinfolist
             */
            @Override
            public void setTargetGroupInfoList(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("targetGroupInfoList", value);
            }

            /**
             * ``DeploymentGroupResource.LoadBalancerInfoProperty.TargetGroupInfoList``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-targetgroupinfolist
             */
            @Override
            public void setTargetGroupInfoList(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("targetGroupInfoList", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html
     */
    public static interface RevisionLocationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentGroupResource.RevisionLocationProperty.GitHubLocation``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation
         */
        java.lang.Object getGitHubLocation();
        /**
         * ``DeploymentGroupResource.RevisionLocationProperty.GitHubLocation``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation
         */
        void setGitHubLocation(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``DeploymentGroupResource.RevisionLocationProperty.GitHubLocation``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation
         */
        void setGitHubLocation(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.GitHubLocationProperty value);
        /**
         * ``DeploymentGroupResource.RevisionLocationProperty.RevisionType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-revisiontype
         */
        java.lang.Object getRevisionType();
        /**
         * ``DeploymentGroupResource.RevisionLocationProperty.RevisionType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-revisiontype
         */
        void setRevisionType(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.RevisionLocationProperty.RevisionType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-revisiontype
         */
        void setRevisionType(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``DeploymentGroupResource.RevisionLocationProperty.S3Location``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location
         */
        java.lang.Object getS3Location();
        /**
         * ``DeploymentGroupResource.RevisionLocationProperty.S3Location``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location
         */
        void setS3Location(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``DeploymentGroupResource.RevisionLocationProperty.S3Location``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location
         */
        void setS3Location(final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.S3LocationProperty value);

        /**
         * @return a {@link Builder} of {@link RevisionLocationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RevisionLocationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _gitHubLocation;
            @javax.annotation.Nullable
            private java.lang.Object _revisionType;
            @javax.annotation.Nullable
            private java.lang.Object _s3Location;

            /**
             * Sets the value of GitHubLocation
             * @param value ``DeploymentGroupResource.RevisionLocationProperty.GitHubLocation``
             * @return {@code this}
             */
            public Builder withGitHubLocation(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._gitHubLocation = value;
                return this;
            }
            /**
             * Sets the value of GitHubLocation
             * @param value ``DeploymentGroupResource.RevisionLocationProperty.GitHubLocation``
             * @return {@code this}
             */
            public Builder withGitHubLocation(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.GitHubLocationProperty value) {
                this._gitHubLocation = value;
                return this;
            }
            /**
             * Sets the value of RevisionType
             * @param value ``DeploymentGroupResource.RevisionLocationProperty.RevisionType``
             * @return {@code this}
             */
            public Builder withRevisionType(@javax.annotation.Nullable final java.lang.String value) {
                this._revisionType = value;
                return this;
            }
            /**
             * Sets the value of RevisionType
             * @param value ``DeploymentGroupResource.RevisionLocationProperty.RevisionType``
             * @return {@code this}
             */
            public Builder withRevisionType(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._revisionType = value;
                return this;
            }
            /**
             * Sets the value of S3Location
             * @param value ``DeploymentGroupResource.RevisionLocationProperty.S3Location``
             * @return {@code this}
             */
            public Builder withS3Location(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._s3Location = value;
                return this;
            }
            /**
             * Sets the value of S3Location
             * @param value ``DeploymentGroupResource.RevisionLocationProperty.S3Location``
             * @return {@code this}
             */
            public Builder withS3Location(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.S3LocationProperty value) {
                this._s3Location = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RevisionLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public RevisionLocationProperty build() {
                return new RevisionLocationProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $gitHubLocation = _gitHubLocation;
                    @javax.annotation.Nullable
                    private java.lang.Object $revisionType = _revisionType;
                    @javax.annotation.Nullable
                    private java.lang.Object $s3Location = _s3Location;

                    @Override
                    public java.lang.Object getGitHubLocation() {
                        return this.$gitHubLocation;
                    }

                    @Override
                    public void setGitHubLocation(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$gitHubLocation = value;
                    }

                    @Override
                    public void setGitHubLocation(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.GitHubLocationProperty value) {
                        this.$gitHubLocation = value;
                    }

                    @Override
                    public java.lang.Object getRevisionType() {
                        return this.$revisionType;
                    }

                    @Override
                    public void setRevisionType(@javax.annotation.Nullable final java.lang.String value) {
                        this.$revisionType = value;
                    }

                    @Override
                    public void setRevisionType(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$revisionType = value;
                    }

                    @Override
                    public java.lang.Object getS3Location() {
                        return this.$s3Location;
                    }

                    @Override
                    public void setS3Location(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$s3Location = value;
                    }

                    @Override
                    public void setS3Location(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.S3LocationProperty value) {
                        this.$s3Location = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.RevisionLocationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``DeploymentGroupResource.RevisionLocationProperty.GitHubLocation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getGitHubLocation() {
                return this.jsiiGet("gitHubLocation", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.RevisionLocationProperty.GitHubLocation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation
             */
            @Override
            public void setGitHubLocation(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("gitHubLocation", value);
            }

            /**
             * ``DeploymentGroupResource.RevisionLocationProperty.GitHubLocation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation
             */
            @Override
            public void setGitHubLocation(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.GitHubLocationProperty value) {
                this.jsiiSet("gitHubLocation", value);
            }

            /**
             * ``DeploymentGroupResource.RevisionLocationProperty.RevisionType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-revisiontype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getRevisionType() {
                return this.jsiiGet("revisionType", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.RevisionLocationProperty.RevisionType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-revisiontype
             */
            @Override
            public void setRevisionType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("revisionType", value);
            }

            /**
             * ``DeploymentGroupResource.RevisionLocationProperty.RevisionType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-revisiontype
             */
            @Override
            public void setRevisionType(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("revisionType", value);
            }

            /**
             * ``DeploymentGroupResource.RevisionLocationProperty.S3Location``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getS3Location() {
                return this.jsiiGet("s3Location", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.RevisionLocationProperty.S3Location``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location
             */
            @Override
            public void setS3Location(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("s3Location", value);
            }

            /**
             * ``DeploymentGroupResource.RevisionLocationProperty.S3Location``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location
             */
            @Override
            public void setS3Location(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.S3LocationProperty value) {
                this.jsiiSet("s3Location", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html
     */
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentGroupResource.S3LocationProperty.Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bucket
         */
        java.lang.Object getBucket();
        /**
         * ``DeploymentGroupResource.S3LocationProperty.Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bucket
         */
        void setBucket(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.S3LocationProperty.Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bucket
         */
        void setBucket(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``DeploymentGroupResource.S3LocationProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-key
         */
        java.lang.Object getKey();
        /**
         * ``DeploymentGroupResource.S3LocationProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-key
         */
        void setKey(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.S3LocationProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-key
         */
        void setKey(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``DeploymentGroupResource.S3LocationProperty.BundleType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bundletype
         */
        java.lang.Object getBundleType();
        /**
         * ``DeploymentGroupResource.S3LocationProperty.BundleType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bundletype
         */
        void setBundleType(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.S3LocationProperty.BundleType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bundletype
         */
        void setBundleType(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``DeploymentGroupResource.S3LocationProperty.ETag``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-etag
         */
        java.lang.Object getETag();
        /**
         * ``DeploymentGroupResource.S3LocationProperty.ETag``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-etag
         */
        void setETag(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.S3LocationProperty.ETag``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-etag
         */
        void setETag(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``DeploymentGroupResource.S3LocationProperty.Version``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-value
         */
        java.lang.Object getVersion();
        /**
         * ``DeploymentGroupResource.S3LocationProperty.Version``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-value
         */
        void setVersion(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.S3LocationProperty.Version``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-value
         */
        void setVersion(final software.amazon.awscdk.CloudFormationToken value);

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link S3LocationProperty}
         */
        final class Builder {
            private java.lang.Object _bucket;
            private java.lang.Object _key;
            @javax.annotation.Nullable
            private java.lang.Object _bundleType;
            @javax.annotation.Nullable
            private java.lang.Object _eTag;
            @javax.annotation.Nullable
            private java.lang.Object _version;

            /**
             * Sets the value of Bucket
             * @param value ``DeploymentGroupResource.S3LocationProperty.Bucket``
             * @return {@code this}
             */
            public Builder withBucket(final java.lang.String value) {
                this._bucket = java.util.Objects.requireNonNull(value, "bucket is required");
                return this;
            }
            /**
             * Sets the value of Bucket
             * @param value ``DeploymentGroupResource.S3LocationProperty.Bucket``
             * @return {@code this}
             */
            public Builder withBucket(final software.amazon.awscdk.CloudFormationToken value) {
                this._bucket = java.util.Objects.requireNonNull(value, "bucket is required");
                return this;
            }
            /**
             * Sets the value of Key
             * @param value ``DeploymentGroupResource.S3LocationProperty.Key``
             * @return {@code this}
             */
            public Builder withKey(final java.lang.String value) {
                this._key = java.util.Objects.requireNonNull(value, "key is required");
                return this;
            }
            /**
             * Sets the value of Key
             * @param value ``DeploymentGroupResource.S3LocationProperty.Key``
             * @return {@code this}
             */
            public Builder withKey(final software.amazon.awscdk.CloudFormationToken value) {
                this._key = java.util.Objects.requireNonNull(value, "key is required");
                return this;
            }
            /**
             * Sets the value of BundleType
             * @param value ``DeploymentGroupResource.S3LocationProperty.BundleType``
             * @return {@code this}
             */
            public Builder withBundleType(@javax.annotation.Nullable final java.lang.String value) {
                this._bundleType = value;
                return this;
            }
            /**
             * Sets the value of BundleType
             * @param value ``DeploymentGroupResource.S3LocationProperty.BundleType``
             * @return {@code this}
             */
            public Builder withBundleType(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._bundleType = value;
                return this;
            }
            /**
             * Sets the value of ETag
             * @param value ``DeploymentGroupResource.S3LocationProperty.ETag``
             * @return {@code this}
             */
            public Builder withETag(@javax.annotation.Nullable final java.lang.String value) {
                this._eTag = value;
                return this;
            }
            /**
             * Sets the value of ETag
             * @param value ``DeploymentGroupResource.S3LocationProperty.ETag``
             * @return {@code this}
             */
            public Builder withETag(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._eTag = value;
                return this;
            }
            /**
             * Sets the value of Version
             * @param value ``DeploymentGroupResource.S3LocationProperty.Version``
             * @return {@code this}
             */
            public Builder withVersion(@javax.annotation.Nullable final java.lang.String value) {
                this._version = value;
                return this;
            }
            /**
             * Sets the value of Version
             * @param value ``DeploymentGroupResource.S3LocationProperty.Version``
             * @return {@code this}
             */
            public Builder withVersion(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._version = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public S3LocationProperty build() {
                return new S3LocationProperty() {
                    private java.lang.Object $bucket = java.util.Objects.requireNonNull(_bucket, "bucket is required");
                    private java.lang.Object $key = java.util.Objects.requireNonNull(_key, "key is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $bundleType = _bundleType;
                    @javax.annotation.Nullable
                    private java.lang.Object $eTag = _eTag;
                    @javax.annotation.Nullable
                    private java.lang.Object $version = _version;

                    @Override
                    public java.lang.Object getBucket() {
                        return this.$bucket;
                    }

                    @Override
                    public void setBucket(final java.lang.String value) {
                        this.$bucket = java.util.Objects.requireNonNull(value, "bucket is required");
                    }

                    @Override
                    public void setBucket(final software.amazon.awscdk.CloudFormationToken value) {
                        this.$bucket = java.util.Objects.requireNonNull(value, "bucket is required");
                    }

                    @Override
                    public java.lang.Object getKey() {
                        return this.$key;
                    }

                    @Override
                    public void setKey(final java.lang.String value) {
                        this.$key = java.util.Objects.requireNonNull(value, "key is required");
                    }

                    @Override
                    public void setKey(final software.amazon.awscdk.CloudFormationToken value) {
                        this.$key = java.util.Objects.requireNonNull(value, "key is required");
                    }

                    @Override
                    public java.lang.Object getBundleType() {
                        return this.$bundleType;
                    }

                    @Override
                    public void setBundleType(@javax.annotation.Nullable final java.lang.String value) {
                        this.$bundleType = value;
                    }

                    @Override
                    public void setBundleType(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$bundleType = value;
                    }

                    @Override
                    public java.lang.Object getETag() {
                        return this.$eTag;
                    }

                    @Override
                    public void setETag(@javax.annotation.Nullable final java.lang.String value) {
                        this.$eTag = value;
                    }

                    @Override
                    public void setETag(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$eTag = value;
                    }

                    @Override
                    public java.lang.Object getVersion() {
                        return this.$version;
                    }

                    @Override
                    public void setVersion(@javax.annotation.Nullable final java.lang.String value) {
                        this.$version = value;
                    }

                    @Override
                    public void setVersion(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$version = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.S3LocationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``DeploymentGroupResource.S3LocationProperty.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bucket
             */
            @Override
            public java.lang.Object getBucket() {
                return this.jsiiGet("bucket", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.S3LocationProperty.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bucket
             */
            @Override
            public void setBucket(final java.lang.String value) {
                this.jsiiSet("bucket", java.util.Objects.requireNonNull(value, "bucket is required"));
            }

            /**
             * ``DeploymentGroupResource.S3LocationProperty.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bucket
             */
            @Override
            public void setBucket(final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("bucket", java.util.Objects.requireNonNull(value, "bucket is required"));
            }

            /**
             * ``DeploymentGroupResource.S3LocationProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-key
             */
            @Override
            public java.lang.Object getKey() {
                return this.jsiiGet("key", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.S3LocationProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-key
             */
            @Override
            public void setKey(final java.lang.String value) {
                this.jsiiSet("key", java.util.Objects.requireNonNull(value, "key is required"));
            }

            /**
             * ``DeploymentGroupResource.S3LocationProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-key
             */
            @Override
            public void setKey(final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("key", java.util.Objects.requireNonNull(value, "key is required"));
            }

            /**
             * ``DeploymentGroupResource.S3LocationProperty.BundleType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bundletype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getBundleType() {
                return this.jsiiGet("bundleType", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.S3LocationProperty.BundleType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bundletype
             */
            @Override
            public void setBundleType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("bundleType", value);
            }

            /**
             * ``DeploymentGroupResource.S3LocationProperty.BundleType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bundletype
             */
            @Override
            public void setBundleType(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("bundleType", value);
            }

            /**
             * ``DeploymentGroupResource.S3LocationProperty.ETag``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-etag
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getETag() {
                return this.jsiiGet("eTag", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.S3LocationProperty.ETag``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-etag
             */
            @Override
            public void setETag(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("eTag", value);
            }

            /**
             * ``DeploymentGroupResource.S3LocationProperty.ETag``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-etag
             */
            @Override
            public void setETag(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("eTag", value);
            }

            /**
             * ``DeploymentGroupResource.S3LocationProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-value
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getVersion() {
                return this.jsiiGet("version", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.S3LocationProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-value
             */
            @Override
            public void setVersion(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("version", value);
            }

            /**
             * ``DeploymentGroupResource.S3LocationProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-value
             */
            @Override
            public void setVersion(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("version", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html
     */
    public static interface TagFilterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentGroupResource.TagFilterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-key
         */
        java.lang.Object getKey();
        /**
         * ``DeploymentGroupResource.TagFilterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-key
         */
        void setKey(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.TagFilterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-key
         */
        void setKey(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``DeploymentGroupResource.TagFilterProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-type
         */
        java.lang.Object getType();
        /**
         * ``DeploymentGroupResource.TagFilterProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-type
         */
        void setType(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.TagFilterProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-type
         */
        void setType(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``DeploymentGroupResource.TagFilterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-value
         */
        java.lang.Object getValue();
        /**
         * ``DeploymentGroupResource.TagFilterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-value
         */
        void setValue(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.TagFilterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-value
         */
        void setValue(final software.amazon.awscdk.CloudFormationToken value);

        /**
         * @return a {@link Builder} of {@link TagFilterProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TagFilterProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _key;
            @javax.annotation.Nullable
            private java.lang.Object _type;
            @javax.annotation.Nullable
            private java.lang.Object _value;

            /**
             * Sets the value of Key
             * @param value ``DeploymentGroupResource.TagFilterProperty.Key``
             * @return {@code this}
             */
            public Builder withKey(@javax.annotation.Nullable final java.lang.String value) {
                this._key = value;
                return this;
            }
            /**
             * Sets the value of Key
             * @param value ``DeploymentGroupResource.TagFilterProperty.Key``
             * @return {@code this}
             */
            public Builder withKey(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._key = value;
                return this;
            }
            /**
             * Sets the value of Type
             * @param value ``DeploymentGroupResource.TagFilterProperty.Type``
             * @return {@code this}
             */
            public Builder withType(@javax.annotation.Nullable final java.lang.String value) {
                this._type = value;
                return this;
            }
            /**
             * Sets the value of Type
             * @param value ``DeploymentGroupResource.TagFilterProperty.Type``
             * @return {@code this}
             */
            public Builder withType(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._type = value;
                return this;
            }
            /**
             * Sets the value of Value
             * @param value ``DeploymentGroupResource.TagFilterProperty.Value``
             * @return {@code this}
             */
            public Builder withValue(@javax.annotation.Nullable final java.lang.String value) {
                this._value = value;
                return this;
            }
            /**
             * Sets the value of Value
             * @param value ``DeploymentGroupResource.TagFilterProperty.Value``
             * @return {@code this}
             */
            public Builder withValue(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TagFilterProperty build() {
                return new TagFilterProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $key = _key;
                    @javax.annotation.Nullable
                    private java.lang.Object $type = _type;
                    @javax.annotation.Nullable
                    private java.lang.Object $value = _value;

                    @Override
                    public java.lang.Object getKey() {
                        return this.$key;
                    }

                    @Override
                    public void setKey(@javax.annotation.Nullable final java.lang.String value) {
                        this.$key = value;
                    }

                    @Override
                    public void setKey(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$key = value;
                    }

                    @Override
                    public java.lang.Object getType() {
                        return this.$type;
                    }

                    @Override
                    public void setType(@javax.annotation.Nullable final java.lang.String value) {
                        this.$type = value;
                    }

                    @Override
                    public void setType(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$type = value;
                    }

                    @Override
                    public java.lang.Object getValue() {
                        return this.$value;
                    }

                    @Override
                    public void setValue(@javax.annotation.Nullable final java.lang.String value) {
                        this.$value = value;
                    }

                    @Override
                    public void setValue(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$value = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.TagFilterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``DeploymentGroupResource.TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-key
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getKey() {
                return this.jsiiGet("key", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-key
             */
            @Override
            public void setKey(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("key", value);
            }

            /**
             * ``DeploymentGroupResource.TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-key
             */
            @Override
            public void setKey(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("key", value);
            }

            /**
             * ``DeploymentGroupResource.TagFilterProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-type
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getType() {
                return this.jsiiGet("type", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.TagFilterProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-type
             */
            @Override
            public void setType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("type", value);
            }

            /**
             * ``DeploymentGroupResource.TagFilterProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-type
             */
            @Override
            public void setType(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("type", value);
            }

            /**
             * ``DeploymentGroupResource.TagFilterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-value
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getValue() {
                return this.jsiiGet("value", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.TagFilterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-value
             */
            @Override
            public void setValue(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("value", value);
            }

            /**
             * ``DeploymentGroupResource.TagFilterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters.html#cfn-properties-codedeploy-deploymentgroup-onpremisesinstancetagfilters-value
             */
            @Override
            public void setValue(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("value", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-targetgroupinfo.html
     */
    public static interface TargetGroupInfoProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentGroupResource.TargetGroupInfoProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-targetgroupinfo.html#cfn-codedeploy-deploymentgroup-targetgroupinfo-name
         */
        java.lang.Object getName();
        /**
         * ``DeploymentGroupResource.TargetGroupInfoProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-targetgroupinfo.html#cfn-codedeploy-deploymentgroup-targetgroupinfo-name
         */
        void setName(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.TargetGroupInfoProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-targetgroupinfo.html#cfn-codedeploy-deploymentgroup-targetgroupinfo-name
         */
        void setName(final software.amazon.awscdk.CloudFormationToken value);

        /**
         * @return a {@link Builder} of {@link TargetGroupInfoProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TargetGroupInfoProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _name;

            /**
             * Sets the value of Name
             * @param value ``DeploymentGroupResource.TargetGroupInfoProperty.Name``
             * @return {@code this}
             */
            public Builder withName(@javax.annotation.Nullable final java.lang.String value) {
                this._name = value;
                return this;
            }
            /**
             * Sets the value of Name
             * @param value ``DeploymentGroupResource.TargetGroupInfoProperty.Name``
             * @return {@code this}
             */
            public Builder withName(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._name = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetGroupInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TargetGroupInfoProperty build() {
                return new TargetGroupInfoProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $name = _name;

                    @Override
                    public java.lang.Object getName() {
                        return this.$name;
                    }

                    @Override
                    public void setName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$name = value;
                    }

                    @Override
                    public void setName(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$name = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.TargetGroupInfoProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``DeploymentGroupResource.TargetGroupInfoProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-targetgroupinfo.html#cfn-codedeploy-deploymentgroup-targetgroupinfo-name
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getName() {
                return this.jsiiGet("name", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.TargetGroupInfoProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-targetgroupinfo.html#cfn-codedeploy-deploymentgroup-targetgroupinfo-name
             */
            @Override
            public void setName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("name", value);
            }

            /**
             * ``DeploymentGroupResource.TargetGroupInfoProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-targetgroupinfo.html#cfn-codedeploy-deploymentgroup-targetgroupinfo-name
             */
            @Override
            public void setName(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("name", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html
     */
    public static interface TriggerConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentGroupResource.TriggerConfigProperty.TriggerEvents``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggerevents
         */
        java.lang.Object getTriggerEvents();
        /**
         * ``DeploymentGroupResource.TriggerConfigProperty.TriggerEvents``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggerevents
         */
        void setTriggerEvents(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``DeploymentGroupResource.TriggerConfigProperty.TriggerEvents``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggerevents
         */
        void setTriggerEvents(final java.util.List<java.lang.Object> value);
        /**
         * ``DeploymentGroupResource.TriggerConfigProperty.TriggerName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggername
         */
        java.lang.Object getTriggerName();
        /**
         * ``DeploymentGroupResource.TriggerConfigProperty.TriggerName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggername
         */
        void setTriggerName(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.TriggerConfigProperty.TriggerName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggername
         */
        void setTriggerName(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``DeploymentGroupResource.TriggerConfigProperty.TriggerTargetArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggertargetarn
         */
        java.lang.Object getTriggerTargetArn();
        /**
         * ``DeploymentGroupResource.TriggerConfigProperty.TriggerTargetArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggertargetarn
         */
        void setTriggerTargetArn(final java.lang.String value);
        /**
         * ``DeploymentGroupResource.TriggerConfigProperty.TriggerTargetArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggertargetarn
         */
        void setTriggerTargetArn(final software.amazon.awscdk.CloudFormationToken value);

        /**
         * @return a {@link Builder} of {@link TriggerConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TriggerConfigProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _triggerEvents;
            @javax.annotation.Nullable
            private java.lang.Object _triggerName;
            @javax.annotation.Nullable
            private java.lang.Object _triggerTargetArn;

            /**
             * Sets the value of TriggerEvents
             * @param value ``DeploymentGroupResource.TriggerConfigProperty.TriggerEvents``
             * @return {@code this}
             */
            public Builder withTriggerEvents(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._triggerEvents = value;
                return this;
            }
            /**
             * Sets the value of TriggerEvents
             * @param value ``DeploymentGroupResource.TriggerConfigProperty.TriggerEvents``
             * @return {@code this}
             */
            public Builder withTriggerEvents(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._triggerEvents = value;
                return this;
            }
            /**
             * Sets the value of TriggerName
             * @param value ``DeploymentGroupResource.TriggerConfigProperty.TriggerName``
             * @return {@code this}
             */
            public Builder withTriggerName(@javax.annotation.Nullable final java.lang.String value) {
                this._triggerName = value;
                return this;
            }
            /**
             * Sets the value of TriggerName
             * @param value ``DeploymentGroupResource.TriggerConfigProperty.TriggerName``
             * @return {@code this}
             */
            public Builder withTriggerName(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._triggerName = value;
                return this;
            }
            /**
             * Sets the value of TriggerTargetArn
             * @param value ``DeploymentGroupResource.TriggerConfigProperty.TriggerTargetArn``
             * @return {@code this}
             */
            public Builder withTriggerTargetArn(@javax.annotation.Nullable final java.lang.String value) {
                this._triggerTargetArn = value;
                return this;
            }
            /**
             * Sets the value of TriggerTargetArn
             * @param value ``DeploymentGroupResource.TriggerConfigProperty.TriggerTargetArn``
             * @return {@code this}
             */
            public Builder withTriggerTargetArn(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._triggerTargetArn = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TriggerConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TriggerConfigProperty build() {
                return new TriggerConfigProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $triggerEvents = _triggerEvents;
                    @javax.annotation.Nullable
                    private java.lang.Object $triggerName = _triggerName;
                    @javax.annotation.Nullable
                    private java.lang.Object $triggerTargetArn = _triggerTargetArn;

                    @Override
                    public java.lang.Object getTriggerEvents() {
                        return this.$triggerEvents;
                    }

                    @Override
                    public void setTriggerEvents(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$triggerEvents = value;
                    }

                    @Override
                    public void setTriggerEvents(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$triggerEvents = value;
                    }

                    @Override
                    public java.lang.Object getTriggerName() {
                        return this.$triggerName;
                    }

                    @Override
                    public void setTriggerName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$triggerName = value;
                    }

                    @Override
                    public void setTriggerName(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$triggerName = value;
                    }

                    @Override
                    public java.lang.Object getTriggerTargetArn() {
                        return this.$triggerTargetArn;
                    }

                    @Override
                    public void setTriggerTargetArn(@javax.annotation.Nullable final java.lang.String value) {
                        this.$triggerTargetArn = value;
                    }

                    @Override
                    public void setTriggerTargetArn(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$triggerTargetArn = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.cloudformation.DeploymentGroupResource.TriggerConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``DeploymentGroupResource.TriggerConfigProperty.TriggerEvents``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggerevents
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTriggerEvents() {
                return this.jsiiGet("triggerEvents", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.TriggerConfigProperty.TriggerEvents``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggerevents
             */
            @Override
            public void setTriggerEvents(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("triggerEvents", value);
            }

            /**
             * ``DeploymentGroupResource.TriggerConfigProperty.TriggerEvents``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggerevents
             */
            @Override
            public void setTriggerEvents(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("triggerEvents", value);
            }

            /**
             * ``DeploymentGroupResource.TriggerConfigProperty.TriggerName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggername
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTriggerName() {
                return this.jsiiGet("triggerName", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.TriggerConfigProperty.TriggerName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggername
             */
            @Override
            public void setTriggerName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("triggerName", value);
            }

            /**
             * ``DeploymentGroupResource.TriggerConfigProperty.TriggerName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggername
             */
            @Override
            public void setTriggerName(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("triggerName", value);
            }

            /**
             * ``DeploymentGroupResource.TriggerConfigProperty.TriggerTargetArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggertargetarn
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTriggerTargetArn() {
                return this.jsiiGet("triggerTargetArn", java.lang.Object.class);
            }

            /**
             * ``DeploymentGroupResource.TriggerConfigProperty.TriggerTargetArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggertargetarn
             */
            @Override
            public void setTriggerTargetArn(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("triggerTargetArn", value);
            }

            /**
             * ``DeploymentGroupResource.TriggerConfigProperty.TriggerTargetArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggertargetarn
             */
            @Override
            public void setTriggerTargetArn(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("triggerTargetArn", value);
            }
        }
    }
}
