package software.amazon.awscdk.services.codedeploy;

/**
 * Construction properties of the {@link PipelineDeployAction CodeDeploy deploy CodePipeline Action}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.6 (build 04cb6bb)", date = "2018-09-20T13:05:15.951Z")
public interface PipelineDeployActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codepipeline.api.CommonActionProps {
    /**
     * The name of the CodeDeploy application to deploy to.
     * @note this will most likely be changed to a proper CodeDeploy AWS Construct reference once that functionality has been implemented for CodeDeploy
     */
    java.lang.String getApplicationName();
    /**
     * The name of the CodeDeploy application to deploy to.
     * @note this will most likely be changed to a proper CodeDeploy AWS Construct reference once that functionality has been implemented for CodeDeploy
     */
    void setApplicationName(final java.lang.String value);
    /**
     * The name of the CodeDeploy deployment group to deploy to.
     * @note this will most likely be changed to a proper CodeDeploy AWS Construct reference once that functionality has been implemented for CodeDeploy
     */
    java.lang.String getDeploymentGroupName();
    /**
     * The name of the CodeDeploy deployment group to deploy to.
     * @note this will most likely be changed to a proper CodeDeploy AWS Construct reference once that functionality has been implemented for CodeDeploy
     */
    void setDeploymentGroupName(final java.lang.String value);
    /**
     * The source to use as input for deployment.
     */
    software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact();
    /**
     * The source to use as input for deployment.
     */
    void setInputArtifact(final software.amazon.awscdk.services.codepipeline.api.Artifact value);

    /**
     * @return a {@link Builder} of {@link PipelineDeployActionProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link PipelineDeployActionProps}
     */
    final class Builder {
        private java.lang.String _applicationName;
        private java.lang.String _deploymentGroupName;
        private software.amazon.awscdk.services.codepipeline.api.Artifact _inputArtifact;
        private software.amazon.awscdk.services.codepipeline.api.IStage _stage;

        /**
         * Sets the value of ApplicationName
         * @param value The name of the CodeDeploy application to deploy to.
         * @return {@code this}
         */
        public Builder withApplicationName(final java.lang.String value) {
            this._applicationName = java.util.Objects.requireNonNull(value, "applicationName is required");
            return this;
        }
        /**
         * Sets the value of DeploymentGroupName
         * @param value The name of the CodeDeploy deployment group to deploy to.
         * @return {@code this}
         */
        public Builder withDeploymentGroupName(final java.lang.String value) {
            this._deploymentGroupName = java.util.Objects.requireNonNull(value, "deploymentGroupName is required");
            return this;
        }
        /**
         * Sets the value of InputArtifact
         * @param value The source to use as input for deployment.
         * @return {@code this}
         */
        public Builder withInputArtifact(final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
            this._inputArtifact = java.util.Objects.requireNonNull(value, "inputArtifact is required");
            return this;
        }
        /**
         * Sets the value of Stage
         * @param value The Pipeline Stage to add this Action to.
         * @return {@code this}
         */
        public Builder withStage(final software.amazon.awscdk.services.codepipeline.api.IStage value) {
            this._stage = java.util.Objects.requireNonNull(value, "stage is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PipelineDeployActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public PipelineDeployActionProps build() {
            return new PipelineDeployActionProps() {
                private java.lang.String $applicationName = java.util.Objects.requireNonNull(_applicationName, "applicationName is required");
                private java.lang.String $deploymentGroupName = java.util.Objects.requireNonNull(_deploymentGroupName, "deploymentGroupName is required");
                private software.amazon.awscdk.services.codepipeline.api.Artifact $inputArtifact = java.util.Objects.requireNonNull(_inputArtifact, "inputArtifact is required");
                private software.amazon.awscdk.services.codepipeline.api.IStage $stage = java.util.Objects.requireNonNull(_stage, "stage is required");

                @Override
                public java.lang.String getApplicationName() {
                    return this.$applicationName;
                }

                @Override
                public void setApplicationName(final java.lang.String value) {
                    this.$applicationName = java.util.Objects.requireNonNull(value, "applicationName is required");
                }

                @Override
                public java.lang.String getDeploymentGroupName() {
                    return this.$deploymentGroupName;
                }

                @Override
                public void setDeploymentGroupName(final java.lang.String value) {
                    this.$deploymentGroupName = java.util.Objects.requireNonNull(value, "deploymentGroupName is required");
                }

                @Override
                public software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact() {
                    return this.$inputArtifact;
                }

                @Override
                public void setInputArtifact(final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
                    this.$inputArtifact = java.util.Objects.requireNonNull(value, "inputArtifact is required");
                }

                @Override
                public software.amazon.awscdk.services.codepipeline.api.IStage getStage() {
                    return this.$stage;
                }

                @Override
                public void setStage(final software.amazon.awscdk.services.codepipeline.api.IStage value) {
                    this.$stage = java.util.Objects.requireNonNull(value, "stage is required");
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.PipelineDeployActionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The name of the CodeDeploy application to deploy to.
         * @note this will most likely be changed to a proper CodeDeploy AWS Construct reference once that functionality has been implemented for CodeDeploy
         */
        @Override
        public java.lang.String getApplicationName() {
            return this.jsiiGet("applicationName", java.lang.String.class);
        }

        /**
         * The name of the CodeDeploy application to deploy to.
         * @note this will most likely be changed to a proper CodeDeploy AWS Construct reference once that functionality has been implemented for CodeDeploy
         */
        @Override
        public void setApplicationName(final java.lang.String value) {
            this.jsiiSet("applicationName", java.util.Objects.requireNonNull(value, "applicationName is required"));
        }

        /**
         * The name of the CodeDeploy deployment group to deploy to.
         * @note this will most likely be changed to a proper CodeDeploy AWS Construct reference once that functionality has been implemented for CodeDeploy
         */
        @Override
        public java.lang.String getDeploymentGroupName() {
            return this.jsiiGet("deploymentGroupName", java.lang.String.class);
        }

        /**
         * The name of the CodeDeploy deployment group to deploy to.
         * @note this will most likely be changed to a proper CodeDeploy AWS Construct reference once that functionality has been implemented for CodeDeploy
         */
        @Override
        public void setDeploymentGroupName(final java.lang.String value) {
            this.jsiiSet("deploymentGroupName", java.util.Objects.requireNonNull(value, "deploymentGroupName is required"));
        }

        /**
         * The source to use as input for deployment.
         */
        @Override
        public software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact() {
            return this.jsiiGet("inputArtifact", software.amazon.awscdk.services.codepipeline.api.Artifact.class);
        }

        /**
         * The source to use as input for deployment.
         */
        @Override
        public void setInputArtifact(final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
            this.jsiiSet("inputArtifact", java.util.Objects.requireNonNull(value, "inputArtifact is required"));
        }

        /**
         * The Pipeline Stage to add this Action to.
         */
        @Override
        public software.amazon.awscdk.services.codepipeline.api.IStage getStage() {
            return this.jsiiGet("stage", software.amazon.awscdk.services.codepipeline.api.IStage.class);
        }

        /**
         * The Pipeline Stage to add this Action to.
         */
        @Override
        public void setStage(final software.amazon.awscdk.services.codepipeline.api.IStage value) {
            this.jsiiSet("stage", java.util.Objects.requireNonNull(value, "stage is required"));
        }
    }
}
