/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codedeploy;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.cloudwatch.IAlarm;
import software.amazon.awscdk.services.codedeploy.AutoRollbackConfig;
import software.amazon.awscdk.services.codedeploy.ILambdaApplication;
import software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.lambda.Alias;
import software.amazon.awscdk.services.lambda.IFunction;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface LambdaDeploymentGroupProps
extends JsiiSerializable {
    public Alias getAlias();

    public List<IAlarm> getAlarms();

    public ILambdaApplication getApplication();

    public AutoRollbackConfig getAutoRollback();

    public ILambdaDeploymentConfig getDeploymentConfig();

    public String getDeploymentGroupName();

    public Boolean getIgnorePollAlarmsFailure();

    public IFunction getPostHook();

    public IFunction getPreHook();

    public IRole getRole();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Alias _alias;
        @Nullable
        private List<IAlarm> _alarms;
        @Nullable
        private ILambdaApplication _application;
        @Nullable
        private AutoRollbackConfig _autoRollback;
        @Nullable
        private ILambdaDeploymentConfig _deploymentConfig;
        @Nullable
        private String _deploymentGroupName;
        @Nullable
        private Boolean _ignorePollAlarmsFailure;
        @Nullable
        private IFunction _postHook;
        @Nullable
        private IFunction _preHook;
        @Nullable
        private IRole _role;

        public Builder withAlias(Alias value) {
            this._alias = Objects.requireNonNull(value, "alias is required");
            return this;
        }

        public Builder withAlarms(@Nullable List<IAlarm> value) {
            this._alarms = value;
            return this;
        }

        public Builder withApplication(@Nullable ILambdaApplication value) {
            this._application = value;
            return this;
        }

        public Builder withAutoRollback(@Nullable AutoRollbackConfig value) {
            this._autoRollback = value;
            return this;
        }

        public Builder withDeploymentConfig(@Nullable ILambdaDeploymentConfig value) {
            this._deploymentConfig = value;
            return this;
        }

        public Builder withDeploymentGroupName(@Nullable String value) {
            this._deploymentGroupName = value;
            return this;
        }

        public Builder withIgnorePollAlarmsFailure(@Nullable Boolean value) {
            this._ignorePollAlarmsFailure = value;
            return this;
        }

        public Builder withPostHook(@Nullable IFunction value) {
            this._postHook = value;
            return this;
        }

        public Builder withPreHook(@Nullable IFunction value) {
            this._preHook = value;
            return this;
        }

        public Builder withRole(@Nullable IRole value) {
            this._role = value;
            return this;
        }

        public LambdaDeploymentGroupProps build() {
            return new LambdaDeploymentGroupProps(){
                private final Alias $alias;
                @Nullable
                private final List<IAlarm> $alarms;
                @Nullable
                private final ILambdaApplication $application;
                @Nullable
                private final AutoRollbackConfig $autoRollback;
                @Nullable
                private final ILambdaDeploymentConfig $deploymentConfig;
                @Nullable
                private final String $deploymentGroupName;
                @Nullable
                private final Boolean $ignorePollAlarmsFailure;
                @Nullable
                private final IFunction $postHook;
                @Nullable
                private final IFunction $preHook;
                @Nullable
                private final IRole $role;
                {
                    this.$alias = Objects.requireNonNull(_alias, "alias is required");
                    this.$alarms = _alarms;
                    this.$application = _application;
                    this.$autoRollback = _autoRollback;
                    this.$deploymentConfig = _deploymentConfig;
                    this.$deploymentGroupName = _deploymentGroupName;
                    this.$ignorePollAlarmsFailure = _ignorePollAlarmsFailure;
                    this.$postHook = _postHook;
                    this.$preHook = _preHook;
                    this.$role = _role;
                }

                @Override
                public Alias getAlias() {
                    return this.$alias;
                }

                @Override
                public List<IAlarm> getAlarms() {
                    return this.$alarms;
                }

                @Override
                public ILambdaApplication getApplication() {
                    return this.$application;
                }

                @Override
                public AutoRollbackConfig getAutoRollback() {
                    return this.$autoRollback;
                }

                @Override
                public ILambdaDeploymentConfig getDeploymentConfig() {
                    return this.$deploymentConfig;
                }

                @Override
                public String getDeploymentGroupName() {
                    return this.$deploymentGroupName;
                }

                @Override
                public Boolean getIgnorePollAlarmsFailure() {
                    return this.$ignorePollAlarmsFailure;
                }

                @Override
                public IFunction getPostHook() {
                    return this.$postHook;
                }

                @Override
                public IFunction getPreHook() {
                    return this.$preHook;
                }

                @Override
                public IRole getRole() {
                    return this.$role;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("alias", om.valueToTree((Object)this.getAlias()));
                    if (this.getAlarms() != null) {
                        obj.set("alarms", om.valueToTree(this.getAlarms()));
                    }
                    if (this.getApplication() != null) {
                        obj.set("application", om.valueToTree((Object)this.getApplication()));
                    }
                    if (this.getAutoRollback() != null) {
                        obj.set("autoRollback", om.valueToTree((Object)this.getAutoRollback()));
                    }
                    if (this.getDeploymentConfig() != null) {
                        obj.set("deploymentConfig", om.valueToTree((Object)this.getDeploymentConfig()));
                    }
                    if (this.getDeploymentGroupName() != null) {
                        obj.set("deploymentGroupName", om.valueToTree((Object)this.getDeploymentGroupName()));
                    }
                    if (this.getIgnorePollAlarmsFailure() != null) {
                        obj.set("ignorePollAlarmsFailure", om.valueToTree((Object)this.getIgnorePollAlarmsFailure()));
                    }
                    if (this.getPostHook() != null) {
                        obj.set("postHook", om.valueToTree((Object)this.getPostHook()));
                    }
                    if (this.getPreHook() != null) {
                        obj.set("preHook", om.valueToTree((Object)this.getPreHook()));
                    }
                    if (this.getRole() != null) {
                        obj.set("role", om.valueToTree((Object)this.getRole()));
                    }
                    return obj;
                }
            };
        }
    }
}

