package software.amazon.awscdk.services.codedeploy;

/**
 * A CloudFormation `AWS::CodeDeploy::DeploymentGroup`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.0 (build 7d5d104)", date = "2019-09-30T08:41:18.749Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroup")
public class CfnDeploymentGroup extends software.amazon.awscdk.core.CfnResource {

    protected CfnDeploymentGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDeploymentGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::CodeDeploy::DeploymentGroup`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnDeploymentGroup(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.ApplicationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getApplicationName() {
        return this.jsiiGet("applicationName", java.lang.String.class);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.ApplicationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setApplicationName(final java.lang.String value) {
        this.jsiiSet("applicationName", java.util.Objects.requireNonNull(value, "applicationName is required"));
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.ServiceRoleArn`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-servicerolearn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getServiceRoleArn() {
        return this.jsiiGet("serviceRoleArn", java.lang.String.class);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.ServiceRoleArn`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-servicerolearn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setServiceRoleArn(final java.lang.String value) {
        this.jsiiSet("serviceRoleArn", java.util.Objects.requireNonNull(value, "serviceRoleArn is required"));
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.AlarmConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-alarmconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getAlarmConfiguration() {
        return this.jsiiGet("alarmConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.AlarmConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-alarmconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAlarmConfiguration(final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.AlarmConfigurationProperty value) {
        this.jsiiSet("alarmConfiguration", value);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.AlarmConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-alarmconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAlarmConfiguration(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("alarmConfiguration", value);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.AutoRollbackConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getAutoRollbackConfiguration() {
        return this.jsiiGet("autoRollbackConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.AutoRollbackConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAutoRollbackConfiguration(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("autoRollbackConfiguration", value);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.AutoRollbackConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAutoRollbackConfiguration(final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.AutoRollbackConfigurationProperty value) {
        this.jsiiSet("autoRollbackConfiguration", value);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.AutoScalingGroups`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-autoscalinggroups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.util.List<java.lang.String> getAutoScalingGroups() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("autoScalingGroups", java.util.List.class));
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.AutoScalingGroups`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-autoscalinggroups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAutoScalingGroups(final java.util.List<java.lang.String> value) {
        this.jsiiSet("autoScalingGroups", value);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.Deployment`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deployment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getDeployment() {
        return this.jsiiGet("deployment", java.lang.Object.class);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.Deployment`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deployment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDeployment(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("deployment", value);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.Deployment`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deployment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDeployment(final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.DeploymentProperty value) {
        this.jsiiSet("deployment", value);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.DeploymentConfigName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentconfigname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getDeploymentConfigName() {
        return this.jsiiGet("deploymentConfigName", java.lang.String.class);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.DeploymentConfigName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentconfigname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDeploymentConfigName(final java.lang.String value) {
        this.jsiiSet("deploymentConfigName", value);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.DeploymentGroupName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentgroupname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getDeploymentGroupName() {
        return this.jsiiGet("deploymentGroupName", java.lang.String.class);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.DeploymentGroupName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentgroupname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDeploymentGroupName(final java.lang.String value) {
        this.jsiiSet("deploymentGroupName", value);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.DeploymentStyle`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentstyle
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getDeploymentStyle() {
        return this.jsiiGet("deploymentStyle", java.lang.Object.class);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.DeploymentStyle`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentstyle
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDeploymentStyle(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("deploymentStyle", value);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.DeploymentStyle`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentstyle
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDeploymentStyle(final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.DeploymentStyleProperty value) {
        this.jsiiSet("deploymentStyle", value);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.Ec2TagFilters`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-ec2tagfilters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getEc2TagFilters() {
        return this.jsiiGet("ec2TagFilters", java.lang.Object.class);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.Ec2TagFilters`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-ec2tagfilters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setEc2TagFilters(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("ec2TagFilters", value);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.Ec2TagFilters`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-ec2tagfilters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setEc2TagFilters(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("ec2TagFilters", value);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.Ec2TagSet`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-ec2tagset
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getEc2TagSet() {
        return this.jsiiGet("ec2TagSet", java.lang.Object.class);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.Ec2TagSet`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-ec2tagset
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setEc2TagSet(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("ec2TagSet", value);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.Ec2TagSet`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-ec2tagset
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setEc2TagSet(final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.EC2TagSetProperty value) {
        this.jsiiSet("ec2TagSet", value);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.LoadBalancerInfo`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getLoadBalancerInfo() {
        return this.jsiiGet("loadBalancerInfo", java.lang.Object.class);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.LoadBalancerInfo`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLoadBalancerInfo(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("loadBalancerInfo", value);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.LoadBalancerInfo`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLoadBalancerInfo(final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.LoadBalancerInfoProperty value) {
        this.jsiiSet("loadBalancerInfo", value);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.OnPremisesInstanceTagFilters`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-onpremisesinstancetagfilters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getOnPremisesInstanceTagFilters() {
        return this.jsiiGet("onPremisesInstanceTagFilters", java.lang.Object.class);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.OnPremisesInstanceTagFilters`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-onpremisesinstancetagfilters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setOnPremisesInstanceTagFilters(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("onPremisesInstanceTagFilters", value);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.OnPremisesInstanceTagFilters`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-onpremisesinstancetagfilters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setOnPremisesInstanceTagFilters(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("onPremisesInstanceTagFilters", value);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.OnPremisesTagSet`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-onpremisestagset
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getOnPremisesTagSet() {
        return this.jsiiGet("onPremisesTagSet", java.lang.Object.class);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.OnPremisesTagSet`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-onpremisestagset
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setOnPremisesTagSet(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("onPremisesTagSet", value);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.OnPremisesTagSet`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-onpremisestagset
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setOnPremisesTagSet(final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.OnPremisesTagSetProperty value) {
        this.jsiiSet("onPremisesTagSet", value);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.TriggerConfigurations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-triggerconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getTriggerConfigurations() {
        return this.jsiiGet("triggerConfigurations", java.lang.Object.class);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.TriggerConfigurations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-triggerconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTriggerConfigurations(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("triggerConfigurations", value);
    }

    /**
     * `AWS::CodeDeploy::DeploymentGroup.TriggerConfigurations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-triggerconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTriggerConfigurations(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("triggerConfigurations", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface AlarmConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDeploymentGroup.AlarmConfigurationProperty.Alarms`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-alarms
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getAlarms();

        /**
         * `CfnDeploymentGroup.AlarmConfigurationProperty.Enabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-enabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEnabled();

        /**
         * `CfnDeploymentGroup.AlarmConfigurationProperty.IgnorePollAlarmFailure`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-ignorepollalarmfailure
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getIgnorePollAlarmFailure();

        /**
         * @return a {@link Builder} of {@link AlarmConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AlarmConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object alarms;
            private java.lang.Object enabled;
            private java.lang.Object ignorePollAlarmFailure;

            /**
             * Sets the value of Alarms
             * @param alarms `CfnDeploymentGroup.AlarmConfigurationProperty.Alarms`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder alarms(software.amazon.awscdk.core.IResolvable alarms) {
                this.alarms = alarms;
                return this;
            }

            /**
             * Sets the value of Alarms
             * @param alarms `CfnDeploymentGroup.AlarmConfigurationProperty.Alarms`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder alarms(java.util.List<java.lang.Object> alarms) {
                this.alarms = alarms;
                return this;
            }

            /**
             * Sets the value of Enabled
             * @param enabled `CfnDeploymentGroup.AlarmConfigurationProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of Enabled
             * @param enabled `CfnDeploymentGroup.AlarmConfigurationProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of IgnorePollAlarmFailure
             * @param ignorePollAlarmFailure `CfnDeploymentGroup.AlarmConfigurationProperty.IgnorePollAlarmFailure`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder ignorePollAlarmFailure(java.lang.Boolean ignorePollAlarmFailure) {
                this.ignorePollAlarmFailure = ignorePollAlarmFailure;
                return this;
            }

            /**
             * Sets the value of IgnorePollAlarmFailure
             * @param ignorePollAlarmFailure `CfnDeploymentGroup.AlarmConfigurationProperty.IgnorePollAlarmFailure`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder ignorePollAlarmFailure(software.amazon.awscdk.core.IResolvable ignorePollAlarmFailure) {
                this.ignorePollAlarmFailure = ignorePollAlarmFailure;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AlarmConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public AlarmConfigurationProperty build() {
                return new Jsii$Proxy(alarms, enabled, ignorePollAlarmFailure);
            }
        }

        /**
         * An implementation for {@link AlarmConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlarmConfigurationProperty {
            private final java.lang.Object alarms;
            private final java.lang.Object enabled;
            private final java.lang.Object ignorePollAlarmFailure;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.alarms = this.jsiiGet("alarms", java.lang.Object.class);
                this.enabled = this.jsiiGet("enabled", java.lang.Object.class);
                this.ignorePollAlarmFailure = this.jsiiGet("ignorePollAlarmFailure", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object alarms, java.lang.Object enabled, java.lang.Object ignorePollAlarmFailure) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alarms = alarms;
                this.enabled = enabled;
                this.ignorePollAlarmFailure = ignorePollAlarmFailure;
            }

            @Override
            public java.lang.Object getAlarms() {
                return this.alarms;
            }

            @Override
            public java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public java.lang.Object getIgnorePollAlarmFailure() {
                return this.ignorePollAlarmFailure;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getAlarms() != null) {
                    obj.set("alarms", om.valueToTree(this.getAlarms()));
                }
                if (this.getEnabled() != null) {
                    obj.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getIgnorePollAlarmFailure() != null) {
                    obj.set("ignorePollAlarmFailure", om.valueToTree(this.getIgnorePollAlarmFailure()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AlarmConfigurationProperty.Jsii$Proxy that = (AlarmConfigurationProperty.Jsii$Proxy) o;

                if (this.alarms != null ? !this.alarms.equals(that.alarms) : that.alarms != null) return false;
                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                return this.ignorePollAlarmFailure != null ? this.ignorePollAlarmFailure.equals(that.ignorePollAlarmFailure) : that.ignorePollAlarmFailure == null;
            }

            @Override
            public int hashCode() {
                int result = this.alarms != null ? this.alarms.hashCode() : 0;
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                result = 31 * result + (this.ignorePollAlarmFailure != null ? this.ignorePollAlarmFailure.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarm.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface AlarmProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDeploymentGroup.AlarmProperty.Name`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarm.html#cfn-codedeploy-deploymentgroup-alarm-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link AlarmProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AlarmProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String name;

            /**
             * Sets the value of Name
             * @param name `CfnDeploymentGroup.AlarmProperty.Name`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AlarmProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public AlarmProperty build() {
                return new Jsii$Proxy(name);
            }
        }

        /**
         * An implementation for {@link AlarmProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlarmProperty {
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.name = this.jsiiGet("name", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String name) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = name;
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getName() != null) {
                    obj.set("name", om.valueToTree(this.getName()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AlarmProperty.Jsii$Proxy that = (AlarmProperty.Jsii$Proxy) o;

                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface AutoRollbackConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDeploymentGroup.AutoRollbackConfigurationProperty.Enabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-enabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEnabled();

        /**
         * `CfnDeploymentGroup.AutoRollbackConfigurationProperty.Events`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-events
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getEvents();

        /**
         * @return a {@link Builder} of {@link AutoRollbackConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoRollbackConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object enabled;
            private java.util.List<java.lang.String> events;

            /**
             * Sets the value of Enabled
             * @param enabled `CfnDeploymentGroup.AutoRollbackConfigurationProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of Enabled
             * @param enabled `CfnDeploymentGroup.AutoRollbackConfigurationProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of Events
             * @param events `CfnDeploymentGroup.AutoRollbackConfigurationProperty.Events`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder events(java.util.List<java.lang.String> events) {
                this.events = events;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoRollbackConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public AutoRollbackConfigurationProperty build() {
                return new Jsii$Proxy(enabled, events);
            }
        }

        /**
         * An implementation for {@link AutoRollbackConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoRollbackConfigurationProperty {
            private final java.lang.Object enabled;
            private final java.util.List<java.lang.String> events;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.enabled = this.jsiiGet("enabled", java.lang.Object.class);
                this.events = this.jsiiGet("events", java.util.List.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object enabled, java.util.List<java.lang.String> events) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = enabled;
                this.events = events;
            }

            @Override
            public java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public java.util.List<java.lang.String> getEvents() {
                return this.events;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getEnabled() != null) {
                    obj.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getEvents() != null) {
                    obj.set("events", om.valueToTree(this.getEvents()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoRollbackConfigurationProperty.Jsii$Proxy that = (AutoRollbackConfigurationProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                return this.events != null ? this.events.equals(that.events) : that.events == null;
            }

            @Override
            public int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.events != null ? this.events.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface DeploymentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDeploymentGroup.DeploymentProperty.Revision`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getRevision();

        /**
         * `CfnDeploymentGroup.DeploymentProperty.Description`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-description
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDescription();

        /**
         * `CfnDeploymentGroup.DeploymentProperty.IgnoreApplicationStopFailures`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-ignoreapplicationstopfailures
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getIgnoreApplicationStopFailures();

        /**
         * @return a {@link Builder} of {@link DeploymentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeploymentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object revision;
            private java.lang.String description;
            private java.lang.Object ignoreApplicationStopFailures;

            /**
             * Sets the value of Revision
             * @param revision `CfnDeploymentGroup.DeploymentProperty.Revision`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder revision(software.amazon.awscdk.core.IResolvable revision) {
                this.revision = revision;
                return this;
            }

            /**
             * Sets the value of Revision
             * @param revision `CfnDeploymentGroup.DeploymentProperty.Revision`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder revision(software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.RevisionLocationProperty revision) {
                this.revision = revision;
                return this;
            }

            /**
             * Sets the value of Description
             * @param description `CfnDeploymentGroup.DeploymentProperty.Description`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of IgnoreApplicationStopFailures
             * @param ignoreApplicationStopFailures `CfnDeploymentGroup.DeploymentProperty.IgnoreApplicationStopFailures`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder ignoreApplicationStopFailures(java.lang.Boolean ignoreApplicationStopFailures) {
                this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
                return this;
            }

            /**
             * Sets the value of IgnoreApplicationStopFailures
             * @param ignoreApplicationStopFailures `CfnDeploymentGroup.DeploymentProperty.IgnoreApplicationStopFailures`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder ignoreApplicationStopFailures(software.amazon.awscdk.core.IResolvable ignoreApplicationStopFailures) {
                this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public DeploymentProperty build() {
                return new Jsii$Proxy(revision, description, ignoreApplicationStopFailures);
            }
        }

        /**
         * An implementation for {@link DeploymentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentProperty {
            private final java.lang.Object revision;
            private final java.lang.String description;
            private final java.lang.Object ignoreApplicationStopFailures;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.revision = this.jsiiGet("revision", java.lang.Object.class);
                this.description = this.jsiiGet("description", java.lang.String.class);
                this.ignoreApplicationStopFailures = this.jsiiGet("ignoreApplicationStopFailures", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object revision, java.lang.String description, java.lang.Object ignoreApplicationStopFailures) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.revision = java.util.Objects.requireNonNull(revision, "revision is required");
                this.description = description;
                this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
            }

            @Override
            public java.lang.Object getRevision() {
                return this.revision;
            }

            @Override
            public java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public java.lang.Object getIgnoreApplicationStopFailures() {
                return this.ignoreApplicationStopFailures;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("revision", om.valueToTree(this.getRevision()));
                if (this.getDescription() != null) {
                    obj.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getIgnoreApplicationStopFailures() != null) {
                    obj.set("ignoreApplicationStopFailures", om.valueToTree(this.getIgnoreApplicationStopFailures()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeploymentProperty.Jsii$Proxy that = (DeploymentProperty.Jsii$Proxy) o;

                if (!revision.equals(that.revision)) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                return this.ignoreApplicationStopFailures != null ? this.ignoreApplicationStopFailures.equals(that.ignoreApplicationStopFailures) : that.ignoreApplicationStopFailures == null;
            }

            @Override
            public int hashCode() {
                int result = this.revision.hashCode();
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.ignoreApplicationStopFailures != null ? this.ignoreApplicationStopFailures.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface DeploymentStyleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDeploymentGroup.DeploymentStyleProperty.DeploymentOption`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymentoption
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDeploymentOption();

        /**
         * `CfnDeploymentGroup.DeploymentStyleProperty.DeploymentType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymenttype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDeploymentType();

        /**
         * @return a {@link Builder} of {@link DeploymentStyleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeploymentStyleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String deploymentOption;
            private java.lang.String deploymentType;

            /**
             * Sets the value of DeploymentOption
             * @param deploymentOption `CfnDeploymentGroup.DeploymentStyleProperty.DeploymentOption`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder deploymentOption(java.lang.String deploymentOption) {
                this.deploymentOption = deploymentOption;
                return this;
            }

            /**
             * Sets the value of DeploymentType
             * @param deploymentType `CfnDeploymentGroup.DeploymentStyleProperty.DeploymentType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder deploymentType(java.lang.String deploymentType) {
                this.deploymentType = deploymentType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentStyleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public DeploymentStyleProperty build() {
                return new Jsii$Proxy(deploymentOption, deploymentType);
            }
        }

        /**
         * An implementation for {@link DeploymentStyleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentStyleProperty {
            private final java.lang.String deploymentOption;
            private final java.lang.String deploymentType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.deploymentOption = this.jsiiGet("deploymentOption", java.lang.String.class);
                this.deploymentType = this.jsiiGet("deploymentType", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String deploymentOption, java.lang.String deploymentType) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deploymentOption = deploymentOption;
                this.deploymentType = deploymentType;
            }

            @Override
            public java.lang.String getDeploymentOption() {
                return this.deploymentOption;
            }

            @Override
            public java.lang.String getDeploymentType() {
                return this.deploymentType;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getDeploymentOption() != null) {
                    obj.set("deploymentOption", om.valueToTree(this.getDeploymentOption()));
                }
                if (this.getDeploymentType() != null) {
                    obj.set("deploymentType", om.valueToTree(this.getDeploymentType()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeploymentStyleProperty.Jsii$Proxy that = (DeploymentStyleProperty.Jsii$Proxy) o;

                if (this.deploymentOption != null ? !this.deploymentOption.equals(that.deploymentOption) : that.deploymentOption != null) return false;
                return this.deploymentType != null ? this.deploymentType.equals(that.deploymentType) : that.deploymentType == null;
            }

            @Override
            public int hashCode() {
                int result = this.deploymentOption != null ? this.deploymentOption.hashCode() : 0;
                result = 31 * result + (this.deploymentType != null ? this.deploymentType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilter.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface EC2TagFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDeploymentGroup.EC2TagFilterProperty.Key`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilter.html#cfn-codedeploy-deploymentgroup-ec2tagfilter-key
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getKey();

        /**
         * `CfnDeploymentGroup.EC2TagFilterProperty.Type`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilter.html#cfn-codedeploy-deploymentgroup-ec2tagfilter-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getType();

        /**
         * `CfnDeploymentGroup.EC2TagFilterProperty.Value`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilter.html#cfn-codedeploy-deploymentgroup-ec2tagfilter-value
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link EC2TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EC2TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String key;
            private java.lang.String type;
            private java.lang.String value;

            /**
             * Sets the value of Key
             * @param key `CfnDeploymentGroup.EC2TagFilterProperty.Key`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of Type
             * @param type `CfnDeploymentGroup.EC2TagFilterProperty.Type`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of Value
             * @param value `CfnDeploymentGroup.EC2TagFilterProperty.Value`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EC2TagFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public EC2TagFilterProperty build() {
                return new Jsii$Proxy(key, type, value);
            }
        }

        /**
         * An implementation for {@link EC2TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EC2TagFilterProperty {
            private final java.lang.String key;
            private final java.lang.String type;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.key = this.jsiiGet("key", java.lang.String.class);
                this.type = this.jsiiGet("type", java.lang.String.class);
                this.value = this.jsiiGet("value", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String key, java.lang.String type, java.lang.String value) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = key;
                this.type = type;
                this.value = value;
            }

            @Override
            public java.lang.String getKey() {
                return this.key;
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public java.lang.String getValue() {
                return this.value;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getKey() != null) {
                    obj.set("key", om.valueToTree(this.getKey()));
                }
                if (this.getType() != null) {
                    obj.set("type", om.valueToTree(this.getType()));
                }
                if (this.getValue() != null) {
                    obj.set("value", om.valueToTree(this.getValue()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EC2TagFilterProperty.Jsii$Proxy that = (EC2TagFilterProperty.Jsii$Proxy) o;

                if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
                if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public int hashCode() {
                int result = this.key != null ? this.key.hashCode() : 0;
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagsetlistobject.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface EC2TagSetListObjectProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDeploymentGroup.EC2TagSetListObjectProperty.Ec2TagGroup`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagsetlistobject.html#cfn-codedeploy-deploymentgroup-ec2tagsetlistobject-ec2taggroup
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEc2TagGroup();

        /**
         * @return a {@link Builder} of {@link EC2TagSetListObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EC2TagSetListObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object ec2TagGroup;

            /**
             * Sets the value of Ec2TagGroup
             * @param ec2TagGroup `CfnDeploymentGroup.EC2TagSetListObjectProperty.Ec2TagGroup`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder ec2TagGroup(software.amazon.awscdk.core.IResolvable ec2TagGroup) {
                this.ec2TagGroup = ec2TagGroup;
                return this;
            }

            /**
             * Sets the value of Ec2TagGroup
             * @param ec2TagGroup `CfnDeploymentGroup.EC2TagSetListObjectProperty.Ec2TagGroup`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder ec2TagGroup(java.util.List<java.lang.Object> ec2TagGroup) {
                this.ec2TagGroup = ec2TagGroup;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EC2TagSetListObjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public EC2TagSetListObjectProperty build() {
                return new Jsii$Proxy(ec2TagGroup);
            }
        }

        /**
         * An implementation for {@link EC2TagSetListObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EC2TagSetListObjectProperty {
            private final java.lang.Object ec2TagGroup;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.ec2TagGroup = this.jsiiGet("ec2TagGroup", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object ec2TagGroup) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ec2TagGroup = ec2TagGroup;
            }

            @Override
            public java.lang.Object getEc2TagGroup() {
                return this.ec2TagGroup;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getEc2TagGroup() != null) {
                    obj.set("ec2TagGroup", om.valueToTree(this.getEc2TagGroup()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EC2TagSetListObjectProperty.Jsii$Proxy that = (EC2TagSetListObjectProperty.Jsii$Proxy) o;

                return this.ec2TagGroup != null ? this.ec2TagGroup.equals(that.ec2TagGroup) : that.ec2TagGroup == null;
            }

            @Override
            public int hashCode() {
                int result = this.ec2TagGroup != null ? this.ec2TagGroup.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagset.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface EC2TagSetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDeploymentGroup.EC2TagSetProperty.Ec2TagSetList`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagset.html#cfn-codedeploy-deploymentgroup-ec2tagset-ec2tagsetlist
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEc2TagSetList();

        /**
         * @return a {@link Builder} of {@link EC2TagSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EC2TagSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object ec2TagSetList;

            /**
             * Sets the value of Ec2TagSetList
             * @param ec2TagSetList `CfnDeploymentGroup.EC2TagSetProperty.Ec2TagSetList`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder ec2TagSetList(software.amazon.awscdk.core.IResolvable ec2TagSetList) {
                this.ec2TagSetList = ec2TagSetList;
                return this;
            }

            /**
             * Sets the value of Ec2TagSetList
             * @param ec2TagSetList `CfnDeploymentGroup.EC2TagSetProperty.Ec2TagSetList`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder ec2TagSetList(java.util.List<java.lang.Object> ec2TagSetList) {
                this.ec2TagSetList = ec2TagSetList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EC2TagSetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public EC2TagSetProperty build() {
                return new Jsii$Proxy(ec2TagSetList);
            }
        }

        /**
         * An implementation for {@link EC2TagSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EC2TagSetProperty {
            private final java.lang.Object ec2TagSetList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.ec2TagSetList = this.jsiiGet("ec2TagSetList", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object ec2TagSetList) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ec2TagSetList = ec2TagSetList;
            }

            @Override
            public java.lang.Object getEc2TagSetList() {
                return this.ec2TagSetList;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getEc2TagSetList() != null) {
                    obj.set("ec2TagSetList", om.valueToTree(this.getEc2TagSetList()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EC2TagSetProperty.Jsii$Proxy that = (EC2TagSetProperty.Jsii$Proxy) o;

                return this.ec2TagSetList != null ? this.ec2TagSetList.equals(that.ec2TagSetList) : that.ec2TagSetList == null;
            }

            @Override
            public int hashCode() {
                int result = this.ec2TagSetList != null ? this.ec2TagSetList.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-elbinfo.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ELBInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDeploymentGroup.ELBInfoProperty.Name`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-elbinfo.html#cfn-codedeploy-deploymentgroup-elbinfo-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link ELBInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ELBInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String name;

            /**
             * Sets the value of Name
             * @param name `CfnDeploymentGroup.ELBInfoProperty.Name`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ELBInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ELBInfoProperty build() {
                return new Jsii$Proxy(name);
            }
        }

        /**
         * An implementation for {@link ELBInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ELBInfoProperty {
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.name = this.jsiiGet("name", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String name) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = name;
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getName() != null) {
                    obj.set("name", om.valueToTree(this.getName()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ELBInfoProperty.Jsii$Proxy that = (ELBInfoProperty.Jsii$Proxy) o;

                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface GitHubLocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDeploymentGroup.GitHubLocationProperty.CommitId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-commitid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getCommitId();

        /**
         * `CfnDeploymentGroup.GitHubLocationProperty.Repository`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-repository
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getRepository();

        /**
         * @return a {@link Builder} of {@link GitHubLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GitHubLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String commitId;
            private java.lang.String repository;

            /**
             * Sets the value of CommitId
             * @param commitId `CfnDeploymentGroup.GitHubLocationProperty.CommitId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder commitId(java.lang.String commitId) {
                this.commitId = commitId;
                return this;
            }

            /**
             * Sets the value of Repository
             * @param repository `CfnDeploymentGroup.GitHubLocationProperty.Repository`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder repository(java.lang.String repository) {
                this.repository = repository;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GitHubLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public GitHubLocationProperty build() {
                return new Jsii$Proxy(commitId, repository);
            }
        }

        /**
         * An implementation for {@link GitHubLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GitHubLocationProperty {
            private final java.lang.String commitId;
            private final java.lang.String repository;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.commitId = this.jsiiGet("commitId", java.lang.String.class);
                this.repository = this.jsiiGet("repository", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String commitId, java.lang.String repository) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.commitId = java.util.Objects.requireNonNull(commitId, "commitId is required");
                this.repository = java.util.Objects.requireNonNull(repository, "repository is required");
            }

            @Override
            public java.lang.String getCommitId() {
                return this.commitId;
            }

            @Override
            public java.lang.String getRepository() {
                return this.repository;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("commitId", om.valueToTree(this.getCommitId()));
                obj.set("repository", om.valueToTree(this.getRepository()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GitHubLocationProperty.Jsii$Proxy that = (GitHubLocationProperty.Jsii$Proxy) o;

                if (!commitId.equals(that.commitId)) return false;
                return this.repository.equals(that.repository);
            }

            @Override
            public int hashCode() {
                int result = this.commitId.hashCode();
                result = 31 * result + (this.repository.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface LoadBalancerInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDeploymentGroup.LoadBalancerInfoProperty.ElbInfoList`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-elbinfolist
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getElbInfoList();

        /**
         * `CfnDeploymentGroup.LoadBalancerInfoProperty.TargetGroupInfoList`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-targetgroupinfolist
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getTargetGroupInfoList();

        /**
         * @return a {@link Builder} of {@link LoadBalancerInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoadBalancerInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object elbInfoList;
            private java.lang.Object targetGroupInfoList;

            /**
             * Sets the value of ElbInfoList
             * @param elbInfoList `CfnDeploymentGroup.LoadBalancerInfoProperty.ElbInfoList`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder elbInfoList(software.amazon.awscdk.core.IResolvable elbInfoList) {
                this.elbInfoList = elbInfoList;
                return this;
            }

            /**
             * Sets the value of ElbInfoList
             * @param elbInfoList `CfnDeploymentGroup.LoadBalancerInfoProperty.ElbInfoList`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder elbInfoList(java.util.List<java.lang.Object> elbInfoList) {
                this.elbInfoList = elbInfoList;
                return this;
            }

            /**
             * Sets the value of TargetGroupInfoList
             * @param targetGroupInfoList `CfnDeploymentGroup.LoadBalancerInfoProperty.TargetGroupInfoList`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder targetGroupInfoList(software.amazon.awscdk.core.IResolvable targetGroupInfoList) {
                this.targetGroupInfoList = targetGroupInfoList;
                return this;
            }

            /**
             * Sets the value of TargetGroupInfoList
             * @param targetGroupInfoList `CfnDeploymentGroup.LoadBalancerInfoProperty.TargetGroupInfoList`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder targetGroupInfoList(java.util.List<java.lang.Object> targetGroupInfoList) {
                this.targetGroupInfoList = targetGroupInfoList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoadBalancerInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public LoadBalancerInfoProperty build() {
                return new Jsii$Proxy(elbInfoList, targetGroupInfoList);
            }
        }

        /**
         * An implementation for {@link LoadBalancerInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoadBalancerInfoProperty {
            private final java.lang.Object elbInfoList;
            private final java.lang.Object targetGroupInfoList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.elbInfoList = this.jsiiGet("elbInfoList", java.lang.Object.class);
                this.targetGroupInfoList = this.jsiiGet("targetGroupInfoList", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object elbInfoList, java.lang.Object targetGroupInfoList) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.elbInfoList = elbInfoList;
                this.targetGroupInfoList = targetGroupInfoList;
            }

            @Override
            public java.lang.Object getElbInfoList() {
                return this.elbInfoList;
            }

            @Override
            public java.lang.Object getTargetGroupInfoList() {
                return this.targetGroupInfoList;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getElbInfoList() != null) {
                    obj.set("elbInfoList", om.valueToTree(this.getElbInfoList()));
                }
                if (this.getTargetGroupInfoList() != null) {
                    obj.set("targetGroupInfoList", om.valueToTree(this.getTargetGroupInfoList()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoadBalancerInfoProperty.Jsii$Proxy that = (LoadBalancerInfoProperty.Jsii$Proxy) o;

                if (this.elbInfoList != null ? !this.elbInfoList.equals(that.elbInfoList) : that.elbInfoList != null) return false;
                return this.targetGroupInfoList != null ? this.targetGroupInfoList.equals(that.targetGroupInfoList) : that.targetGroupInfoList == null;
            }

            @Override
            public int hashCode() {
                int result = this.elbInfoList != null ? this.elbInfoList.hashCode() : 0;
                result = 31 * result + (this.targetGroupInfoList != null ? this.targetGroupInfoList.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisestagsetlistobject.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface OnPremisesTagSetListObjectProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDeploymentGroup.OnPremisesTagSetListObjectProperty.OnPremisesTagGroup`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisestagsetlistobject.html#cfn-codedeploy-deploymentgroup-onpremisestagsetlistobject-onpremisestaggroup
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getOnPremisesTagGroup();

        /**
         * @return a {@link Builder} of {@link OnPremisesTagSetListObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OnPremisesTagSetListObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object onPremisesTagGroup;

            /**
             * Sets the value of OnPremisesTagGroup
             * @param onPremisesTagGroup `CfnDeploymentGroup.OnPremisesTagSetListObjectProperty.OnPremisesTagGroup`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder onPremisesTagGroup(software.amazon.awscdk.core.IResolvable onPremisesTagGroup) {
                this.onPremisesTagGroup = onPremisesTagGroup;
                return this;
            }

            /**
             * Sets the value of OnPremisesTagGroup
             * @param onPremisesTagGroup `CfnDeploymentGroup.OnPremisesTagSetListObjectProperty.OnPremisesTagGroup`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder onPremisesTagGroup(java.util.List<java.lang.Object> onPremisesTagGroup) {
                this.onPremisesTagGroup = onPremisesTagGroup;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OnPremisesTagSetListObjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public OnPremisesTagSetListObjectProperty build() {
                return new Jsii$Proxy(onPremisesTagGroup);
            }
        }

        /**
         * An implementation for {@link OnPremisesTagSetListObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OnPremisesTagSetListObjectProperty {
            private final java.lang.Object onPremisesTagGroup;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.onPremisesTagGroup = this.jsiiGet("onPremisesTagGroup", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object onPremisesTagGroup) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.onPremisesTagGroup = onPremisesTagGroup;
            }

            @Override
            public java.lang.Object getOnPremisesTagGroup() {
                return this.onPremisesTagGroup;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getOnPremisesTagGroup() != null) {
                    obj.set("onPremisesTagGroup", om.valueToTree(this.getOnPremisesTagGroup()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OnPremisesTagSetListObjectProperty.Jsii$Proxy that = (OnPremisesTagSetListObjectProperty.Jsii$Proxy) o;

                return this.onPremisesTagGroup != null ? this.onPremisesTagGroup.equals(that.onPremisesTagGroup) : that.onPremisesTagGroup == null;
            }

            @Override
            public int hashCode() {
                int result = this.onPremisesTagGroup != null ? this.onPremisesTagGroup.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisestagset.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface OnPremisesTagSetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDeploymentGroup.OnPremisesTagSetProperty.OnPremisesTagSetList`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisestagset.html#cfn-codedeploy-deploymentgroup-onpremisestagset-onpremisestagsetlist
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getOnPremisesTagSetList();

        /**
         * @return a {@link Builder} of {@link OnPremisesTagSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OnPremisesTagSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object onPremisesTagSetList;

            /**
             * Sets the value of OnPremisesTagSetList
             * @param onPremisesTagSetList `CfnDeploymentGroup.OnPremisesTagSetProperty.OnPremisesTagSetList`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder onPremisesTagSetList(software.amazon.awscdk.core.IResolvable onPremisesTagSetList) {
                this.onPremisesTagSetList = onPremisesTagSetList;
                return this;
            }

            /**
             * Sets the value of OnPremisesTagSetList
             * @param onPremisesTagSetList `CfnDeploymentGroup.OnPremisesTagSetProperty.OnPremisesTagSetList`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder onPremisesTagSetList(java.util.List<java.lang.Object> onPremisesTagSetList) {
                this.onPremisesTagSetList = onPremisesTagSetList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OnPremisesTagSetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public OnPremisesTagSetProperty build() {
                return new Jsii$Proxy(onPremisesTagSetList);
            }
        }

        /**
         * An implementation for {@link OnPremisesTagSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OnPremisesTagSetProperty {
            private final java.lang.Object onPremisesTagSetList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.onPremisesTagSetList = this.jsiiGet("onPremisesTagSetList", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object onPremisesTagSetList) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.onPremisesTagSetList = onPremisesTagSetList;
            }

            @Override
            public java.lang.Object getOnPremisesTagSetList() {
                return this.onPremisesTagSetList;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getOnPremisesTagSetList() != null) {
                    obj.set("onPremisesTagSetList", om.valueToTree(this.getOnPremisesTagSetList()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OnPremisesTagSetProperty.Jsii$Proxy that = (OnPremisesTagSetProperty.Jsii$Proxy) o;

                return this.onPremisesTagSetList != null ? this.onPremisesTagSetList.equals(that.onPremisesTagSetList) : that.onPremisesTagSetList == null;
            }

            @Override
            public int hashCode() {
                int result = this.onPremisesTagSetList != null ? this.onPremisesTagSetList.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface RevisionLocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDeploymentGroup.RevisionLocationProperty.GitHubLocation`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getGitHubLocation();

        /**
         * `CfnDeploymentGroup.RevisionLocationProperty.RevisionType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-revisiontype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getRevisionType();

        /**
         * `CfnDeploymentGroup.RevisionLocationProperty.S3Location`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getS3Location();

        /**
         * @return a {@link Builder} of {@link RevisionLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RevisionLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object gitHubLocation;
            private java.lang.String revisionType;
            private java.lang.Object s3Location;

            /**
             * Sets the value of GitHubLocation
             * @param gitHubLocation `CfnDeploymentGroup.RevisionLocationProperty.GitHubLocation`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder gitHubLocation(software.amazon.awscdk.core.IResolvable gitHubLocation) {
                this.gitHubLocation = gitHubLocation;
                return this;
            }

            /**
             * Sets the value of GitHubLocation
             * @param gitHubLocation `CfnDeploymentGroup.RevisionLocationProperty.GitHubLocation`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder gitHubLocation(software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.GitHubLocationProperty gitHubLocation) {
                this.gitHubLocation = gitHubLocation;
                return this;
            }

            /**
             * Sets the value of RevisionType
             * @param revisionType `CfnDeploymentGroup.RevisionLocationProperty.RevisionType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder revisionType(java.lang.String revisionType) {
                this.revisionType = revisionType;
                return this;
            }

            /**
             * Sets the value of S3Location
             * @param s3Location `CfnDeploymentGroup.RevisionLocationProperty.S3Location`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder s3Location(software.amazon.awscdk.core.IResolvable s3Location) {
                this.s3Location = s3Location;
                return this;
            }

            /**
             * Sets the value of S3Location
             * @param s3Location `CfnDeploymentGroup.RevisionLocationProperty.S3Location`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder s3Location(software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.S3LocationProperty s3Location) {
                this.s3Location = s3Location;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RevisionLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public RevisionLocationProperty build() {
                return new Jsii$Proxy(gitHubLocation, revisionType, s3Location);
            }
        }

        /**
         * An implementation for {@link RevisionLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RevisionLocationProperty {
            private final java.lang.Object gitHubLocation;
            private final java.lang.String revisionType;
            private final java.lang.Object s3Location;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.gitHubLocation = this.jsiiGet("gitHubLocation", java.lang.Object.class);
                this.revisionType = this.jsiiGet("revisionType", java.lang.String.class);
                this.s3Location = this.jsiiGet("s3Location", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object gitHubLocation, java.lang.String revisionType, java.lang.Object s3Location) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.gitHubLocation = gitHubLocation;
                this.revisionType = revisionType;
                this.s3Location = s3Location;
            }

            @Override
            public java.lang.Object getGitHubLocation() {
                return this.gitHubLocation;
            }

            @Override
            public java.lang.String getRevisionType() {
                return this.revisionType;
            }

            @Override
            public java.lang.Object getS3Location() {
                return this.s3Location;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getGitHubLocation() != null) {
                    obj.set("gitHubLocation", om.valueToTree(this.getGitHubLocation()));
                }
                if (this.getRevisionType() != null) {
                    obj.set("revisionType", om.valueToTree(this.getRevisionType()));
                }
                if (this.getS3Location() != null) {
                    obj.set("s3Location", om.valueToTree(this.getS3Location()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RevisionLocationProperty.Jsii$Proxy that = (RevisionLocationProperty.Jsii$Proxy) o;

                if (this.gitHubLocation != null ? !this.gitHubLocation.equals(that.gitHubLocation) : that.gitHubLocation != null) return false;
                if (this.revisionType != null ? !this.revisionType.equals(that.revisionType) : that.revisionType != null) return false;
                return this.s3Location != null ? this.s3Location.equals(that.s3Location) : that.s3Location == null;
            }

            @Override
            public int hashCode() {
                int result = this.gitHubLocation != null ? this.gitHubLocation.hashCode() : 0;
                result = 31 * result + (this.revisionType != null ? this.revisionType.hashCode() : 0);
                result = 31 * result + (this.s3Location != null ? this.s3Location.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDeploymentGroup.S3LocationProperty.Bucket`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bucket
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getBucket();

        /**
         * `CfnDeploymentGroup.S3LocationProperty.Key`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-key
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getKey();

        /**
         * `CfnDeploymentGroup.S3LocationProperty.BundleType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bundletype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getBundleType();

        /**
         * `CfnDeploymentGroup.S3LocationProperty.ETag`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-etag
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getETag();

        /**
         * `CfnDeploymentGroup.S3LocationProperty.Version`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-value
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getVersion();

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String bucket;
            private java.lang.String key;
            private java.lang.String bundleType;
            private java.lang.String eTag;
            private java.lang.String version;

            /**
             * Sets the value of Bucket
             * @param bucket `CfnDeploymentGroup.S3LocationProperty.Bucket`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of Key
             * @param key `CfnDeploymentGroup.S3LocationProperty.Key`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of BundleType
             * @param bundleType `CfnDeploymentGroup.S3LocationProperty.BundleType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder bundleType(java.lang.String bundleType) {
                this.bundleType = bundleType;
                return this;
            }

            /**
             * Sets the value of ETag
             * @param eTag `CfnDeploymentGroup.S3LocationProperty.ETag`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder eTag(java.lang.String eTag) {
                this.eTag = eTag;
                return this;
            }

            /**
             * Sets the value of Version
             * @param version `CfnDeploymentGroup.S3LocationProperty.Version`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public S3LocationProperty build() {
                return new Jsii$Proxy(bucket, key, bundleType, eTag, version);
            }
        }

        /**
         * An implementation for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3LocationProperty {
            private final java.lang.String bucket;
            private final java.lang.String key;
            private final java.lang.String bundleType;
            private final java.lang.String eTag;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.bucket = this.jsiiGet("bucket", java.lang.String.class);
                this.key = this.jsiiGet("key", java.lang.String.class);
                this.bundleType = this.jsiiGet("bundleType", java.lang.String.class);
                this.eTag = this.jsiiGet("eTag", java.lang.String.class);
                this.version = this.jsiiGet("version", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String bucket, java.lang.String key, java.lang.String bundleType, java.lang.String eTag, java.lang.String version) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(bucket, "bucket is required");
                this.key = java.util.Objects.requireNonNull(key, "key is required");
                this.bundleType = bundleType;
                this.eTag = eTag;
                this.version = version;
            }

            @Override
            public java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public java.lang.String getKey() {
                return this.key;
            }

            @Override
            public java.lang.String getBundleType() {
                return this.bundleType;
            }

            @Override
            public java.lang.String getETag() {
                return this.eTag;
            }

            @Override
            public java.lang.String getVersion() {
                return this.version;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("bucket", om.valueToTree(this.getBucket()));
                obj.set("key", om.valueToTree(this.getKey()));
                if (this.getBundleType() != null) {
                    obj.set("bundleType", om.valueToTree(this.getBundleType()));
                }
                if (this.getETag() != null) {
                    obj.set("eTag", om.valueToTree(this.getETag()));
                }
                if (this.getVersion() != null) {
                    obj.set("version", om.valueToTree(this.getVersion()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3LocationProperty.Jsii$Proxy that = (S3LocationProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (!key.equals(that.key)) return false;
                if (this.bundleType != null ? !this.bundleType.equals(that.bundleType) : that.bundleType != null) return false;
                if (this.eTag != null ? !this.eTag.equals(that.eTag) : that.eTag != null) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.key.hashCode());
                result = 31 * result + (this.bundleType != null ? this.bundleType.hashCode() : 0);
                result = 31 * result + (this.eTag != null ? this.eTag.hashCode() : 0);
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-tagfilter.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface TagFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDeploymentGroup.TagFilterProperty.Key`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-tagfilter.html#cfn-codedeploy-deploymentgroup-tagfilter-key
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getKey();

        /**
         * `CfnDeploymentGroup.TagFilterProperty.Type`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-tagfilter.html#cfn-codedeploy-deploymentgroup-tagfilter-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getType();

        /**
         * `CfnDeploymentGroup.TagFilterProperty.Value`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-tagfilter.html#cfn-codedeploy-deploymentgroup-tagfilter-value
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String key;
            private java.lang.String type;
            private java.lang.String value;

            /**
             * Sets the value of Key
             * @param key `CfnDeploymentGroup.TagFilterProperty.Key`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of Type
             * @param type `CfnDeploymentGroup.TagFilterProperty.Type`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of Value
             * @param value `CfnDeploymentGroup.TagFilterProperty.Value`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public TagFilterProperty build() {
                return new Jsii$Proxy(key, type, value);
            }
        }

        /**
         * An implementation for {@link TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagFilterProperty {
            private final java.lang.String key;
            private final java.lang.String type;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.key = this.jsiiGet("key", java.lang.String.class);
                this.type = this.jsiiGet("type", java.lang.String.class);
                this.value = this.jsiiGet("value", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String key, java.lang.String type, java.lang.String value) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = key;
                this.type = type;
                this.value = value;
            }

            @Override
            public java.lang.String getKey() {
                return this.key;
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public java.lang.String getValue() {
                return this.value;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getKey() != null) {
                    obj.set("key", om.valueToTree(this.getKey()));
                }
                if (this.getType() != null) {
                    obj.set("type", om.valueToTree(this.getType()));
                }
                if (this.getValue() != null) {
                    obj.set("value", om.valueToTree(this.getValue()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagFilterProperty.Jsii$Proxy that = (TagFilterProperty.Jsii$Proxy) o;

                if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
                if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public int hashCode() {
                int result = this.key != null ? this.key.hashCode() : 0;
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-targetgroupinfo.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface TargetGroupInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDeploymentGroup.TargetGroupInfoProperty.Name`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-targetgroupinfo.html#cfn-codedeploy-deploymentgroup-targetgroupinfo-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link TargetGroupInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetGroupInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String name;

            /**
             * Sets the value of Name
             * @param name `CfnDeploymentGroup.TargetGroupInfoProperty.Name`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetGroupInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public TargetGroupInfoProperty build() {
                return new Jsii$Proxy(name);
            }
        }

        /**
         * An implementation for {@link TargetGroupInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetGroupInfoProperty {
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.name = this.jsiiGet("name", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String name) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = name;
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getName() != null) {
                    obj.set("name", om.valueToTree(this.getName()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetGroupInfoProperty.Jsii$Proxy that = (TargetGroupInfoProperty.Jsii$Proxy) o;

                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface TriggerConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDeploymentGroup.TriggerConfigProperty.TriggerEvents`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggerevents
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getTriggerEvents();

        /**
         * `CfnDeploymentGroup.TriggerConfigProperty.TriggerName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggername
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getTriggerName();

        /**
         * `CfnDeploymentGroup.TriggerConfigProperty.TriggerTargetArn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggertargetarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getTriggerTargetArn();

        /**
         * @return a {@link Builder} of {@link TriggerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TriggerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.util.List<java.lang.String> triggerEvents;
            private java.lang.String triggerName;
            private java.lang.String triggerTargetArn;

            /**
             * Sets the value of TriggerEvents
             * @param triggerEvents `CfnDeploymentGroup.TriggerConfigProperty.TriggerEvents`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder triggerEvents(java.util.List<java.lang.String> triggerEvents) {
                this.triggerEvents = triggerEvents;
                return this;
            }

            /**
             * Sets the value of TriggerName
             * @param triggerName `CfnDeploymentGroup.TriggerConfigProperty.TriggerName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder triggerName(java.lang.String triggerName) {
                this.triggerName = triggerName;
                return this;
            }

            /**
             * Sets the value of TriggerTargetArn
             * @param triggerTargetArn `CfnDeploymentGroup.TriggerConfigProperty.TriggerTargetArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder triggerTargetArn(java.lang.String triggerTargetArn) {
                this.triggerTargetArn = triggerTargetArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TriggerConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public TriggerConfigProperty build() {
                return new Jsii$Proxy(triggerEvents, triggerName, triggerTargetArn);
            }
        }

        /**
         * An implementation for {@link TriggerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TriggerConfigProperty {
            private final java.util.List<java.lang.String> triggerEvents;
            private final java.lang.String triggerName;
            private final java.lang.String triggerTargetArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.triggerEvents = this.jsiiGet("triggerEvents", java.util.List.class);
                this.triggerName = this.jsiiGet("triggerName", java.lang.String.class);
                this.triggerTargetArn = this.jsiiGet("triggerTargetArn", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.util.List<java.lang.String> triggerEvents, java.lang.String triggerName, java.lang.String triggerTargetArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.triggerEvents = triggerEvents;
                this.triggerName = triggerName;
                this.triggerTargetArn = triggerTargetArn;
            }

            @Override
            public java.util.List<java.lang.String> getTriggerEvents() {
                return this.triggerEvents;
            }

            @Override
            public java.lang.String getTriggerName() {
                return this.triggerName;
            }

            @Override
            public java.lang.String getTriggerTargetArn() {
                return this.triggerTargetArn;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getTriggerEvents() != null) {
                    obj.set("triggerEvents", om.valueToTree(this.getTriggerEvents()));
                }
                if (this.getTriggerName() != null) {
                    obj.set("triggerName", om.valueToTree(this.getTriggerName()));
                }
                if (this.getTriggerTargetArn() != null) {
                    obj.set("triggerTargetArn", om.valueToTree(this.getTriggerTargetArn()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TriggerConfigProperty.Jsii$Proxy that = (TriggerConfigProperty.Jsii$Proxy) o;

                if (this.triggerEvents != null ? !this.triggerEvents.equals(that.triggerEvents) : that.triggerEvents != null) return false;
                if (this.triggerName != null ? !this.triggerName.equals(that.triggerName) : that.triggerName != null) return false;
                return this.triggerTargetArn != null ? this.triggerTargetArn.equals(that.triggerTargetArn) : that.triggerTargetArn == null;
            }

            @Override
            public int hashCode() {
                int result = this.triggerEvents != null ? this.triggerEvents.hashCode() : 0;
                result = 31 * result + (this.triggerName != null ? this.triggerName.hashCode() : 0);
                result = 31 * result + (this.triggerTargetArn != null ? this.triggerTargetArn.hashCode() : 0);
                return result;
            }
        }
    }
}
