package software.amazon.awscdk.services.codedeploy;

/**
 * A custom Deployment Configuration for a Lambda Deployment Group.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-28T11:53:16.020Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CustomLambdaDeploymentConfig")
public class CustomLambdaDeploymentConfig extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig {

    protected CustomLambdaDeploymentConfig(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CustomLambdaDeploymentConfig(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CustomLambdaDeploymentConfig(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.CustomLambdaDeploymentConfigProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The arn of the deployment config.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDeploymentConfigArn() {
        return software.amazon.jsii.Kernel.get(this, "deploymentConfigArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the deployment config.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDeploymentConfigName() {
        return software.amazon.jsii.Kernel.get(this, "deploymentConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codedeploy.CustomLambdaDeploymentConfig}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codedeploy.CustomLambdaDeploymentConfig> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.codedeploy.CustomLambdaDeploymentConfigProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.codedeploy.CustomLambdaDeploymentConfigProps.Builder();
        }

        /**
         * The interval, in number of minutes: - For LINEAR, how frequently additional traffic is shifted - For CANARY, how long to shift traffic before the full deployment.
         * <p>
         * @return {@code this}
         * @param interval The interval, in number of minutes: - For LINEAR, how frequently additional traffic is shifted - For CANARY, how long to shift traffic before the full deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder interval(final software.amazon.awscdk.core.Duration interval) {
            this.props.interval(interval);
            return this;
        }

        /**
         * The integer percentage of traffic to shift: - For LINEAR, the percentage to shift every interval - For CANARY, the percentage to shift until the interval passes, before the full deployment.
         * <p>
         * @return {@code this}
         * @param percentage The integer percentage of traffic to shift: - For LINEAR, the percentage to shift every interval - For CANARY, the percentage to shift until the interval passes, before the full deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder percentage(final java.lang.Number percentage) {
            this.props.percentage(percentage);
            return this;
        }

        /**
         * The type of deployment config, either CANARY or LINEAR.
         * <p>
         * @return {@code this}
         * @param type The type of deployment config, either CANARY or LINEAR. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final software.amazon.awscdk.services.codedeploy.CustomLambdaDeploymentConfigType type) {
            this.props.type(type);
            return this;
        }

        /**
         * The verbatim name of the deployment config.
         * <p>
         * Must be unique per account/region.
         * Other parameters cannot be updated if this name is provided.
         * <p>
         * Default: - automatically generated name
         * <p>
         * @return {@code this}
         * @param deploymentConfigName The verbatim name of the deployment config. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfigName(final java.lang.String deploymentConfigName) {
            this.props.deploymentConfigName(deploymentConfigName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.codedeploy.CustomLambdaDeploymentConfig}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codedeploy.CustomLambdaDeploymentConfig build() {
            return new software.amazon.awscdk.services.codedeploy.CustomLambdaDeploymentConfig(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
