package software.amazon.awscdk.services.codedeploy;

/**
 * Construction properties of {@link ServerDeploymentConfig}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-28T11:53:16.042Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.ServerDeploymentConfigProps")
@software.amazon.jsii.Jsii.Proxy(ServerDeploymentConfigProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ServerDeploymentConfigProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Minimum number of healthy hosts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts getMinimumHealthyHosts();

    /**
     * The physical, human-readable name of the Deployment Configuration.
     * <p>
     * Default: a name will be auto-generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeploymentConfigName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ServerDeploymentConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ServerDeploymentConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ServerDeploymentConfigProps> {
        private software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts minimumHealthyHosts;
        private java.lang.String deploymentConfigName;

        /**
         * Sets the value of {@link ServerDeploymentConfigProps#getMinimumHealthyHosts}
         * @param minimumHealthyHosts Minimum number of healthy hosts. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumHealthyHosts(software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts minimumHealthyHosts) {
            this.minimumHealthyHosts = minimumHealthyHosts;
            return this;
        }

        /**
         * Sets the value of {@link ServerDeploymentConfigProps#getDeploymentConfigName}
         * @param deploymentConfigName The physical, human-readable name of the Deployment Configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfigName(java.lang.String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServerDeploymentConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ServerDeploymentConfigProps build() {
            return new Jsii$Proxy(minimumHealthyHosts, deploymentConfigName);
        }
    }

    /**
     * An implementation for {@link ServerDeploymentConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerDeploymentConfigProps {
        private final software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts minimumHealthyHosts;
        private final java.lang.String deploymentConfigName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.minimumHealthyHosts = software.amazon.jsii.Kernel.get(this, "minimumHealthyHosts", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts.class));
            this.deploymentConfigName = software.amazon.jsii.Kernel.get(this, "deploymentConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts minimumHealthyHosts, final java.lang.String deploymentConfigName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.minimumHealthyHosts = java.util.Objects.requireNonNull(minimumHealthyHosts, "minimumHealthyHosts is required");
            this.deploymentConfigName = deploymentConfigName;
        }

        @Override
        public final software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts getMinimumHealthyHosts() {
            return this.minimumHealthyHosts;
        }

        @Override
        public final java.lang.String getDeploymentConfigName() {
            return this.deploymentConfigName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("minimumHealthyHosts", om.valueToTree(this.getMinimumHealthyHosts()));
            if (this.getDeploymentConfigName() != null) {
                data.set("deploymentConfigName", om.valueToTree(this.getDeploymentConfigName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.ServerDeploymentConfigProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServerDeploymentConfigProps.Jsii$Proxy that = (ServerDeploymentConfigProps.Jsii$Proxy) o;

            if (!minimumHealthyHosts.equals(that.minimumHealthyHosts)) return false;
            return this.deploymentConfigName != null ? this.deploymentConfigName.equals(that.deploymentConfigName) : that.deploymentConfigName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.minimumHealthyHosts.hashCode();
            result = 31 * result + (this.deploymentConfigName != null ? this.deploymentConfigName.hashCode() : 0);
            return result;
        }
    }
}
