package software.amazon.awscdk.services.codedeploy;

/**
 * Construction properties for {@link ServerDeploymentGroup}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-08-26T12:08:34.563Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.ServerDeploymentGroupProps")
@software.amazon.jsii.Jsii.Proxy(ServerDeploymentGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ServerDeploymentGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The CloudWatch alarms associated with this Deployment Group.
     * <p>
     * CodeDeploy will stop (and optionally roll back)
     * a deployment if during it any of the alarms trigger.
     * <p>
     * Alarms can also be added after the Deployment Group is created using the {&#64;link #addAlarm} method.
     * <p>
     * Default: []
     * <p>
     * @see https://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-create-alarms.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudwatch.IAlarm> getAlarms() {
        return null;
    }

    /**
     * The CodeDeploy EC2/on-premise Application this Deployment Group belongs to.
     * <p>
     * Default: - A new Application will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.IServerApplication getApplication() {
        return null;
    }

    /**
     * The auto-rollback configuration for this Deployment Group.
     * <p>
     * Default: - default AutoRollbackConfig.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.AutoRollbackConfig getAutoRollback() {
        return null;
    }

    /**
     * The auto-scaling groups belonging to this Deployment Group.
     * <p>
     * Auto-scaling groups can also be added after the Deployment Group is created
     * using the {&#64;link #addAutoScalingGroup} method.
     * <p>
     * [disable-awslint:ref-via-interface] is needed because we update userdata
     * for ASGs to install the codedeploy agent.
     * <p>
     * Default: []
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.autoscaling.IAutoScalingGroup> getAutoScalingGroups() {
        return null;
    }

    /**
     * The EC2/on-premise Deployment Configuration to use for this Deployment Group.
     * <p>
     * Default: ServerDeploymentConfig#OneAtATime
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig getDeploymentConfig() {
        return null;
    }

    /**
     * The physical, human-readable name of the CodeDeploy Deployment Group.
     * <p>
     * Default: - An auto-generated name will be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeploymentGroupName() {
        return null;
    }

    /**
     * All EC2 instances matching the given set of tags when a deployment occurs will be added to this Deployment Group.
     * <p>
     * Default: - No additional EC2 instances will be added to the Deployment Group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.InstanceTagSet getEc2InstanceTags() {
        return null;
    }

    /**
     * Whether to continue a deployment even if fetching the alarm status from CloudWatch failed.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIgnorePollAlarmsFailure() {
        return null;
    }

    /**
     * If you've provided any auto-scaling groups with the {@link #autoScalingGroups} property, you can set this property to add User Data that installs the CodeDeploy agent on the instances.
     * <p>
     * Default: true
     * <p>
     * @see https://docs.aws.amazon.com/codedeploy/latest/userguide/codedeploy-agent-operations-install.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getInstallAgent() {
        return null;
    }

    /**
     * The load balancer to place in front of this Deployment Group.
     * <p>
     * Can be created from either a classic Elastic Load Balancer,
     * or an Application Load Balancer / Network Load Balancer Target Group.
     * <p>
     * Default: - Deployment Group will not have a load balancer defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.LoadBalancer getLoadBalancer() {
        return null;
    }

    /**
     * All on-premise instances matching the given set of tags when a deployment occurs will be added to this Deployment Group.
     * <p>
     * Default: - No additional on-premise instances will be added to the Deployment Group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.InstanceTagSet getOnPremiseInstanceTags() {
        return null;
    }

    /**
     * The service Role of this Deployment Group.
     * <p>
     * Default: - A new Role will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ServerDeploymentGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ServerDeploymentGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ServerDeploymentGroupProps> {
        private java.util.List<software.amazon.awscdk.services.cloudwatch.IAlarm> alarms;
        private software.amazon.awscdk.services.codedeploy.IServerApplication application;
        private software.amazon.awscdk.services.codedeploy.AutoRollbackConfig autoRollback;
        private java.util.List<software.amazon.awscdk.services.autoscaling.IAutoScalingGroup> autoScalingGroups;
        private software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig deploymentConfig;
        private java.lang.String deploymentGroupName;
        private software.amazon.awscdk.services.codedeploy.InstanceTagSet ec2InstanceTags;
        private java.lang.Boolean ignorePollAlarmsFailure;
        private java.lang.Boolean installAgent;
        private software.amazon.awscdk.services.codedeploy.LoadBalancer loadBalancer;
        private software.amazon.awscdk.services.codedeploy.InstanceTagSet onPremiseInstanceTags;
        private software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of {@link ServerDeploymentGroupProps#getAlarms}
         * @param alarms The CloudWatch alarms associated with this Deployment Group.
         *               CodeDeploy will stop (and optionally roll back)
         *               a deployment if during it any of the alarms trigger.
         *               <p>
         *               Alarms can also be added after the Deployment Group is created using the {&#64;link #addAlarm} method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder alarms(java.util.List<? extends software.amazon.awscdk.services.cloudwatch.IAlarm> alarms) {
            this.alarms = (java.util.List<software.amazon.awscdk.services.cloudwatch.IAlarm>)alarms;
            return this;
        }

        /**
         * Sets the value of {@link ServerDeploymentGroupProps#getApplication}
         * @param application The CodeDeploy EC2/on-premise Application this Deployment Group belongs to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder application(software.amazon.awscdk.services.codedeploy.IServerApplication application) {
            this.application = application;
            return this;
        }

        /**
         * Sets the value of {@link ServerDeploymentGroupProps#getAutoRollback}
         * @param autoRollback The auto-rollback configuration for this Deployment Group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoRollback(software.amazon.awscdk.services.codedeploy.AutoRollbackConfig autoRollback) {
            this.autoRollback = autoRollback;
            return this;
        }

        /**
         * Sets the value of {@link ServerDeploymentGroupProps#getAutoScalingGroups}
         * @param autoScalingGroups The auto-scaling groups belonging to this Deployment Group.
         *                          Auto-scaling groups can also be added after the Deployment Group is created
         *                          using the {&#64;link #addAutoScalingGroup} method.
         *                          <p>
         *                          [disable-awslint:ref-via-interface] is needed because we update userdata
         *                          for ASGs to install the codedeploy agent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder autoScalingGroups(java.util.List<? extends software.amazon.awscdk.services.autoscaling.IAutoScalingGroup> autoScalingGroups) {
            this.autoScalingGroups = (java.util.List<software.amazon.awscdk.services.autoscaling.IAutoScalingGroup>)autoScalingGroups;
            return this;
        }

        /**
         * Sets the value of {@link ServerDeploymentGroupProps#getDeploymentConfig}
         * @param deploymentConfig The EC2/on-premise Deployment Configuration to use for this Deployment Group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfig(software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig deploymentConfig) {
            this.deploymentConfig = deploymentConfig;
            return this;
        }

        /**
         * Sets the value of {@link ServerDeploymentGroupProps#getDeploymentGroupName}
         * @param deploymentGroupName The physical, human-readable name of the CodeDeploy Deployment Group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentGroupName(java.lang.String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        /**
         * Sets the value of {@link ServerDeploymentGroupProps#getEc2InstanceTags}
         * @param ec2InstanceTags All EC2 instances matching the given set of tags when a deployment occurs will be added to this Deployment Group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2InstanceTags(software.amazon.awscdk.services.codedeploy.InstanceTagSet ec2InstanceTags) {
            this.ec2InstanceTags = ec2InstanceTags;
            return this;
        }

        /**
         * Sets the value of {@link ServerDeploymentGroupProps#getIgnorePollAlarmsFailure}
         * @param ignorePollAlarmsFailure Whether to continue a deployment even if fetching the alarm status from CloudWatch failed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignorePollAlarmsFailure(java.lang.Boolean ignorePollAlarmsFailure) {
            this.ignorePollAlarmsFailure = ignorePollAlarmsFailure;
            return this;
        }

        /**
         * Sets the value of {@link ServerDeploymentGroupProps#getInstallAgent}
         * @param installAgent If you've provided any auto-scaling groups with the {@link #autoScalingGroups} property, you can set this property to add User Data that installs the CodeDeploy agent on the instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder installAgent(java.lang.Boolean installAgent) {
            this.installAgent = installAgent;
            return this;
        }

        /**
         * Sets the value of {@link ServerDeploymentGroupProps#getLoadBalancer}
         * @param loadBalancer The load balancer to place in front of this Deployment Group.
         *                     Can be created from either a classic Elastic Load Balancer,
         *                     or an Application Load Balancer / Network Load Balancer Target Group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancer(software.amazon.awscdk.services.codedeploy.LoadBalancer loadBalancer) {
            this.loadBalancer = loadBalancer;
            return this;
        }

        /**
         * Sets the value of {@link ServerDeploymentGroupProps#getOnPremiseInstanceTags}
         * @param onPremiseInstanceTags All on-premise instances matching the given set of tags when a deployment occurs will be added to this Deployment Group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onPremiseInstanceTags(software.amazon.awscdk.services.codedeploy.InstanceTagSet onPremiseInstanceTags) {
            this.onPremiseInstanceTags = onPremiseInstanceTags;
            return this;
        }

        /**
         * Sets the value of {@link ServerDeploymentGroupProps#getRole}
         * @param role The service Role of this Deployment Group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServerDeploymentGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ServerDeploymentGroupProps build() {
            return new Jsii$Proxy(alarms, application, autoRollback, autoScalingGroups, deploymentConfig, deploymentGroupName, ec2InstanceTags, ignorePollAlarmsFailure, installAgent, loadBalancer, onPremiseInstanceTags, role);
        }
    }

    /**
     * An implementation for {@link ServerDeploymentGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerDeploymentGroupProps {
        private final java.util.List<software.amazon.awscdk.services.cloudwatch.IAlarm> alarms;
        private final software.amazon.awscdk.services.codedeploy.IServerApplication application;
        private final software.amazon.awscdk.services.codedeploy.AutoRollbackConfig autoRollback;
        private final java.util.List<software.amazon.awscdk.services.autoscaling.IAutoScalingGroup> autoScalingGroups;
        private final software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig deploymentConfig;
        private final java.lang.String deploymentGroupName;
        private final software.amazon.awscdk.services.codedeploy.InstanceTagSet ec2InstanceTags;
        private final java.lang.Boolean ignorePollAlarmsFailure;
        private final java.lang.Boolean installAgent;
        private final software.amazon.awscdk.services.codedeploy.LoadBalancer loadBalancer;
        private final software.amazon.awscdk.services.codedeploy.InstanceTagSet onPremiseInstanceTags;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.alarms = software.amazon.jsii.Kernel.get(this, "alarms", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IAlarm.class)));
            this.application = software.amazon.jsii.Kernel.get(this, "application", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.IServerApplication.class));
            this.autoRollback = software.amazon.jsii.Kernel.get(this, "autoRollback", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.AutoRollbackConfig.class));
            this.autoScalingGroups = software.amazon.jsii.Kernel.get(this, "autoScalingGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.IAutoScalingGroup.class)));
            this.deploymentConfig = software.amazon.jsii.Kernel.get(this, "deploymentConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig.class));
            this.deploymentGroupName = software.amazon.jsii.Kernel.get(this, "deploymentGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ec2InstanceTags = software.amazon.jsii.Kernel.get(this, "ec2InstanceTags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.InstanceTagSet.class));
            this.ignorePollAlarmsFailure = software.amazon.jsii.Kernel.get(this, "ignorePollAlarmsFailure", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.installAgent = software.amazon.jsii.Kernel.get(this, "installAgent", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.loadBalancer = software.amazon.jsii.Kernel.get(this, "loadBalancer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.LoadBalancer.class));
            this.onPremiseInstanceTags = software.amazon.jsii.Kernel.get(this, "onPremiseInstanceTags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.InstanceTagSet.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.util.List<? extends software.amazon.awscdk.services.cloudwatch.IAlarm> alarms, final software.amazon.awscdk.services.codedeploy.IServerApplication application, final software.amazon.awscdk.services.codedeploy.AutoRollbackConfig autoRollback, final java.util.List<? extends software.amazon.awscdk.services.autoscaling.IAutoScalingGroup> autoScalingGroups, final software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig deploymentConfig, final java.lang.String deploymentGroupName, final software.amazon.awscdk.services.codedeploy.InstanceTagSet ec2InstanceTags, final java.lang.Boolean ignorePollAlarmsFailure, final java.lang.Boolean installAgent, final software.amazon.awscdk.services.codedeploy.LoadBalancer loadBalancer, final software.amazon.awscdk.services.codedeploy.InstanceTagSet onPremiseInstanceTags, final software.amazon.awscdk.services.iam.IRole role) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.alarms = (java.util.List<software.amazon.awscdk.services.cloudwatch.IAlarm>)alarms;
            this.application = application;
            this.autoRollback = autoRollback;
            this.autoScalingGroups = (java.util.List<software.amazon.awscdk.services.autoscaling.IAutoScalingGroup>)autoScalingGroups;
            this.deploymentConfig = deploymentConfig;
            this.deploymentGroupName = deploymentGroupName;
            this.ec2InstanceTags = ec2InstanceTags;
            this.ignorePollAlarmsFailure = ignorePollAlarmsFailure;
            this.installAgent = installAgent;
            this.loadBalancer = loadBalancer;
            this.onPremiseInstanceTags = onPremiseInstanceTags;
            this.role = role;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudwatch.IAlarm> getAlarms() {
            return this.alarms;
        }

        @Override
        public final software.amazon.awscdk.services.codedeploy.IServerApplication getApplication() {
            return this.application;
        }

        @Override
        public final software.amazon.awscdk.services.codedeploy.AutoRollbackConfig getAutoRollback() {
            return this.autoRollback;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.autoscaling.IAutoScalingGroup> getAutoScalingGroups() {
            return this.autoScalingGroups;
        }

        @Override
        public final software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig getDeploymentConfig() {
            return this.deploymentConfig;
        }

        @Override
        public final java.lang.String getDeploymentGroupName() {
            return this.deploymentGroupName;
        }

        @Override
        public final software.amazon.awscdk.services.codedeploy.InstanceTagSet getEc2InstanceTags() {
            return this.ec2InstanceTags;
        }

        @Override
        public final java.lang.Boolean getIgnorePollAlarmsFailure() {
            return this.ignorePollAlarmsFailure;
        }

        @Override
        public final java.lang.Boolean getInstallAgent() {
            return this.installAgent;
        }

        @Override
        public final software.amazon.awscdk.services.codedeploy.LoadBalancer getLoadBalancer() {
            return this.loadBalancer;
        }

        @Override
        public final software.amazon.awscdk.services.codedeploy.InstanceTagSet getOnPremiseInstanceTags() {
            return this.onPremiseInstanceTags;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAlarms() != null) {
                data.set("alarms", om.valueToTree(this.getAlarms()));
            }
            if (this.getApplication() != null) {
                data.set("application", om.valueToTree(this.getApplication()));
            }
            if (this.getAutoRollback() != null) {
                data.set("autoRollback", om.valueToTree(this.getAutoRollback()));
            }
            if (this.getAutoScalingGroups() != null) {
                data.set("autoScalingGroups", om.valueToTree(this.getAutoScalingGroups()));
            }
            if (this.getDeploymentConfig() != null) {
                data.set("deploymentConfig", om.valueToTree(this.getDeploymentConfig()));
            }
            if (this.getDeploymentGroupName() != null) {
                data.set("deploymentGroupName", om.valueToTree(this.getDeploymentGroupName()));
            }
            if (this.getEc2InstanceTags() != null) {
                data.set("ec2InstanceTags", om.valueToTree(this.getEc2InstanceTags()));
            }
            if (this.getIgnorePollAlarmsFailure() != null) {
                data.set("ignorePollAlarmsFailure", om.valueToTree(this.getIgnorePollAlarmsFailure()));
            }
            if (this.getInstallAgent() != null) {
                data.set("installAgent", om.valueToTree(this.getInstallAgent()));
            }
            if (this.getLoadBalancer() != null) {
                data.set("loadBalancer", om.valueToTree(this.getLoadBalancer()));
            }
            if (this.getOnPremiseInstanceTags() != null) {
                data.set("onPremiseInstanceTags", om.valueToTree(this.getOnPremiseInstanceTags()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.ServerDeploymentGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServerDeploymentGroupProps.Jsii$Proxy that = (ServerDeploymentGroupProps.Jsii$Proxy) o;

            if (this.alarms != null ? !this.alarms.equals(that.alarms) : that.alarms != null) return false;
            if (this.application != null ? !this.application.equals(that.application) : that.application != null) return false;
            if (this.autoRollback != null ? !this.autoRollback.equals(that.autoRollback) : that.autoRollback != null) return false;
            if (this.autoScalingGroups != null ? !this.autoScalingGroups.equals(that.autoScalingGroups) : that.autoScalingGroups != null) return false;
            if (this.deploymentConfig != null ? !this.deploymentConfig.equals(that.deploymentConfig) : that.deploymentConfig != null) return false;
            if (this.deploymentGroupName != null ? !this.deploymentGroupName.equals(that.deploymentGroupName) : that.deploymentGroupName != null) return false;
            if (this.ec2InstanceTags != null ? !this.ec2InstanceTags.equals(that.ec2InstanceTags) : that.ec2InstanceTags != null) return false;
            if (this.ignorePollAlarmsFailure != null ? !this.ignorePollAlarmsFailure.equals(that.ignorePollAlarmsFailure) : that.ignorePollAlarmsFailure != null) return false;
            if (this.installAgent != null ? !this.installAgent.equals(that.installAgent) : that.installAgent != null) return false;
            if (this.loadBalancer != null ? !this.loadBalancer.equals(that.loadBalancer) : that.loadBalancer != null) return false;
            if (this.onPremiseInstanceTags != null ? !this.onPremiseInstanceTags.equals(that.onPremiseInstanceTags) : that.onPremiseInstanceTags != null) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public final int hashCode() {
            int result = this.alarms != null ? this.alarms.hashCode() : 0;
            result = 31 * result + (this.application != null ? this.application.hashCode() : 0);
            result = 31 * result + (this.autoRollback != null ? this.autoRollback.hashCode() : 0);
            result = 31 * result + (this.autoScalingGroups != null ? this.autoScalingGroups.hashCode() : 0);
            result = 31 * result + (this.deploymentConfig != null ? this.deploymentConfig.hashCode() : 0);
            result = 31 * result + (this.deploymentGroupName != null ? this.deploymentGroupName.hashCode() : 0);
            result = 31 * result + (this.ec2InstanceTags != null ? this.ec2InstanceTags.hashCode() : 0);
            result = 31 * result + (this.ignorePollAlarmsFailure != null ? this.ignorePollAlarmsFailure.hashCode() : 0);
            result = 31 * result + (this.installAgent != null ? this.installAgent.hashCode() : 0);
            result = 31 * result + (this.loadBalancer != null ? this.loadBalancer.hashCode() : 0);
            result = 31 * result + (this.onPremiseInstanceTags != null ? this.onPremiseInstanceTags.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
