/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codedeploy;

import java.util.List;
import software.amazon.awscdk.services.autoscaling.AutoScalingGroup;
import software.amazon.awscdk.services.cloudwatch.IAlarm;
import software.amazon.awscdk.services.codedeploy.AutoRollbackConfig;
import software.amazon.awscdk.services.codedeploy.IServerApplication;
import software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig;
import software.amazon.awscdk.services.codedeploy.InstanceTagSet;
import software.amazon.awscdk.services.codedeploy.LoadBalancer;
import software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupProps;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.JsiiSerializable;

public interface ServerDeploymentGroupProps
extends JsiiSerializable {
    public List<IAlarm> getAlarms();

    public IServerApplication getApplication();

    public AutoRollbackConfig getAutoRollback();

    public List<AutoScalingGroup> getAutoScalingGroups();

    public IServerDeploymentConfig getDeploymentConfig();

    public String getDeploymentGroupName();

    public InstanceTagSet getEc2InstanceTags();

    public Boolean getIgnorePollAlarmsFailure();

    public Boolean getInstallAgent();

    public LoadBalancer getLoadBalancer();

    public InstanceTagSet getOnPremiseInstanceTags();

    public IRole getRole();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<IAlarm> alarms;
        private IServerApplication application;
        private AutoRollbackConfig autoRollback;
        private List<AutoScalingGroup> autoScalingGroups;
        private IServerDeploymentConfig deploymentConfig;
        private String deploymentGroupName;
        private InstanceTagSet ec2InstanceTags;
        private Boolean ignorePollAlarmsFailure;
        private Boolean installAgent;
        private LoadBalancer loadBalancer;
        private InstanceTagSet onPremiseInstanceTags;
        private IRole role;

        public Builder alarms(List<IAlarm> alarms) {
            this.alarms = alarms;
            return this;
        }

        public Builder application(IServerApplication application) {
            this.application = application;
            return this;
        }

        public Builder autoRollback(AutoRollbackConfig autoRollback) {
            this.autoRollback = autoRollback;
            return this;
        }

        public Builder autoScalingGroups(List<AutoScalingGroup> autoScalingGroups) {
            this.autoScalingGroups = autoScalingGroups;
            return this;
        }

        public Builder deploymentConfig(IServerDeploymentConfig deploymentConfig) {
            this.deploymentConfig = deploymentConfig;
            return this;
        }

        public Builder deploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        public Builder ec2InstanceTags(InstanceTagSet ec2InstanceTags) {
            this.ec2InstanceTags = ec2InstanceTags;
            return this;
        }

        public Builder ignorePollAlarmsFailure(Boolean ignorePollAlarmsFailure) {
            this.ignorePollAlarmsFailure = ignorePollAlarmsFailure;
            return this;
        }

        public Builder installAgent(Boolean installAgent) {
            this.installAgent = installAgent;
            return this;
        }

        public Builder loadBalancer(LoadBalancer loadBalancer) {
            this.loadBalancer = loadBalancer;
            return this;
        }

        public Builder onPremiseInstanceTags(InstanceTagSet onPremiseInstanceTags) {
            this.onPremiseInstanceTags = onPremiseInstanceTags;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public ServerDeploymentGroupProps build() {
            return new Jsii.Proxy(this.alarms, this.application, this.autoRollback, this.autoScalingGroups, this.deploymentConfig, this.deploymentGroupName, this.ec2InstanceTags, this.ignorePollAlarmsFailure, this.installAgent, this.loadBalancer, this.onPremiseInstanceTags, this.role, null);
        }
    }
}

