package software.amazon.awscdk.services.codedeploy;

/**
 * Construction properties of {@link ServerDeploymentConfig}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-22T08:28:57.302Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ServerDeploymentConfigProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Minimum number of healthy hosts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts getMinimumHealthyHosts();

    /**
     * The physical, human-readable name of the Deployment Configuration.
     * 
     * Default: a name will be auto-generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getDeploymentConfigName();

    /**
     * @return a {@link Builder} of {@link ServerDeploymentConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ServerDeploymentConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts minimumHealthyHosts;
        private java.lang.String deploymentConfigName;

        /**
         * Sets the value of MinimumHealthyHosts
         * @param minimumHealthyHosts Minimum number of healthy hosts. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumHealthyHosts(software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts minimumHealthyHosts) {
            this.minimumHealthyHosts = minimumHealthyHosts;
            return this;
        }

        /**
         * Sets the value of DeploymentConfigName
         * @param deploymentConfigName The physical, human-readable name of the Deployment Configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfigName(java.lang.String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServerDeploymentConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ServerDeploymentConfigProps build() {
            return new Jsii$Proxy(minimumHealthyHosts, deploymentConfigName);
        }
    }

    /**
     * An implementation for {@link ServerDeploymentConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerDeploymentConfigProps {
        private final software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts minimumHealthyHosts;
        private final java.lang.String deploymentConfigName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.minimumHealthyHosts = this.jsiiGet("minimumHealthyHosts", software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts.class);
            this.deploymentConfigName = this.jsiiGet("deploymentConfigName", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts minimumHealthyHosts, java.lang.String deploymentConfigName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.minimumHealthyHosts = java.util.Objects.requireNonNull(minimumHealthyHosts, "minimumHealthyHosts is required");
            this.deploymentConfigName = deploymentConfigName;
        }

        @Override
        public software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts getMinimumHealthyHosts() {
            return this.minimumHealthyHosts;
        }

        @Override
        public java.lang.String getDeploymentConfigName() {
            return this.deploymentConfigName;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("minimumHealthyHosts", om.valueToTree(this.getMinimumHealthyHosts()));
            if (this.getDeploymentConfigName() != null) {
                obj.set("deploymentConfigName", om.valueToTree(this.getDeploymentConfigName()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServerDeploymentConfigProps.Jsii$Proxy that = (ServerDeploymentConfigProps.Jsii$Proxy) o;

            if (!minimumHealthyHosts.equals(that.minimumHealthyHosts)) return false;
            return this.deploymentConfigName != null ? this.deploymentConfigName.equals(that.deploymentConfigName) : that.deploymentConfigName == null;
        }

        @Override
        public int hashCode() {
            int result = this.minimumHealthyHosts.hashCode();
            result = 31 * result + (this.deploymentConfigName != null ? this.deploymentConfigName.hashCode() : 0);
            return result;
        }
    }
}
