package software.amazon.awscdk.services.codedeploy;

/**
 * The Deployment Configuration of a Lambda Deployment Group.
 * <p>
 * The default, pre-defined Configurations are available as constants on the {&#64;link LambdaDeploymentConfig} class
 * (<code>LambdaDeploymentConfig.AllAtOnce</code>, <code>LambdaDeploymentConfig.Canary10Percent30Minutes</code>, etc.).
 * <p>
 * Note: CloudFormation does not currently support creating custom lambda configs outside
 * of using a custom resource. You can import custom deployment config created outside the
 * CDK or via a custom resource with {&#64;link LambdaDeploymentConfig#import}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-27T11:49:01.471Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.ILambdaDeploymentConfig")
@software.amazon.jsii.Jsii.Proxy(ILambdaDeploymentConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ILambdaDeploymentConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDeploymentConfigArn();

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDeploymentConfigName();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getDeploymentConfigArn() {
            return software.amazon.jsii.Kernel.get(this, "deploymentConfigArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getDeploymentConfigName() {
            return software.amazon.jsii.Kernel.get(this, "deploymentConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }

    /**
     * Internal default implementation for {@link ILambdaDeploymentConfig}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends ILambdaDeploymentConfig {

        /**
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getDeploymentConfigArn() {
            return software.amazon.jsii.Kernel.get(this, "deploymentConfigArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getDeploymentConfigName() {
            return software.amazon.jsii.Kernel.get(this, "deploymentConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }
}
