package software.amazon.awscdk.services.codedeploy;

/**
 * Minimum number of healthy hosts for a server deployment.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ServerDeploymentConfig deploymentConfig = ServerDeploymentConfig.Builder.create(this, "DeploymentConfiguration")
 *         .deploymentConfigName("MyDeploymentConfiguration") // optional property
 *         // one of these is required, but both cannot be specified at the same time
 *         .minimumHealthyHosts(MinimumHealthyHosts.count(2))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-27T11:49:01.483Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.MinimumHealthyHosts")
public class MinimumHealthyHosts extends software.amazon.jsii.JsiiObject {

    protected MinimumHealthyHosts(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected MinimumHealthyHosts(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * The minimum healhty hosts threshold expressed as an absolute number.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts count(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts.class, "count", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * The minmum healhty hosts threshold expressed as a percentage of the fleet.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts percentage(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts.class, "percentage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }
}
