package software.amazon.awscdk.services.codedeploy;

/**
 * Lambda Deployment config type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * LambdaApplication application;
 * Alias alias;
 * CustomLambdaDeploymentConfig config = CustomLambdaDeploymentConfig.Builder.create(this, "CustomConfig")
 *         .type(CustomLambdaDeploymentConfigType.CANARY)
 *         .interval(Duration.minutes(1))
 *         .percentage(5)
 *         .build();
 * LambdaDeploymentGroup deploymentGroup = LambdaDeploymentGroup.Builder.create(this, "BlueGreenDeployment")
 *         .application(application)
 *         .alias(alias)
 *         .deploymentConfig(config)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-02-08T19:43:56.782Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CustomLambdaDeploymentConfigType")
public enum CustomLambdaDeploymentConfigType {
    /**
     * Canary deployment type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CANARY,
    /**
     * Linear deployment type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LINEAR,
}
