package software.amazon.awscdk.services.codedeploy;

/**
 * Properties of a reference to a CodeDeploy ECS Deployment Group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codedeploy.*;
 * EcsApplication ecsApplication;
 * IEcsDeploymentConfig ecsDeploymentConfig;
 * EcsDeploymentGroupAttributes ecsDeploymentGroupAttributes = EcsDeploymentGroupAttributes.builder()
 *         .application(ecsApplication)
 *         .deploymentGroupName("deploymentGroupName")
 *         // the properties below are optional
 *         .deploymentConfig(ecsDeploymentConfig)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see EcsDeploymentGroup#fromEcsDeploymentGroupAttributes
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.57.0 (build f614666)", date = "2022-04-22T09:25:24.969Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.EcsDeploymentGroupAttributes")
@software.amazon.jsii.Jsii.Proxy(EcsDeploymentGroupAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EcsDeploymentGroupAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The reference to the CodeDeploy ECS Application that this Deployment Group belongs to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.IEcsApplication getApplication();

    /**
     * The physical, human-readable name of the CodeDeploy ECS Deployment Group that we are referencing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDeploymentGroupName();

    /**
     * The Deployment Configuration this Deployment Group uses.
     * <p>
     * Default: EcsDeploymentConfig.ALL_AT_ONCE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig getDeploymentConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EcsDeploymentGroupAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EcsDeploymentGroupAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EcsDeploymentGroupAttributes> {
        software.amazon.awscdk.services.codedeploy.IEcsApplication application;
        java.lang.String deploymentGroupName;
        software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig deploymentConfig;

        /**
         * Sets the value of {@link EcsDeploymentGroupAttributes#getApplication}
         * @param application The reference to the CodeDeploy ECS Application that this Deployment Group belongs to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder application(software.amazon.awscdk.services.codedeploy.IEcsApplication application) {
            this.application = application;
            return this;
        }

        /**
         * Sets the value of {@link EcsDeploymentGroupAttributes#getDeploymentGroupName}
         * @param deploymentGroupName The physical, human-readable name of the CodeDeploy ECS Deployment Group that we are referencing. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentGroupName(java.lang.String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        /**
         * Sets the value of {@link EcsDeploymentGroupAttributes#getDeploymentConfig}
         * @param deploymentConfig The Deployment Configuration this Deployment Group uses.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfig(software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig deploymentConfig) {
            this.deploymentConfig = deploymentConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EcsDeploymentGroupAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EcsDeploymentGroupAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EcsDeploymentGroupAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcsDeploymentGroupAttributes {
        private final software.amazon.awscdk.services.codedeploy.IEcsApplication application;
        private final java.lang.String deploymentGroupName;
        private final software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig deploymentConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.application = software.amazon.jsii.Kernel.get(this, "application", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.IEcsApplication.class));
            this.deploymentGroupName = software.amazon.jsii.Kernel.get(this, "deploymentGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deploymentConfig = software.amazon.jsii.Kernel.get(this, "deploymentConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.application = java.util.Objects.requireNonNull(builder.application, "application is required");
            this.deploymentGroupName = java.util.Objects.requireNonNull(builder.deploymentGroupName, "deploymentGroupName is required");
            this.deploymentConfig = builder.deploymentConfig;
        }

        @Override
        public final software.amazon.awscdk.services.codedeploy.IEcsApplication getApplication() {
            return this.application;
        }

        @Override
        public final java.lang.String getDeploymentGroupName() {
            return this.deploymentGroupName;
        }

        @Override
        public final software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig getDeploymentConfig() {
            return this.deploymentConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("application", om.valueToTree(this.getApplication()));
            data.set("deploymentGroupName", om.valueToTree(this.getDeploymentGroupName()));
            if (this.getDeploymentConfig() != null) {
                data.set("deploymentConfig", om.valueToTree(this.getDeploymentConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.EcsDeploymentGroupAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EcsDeploymentGroupAttributes.Jsii$Proxy that = (EcsDeploymentGroupAttributes.Jsii$Proxy) o;

            if (!application.equals(that.application)) return false;
            if (!deploymentGroupName.equals(that.deploymentGroupName)) return false;
            return this.deploymentConfig != null ? this.deploymentConfig.equals(that.deploymentConfig) : that.deploymentConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.application.hashCode();
            result = 31 * result + (this.deploymentGroupName.hashCode());
            result = 31 * result + (this.deploymentConfig != null ? this.deploymentConfig.hashCode() : 0);
            return result;
        }
    }
}
