/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codedeploy;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.autoscaling.AutoScalingGroup;
import software.amazon.awscdk.services.cloudwatch.IAlarm;
import software.amazon.awscdk.services.codedeploy.$Module;
import software.amazon.awscdk.services.codedeploy.AutoRollbackConfig;
import software.amazon.awscdk.services.codedeploy.IServerApplication;
import software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig;
import software.amazon.awscdk.services.codedeploy.IServerDeploymentGroup;
import software.amazon.awscdk.services.codedeploy.InstanceTagSet;
import software.amazon.awscdk.services.codedeploy.LoadBalancer;
import software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupAttributes;
import software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupProps;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-codedeploy.ServerDeploymentGroup")
public class ServerDeploymentGroup
extends Resource
implements IServerDeploymentGroup {
    protected ServerDeploymentGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ServerDeploymentGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ServerDeploymentGroup(Construct scope, String id, ServerDeploymentGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public ServerDeploymentGroup(Construct scope, String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public static IServerDeploymentGroup fromServerDeploymentGroupAttributes(Construct scope, String id, ServerDeploymentGroupAttributes attrs) {
        return (IServerDeploymentGroup)JsiiObject.jsiiStaticCall(ServerDeploymentGroup.class, (String)"fromServerDeploymentGroupAttributes", IServerDeploymentGroup.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    public void addAlarm(IAlarm alarm) {
        this.jsiiCall("addAlarm", Void.class, new Object[]{Objects.requireNonNull(alarm, "alarm is required")});
    }

    public void addAutoScalingGroup(AutoScalingGroup asg) {
        this.jsiiCall("addAutoScalingGroup", Void.class, new Object[]{Objects.requireNonNull(asg, "asg is required")});
    }

    @Override
    public IServerApplication getApplication() {
        return (IServerApplication)this.jsiiGet("application", IServerApplication.class);
    }

    @Override
    public IServerDeploymentConfig getDeploymentConfig() {
        return (IServerDeploymentConfig)this.jsiiGet("deploymentConfig", IServerDeploymentConfig.class);
    }

    @Override
    public String getDeploymentGroupArn() {
        return (String)this.jsiiGet("deploymentGroupArn", String.class);
    }

    @Override
    public String getDeploymentGroupName() {
        return (String)this.jsiiGet("deploymentGroupName", String.class);
    }

    @Override
    public List<AutoScalingGroup> getAutoScalingGroups() {
        return Collections.unmodifiableList((List)this.jsiiGet("autoScalingGroups", List.class));
    }

    @Override
    public IRole getRole() {
        return (IRole)this.jsiiGet("role", IRole.class);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private ServerDeploymentGroupProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder alarms(List<IAlarm> alarms) {
            this.props().alarms(alarms);
            return this;
        }

        public Builder application(IServerApplication application) {
            this.props().application(application);
            return this;
        }

        public Builder autoRollback(AutoRollbackConfig autoRollback) {
            this.props().autoRollback(autoRollback);
            return this;
        }

        public Builder autoScalingGroups(List<AutoScalingGroup> autoScalingGroups) {
            this.props().autoScalingGroups(autoScalingGroups);
            return this;
        }

        public Builder deploymentConfig(IServerDeploymentConfig deploymentConfig) {
            this.props().deploymentConfig(deploymentConfig);
            return this;
        }

        public Builder deploymentGroupName(String deploymentGroupName) {
            this.props().deploymentGroupName(deploymentGroupName);
            return this;
        }

        public Builder ec2InstanceTags(InstanceTagSet ec2InstanceTags) {
            this.props().ec2InstanceTags(ec2InstanceTags);
            return this;
        }

        public Builder ignorePollAlarmsFailure(Boolean ignorePollAlarmsFailure) {
            this.props().ignorePollAlarmsFailure(ignorePollAlarmsFailure);
            return this;
        }

        public Builder installAgent(Boolean installAgent) {
            this.props().installAgent(installAgent);
            return this;
        }

        public Builder loadBalancer(LoadBalancer loadBalancer) {
            this.props().loadBalancer(loadBalancer);
            return this;
        }

        public Builder onPremiseInstanceTags(InstanceTagSet onPremiseInstanceTags) {
            this.props().onPremiseInstanceTags(onPremiseInstanceTags);
            return this;
        }

        public Builder role(IRole role) {
            this.props().role(role);
            return this;
        }

        public ServerDeploymentGroup build() {
            return new ServerDeploymentGroup(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private ServerDeploymentGroupProps.Builder props() {
            if (this.props == null) {
                this.props = new ServerDeploymentGroupProps.Builder();
            }
            return this.props;
        }
    }
}

