package software.amazon.awscdk.services.codedeploy;

/**
 * Properties for defining a `CfnDeploymentGroup`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codedeploy.*;
 * CfnDeploymentGroupProps cfnDeploymentGroupProps = CfnDeploymentGroupProps.builder()
 *         .applicationName("applicationName")
 *         .serviceRoleArn("serviceRoleArn")
 *         // the properties below are optional
 *         .alarmConfiguration(AlarmConfigurationProperty.builder()
 *                 .alarms(List.of(AlarmProperty.builder()
 *                         .name("name")
 *                         .build()))
 *                 .enabled(false)
 *                 .ignorePollAlarmFailure(false)
 *                 .build())
 *         .autoRollbackConfiguration(AutoRollbackConfigurationProperty.builder()
 *                 .enabled(false)
 *                 .events(List.of("events"))
 *                 .build())
 *         .autoScalingGroups(List.of("autoScalingGroups"))
 *         .blueGreenDeploymentConfiguration(BlueGreenDeploymentConfigurationProperty.builder()
 *                 .deploymentReadyOption(DeploymentReadyOptionProperty.builder()
 *                         .actionOnTimeout("actionOnTimeout")
 *                         .waitTimeInMinutes(123)
 *                         .build())
 *                 .greenFleetProvisioningOption(GreenFleetProvisioningOptionProperty.builder()
 *                         .action("action")
 *                         .build())
 *                 .terminateBlueInstancesOnDeploymentSuccess(BlueInstanceTerminationOptionProperty.builder()
 *                         .action("action")
 *                         .terminationWaitTimeInMinutes(123)
 *                         .build())
 *                 .build())
 *         .deployment(DeploymentProperty.builder()
 *                 .revision(RevisionLocationProperty.builder()
 *                         .gitHubLocation(GitHubLocationProperty.builder()
 *                                 .commitId("commitId")
 *                                 .repository("repository")
 *                                 .build())
 *                         .revisionType("revisionType")
 *                         .s3Location(S3LocationProperty.builder()
 *                                 .bucket("bucket")
 *                                 .key("key")
 *                                 // the properties below are optional
 *                                 .bundleType("bundleType")
 *                                 .eTag("eTag")
 *                                 .version("version")
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .description("description")
 *                 .ignoreApplicationStopFailures(false)
 *                 .build())
 *         .deploymentConfigName("deploymentConfigName")
 *         .deploymentGroupName("deploymentGroupName")
 *         .deploymentStyle(DeploymentStyleProperty.builder()
 *                 .deploymentOption("deploymentOption")
 *                 .deploymentType("deploymentType")
 *                 .build())
 *         .ec2TagFilters(List.of(EC2TagFilterProperty.builder()
 *                 .key("key")
 *                 .type("type")
 *                 .value("value")
 *                 .build()))
 *         .ec2TagSet(EC2TagSetProperty.builder()
 *                 .ec2TagSetList(List.of(EC2TagSetListObjectProperty.builder()
 *                         .ec2TagGroup(List.of(EC2TagFilterProperty.builder()
 *                                 .key("key")
 *                                 .type("type")
 *                                 .value("value")
 *                                 .build()))
 *                         .build()))
 *                 .build())
 *         .ecsServices(List.of(ECSServiceProperty.builder()
 *                 .clusterName("clusterName")
 *                 .serviceName("serviceName")
 *                 .build()))
 *         .loadBalancerInfo(LoadBalancerInfoProperty.builder()
 *                 .elbInfoList(List.of(ELBInfoProperty.builder()
 *                         .name("name")
 *                         .build()))
 *                 .targetGroupInfoList(List.of(TargetGroupInfoProperty.builder()
 *                         .name("name")
 *                         .build()))
 *                 .targetGroupPairInfoList(List.of(TargetGroupPairInfoProperty.builder()
 *                         .prodTrafficRoute(TrafficRouteProperty.builder()
 *                                 .listenerArns(List.of("listenerArns"))
 *                                 .build())
 *                         .targetGroups(List.of(TargetGroupInfoProperty.builder()
 *                                 .name("name")
 *                                 .build()))
 *                         .testTrafficRoute(TrafficRouteProperty.builder()
 *                                 .listenerArns(List.of("listenerArns"))
 *                                 .build())
 *                         .build()))
 *                 .build())
 *         .onPremisesInstanceTagFilters(List.of(TagFilterProperty.builder()
 *                 .key("key")
 *                 .type("type")
 *                 .value("value")
 *                 .build()))
 *         .onPremisesTagSet(OnPremisesTagSetProperty.builder()
 *                 .onPremisesTagSetList(List.of(OnPremisesTagSetListObjectProperty.builder()
 *                         .onPremisesTagGroup(List.of(TagFilterProperty.builder()
 *                                 .key("key")
 *                                 .type("type")
 *                                 .value("value")
 *                                 .build()))
 *                         .build()))
 *                 .build())
 *         .outdatedInstancesStrategy("outdatedInstancesStrategy")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .triggerConfigurations(List.of(TriggerConfigProperty.builder()
 *                 .triggerEvents(List.of("triggerEvents"))
 *                 .triggerName("triggerName")
 *                 .triggerTargetArn("triggerTargetArn")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.60.0 (build ebcefe6)", date = "2022-07-06T20:02:56.234Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnDeploymentGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDeploymentGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of an existing CodeDeploy application to associate this deployment group with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationName();

    /**
     * A service role Amazon Resource Name (ARN) that grants CodeDeploy permission to make calls to AWS services on your behalf.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/getting-started-create-service-role.html">Create a Service Role for AWS CodeDeploy</a> in the <em>AWS CodeDeploy User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * In some cases, you might need to add a dependency on the service role's policy. For more information, see IAM role policy in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn Attribute</a> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceRoleArn();

    /**
     * Information about the Amazon CloudWatch alarms that are associated with the deployment group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAlarmConfiguration() {
        return null;
    }

    /**
     * Information about the automatic rollback configuration that is associated with the deployment group.
     * <p>
     * If you specify this property, don't specify the <code>Deployment</code> property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutoRollbackConfiguration() {
        return null;
    }

    /**
     * A list of associated Auto Scaling groups that CodeDeploy automatically deploys revisions to when new instances are created.
     * <p>
     * Duplicates are not allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAutoScalingGroups() {
        return null;
    }

    /**
     * Information about blue/green deployment options for a deployment group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBlueGreenDeploymentConfiguration() {
        return null;
    }

    /**
     * The application revision to deploy to this deployment group.
     * <p>
     * If you specify this property, your target application revision is deployed as soon as the provisioning process is complete. If you specify this property, don't specify the <code>AutoRollbackConfiguration</code> property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeployment() {
        return null;
    }

    /**
     * A deployment configuration name or a predefined configuration name.
     * <p>
     * With predefined configurations, you can deploy application revisions to one instance at a time ( <code>CodeDeployDefault.OneAtATime</code> ), half of the instances at a time ( <code>CodeDeployDefault.HalfAtATime</code> ), or all the instances at once ( <code>CodeDeployDefault.AllAtOnce</code> ). For more information and valid values, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html">Working with Deployment Configurations</a> in the <em>AWS CodeDeploy User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeploymentConfigName() {
        return null;
    }

    /**
     * A name for the deployment group.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the deployment group name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeploymentGroupName() {
        return null;
    }

    /**
     * Attributes that determine the type of deployment to run and whether to route deployment traffic behind a load balancer.
     * <p>
     * If you specify this property with a blue/green deployment type, don't specify the <code>AutoScalingGroups</code> , <code>LoadBalancerInfo</code> , or <code>Deployment</code> properties.
     * <p>
     * <blockquote>
     * <p>
     * For blue/green deployments, AWS CloudFormation supports deployments on Lambda compute platforms only. You can perform Amazon ECS blue/green deployments using <code>AWS::CodeDeploy::BlueGreen</code> hook. See <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/blue-green.html">Perform Amazon ECS blue/green deployments through CodeDeploy using AWS CloudFormation</a> for more information.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeploymentStyle() {
        return null;
    }

    /**
     * The Amazon EC2 tags that are already applied to Amazon EC2 instances that you want to include in the deployment group.
     * <p>
     * CodeDeploy includes all Amazon EC2 instances identified by any of the tags you specify in this deployment group. Duplicates are not allowed.
     * <p>
     * You can specify <code>EC2TagFilters</code> or <code>Ec2TagSet</code> , but not both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEc2TagFilters() {
        return null;
    }

    /**
     * Information about groups of tags applied to Amazon EC2 instances.
     * <p>
     * The deployment group includes only Amazon EC2 instances identified by all the tag groups. Cannot be used in the same call as <code>ec2TagFilter</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEc2TagSet() {
        return null;
    }

    /**
     * The target Amazon ECS services in the deployment group.
     * <p>
     * This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEcsServices() {
        return null;
    }

    /**
     * Information about the load balancer to use in a deployment.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-elastic-load-balancing.html">Integrating CodeDeploy with Elastic Load Balancing</a> in the <em>AWS CodeDeploy User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLoadBalancerInfo() {
        return null;
    }

    /**
     * The on-premises instance tags already applied to on-premises instances that you want to include in the deployment group.
     * <p>
     * CodeDeploy includes all on-premises instances identified by any of the tags you specify in this deployment group. To register on-premises instances with CodeDeploy , see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-on-premises.html">Working with On-Premises Instances for CodeDeploy</a> in the <em>AWS CodeDeploy User Guide</em> . Duplicates are not allowed.
     * <p>
     * You can specify <code>OnPremisesInstanceTagFilters</code> or <code>OnPremisesInstanceTagSet</code> , but not both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOnPremisesInstanceTagFilters() {
        return null;
    }

    /**
     * Information about groups of tags applied to on-premises instances.
     * <p>
     * The deployment group includes only on-premises instances identified by all the tag groups.
     * <p>
     * You can specify <code>OnPremisesInstanceTagFilters</code> or <code>OnPremisesInstanceTagSet</code> , but not both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOnPremisesTagSet() {
        return null;
    }

    /**
     * Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed application revision.
     * <p>
     * If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update outdated instances' deployments to apply the deployed application revision to the new Amazon EC2 instances.
     * <p>
     * If this option is set to <code>IGNORE</code> , CodeDeploy does not initiate a deployment to update the new Amazon EC2 instances. This may result in instances having different revisions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOutdatedInstancesStrategy() {
        return null;
    }

    /**
     * The metadata that you apply to CodeDeploy deployment groups to help you organize and categorize them.
     * <p>
     * Each tag consists of a key and an optional value, both of which you define.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * Information about triggers associated with the deployment group.
     * <p>
     * Duplicates are not allowed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTriggerConfigurations() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDeploymentGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDeploymentGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDeploymentGroupProps> {
        java.lang.String applicationName;
        java.lang.String serviceRoleArn;
        java.lang.Object alarmConfiguration;
        java.lang.Object autoRollbackConfiguration;
        java.util.List<java.lang.String> autoScalingGroups;
        java.lang.Object blueGreenDeploymentConfiguration;
        java.lang.Object deployment;
        java.lang.String deploymentConfigName;
        java.lang.String deploymentGroupName;
        java.lang.Object deploymentStyle;
        java.lang.Object ec2TagFilters;
        java.lang.Object ec2TagSet;
        java.lang.Object ecsServices;
        java.lang.Object loadBalancerInfo;
        java.lang.Object onPremisesInstanceTagFilters;
        java.lang.Object onPremisesTagSet;
        java.lang.String outdatedInstancesStrategy;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        java.lang.Object triggerConfigurations;

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getApplicationName}
         * @param applicationName The name of an existing CodeDeploy application to associate this deployment group with. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationName(java.lang.String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getServiceRoleArn}
         * @param serviceRoleArn A service role Amazon Resource Name (ARN) that grants CodeDeploy permission to make calls to AWS services on your behalf. This parameter is required.
         *                       For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/getting-started-create-service-role.html">Create a Service Role for AWS CodeDeploy</a> in the <em>AWS CodeDeploy User Guide</em> .
         *                       <p>
         *                       <blockquote>
         *                       <p>
         *                       In some cases, you might need to add a dependency on the service role's policy. For more information, see IAM role policy in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn Attribute</a> .
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRoleArn(java.lang.String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getAlarmConfiguration}
         * @param alarmConfiguration Information about the Amazon CloudWatch alarms that are associated with the deployment group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmConfiguration(software.amazon.awscdk.core.IResolvable alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getAlarmConfiguration}
         * @param alarmConfiguration Information about the Amazon CloudWatch alarms that are associated with the deployment group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmConfiguration(software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.AlarmConfigurationProperty alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getAutoRollbackConfiguration}
         * @param autoRollbackConfiguration Information about the automatic rollback configuration that is associated with the deployment group.
         *                                  If you specify this property, don't specify the <code>Deployment</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoRollbackConfiguration(software.amazon.awscdk.core.IResolvable autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getAutoRollbackConfiguration}
         * @param autoRollbackConfiguration Information about the automatic rollback configuration that is associated with the deployment group.
         *                                  If you specify this property, don't specify the <code>Deployment</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoRollbackConfiguration(software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.AutoRollbackConfigurationProperty autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getAutoScalingGroups}
         * @param autoScalingGroups A list of associated Auto Scaling groups that CodeDeploy automatically deploys revisions to when new instances are created.
         *                          Duplicates are not allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroups(java.util.List<java.lang.String> autoScalingGroups) {
            this.autoScalingGroups = autoScalingGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getBlueGreenDeploymentConfiguration}
         * @param blueGreenDeploymentConfiguration Information about blue/green deployment options for a deployment group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blueGreenDeploymentConfiguration(software.amazon.awscdk.core.IResolvable blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getBlueGreenDeploymentConfiguration}
         * @param blueGreenDeploymentConfiguration Information about blue/green deployment options for a deployment group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blueGreenDeploymentConfiguration(software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.BlueGreenDeploymentConfigurationProperty blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getDeployment}
         * @param deployment The application revision to deploy to this deployment group.
         *                   If you specify this property, your target application revision is deployed as soon as the provisioning process is complete. If you specify this property, don't specify the <code>AutoRollbackConfiguration</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployment(software.amazon.awscdk.core.IResolvable deployment) {
            this.deployment = deployment;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getDeployment}
         * @param deployment The application revision to deploy to this deployment group.
         *                   If you specify this property, your target application revision is deployed as soon as the provisioning process is complete. If you specify this property, don't specify the <code>AutoRollbackConfiguration</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployment(software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.DeploymentProperty deployment) {
            this.deployment = deployment;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getDeploymentConfigName}
         * @param deploymentConfigName A deployment configuration name or a predefined configuration name.
         *                             With predefined configurations, you can deploy application revisions to one instance at a time ( <code>CodeDeployDefault.OneAtATime</code> ), half of the instances at a time ( <code>CodeDeployDefault.HalfAtATime</code> ), or all the instances at once ( <code>CodeDeployDefault.AllAtOnce</code> ). For more information and valid values, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html">Working with Deployment Configurations</a> in the <em>AWS CodeDeploy User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfigName(java.lang.String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getDeploymentGroupName}
         * @param deploymentGroupName A name for the deployment group.
         *                            If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the deployment group name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
         *                            <p>
         *                            <blockquote>
         *                            <p>
         *                            If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         *                            <p>
         *                            </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentGroupName(java.lang.String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getDeploymentStyle}
         * @param deploymentStyle Attributes that determine the type of deployment to run and whether to route deployment traffic behind a load balancer.
         *                        If you specify this property with a blue/green deployment type, don't specify the <code>AutoScalingGroups</code> , <code>LoadBalancerInfo</code> , or <code>Deployment</code> properties.
         *                        <p>
         *                        <blockquote>
         *                        <p>
         *                        For blue/green deployments, AWS CloudFormation supports deployments on Lambda compute platforms only. You can perform Amazon ECS blue/green deployments using <code>AWS::CodeDeploy::BlueGreen</code> hook. See <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/blue-green.html">Perform Amazon ECS blue/green deployments through CodeDeploy using AWS CloudFormation</a> for more information.
         *                        <p>
         *                        </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentStyle(software.amazon.awscdk.core.IResolvable deploymentStyle) {
            this.deploymentStyle = deploymentStyle;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getDeploymentStyle}
         * @param deploymentStyle Attributes that determine the type of deployment to run and whether to route deployment traffic behind a load balancer.
         *                        If you specify this property with a blue/green deployment type, don't specify the <code>AutoScalingGroups</code> , <code>LoadBalancerInfo</code> , or <code>Deployment</code> properties.
         *                        <p>
         *                        <blockquote>
         *                        <p>
         *                        For blue/green deployments, AWS CloudFormation supports deployments on Lambda compute platforms only. You can perform Amazon ECS blue/green deployments using <code>AWS::CodeDeploy::BlueGreen</code> hook. See <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/blue-green.html">Perform Amazon ECS blue/green deployments through CodeDeploy using AWS CloudFormation</a> for more information.
         *                        <p>
         *                        </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentStyle(software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.DeploymentStyleProperty deploymentStyle) {
            this.deploymentStyle = deploymentStyle;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getEc2TagFilters}
         * @param ec2TagFilters The Amazon EC2 tags that are already applied to Amazon EC2 instances that you want to include in the deployment group.
         *                      CodeDeploy includes all Amazon EC2 instances identified by any of the tags you specify in this deployment group. Duplicates are not allowed.
         *                      <p>
         *                      You can specify <code>EC2TagFilters</code> or <code>Ec2TagSet</code> , but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2TagFilters(software.amazon.awscdk.core.IResolvable ec2TagFilters) {
            this.ec2TagFilters = ec2TagFilters;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getEc2TagFilters}
         * @param ec2TagFilters The Amazon EC2 tags that are already applied to Amazon EC2 instances that you want to include in the deployment group.
         *                      CodeDeploy includes all Amazon EC2 instances identified by any of the tags you specify in this deployment group. Duplicates are not allowed.
         *                      <p>
         *                      You can specify <code>EC2TagFilters</code> or <code>Ec2TagSet</code> , but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2TagFilters(java.util.List<? extends java.lang.Object> ec2TagFilters) {
            this.ec2TagFilters = ec2TagFilters;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getEc2TagSet}
         * @param ec2TagSet Information about groups of tags applied to Amazon EC2 instances.
         *                  The deployment group includes only Amazon EC2 instances identified by all the tag groups. Cannot be used in the same call as <code>ec2TagFilter</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2TagSet(software.amazon.awscdk.core.IResolvable ec2TagSet) {
            this.ec2TagSet = ec2TagSet;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getEc2TagSet}
         * @param ec2TagSet Information about groups of tags applied to Amazon EC2 instances.
         *                  The deployment group includes only Amazon EC2 instances identified by all the tag groups. Cannot be used in the same call as <code>ec2TagFilter</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2TagSet(software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.EC2TagSetProperty ec2TagSet) {
            this.ec2TagSet = ec2TagSet;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getEcsServices}
         * @param ecsServices The target Amazon ECS services in the deployment group.
         *                    This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ecsServices(software.amazon.awscdk.core.IResolvable ecsServices) {
            this.ecsServices = ecsServices;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getEcsServices}
         * @param ecsServices The target Amazon ECS services in the deployment group.
         *                    This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ecsServices(java.util.List<? extends java.lang.Object> ecsServices) {
            this.ecsServices = ecsServices;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getLoadBalancerInfo}
         * @param loadBalancerInfo Information about the load balancer to use in a deployment.
         *                         For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-elastic-load-balancing.html">Integrating CodeDeploy with Elastic Load Balancing</a> in the <em>AWS CodeDeploy User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerInfo(software.amazon.awscdk.core.IResolvable loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getLoadBalancerInfo}
         * @param loadBalancerInfo Information about the load balancer to use in a deployment.
         *                         For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-elastic-load-balancing.html">Integrating CodeDeploy with Elastic Load Balancing</a> in the <em>AWS CodeDeploy User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerInfo(software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.LoadBalancerInfoProperty loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getOnPremisesInstanceTagFilters}
         * @param onPremisesInstanceTagFilters The on-premises instance tags already applied to on-premises instances that you want to include in the deployment group.
         *                                     CodeDeploy includes all on-premises instances identified by any of the tags you specify in this deployment group. To register on-premises instances with CodeDeploy , see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-on-premises.html">Working with On-Premises Instances for CodeDeploy</a> in the <em>AWS CodeDeploy User Guide</em> . Duplicates are not allowed.
         *                                     <p>
         *                                     You can specify <code>OnPremisesInstanceTagFilters</code> or <code>OnPremisesInstanceTagSet</code> , but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onPremisesInstanceTagFilters(software.amazon.awscdk.core.IResolvable onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters = onPremisesInstanceTagFilters;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getOnPremisesInstanceTagFilters}
         * @param onPremisesInstanceTagFilters The on-premises instance tags already applied to on-premises instances that you want to include in the deployment group.
         *                                     CodeDeploy includes all on-premises instances identified by any of the tags you specify in this deployment group. To register on-premises instances with CodeDeploy , see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-on-premises.html">Working with On-Premises Instances for CodeDeploy</a> in the <em>AWS CodeDeploy User Guide</em> . Duplicates are not allowed.
         *                                     <p>
         *                                     You can specify <code>OnPremisesInstanceTagFilters</code> or <code>OnPremisesInstanceTagSet</code> , but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onPremisesInstanceTagFilters(java.util.List<? extends java.lang.Object> onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters = onPremisesInstanceTagFilters;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getOnPremisesTagSet}
         * @param onPremisesTagSet Information about groups of tags applied to on-premises instances.
         *                         The deployment group includes only on-premises instances identified by all the tag groups.
         *                         <p>
         *                         You can specify <code>OnPremisesInstanceTagFilters</code> or <code>OnPremisesInstanceTagSet</code> , but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onPremisesTagSet(software.amazon.awscdk.core.IResolvable onPremisesTagSet) {
            this.onPremisesTagSet = onPremisesTagSet;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getOnPremisesTagSet}
         * @param onPremisesTagSet Information about groups of tags applied to on-premises instances.
         *                         The deployment group includes only on-premises instances identified by all the tag groups.
         *                         <p>
         *                         You can specify <code>OnPremisesInstanceTagFilters</code> or <code>OnPremisesInstanceTagSet</code> , but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onPremisesTagSet(software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.OnPremisesTagSetProperty onPremisesTagSet) {
            this.onPremisesTagSet = onPremisesTagSet;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getOutdatedInstancesStrategy}
         * @param outdatedInstancesStrategy Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed application revision.
         *                                  If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update outdated instances' deployments to apply the deployed application revision to the new Amazon EC2 instances.
         *                                  <p>
         *                                  If this option is set to <code>IGNORE</code> , CodeDeploy does not initiate a deployment to update the new Amazon EC2 instances. This may result in instances having different revisions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outdatedInstancesStrategy(java.lang.String outdatedInstancesStrategy) {
            this.outdatedInstancesStrategy = outdatedInstancesStrategy;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getTags}
         * @param tags The metadata that you apply to CodeDeploy deployment groups to help you organize and categorize them.
         *             Each tag consists of a key and an optional value, both of which you define.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getTriggerConfigurations}
         * @param triggerConfigurations Information about triggers associated with the deployment group.
         *                              Duplicates are not allowed
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggerConfigurations(software.amazon.awscdk.core.IResolvable triggerConfigurations) {
            this.triggerConfigurations = triggerConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentGroupProps#getTriggerConfigurations}
         * @param triggerConfigurations Information about triggers associated with the deployment group.
         *                              Duplicates are not allowed
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggerConfigurations(java.util.List<? extends java.lang.Object> triggerConfigurations) {
            this.triggerConfigurations = triggerConfigurations;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDeploymentGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDeploymentGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDeploymentGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDeploymentGroupProps {
        private final java.lang.String applicationName;
        private final java.lang.String serviceRoleArn;
        private final java.lang.Object alarmConfiguration;
        private final java.lang.Object autoRollbackConfiguration;
        private final java.util.List<java.lang.String> autoScalingGroups;
        private final java.lang.Object blueGreenDeploymentConfiguration;
        private final java.lang.Object deployment;
        private final java.lang.String deploymentConfigName;
        private final java.lang.String deploymentGroupName;
        private final java.lang.Object deploymentStyle;
        private final java.lang.Object ec2TagFilters;
        private final java.lang.Object ec2TagSet;
        private final java.lang.Object ecsServices;
        private final java.lang.Object loadBalancerInfo;
        private final java.lang.Object onPremisesInstanceTagFilters;
        private final java.lang.Object onPremisesTagSet;
        private final java.lang.String outdatedInstancesStrategy;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.Object triggerConfigurations;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationName = software.amazon.jsii.Kernel.get(this, "applicationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceRoleArn = software.amazon.jsii.Kernel.get(this, "serviceRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.alarmConfiguration = software.amazon.jsii.Kernel.get(this, "alarmConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.autoRollbackConfiguration = software.amazon.jsii.Kernel.get(this, "autoRollbackConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.autoScalingGroups = software.amazon.jsii.Kernel.get(this, "autoScalingGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.blueGreenDeploymentConfiguration = software.amazon.jsii.Kernel.get(this, "blueGreenDeploymentConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.deployment = software.amazon.jsii.Kernel.get(this, "deployment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.deploymentConfigName = software.amazon.jsii.Kernel.get(this, "deploymentConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deploymentGroupName = software.amazon.jsii.Kernel.get(this, "deploymentGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deploymentStyle = software.amazon.jsii.Kernel.get(this, "deploymentStyle", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ec2TagFilters = software.amazon.jsii.Kernel.get(this, "ec2TagFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ec2TagSet = software.amazon.jsii.Kernel.get(this, "ec2TagSet", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ecsServices = software.amazon.jsii.Kernel.get(this, "ecsServices", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.loadBalancerInfo = software.amazon.jsii.Kernel.get(this, "loadBalancerInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.onPremisesInstanceTagFilters = software.amazon.jsii.Kernel.get(this, "onPremisesInstanceTagFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.onPremisesTagSet = software.amazon.jsii.Kernel.get(this, "onPremisesTagSet", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.outdatedInstancesStrategy = software.amazon.jsii.Kernel.get(this, "outdatedInstancesStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            this.triggerConfigurations = software.amazon.jsii.Kernel.get(this, "triggerConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationName = java.util.Objects.requireNonNull(builder.applicationName, "applicationName is required");
            this.serviceRoleArn = java.util.Objects.requireNonNull(builder.serviceRoleArn, "serviceRoleArn is required");
            this.alarmConfiguration = builder.alarmConfiguration;
            this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
            this.autoScalingGroups = builder.autoScalingGroups;
            this.blueGreenDeploymentConfiguration = builder.blueGreenDeploymentConfiguration;
            this.deployment = builder.deployment;
            this.deploymentConfigName = builder.deploymentConfigName;
            this.deploymentGroupName = builder.deploymentGroupName;
            this.deploymentStyle = builder.deploymentStyle;
            this.ec2TagFilters = builder.ec2TagFilters;
            this.ec2TagSet = builder.ec2TagSet;
            this.ecsServices = builder.ecsServices;
            this.loadBalancerInfo = builder.loadBalancerInfo;
            this.onPremisesInstanceTagFilters = builder.onPremisesInstanceTagFilters;
            this.onPremisesTagSet = builder.onPremisesTagSet;
            this.outdatedInstancesStrategy = builder.outdatedInstancesStrategy;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
            this.triggerConfigurations = builder.triggerConfigurations;
        }

        @Override
        public final java.lang.String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final java.lang.String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        @Override
        public final java.lang.Object getAlarmConfiguration() {
            return this.alarmConfiguration;
        }

        @Override
        public final java.lang.Object getAutoRollbackConfiguration() {
            return this.autoRollbackConfiguration;
        }

        @Override
        public final java.util.List<java.lang.String> getAutoScalingGroups() {
            return this.autoScalingGroups;
        }

        @Override
        public final java.lang.Object getBlueGreenDeploymentConfiguration() {
            return this.blueGreenDeploymentConfiguration;
        }

        @Override
        public final java.lang.Object getDeployment() {
            return this.deployment;
        }

        @Override
        public final java.lang.String getDeploymentConfigName() {
            return this.deploymentConfigName;
        }

        @Override
        public final java.lang.String getDeploymentGroupName() {
            return this.deploymentGroupName;
        }

        @Override
        public final java.lang.Object getDeploymentStyle() {
            return this.deploymentStyle;
        }

        @Override
        public final java.lang.Object getEc2TagFilters() {
            return this.ec2TagFilters;
        }

        @Override
        public final java.lang.Object getEc2TagSet() {
            return this.ec2TagSet;
        }

        @Override
        public final java.lang.Object getEcsServices() {
            return this.ecsServices;
        }

        @Override
        public final java.lang.Object getLoadBalancerInfo() {
            return this.loadBalancerInfo;
        }

        @Override
        public final java.lang.Object getOnPremisesInstanceTagFilters() {
            return this.onPremisesInstanceTagFilters;
        }

        @Override
        public final java.lang.Object getOnPremisesTagSet() {
            return this.onPremisesTagSet;
        }

        @Override
        public final java.lang.String getOutdatedInstancesStrategy() {
            return this.outdatedInstancesStrategy;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTriggerConfigurations() {
            return this.triggerConfigurations;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationName", om.valueToTree(this.getApplicationName()));
            data.set("serviceRoleArn", om.valueToTree(this.getServiceRoleArn()));
            if (this.getAlarmConfiguration() != null) {
                data.set("alarmConfiguration", om.valueToTree(this.getAlarmConfiguration()));
            }
            if (this.getAutoRollbackConfiguration() != null) {
                data.set("autoRollbackConfiguration", om.valueToTree(this.getAutoRollbackConfiguration()));
            }
            if (this.getAutoScalingGroups() != null) {
                data.set("autoScalingGroups", om.valueToTree(this.getAutoScalingGroups()));
            }
            if (this.getBlueGreenDeploymentConfiguration() != null) {
                data.set("blueGreenDeploymentConfiguration", om.valueToTree(this.getBlueGreenDeploymentConfiguration()));
            }
            if (this.getDeployment() != null) {
                data.set("deployment", om.valueToTree(this.getDeployment()));
            }
            if (this.getDeploymentConfigName() != null) {
                data.set("deploymentConfigName", om.valueToTree(this.getDeploymentConfigName()));
            }
            if (this.getDeploymentGroupName() != null) {
                data.set("deploymentGroupName", om.valueToTree(this.getDeploymentGroupName()));
            }
            if (this.getDeploymentStyle() != null) {
                data.set("deploymentStyle", om.valueToTree(this.getDeploymentStyle()));
            }
            if (this.getEc2TagFilters() != null) {
                data.set("ec2TagFilters", om.valueToTree(this.getEc2TagFilters()));
            }
            if (this.getEc2TagSet() != null) {
                data.set("ec2TagSet", om.valueToTree(this.getEc2TagSet()));
            }
            if (this.getEcsServices() != null) {
                data.set("ecsServices", om.valueToTree(this.getEcsServices()));
            }
            if (this.getLoadBalancerInfo() != null) {
                data.set("loadBalancerInfo", om.valueToTree(this.getLoadBalancerInfo()));
            }
            if (this.getOnPremisesInstanceTagFilters() != null) {
                data.set("onPremisesInstanceTagFilters", om.valueToTree(this.getOnPremisesInstanceTagFilters()));
            }
            if (this.getOnPremisesTagSet() != null) {
                data.set("onPremisesTagSet", om.valueToTree(this.getOnPremisesTagSet()));
            }
            if (this.getOutdatedInstancesStrategy() != null) {
                data.set("outdatedInstancesStrategy", om.valueToTree(this.getOutdatedInstancesStrategy()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTriggerConfigurations() != null) {
                data.set("triggerConfigurations", om.valueToTree(this.getTriggerConfigurations()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.CfnDeploymentGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDeploymentGroupProps.Jsii$Proxy that = (CfnDeploymentGroupProps.Jsii$Proxy) o;

            if (!applicationName.equals(that.applicationName)) return false;
            if (!serviceRoleArn.equals(that.serviceRoleArn)) return false;
            if (this.alarmConfiguration != null ? !this.alarmConfiguration.equals(that.alarmConfiguration) : that.alarmConfiguration != null) return false;
            if (this.autoRollbackConfiguration != null ? !this.autoRollbackConfiguration.equals(that.autoRollbackConfiguration) : that.autoRollbackConfiguration != null) return false;
            if (this.autoScalingGroups != null ? !this.autoScalingGroups.equals(that.autoScalingGroups) : that.autoScalingGroups != null) return false;
            if (this.blueGreenDeploymentConfiguration != null ? !this.blueGreenDeploymentConfiguration.equals(that.blueGreenDeploymentConfiguration) : that.blueGreenDeploymentConfiguration != null) return false;
            if (this.deployment != null ? !this.deployment.equals(that.deployment) : that.deployment != null) return false;
            if (this.deploymentConfigName != null ? !this.deploymentConfigName.equals(that.deploymentConfigName) : that.deploymentConfigName != null) return false;
            if (this.deploymentGroupName != null ? !this.deploymentGroupName.equals(that.deploymentGroupName) : that.deploymentGroupName != null) return false;
            if (this.deploymentStyle != null ? !this.deploymentStyle.equals(that.deploymentStyle) : that.deploymentStyle != null) return false;
            if (this.ec2TagFilters != null ? !this.ec2TagFilters.equals(that.ec2TagFilters) : that.ec2TagFilters != null) return false;
            if (this.ec2TagSet != null ? !this.ec2TagSet.equals(that.ec2TagSet) : that.ec2TagSet != null) return false;
            if (this.ecsServices != null ? !this.ecsServices.equals(that.ecsServices) : that.ecsServices != null) return false;
            if (this.loadBalancerInfo != null ? !this.loadBalancerInfo.equals(that.loadBalancerInfo) : that.loadBalancerInfo != null) return false;
            if (this.onPremisesInstanceTagFilters != null ? !this.onPremisesInstanceTagFilters.equals(that.onPremisesInstanceTagFilters) : that.onPremisesInstanceTagFilters != null) return false;
            if (this.onPremisesTagSet != null ? !this.onPremisesTagSet.equals(that.onPremisesTagSet) : that.onPremisesTagSet != null) return false;
            if (this.outdatedInstancesStrategy != null ? !this.outdatedInstancesStrategy.equals(that.outdatedInstancesStrategy) : that.outdatedInstancesStrategy != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.triggerConfigurations != null ? this.triggerConfigurations.equals(that.triggerConfigurations) : that.triggerConfigurations == null;
        }

        @Override
        public final int hashCode() {
            int result = this.applicationName.hashCode();
            result = 31 * result + (this.serviceRoleArn.hashCode());
            result = 31 * result + (this.alarmConfiguration != null ? this.alarmConfiguration.hashCode() : 0);
            result = 31 * result + (this.autoRollbackConfiguration != null ? this.autoRollbackConfiguration.hashCode() : 0);
            result = 31 * result + (this.autoScalingGroups != null ? this.autoScalingGroups.hashCode() : 0);
            result = 31 * result + (this.blueGreenDeploymentConfiguration != null ? this.blueGreenDeploymentConfiguration.hashCode() : 0);
            result = 31 * result + (this.deployment != null ? this.deployment.hashCode() : 0);
            result = 31 * result + (this.deploymentConfigName != null ? this.deploymentConfigName.hashCode() : 0);
            result = 31 * result + (this.deploymentGroupName != null ? this.deploymentGroupName.hashCode() : 0);
            result = 31 * result + (this.deploymentStyle != null ? this.deploymentStyle.hashCode() : 0);
            result = 31 * result + (this.ec2TagFilters != null ? this.ec2TagFilters.hashCode() : 0);
            result = 31 * result + (this.ec2TagSet != null ? this.ec2TagSet.hashCode() : 0);
            result = 31 * result + (this.ecsServices != null ? this.ecsServices.hashCode() : 0);
            result = 31 * result + (this.loadBalancerInfo != null ? this.loadBalancerInfo.hashCode() : 0);
            result = 31 * result + (this.onPremisesInstanceTagFilters != null ? this.onPremisesInstanceTagFilters.hashCode() : 0);
            result = 31 * result + (this.onPremisesTagSet != null ? this.onPremisesTagSet.hashCode() : 0);
            result = 31 * result + (this.outdatedInstancesStrategy != null ? this.outdatedInstancesStrategy.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.triggerConfigurations != null ? this.triggerConfigurations.hashCode() : 0);
            return result;
        }
    }
}
