package software.amazon.awscdk.services.codedeploy;

/**
 * Represents a set of instance tag groups.
 * <p>
 * An instance will match a set if it matches all of the groups in the set -
 * in other words, sets follow 'and' semantics.
 * You can have a maximum of 3 tag groups inside a set.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.autoscaling.*;
 * import software.amazon.awscdk.services.cloudwatch.*;
 * ServerApplication application;
 * AutoScalingGroup asg;
 * Alarm alarm;
 * ServerDeploymentGroup deploymentGroup = ServerDeploymentGroup.Builder.create(this, "CodeDeployDeploymentGroup")
 *         .application(application)
 *         .deploymentGroupName("MyDeploymentGroup")
 *         .autoScalingGroups(List.of(asg))
 *         // adds User Data that installs the CodeDeploy agent on your auto-scaling groups hosts
 *         // default: true
 *         .installAgent(true)
 *         // adds EC2 instances matching tags
 *         .ec2InstanceTags(new InstanceTagSet(Map.of(
 *                 // any instance with tags satisfying
 *                 // key1=v1 or key1=v2 or key2 (any value) or value v3 (any key)
 *                 // will match this group
 *                 "key1", List.of("v1", "v2"),
 *                 "key2", List.of(),
 *                 "", List.of("v3"))))
 *         // adds on-premise instances matching tags
 *         .onPremiseInstanceTags(new InstanceTagSet(Map.of(
 *                 "key1", List.of("v1", "v2")), Map.of(
 *                 "key2", List.of("v3"))))
 *         // CloudWatch alarms
 *         .alarms(List.of(alarm))
 *         // whether to ignore failure to fetch the status of alarms from CloudWatch
 *         // default: false
 *         .ignorePollAlarmsFailure(false)
 *         // auto-rollback configuration
 *         .autoRollback(AutoRollbackConfig.builder()
 *                 .failedDeployment(true) // default: true
 *                 .stoppedDeployment(true) // default: false
 *                 .deploymentInAlarm(true)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T02:14:15.214Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.InstanceTagSet")
public class InstanceTagSet extends software.amazon.jsii.JsiiObject {

    protected InstanceTagSet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected InstanceTagSet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param instanceTagGroups This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public InstanceTagSet(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.util.List<java.lang.String>>... instanceTagGroups) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.Arrays.<Object>stream(instanceTagGroups).toArray(Object[]::new));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.util.Map<java.lang.String, java.util.List<java.lang.String>>> getInstanceTagGroups() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "instanceTagGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))));
    }
}
