package software.amazon.awscdk.services.codedeploy;

/**
 * A CloudFormation `AWS::CodeDeploy::DeploymentGroup`.
 * <p>
 * The <code>AWS::CodeDeploy::DeploymentGroup</code> resource creates an AWS CodeDeploy deployment group that specifies which instances your application revisions are deployed to, along with other deployment options. For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeploymentGroup.html">CreateDeploymentGroup</a> in the <em>CodeDeploy API Reference</em> .
 * <p>
 * <blockquote>
 * <p>
 * Amazon ECS blue/green deployments through CodeDeploy do not use the <code>AWS::CodeDeploy::DeploymentGroup</code> resource. To perform Amazon ECS blue/green deployments, use the <code>AWS::CodeDeploy::BlueGreen</code> hook. See <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/blue-green.html">Perform Amazon ECS blue/green deployments through CodeDeploy using AWS CloudFormation</a> for more information.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codedeploy.*;
 * CfnDeploymentGroup cfnDeploymentGroup = CfnDeploymentGroup.Builder.create(this, "MyCfnDeploymentGroup")
 *         .applicationName("applicationName")
 *         .serviceRoleArn("serviceRoleArn")
 *         // the properties below are optional
 *         .alarmConfiguration(AlarmConfigurationProperty.builder()
 *                 .alarms(List.of(AlarmProperty.builder()
 *                         .name("name")
 *                         .build()))
 *                 .enabled(false)
 *                 .ignorePollAlarmFailure(false)
 *                 .build())
 *         .autoRollbackConfiguration(AutoRollbackConfigurationProperty.builder()
 *                 .enabled(false)
 *                 .events(List.of("events"))
 *                 .build())
 *         .autoScalingGroups(List.of("autoScalingGroups"))
 *         .blueGreenDeploymentConfiguration(BlueGreenDeploymentConfigurationProperty.builder()
 *                 .deploymentReadyOption(DeploymentReadyOptionProperty.builder()
 *                         .actionOnTimeout("actionOnTimeout")
 *                         .waitTimeInMinutes(123)
 *                         .build())
 *                 .greenFleetProvisioningOption(GreenFleetProvisioningOptionProperty.builder()
 *                         .action("action")
 *                         .build())
 *                 .terminateBlueInstancesOnDeploymentSuccess(BlueInstanceTerminationOptionProperty.builder()
 *                         .action("action")
 *                         .terminationWaitTimeInMinutes(123)
 *                         .build())
 *                 .build())
 *         .deployment(DeploymentProperty.builder()
 *                 .revision(RevisionLocationProperty.builder()
 *                         .gitHubLocation(GitHubLocationProperty.builder()
 *                                 .commitId("commitId")
 *                                 .repository("repository")
 *                                 .build())
 *                         .revisionType("revisionType")
 *                         .s3Location(S3LocationProperty.builder()
 *                                 .bucket("bucket")
 *                                 .key("key")
 *                                 // the properties below are optional
 *                                 .bundleType("bundleType")
 *                                 .eTag("eTag")
 *                                 .version("version")
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .description("description")
 *                 .ignoreApplicationStopFailures(false)
 *                 .build())
 *         .deploymentConfigName("deploymentConfigName")
 *         .deploymentGroupName("deploymentGroupName")
 *         .deploymentStyle(DeploymentStyleProperty.builder()
 *                 .deploymentOption("deploymentOption")
 *                 .deploymentType("deploymentType")
 *                 .build())
 *         .ec2TagFilters(List.of(EC2TagFilterProperty.builder()
 *                 .key("key")
 *                 .type("type")
 *                 .value("value")
 *                 .build()))
 *         .ec2TagSet(EC2TagSetProperty.builder()
 *                 .ec2TagSetList(List.of(EC2TagSetListObjectProperty.builder()
 *                         .ec2TagGroup(List.of(EC2TagFilterProperty.builder()
 *                                 .key("key")
 *                                 .type("type")
 *                                 .value("value")
 *                                 .build()))
 *                         .build()))
 *                 .build())
 *         .ecsServices(List.of(ECSServiceProperty.builder()
 *                 .clusterName("clusterName")
 *                 .serviceName("serviceName")
 *                 .build()))
 *         .loadBalancerInfo(LoadBalancerInfoProperty.builder()
 *                 .elbInfoList(List.of(ELBInfoProperty.builder()
 *                         .name("name")
 *                         .build()))
 *                 .targetGroupInfoList(List.of(TargetGroupInfoProperty.builder()
 *                         .name("name")
 *                         .build()))
 *                 .targetGroupPairInfoList(List.of(TargetGroupPairInfoProperty.builder()
 *                         .prodTrafficRoute(TrafficRouteProperty.builder()
 *                                 .listenerArns(List.of("listenerArns"))
 *                                 .build())
 *                         .targetGroups(List.of(TargetGroupInfoProperty.builder()
 *                                 .name("name")
 *                                 .build()))
 *                         .testTrafficRoute(TrafficRouteProperty.builder()
 *                                 .listenerArns(List.of("listenerArns"))
 *                                 .build())
 *                         .build()))
 *                 .build())
 *         .onPremisesInstanceTagFilters(List.of(TagFilterProperty.builder()
 *                 .key("key")
 *                 .type("type")
 *                 .value("value")
 *                 .build()))
 *         .onPremisesTagSet(OnPremisesTagSetProperty.builder()
 *                 .onPremisesTagSetList(List.of(OnPremisesTagSetListObjectProperty.builder()
 *                         .onPremisesTagGroup(List.of(TagFilterProperty.builder()
 *                                 .key("key")
 *                                 .type("type")
 *                                 .value("value")
 *                                 .build()))
 *                         .build()))
 *                 .build())
 *         .outdatedInstancesStrategy("outdatedInstancesStrategy")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .triggerConfigurations(List.of(TriggerConfigProperty.builder()
 *                 .triggerEvents(List.of("triggerEvents"))
 *                 .triggerName("triggerName")
 *                 .triggerTargetArn("triggerTargetArn")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-23T19:57:02.274Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroup")
public class CfnDeploymentGroup extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnDeploymentGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDeploymentGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::CodeDeploy::DeploymentGroup`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDeploymentGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.CfnDeploymentGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The metadata that you apply to CodeDeploy deployment groups to help you organize and categorize them.
     * <p>
     * Each tag consists of a key and an optional value, both of which you define.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The name of an existing CodeDeploy application to associate this deployment group with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApplicationName() {
        return software.amazon.jsii.Kernel.get(this, "applicationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of an existing CodeDeploy application to associate this deployment group with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "applicationName", java.util.Objects.requireNonNull(value, "applicationName is required"));
    }

    /**
     * A service role Amazon Resource Name (ARN) that grants CodeDeploy permission to make calls to AWS services on your behalf.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/getting-started-create-service-role.html">Create a Service Role for AWS CodeDeploy</a> in the <em>AWS CodeDeploy User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * In some cases, you might need to add a dependency on the service role's policy. For more information, see IAM role policy in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn Attribute</a> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "serviceRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A service role Amazon Resource Name (ARN) that grants CodeDeploy permission to make calls to AWS services on your behalf.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/getting-started-create-service-role.html">Create a Service Role for AWS CodeDeploy</a> in the <em>AWS CodeDeploy User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * In some cases, you might need to add a dependency on the service role's policy. For more information, see IAM role policy in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn Attribute</a> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serviceRoleArn", java.util.Objects.requireNonNull(value, "serviceRoleArn is required"));
    }

    /**
     * Information about the Amazon CloudWatch alarms that are associated with the deployment group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAlarmConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "alarmConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about the Amazon CloudWatch alarms that are associated with the deployment group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAlarmConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "alarmConfiguration", value);
    }

    /**
     * Information about the Amazon CloudWatch alarms that are associated with the deployment group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAlarmConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.AlarmConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "alarmConfiguration", value);
    }

    /**
     * Information about the automatic rollback configuration that is associated with the deployment group.
     * <p>
     * If you specify this property, don't specify the <code>Deployment</code> property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAutoRollbackConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "autoRollbackConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about the automatic rollback configuration that is associated with the deployment group.
     * <p>
     * If you specify this property, don't specify the <code>Deployment</code> property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoRollbackConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoRollbackConfiguration", value);
    }

    /**
     * Information about the automatic rollback configuration that is associated with the deployment group.
     * <p>
     * If you specify this property, don't specify the <code>Deployment</code> property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoRollbackConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.AutoRollbackConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "autoRollbackConfiguration", value);
    }

    /**
     * A list of associated Auto Scaling groups that CodeDeploy automatically deploys revisions to when new instances are created.
     * <p>
     * Duplicates are not allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAutoScalingGroups() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "autoScalingGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of associated Auto Scaling groups that CodeDeploy automatically deploys revisions to when new instances are created.
     * <p>
     * Duplicates are not allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoScalingGroups(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "autoScalingGroups", value);
    }

    /**
     * Information about blue/green deployment options for a deployment group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBlueGreenDeploymentConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "blueGreenDeploymentConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about blue/green deployment options for a deployment group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBlueGreenDeploymentConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "blueGreenDeploymentConfiguration", value);
    }

    /**
     * Information about blue/green deployment options for a deployment group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBlueGreenDeploymentConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.BlueGreenDeploymentConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "blueGreenDeploymentConfiguration", value);
    }

    /**
     * The application revision to deploy to this deployment group.
     * <p>
     * If you specify this property, your target application revision is deployed as soon as the provisioning process is complete. If you specify this property, don't specify the <code>AutoRollbackConfiguration</code> property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeployment() {
        return software.amazon.jsii.Kernel.get(this, "deployment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The application revision to deploy to this deployment group.
     * <p>
     * If you specify this property, your target application revision is deployed as soon as the provisioning process is complete. If you specify this property, don't specify the <code>AutoRollbackConfiguration</code> property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeployment(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deployment", value);
    }

    /**
     * The application revision to deploy to this deployment group.
     * <p>
     * If you specify this property, your target application revision is deployed as soon as the provisioning process is complete. If you specify this property, don't specify the <code>AutoRollbackConfiguration</code> property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeployment(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.DeploymentProperty value) {
        software.amazon.jsii.Kernel.set(this, "deployment", value);
    }

    /**
     * A deployment configuration name or a predefined configuration name.
     * <p>
     * With predefined configurations, you can deploy application revisions to one instance at a time ( <code>CodeDeployDefault.OneAtATime</code> ), half of the instances at a time ( <code>CodeDeployDefault.HalfAtATime</code> ), or all the instances at once ( <code>CodeDeployDefault.AllAtOnce</code> ). For more information and valid values, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html">Working with Deployment Configurations</a> in the <em>AWS CodeDeploy User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDeploymentConfigName() {
        return software.amazon.jsii.Kernel.get(this, "deploymentConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A deployment configuration name or a predefined configuration name.
     * <p>
     * With predefined configurations, you can deploy application revisions to one instance at a time ( <code>CodeDeployDefault.OneAtATime</code> ), half of the instances at a time ( <code>CodeDeployDefault.HalfAtATime</code> ), or all the instances at once ( <code>CodeDeployDefault.AllAtOnce</code> ). For more information and valid values, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html">Working with Deployment Configurations</a> in the <em>AWS CodeDeploy User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentConfigName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "deploymentConfigName", value);
    }

    /**
     * A name for the deployment group.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the deployment group name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDeploymentGroupName() {
        return software.amazon.jsii.Kernel.get(this, "deploymentGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the deployment group.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the deployment group name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "deploymentGroupName", value);
    }

    /**
     * Attributes that determine the type of deployment to run and whether to route deployment traffic behind a load balancer.
     * <p>
     * If you specify this property with a blue/green deployment type, don't specify the <code>AutoScalingGroups</code> , <code>LoadBalancerInfo</code> , or <code>Deployment</code> properties.
     * <p>
     * <blockquote>
     * <p>
     * For blue/green deployments, AWS CloudFormation supports deployments on Lambda compute platforms only. You can perform Amazon ECS blue/green deployments using <code>AWS::CodeDeploy::BlueGreen</code> hook. See <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/blue-green.html">Perform Amazon ECS blue/green deployments through CodeDeploy using AWS CloudFormation</a> for more information.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeploymentStyle() {
        return software.amazon.jsii.Kernel.get(this, "deploymentStyle", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Attributes that determine the type of deployment to run and whether to route deployment traffic behind a load balancer.
     * <p>
     * If you specify this property with a blue/green deployment type, don't specify the <code>AutoScalingGroups</code> , <code>LoadBalancerInfo</code> , or <code>Deployment</code> properties.
     * <p>
     * <blockquote>
     * <p>
     * For blue/green deployments, AWS CloudFormation supports deployments on Lambda compute platforms only. You can perform Amazon ECS blue/green deployments using <code>AWS::CodeDeploy::BlueGreen</code> hook. See <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/blue-green.html">Perform Amazon ECS blue/green deployments through CodeDeploy using AWS CloudFormation</a> for more information.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentStyle(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deploymentStyle", value);
    }

    /**
     * Attributes that determine the type of deployment to run and whether to route deployment traffic behind a load balancer.
     * <p>
     * If you specify this property with a blue/green deployment type, don't specify the <code>AutoScalingGroups</code> , <code>LoadBalancerInfo</code> , or <code>Deployment</code> properties.
     * <p>
     * <blockquote>
     * <p>
     * For blue/green deployments, AWS CloudFormation supports deployments on Lambda compute platforms only. You can perform Amazon ECS blue/green deployments using <code>AWS::CodeDeploy::BlueGreen</code> hook. See <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/blue-green.html">Perform Amazon ECS blue/green deployments through CodeDeploy using AWS CloudFormation</a> for more information.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentStyle(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.DeploymentStyleProperty value) {
        software.amazon.jsii.Kernel.set(this, "deploymentStyle", value);
    }

    /**
     * The Amazon EC2 tags that are already applied to Amazon EC2 instances that you want to include in the deployment group.
     * <p>
     * CodeDeploy includes all Amazon EC2 instances identified by any of the tags you specify in this deployment group. Duplicates are not allowed.
     * <p>
     * You can specify <code>EC2TagFilters</code> or <code>Ec2TagSet</code> , but not both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEc2TagFilters() {
        return software.amazon.jsii.Kernel.get(this, "ec2TagFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Amazon EC2 tags that are already applied to Amazon EC2 instances that you want to include in the deployment group.
     * <p>
     * CodeDeploy includes all Amazon EC2 instances identified by any of the tags you specify in this deployment group. Duplicates are not allowed.
     * <p>
     * You can specify <code>EC2TagFilters</code> or <code>Ec2TagSet</code> , but not both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEc2TagFilters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ec2TagFilters", value);
    }

    /**
     * The Amazon EC2 tags that are already applied to Amazon EC2 instances that you want to include in the deployment group.
     * <p>
     * CodeDeploy includes all Amazon EC2 instances identified by any of the tags you specify in this deployment group. Duplicates are not allowed.
     * <p>
     * You can specify <code>EC2TagFilters</code> or <code>Ec2TagSet</code> , but not both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEc2TagFilters(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.EC2TagFilterProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.core.IResolvable, software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.EC2TagFilterProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "ec2TagFilters", value);
    }

    /**
     * Information about groups of tags applied to Amazon EC2 instances.
     * <p>
     * The deployment group includes only Amazon EC2 instances identified by all the tag groups. Cannot be used in the same call as <code>ec2TagFilter</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEc2TagSet() {
        return software.amazon.jsii.Kernel.get(this, "ec2TagSet", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about groups of tags applied to Amazon EC2 instances.
     * <p>
     * The deployment group includes only Amazon EC2 instances identified by all the tag groups. Cannot be used in the same call as <code>ec2TagFilter</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEc2TagSet(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ec2TagSet", value);
    }

    /**
     * Information about groups of tags applied to Amazon EC2 instances.
     * <p>
     * The deployment group includes only Amazon EC2 instances identified by all the tag groups. Cannot be used in the same call as <code>ec2TagFilter</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEc2TagSet(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.EC2TagSetProperty value) {
        software.amazon.jsii.Kernel.set(this, "ec2TagSet", value);
    }

    /**
     * The target Amazon ECS services in the deployment group.
     * <p>
     * This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEcsServices() {
        return software.amazon.jsii.Kernel.get(this, "ecsServices", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The target Amazon ECS services in the deployment group.
     * <p>
     * This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEcsServices(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ecsServices", value);
    }

    /**
     * The target Amazon ECS services in the deployment group.
     * <p>
     * This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEcsServices(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.ECSServiceProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.core.IResolvable, software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.ECSServiceProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "ecsServices", value);
    }

    /**
     * Information about the load balancer to use in a deployment.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-elastic-load-balancing.html">Integrating CodeDeploy with Elastic Load Balancing</a> in the <em>AWS CodeDeploy User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLoadBalancerInfo() {
        return software.amazon.jsii.Kernel.get(this, "loadBalancerInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about the load balancer to use in a deployment.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-elastic-load-balancing.html">Integrating CodeDeploy with Elastic Load Balancing</a> in the <em>AWS CodeDeploy User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoadBalancerInfo(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "loadBalancerInfo", value);
    }

    /**
     * Information about the load balancer to use in a deployment.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-elastic-load-balancing.html">Integrating CodeDeploy with Elastic Load Balancing</a> in the <em>AWS CodeDeploy User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoadBalancerInfo(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.LoadBalancerInfoProperty value) {
        software.amazon.jsii.Kernel.set(this, "loadBalancerInfo", value);
    }

    /**
     * The on-premises instance tags already applied to on-premises instances that you want to include in the deployment group.
     * <p>
     * CodeDeploy includes all on-premises instances identified by any of the tags you specify in this deployment group. To register on-premises instances with CodeDeploy , see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-on-premises.html">Working with On-Premises Instances for CodeDeploy</a> in the <em>AWS CodeDeploy User Guide</em> . Duplicates are not allowed.
     * <p>
     * You can specify <code>OnPremisesInstanceTagFilters</code> or <code>OnPremisesInstanceTagSet</code> , but not both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOnPremisesInstanceTagFilters() {
        return software.amazon.jsii.Kernel.get(this, "onPremisesInstanceTagFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The on-premises instance tags already applied to on-premises instances that you want to include in the deployment group.
     * <p>
     * CodeDeploy includes all on-premises instances identified by any of the tags you specify in this deployment group. To register on-premises instances with CodeDeploy , see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-on-premises.html">Working with On-Premises Instances for CodeDeploy</a> in the <em>AWS CodeDeploy User Guide</em> . Duplicates are not allowed.
     * <p>
     * You can specify <code>OnPremisesInstanceTagFilters</code> or <code>OnPremisesInstanceTagSet</code> , but not both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOnPremisesInstanceTagFilters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "onPremisesInstanceTagFilters", value);
    }

    /**
     * The on-premises instance tags already applied to on-premises instances that you want to include in the deployment group.
     * <p>
     * CodeDeploy includes all on-premises instances identified by any of the tags you specify in this deployment group. To register on-premises instances with CodeDeploy , see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-on-premises.html">Working with On-Premises Instances for CodeDeploy</a> in the <em>AWS CodeDeploy User Guide</em> . Duplicates are not allowed.
     * <p>
     * You can specify <code>OnPremisesInstanceTagFilters</code> or <code>OnPremisesInstanceTagSet</code> , but not both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOnPremisesInstanceTagFilters(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.TagFilterProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.core.IResolvable, software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.TagFilterProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "onPremisesInstanceTagFilters", value);
    }

    /**
     * Information about groups of tags applied to on-premises instances.
     * <p>
     * The deployment group includes only on-premises instances identified by all the tag groups.
     * <p>
     * You can specify <code>OnPremisesInstanceTagFilters</code> or <code>OnPremisesInstanceTagSet</code> , but not both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOnPremisesTagSet() {
        return software.amazon.jsii.Kernel.get(this, "onPremisesTagSet", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about groups of tags applied to on-premises instances.
     * <p>
     * The deployment group includes only on-premises instances identified by all the tag groups.
     * <p>
     * You can specify <code>OnPremisesInstanceTagFilters</code> or <code>OnPremisesInstanceTagSet</code> , but not both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOnPremisesTagSet(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "onPremisesTagSet", value);
    }

    /**
     * Information about groups of tags applied to on-premises instances.
     * <p>
     * The deployment group includes only on-premises instances identified by all the tag groups.
     * <p>
     * You can specify <code>OnPremisesInstanceTagFilters</code> or <code>OnPremisesInstanceTagSet</code> , but not both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOnPremisesTagSet(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.OnPremisesTagSetProperty value) {
        software.amazon.jsii.Kernel.set(this, "onPremisesTagSet", value);
    }

    /**
     * Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed application revision.
     * <p>
     * If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update outdated instances' deployments to apply the deployed application revision to the new Amazon EC2 instances.
     * <p>
     * If this option is set to <code>IGNORE</code> , CodeDeploy does not initiate a deployment to update the new Amazon EC2 instances. This may result in instances having different revisions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getOutdatedInstancesStrategy() {
        return software.amazon.jsii.Kernel.get(this, "outdatedInstancesStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed application revision.
     * <p>
     * If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update outdated instances' deployments to apply the deployed application revision to the new Amazon EC2 instances.
     * <p>
     * If this option is set to <code>IGNORE</code> , CodeDeploy does not initiate a deployment to update the new Amazon EC2 instances. This may result in instances having different revisions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutdatedInstancesStrategy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "outdatedInstancesStrategy", value);
    }

    /**
     * Information about triggers associated with the deployment group.
     * <p>
     * Duplicates are not allowed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTriggerConfigurations() {
        return software.amazon.jsii.Kernel.get(this, "triggerConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about triggers associated with the deployment group.
     * <p>
     * Duplicates are not allowed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTriggerConfigurations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "triggerConfigurations", value);
    }

    /**
     * Information about triggers associated with the deployment group.
     * <p>
     * Duplicates are not allowed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTriggerConfigurations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.TriggerConfigProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.core.IResolvable, software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.TriggerConfigProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "triggerConfigurations", value);
    }
    /**
     * The `AlarmConfiguration` property type configures CloudWatch alarms for an AWS CodeDeploy deployment group.
     * <p>
     * <code>AlarmConfiguration</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html">DeploymentGroup</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codedeploy.*;
     * AlarmConfigurationProperty alarmConfigurationProperty = AlarmConfigurationProperty.builder()
     *         .alarms(List.of(AlarmProperty.builder()
     *                 .name("name")
     *                 .build()))
     *         .enabled(false)
     *         .ignorePollAlarmFailure(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroup.AlarmConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AlarmConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AlarmConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of alarms configured for the deployment or deployment group.
         * <p>
         * A maximum of 10 alarms can be added.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAlarms() {
            return null;
        }

        /**
         * Indicates whether the alarm configuration is enabled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * Indicates whether a deployment should continue if information about the current state of alarms cannot be retrieved from Amazon CloudWatch .
         * <p>
         * The default value is <code>false</code> .
         * <p>
         * <ul>
         * <li><code>true</code> : The deployment proceeds even if alarm status information can't be retrieved from CloudWatch .</li>
         * <li><code>false</code> : The deployment stops if alarm status information can't be retrieved from CloudWatch .</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIgnorePollAlarmFailure() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AlarmConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AlarmConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AlarmConfigurationProperty> {
            java.lang.Object alarms;
            java.lang.Object enabled;
            java.lang.Object ignorePollAlarmFailure;

            /**
             * Sets the value of {@link AlarmConfigurationProperty#getAlarms}
             * @param alarms A list of alarms configured for the deployment or deployment group.
             *               A maximum of 10 alarms can be added.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarms(software.amazon.awscdk.core.IResolvable alarms) {
                this.alarms = alarms;
                return this;
            }

            /**
             * Sets the value of {@link AlarmConfigurationProperty#getAlarms}
             * @param alarms A list of alarms configured for the deployment or deployment group.
             *               A maximum of 10 alarms can be added.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarms(java.util.List<? extends java.lang.Object> alarms) {
                this.alarms = alarms;
                return this;
            }

            /**
             * Sets the value of {@link AlarmConfigurationProperty#getEnabled}
             * @param enabled Indicates whether the alarm configuration is enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link AlarmConfigurationProperty#getEnabled}
             * @param enabled Indicates whether the alarm configuration is enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link AlarmConfigurationProperty#getIgnorePollAlarmFailure}
             * @param ignorePollAlarmFailure Indicates whether a deployment should continue if information about the current state of alarms cannot be retrieved from Amazon CloudWatch .
             *                               The default value is <code>false</code> .
             *                               <p>
             *                               <ul>
             *                               <li><code>true</code> : The deployment proceeds even if alarm status information can't be retrieved from CloudWatch .</li>
             *                               <li><code>false</code> : The deployment stops if alarm status information can't be retrieved from CloudWatch .</li>
             *                               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ignorePollAlarmFailure(java.lang.Boolean ignorePollAlarmFailure) {
                this.ignorePollAlarmFailure = ignorePollAlarmFailure;
                return this;
            }

            /**
             * Sets the value of {@link AlarmConfigurationProperty#getIgnorePollAlarmFailure}
             * @param ignorePollAlarmFailure Indicates whether a deployment should continue if information about the current state of alarms cannot be retrieved from Amazon CloudWatch .
             *                               The default value is <code>false</code> .
             *                               <p>
             *                               <ul>
             *                               <li><code>true</code> : The deployment proceeds even if alarm status information can't be retrieved from CloudWatch .</li>
             *                               <li><code>false</code> : The deployment stops if alarm status information can't be retrieved from CloudWatch .</li>
             *                               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ignorePollAlarmFailure(software.amazon.awscdk.core.IResolvable ignorePollAlarmFailure) {
                this.ignorePollAlarmFailure = ignorePollAlarmFailure;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AlarmConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AlarmConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AlarmConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlarmConfigurationProperty {
            private final java.lang.Object alarms;
            private final java.lang.Object enabled;
            private final java.lang.Object ignorePollAlarmFailure;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alarms = software.amazon.jsii.Kernel.get(this, "alarms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ignorePollAlarmFailure = software.amazon.jsii.Kernel.get(this, "ignorePollAlarmFailure", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alarms = builder.alarms;
                this.enabled = builder.enabled;
                this.ignorePollAlarmFailure = builder.ignorePollAlarmFailure;
            }

            @Override
            public final java.lang.Object getAlarms() {
                return this.alarms;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getIgnorePollAlarmFailure() {
                return this.ignorePollAlarmFailure;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAlarms() != null) {
                    data.set("alarms", om.valueToTree(this.getAlarms()));
                }
                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getIgnorePollAlarmFailure() != null) {
                    data.set("ignorePollAlarmFailure", om.valueToTree(this.getIgnorePollAlarmFailure()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.CfnDeploymentGroup.AlarmConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AlarmConfigurationProperty.Jsii$Proxy that = (AlarmConfigurationProperty.Jsii$Proxy) o;

                if (this.alarms != null ? !this.alarms.equals(that.alarms) : that.alarms != null) return false;
                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                return this.ignorePollAlarmFailure != null ? this.ignorePollAlarmFailure.equals(that.ignorePollAlarmFailure) : that.ignorePollAlarmFailure == null;
            }

            @Override
            public final int hashCode() {
                int result = this.alarms != null ? this.alarms.hashCode() : 0;
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                result = 31 * result + (this.ignorePollAlarmFailure != null ? this.ignorePollAlarmFailure.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `Alarm` property type specifies a CloudWatch alarm to use for an AWS CodeDeploy deployment group.
     * <p>
     * The <code>Alarm</code> property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html">CodeDeploy DeploymentGroup AlarmConfiguration</a> property contains a list of <code>Alarm</code> property types.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codedeploy.*;
     * AlarmProperty alarmProperty = AlarmProperty.builder()
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroup.AlarmProperty")
    @software.amazon.jsii.Jsii.Proxy(AlarmProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AlarmProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the alarm.
         * <p>
         * Maximum length is 255 characters. Each alarm name can be used only once in a list of alarms.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AlarmProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AlarmProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AlarmProperty> {
            java.lang.String name;

            /**
             * Sets the value of {@link AlarmProperty#getName}
             * @param name The name of the alarm.
             *             Maximum length is 255 characters. Each alarm name can be used only once in a list of alarms.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AlarmProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AlarmProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AlarmProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlarmProperty {
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.CfnDeploymentGroup.AlarmProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AlarmProperty.Jsii$Proxy that = (AlarmProperty.Jsii$Proxy) o;

                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The `AutoRollbackConfiguration` property type configures automatic rollback for an AWS CodeDeploy deployment group when a deployment is not completed successfully.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployments-rollback-and-redeploy.html#deployments-rollback-and-redeploy-automatic-rollbacks">Automatic Rollbacks</a> in the <em>AWS CodeDeploy User Guide</em> .
     * <p>
     * <code>AutoRollbackConfiguration</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html">DeploymentGroup</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codedeploy.*;
     * AutoRollbackConfigurationProperty autoRollbackConfigurationProperty = AutoRollbackConfigurationProperty.builder()
     *         .enabled(false)
     *         .events(List.of("events"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroup.AutoRollbackConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoRollbackConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoRollbackConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether a defined automatic rollback configuration is currently enabled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * The event type or types that trigger a rollback.
         * <p>
         * Valid values are <code>DEPLOYMENT_FAILURE</code> , <code>DEPLOYMENT_STOP_ON_ALARM</code> , or <code>DEPLOYMENT_STOP_ON_REQUEST</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEvents() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AutoRollbackConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoRollbackConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoRollbackConfigurationProperty> {
            java.lang.Object enabled;
            java.util.List<java.lang.String> events;

            /**
             * Sets the value of {@link AutoRollbackConfigurationProperty#getEnabled}
             * @param enabled Indicates whether a defined automatic rollback configuration is currently enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link AutoRollbackConfigurationProperty#getEnabled}
             * @param enabled Indicates whether a defined automatic rollback configuration is currently enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link AutoRollbackConfigurationProperty#getEvents}
             * @param events The event type or types that trigger a rollback.
             *               Valid values are <code>DEPLOYMENT_FAILURE</code> , <code>DEPLOYMENT_STOP_ON_ALARM</code> , or <code>DEPLOYMENT_STOP_ON_REQUEST</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder events(java.util.List<java.lang.String> events) {
                this.events = events;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoRollbackConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoRollbackConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoRollbackConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoRollbackConfigurationProperty {
            private final java.lang.Object enabled;
            private final java.util.List<java.lang.String> events;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.events = software.amazon.jsii.Kernel.get(this, "events", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.events = builder.events;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.util.List<java.lang.String> getEvents() {
                return this.events;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getEvents() != null) {
                    data.set("events", om.valueToTree(this.getEvents()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.CfnDeploymentGroup.AutoRollbackConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoRollbackConfigurationProperty.Jsii$Proxy that = (AutoRollbackConfigurationProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                return this.events != null ? this.events.equals(that.events) : that.events == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.events != null ? this.events.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about blue/green deployment options for a deployment group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codedeploy.*;
     * BlueGreenDeploymentConfigurationProperty blueGreenDeploymentConfigurationProperty = BlueGreenDeploymentConfigurationProperty.builder()
     *         .deploymentReadyOption(DeploymentReadyOptionProperty.builder()
     *                 .actionOnTimeout("actionOnTimeout")
     *                 .waitTimeInMinutes(123)
     *                 .build())
     *         .greenFleetProvisioningOption(GreenFleetProvisioningOptionProperty.builder()
     *                 .action("action")
     *                 .build())
     *         .terminateBlueInstancesOnDeploymentSuccess(BlueInstanceTerminationOptionProperty.builder()
     *                 .action("action")
     *                 .terminationWaitTimeInMinutes(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroup.BlueGreenDeploymentConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(BlueGreenDeploymentConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BlueGreenDeploymentConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information about the action to take when newly provisioned instances are ready to receive traffic in a blue/green deployment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeploymentReadyOption() {
            return null;
        }

        /**
         * Information about how instances are provisioned for a replacement environment in a blue/green deployment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGreenFleetProvisioningOption() {
            return null;
        }

        /**
         * Information about whether to terminate instances in the original fleet during a blue/green deployment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTerminateBlueInstancesOnDeploymentSuccess() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BlueGreenDeploymentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BlueGreenDeploymentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BlueGreenDeploymentConfigurationProperty> {
            java.lang.Object deploymentReadyOption;
            java.lang.Object greenFleetProvisioningOption;
            java.lang.Object terminateBlueInstancesOnDeploymentSuccess;

            /**
             * Sets the value of {@link BlueGreenDeploymentConfigurationProperty#getDeploymentReadyOption}
             * @param deploymentReadyOption Information about the action to take when newly provisioned instances are ready to receive traffic in a blue/green deployment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deploymentReadyOption(software.amazon.awscdk.core.IResolvable deploymentReadyOption) {
                this.deploymentReadyOption = deploymentReadyOption;
                return this;
            }

            /**
             * Sets the value of {@link BlueGreenDeploymentConfigurationProperty#getDeploymentReadyOption}
             * @param deploymentReadyOption Information about the action to take when newly provisioned instances are ready to receive traffic in a blue/green deployment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deploymentReadyOption(software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.DeploymentReadyOptionProperty deploymentReadyOption) {
                this.deploymentReadyOption = deploymentReadyOption;
                return this;
            }

            /**
             * Sets the value of {@link BlueGreenDeploymentConfigurationProperty#getGreenFleetProvisioningOption}
             * @param greenFleetProvisioningOption Information about how instances are provisioned for a replacement environment in a blue/green deployment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder greenFleetProvisioningOption(software.amazon.awscdk.core.IResolvable greenFleetProvisioningOption) {
                this.greenFleetProvisioningOption = greenFleetProvisioningOption;
                return this;
            }

            /**
             * Sets the value of {@link BlueGreenDeploymentConfigurationProperty#getGreenFleetProvisioningOption}
             * @param greenFleetProvisioningOption Information about how instances are provisioned for a replacement environment in a blue/green deployment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder greenFleetProvisioningOption(software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.GreenFleetProvisioningOptionProperty greenFleetProvisioningOption) {
                this.greenFleetProvisioningOption = greenFleetProvisioningOption;
                return this;
            }

            /**
             * Sets the value of {@link BlueGreenDeploymentConfigurationProperty#getTerminateBlueInstancesOnDeploymentSuccess}
             * @param terminateBlueInstancesOnDeploymentSuccess Information about whether to terminate instances in the original fleet during a blue/green deployment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder terminateBlueInstancesOnDeploymentSuccess(software.amazon.awscdk.core.IResolvable terminateBlueInstancesOnDeploymentSuccess) {
                this.terminateBlueInstancesOnDeploymentSuccess = terminateBlueInstancesOnDeploymentSuccess;
                return this;
            }

            /**
             * Sets the value of {@link BlueGreenDeploymentConfigurationProperty#getTerminateBlueInstancesOnDeploymentSuccess}
             * @param terminateBlueInstancesOnDeploymentSuccess Information about whether to terminate instances in the original fleet during a blue/green deployment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder terminateBlueInstancesOnDeploymentSuccess(software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.BlueInstanceTerminationOptionProperty terminateBlueInstancesOnDeploymentSuccess) {
                this.terminateBlueInstancesOnDeploymentSuccess = terminateBlueInstancesOnDeploymentSuccess;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BlueGreenDeploymentConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BlueGreenDeploymentConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BlueGreenDeploymentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BlueGreenDeploymentConfigurationProperty {
            private final java.lang.Object deploymentReadyOption;
            private final java.lang.Object greenFleetProvisioningOption;
            private final java.lang.Object terminateBlueInstancesOnDeploymentSuccess;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deploymentReadyOption = software.amazon.jsii.Kernel.get(this, "deploymentReadyOption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.greenFleetProvisioningOption = software.amazon.jsii.Kernel.get(this, "greenFleetProvisioningOption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.terminateBlueInstancesOnDeploymentSuccess = software.amazon.jsii.Kernel.get(this, "terminateBlueInstancesOnDeploymentSuccess", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deploymentReadyOption = builder.deploymentReadyOption;
                this.greenFleetProvisioningOption = builder.greenFleetProvisioningOption;
                this.terminateBlueInstancesOnDeploymentSuccess = builder.terminateBlueInstancesOnDeploymentSuccess;
            }

            @Override
            public final java.lang.Object getDeploymentReadyOption() {
                return this.deploymentReadyOption;
            }

            @Override
            public final java.lang.Object getGreenFleetProvisioningOption() {
                return this.greenFleetProvisioningOption;
            }

            @Override
            public final java.lang.Object getTerminateBlueInstancesOnDeploymentSuccess() {
                return this.terminateBlueInstancesOnDeploymentSuccess;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeploymentReadyOption() != null) {
                    data.set("deploymentReadyOption", om.valueToTree(this.getDeploymentReadyOption()));
                }
                if (this.getGreenFleetProvisioningOption() != null) {
                    data.set("greenFleetProvisioningOption", om.valueToTree(this.getGreenFleetProvisioningOption()));
                }
                if (this.getTerminateBlueInstancesOnDeploymentSuccess() != null) {
                    data.set("terminateBlueInstancesOnDeploymentSuccess", om.valueToTree(this.getTerminateBlueInstancesOnDeploymentSuccess()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.CfnDeploymentGroup.BlueGreenDeploymentConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BlueGreenDeploymentConfigurationProperty.Jsii$Proxy that = (BlueGreenDeploymentConfigurationProperty.Jsii$Proxy) o;

                if (this.deploymentReadyOption != null ? !this.deploymentReadyOption.equals(that.deploymentReadyOption) : that.deploymentReadyOption != null) return false;
                if (this.greenFleetProvisioningOption != null ? !this.greenFleetProvisioningOption.equals(that.greenFleetProvisioningOption) : that.greenFleetProvisioningOption != null) return false;
                return this.terminateBlueInstancesOnDeploymentSuccess != null ? this.terminateBlueInstancesOnDeploymentSuccess.equals(that.terminateBlueInstancesOnDeploymentSuccess) : that.terminateBlueInstancesOnDeploymentSuccess == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deploymentReadyOption != null ? this.deploymentReadyOption.hashCode() : 0;
                result = 31 * result + (this.greenFleetProvisioningOption != null ? this.greenFleetProvisioningOption.hashCode() : 0);
                result = 31 * result + (this.terminateBlueInstancesOnDeploymentSuccess != null ? this.terminateBlueInstancesOnDeploymentSuccess.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about whether instances in the original environment are terminated when a blue/green deployment is successful.
     * <p>
     * <code>BlueInstanceTerminationOption</code> does not apply to Lambda deployments.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codedeploy.*;
     * BlueInstanceTerminationOptionProperty blueInstanceTerminationOptionProperty = BlueInstanceTerminationOptionProperty.builder()
     *         .action("action")
     *         .terminationWaitTimeInMinutes(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroup.BlueInstanceTerminationOptionProperty")
    @software.amazon.jsii.Jsii.Proxy(BlueInstanceTerminationOptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BlueInstanceTerminationOptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action to take on instances in the original environment after a successful blue/green deployment.
         * <p>
         * <ul>
         * <li><code>TERMINATE</code> : Instances are terminated after a specified wait time.</li>
         * <li><code>KEEP_ALIVE</code> : Instances are left running after they are deregistered from the load balancer and removed from the deployment group.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAction() {
            return null;
        }

        /**
         * For an Amazon EC2 deployment, the number of minutes to wait after a successful blue/green deployment before terminating instances from the original environment.
         * <p>
         * For an Amazon ECS deployment, the number of minutes before deleting the original (blue) task set. During an Amazon ECS deployment, CodeDeploy shifts traffic from the original (blue) task set to a replacement (green) task set.
         * <p>
         * The maximum setting is 2880 minutes (2 days).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTerminationWaitTimeInMinutes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BlueInstanceTerminationOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BlueInstanceTerminationOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BlueInstanceTerminationOptionProperty> {
            java.lang.String action;
            java.lang.Number terminationWaitTimeInMinutes;

            /**
             * Sets the value of {@link BlueInstanceTerminationOptionProperty#getAction}
             * @param action The action to take on instances in the original environment after a successful blue/green deployment.
             *               <ul>
             *               <li><code>TERMINATE</code> : Instances are terminated after a specified wait time.</li>
             *               <li><code>KEEP_ALIVE</code> : Instances are left running after they are deregistered from the load balancer and removed from the deployment group.</li>
             *               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link BlueInstanceTerminationOptionProperty#getTerminationWaitTimeInMinutes}
             * @param terminationWaitTimeInMinutes For an Amazon EC2 deployment, the number of minutes to wait after a successful blue/green deployment before terminating instances from the original environment.
             *                                     For an Amazon ECS deployment, the number of minutes before deleting the original (blue) task set. During an Amazon ECS deployment, CodeDeploy shifts traffic from the original (blue) task set to a replacement (green) task set.
             *                                     <p>
             *                                     The maximum setting is 2880 minutes (2 days).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder terminationWaitTimeInMinutes(java.lang.Number terminationWaitTimeInMinutes) {
                this.terminationWaitTimeInMinutes = terminationWaitTimeInMinutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BlueInstanceTerminationOptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BlueInstanceTerminationOptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BlueInstanceTerminationOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BlueInstanceTerminationOptionProperty {
            private final java.lang.String action;
            private final java.lang.Number terminationWaitTimeInMinutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.terminationWaitTimeInMinutes = software.amazon.jsii.Kernel.get(this, "terminationWaitTimeInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = builder.action;
                this.terminationWaitTimeInMinutes = builder.terminationWaitTimeInMinutes;
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            public final java.lang.Number getTerminationWaitTimeInMinutes() {
                return this.terminationWaitTimeInMinutes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAction() != null) {
                    data.set("action", om.valueToTree(this.getAction()));
                }
                if (this.getTerminationWaitTimeInMinutes() != null) {
                    data.set("terminationWaitTimeInMinutes", om.valueToTree(this.getTerminationWaitTimeInMinutes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.CfnDeploymentGroup.BlueInstanceTerminationOptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BlueInstanceTerminationOptionProperty.Jsii$Proxy that = (BlueInstanceTerminationOptionProperty.Jsii$Proxy) o;

                if (this.action != null ? !this.action.equals(that.action) : that.action != null) return false;
                return this.terminationWaitTimeInMinutes != null ? this.terminationWaitTimeInMinutes.equals(that.terminationWaitTimeInMinutes) : that.terminationWaitTimeInMinutes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.action != null ? this.action.hashCode() : 0;
                result = 31 * result + (this.terminationWaitTimeInMinutes != null ? this.terminationWaitTimeInMinutes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `Deployment` is a property of the [DeploymentGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html) resource that specifies an AWS CodeDeploy application revision to be deployed to instances in the deployment group. If you specify an application revision, your target revision is deployed as soon as the provisioning process is complete.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codedeploy.*;
     * DeploymentProperty deploymentProperty = DeploymentProperty.builder()
     *         .revision(RevisionLocationProperty.builder()
     *                 .gitHubLocation(GitHubLocationProperty.builder()
     *                         .commitId("commitId")
     *                         .repository("repository")
     *                         .build())
     *                 .revisionType("revisionType")
     *                 .s3Location(S3LocationProperty.builder()
     *                         .bucket("bucket")
     *                         .key("key")
     *                         // the properties below are optional
     *                         .bundleType("bundleType")
     *                         .eTag("eTag")
     *                         .version("version")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .description("description")
     *         .ignoreApplicationStopFailures(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroup.DeploymentProperty")
    @software.amazon.jsii.Jsii.Proxy(DeploymentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeploymentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information about the location of stored application artifacts and the service from which to retrieve them.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRevision();

        /**
         * A comment about the deployment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * If true, then if an `ApplicationStop` , `BeforeBlockTraffic` , or `AfterBlockTraffic` deployment lifecycle event to an instance fails, then the deployment continues to the next deployment lifecycle event.
         * <p>
         * For example, if <code>ApplicationStop</code> fails, the deployment continues with DownloadBundle. If <code>BeforeBlockTraffic</code> fails, the deployment continues with <code>BlockTraffic</code> . If <code>AfterBlockTraffic</code> fails, the deployment continues with <code>ApplicationStop</code> .
         * <p>
         * If false or not specified, then if a lifecycle event fails during a deployment to an instance, that deployment fails. If deployment to that instance is part of an overall deployment and the number of healthy hosts is not less than the minimum number of healthy hosts, then a deployment to the next instance is attempted.
         * <p>
         * During a deployment, the AWS CodeDeploy agent runs the scripts specified for <code>ApplicationStop</code> , <code>BeforeBlockTraffic</code> , and <code>AfterBlockTraffic</code> in the AppSpec file from the previous successful deployment. (All other scripts are run from the AppSpec file in the current deployment.) If one of these scripts contains an error and does not run successfully, the deployment can fail.
         * <p>
         * If the cause of the failure is a script from the last successful deployment that will never run successfully, create a new deployment and use <code>ignoreApplicationStopFailures</code> to specify that the <code>ApplicationStop</code> , <code>BeforeBlockTraffic</code> , and <code>AfterBlockTraffic</code> failures should be ignored.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIgnoreApplicationStopFailures() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeploymentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeploymentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeploymentProperty> {
            java.lang.Object revision;
            java.lang.String description;
            java.lang.Object ignoreApplicationStopFailures;

            /**
             * Sets the value of {@link DeploymentProperty#getRevision}
             * @param revision Information about the location of stored application artifacts and the service from which to retrieve them. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder revision(software.amazon.awscdk.core.IResolvable revision) {
                this.revision = revision;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentProperty#getRevision}
             * @param revision Information about the location of stored application artifacts and the service from which to retrieve them. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder revision(software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.RevisionLocationProperty revision) {
                this.revision = revision;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentProperty#getDescription}
             * @param description A comment about the deployment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentProperty#getIgnoreApplicationStopFailures}
             * @param ignoreApplicationStopFailures If true, then if an `ApplicationStop` , `BeforeBlockTraffic` , or `AfterBlockTraffic` deployment lifecycle event to an instance fails, then the deployment continues to the next deployment lifecycle event.
             *                                      For example, if <code>ApplicationStop</code> fails, the deployment continues with DownloadBundle. If <code>BeforeBlockTraffic</code> fails, the deployment continues with <code>BlockTraffic</code> . If <code>AfterBlockTraffic</code> fails, the deployment continues with <code>ApplicationStop</code> .
             *                                      <p>
             *                                      If false or not specified, then if a lifecycle event fails during a deployment to an instance, that deployment fails. If deployment to that instance is part of an overall deployment and the number of healthy hosts is not less than the minimum number of healthy hosts, then a deployment to the next instance is attempted.
             *                                      <p>
             *                                      During a deployment, the AWS CodeDeploy agent runs the scripts specified for <code>ApplicationStop</code> , <code>BeforeBlockTraffic</code> , and <code>AfterBlockTraffic</code> in the AppSpec file from the previous successful deployment. (All other scripts are run from the AppSpec file in the current deployment.) If one of these scripts contains an error and does not run successfully, the deployment can fail.
             *                                      <p>
             *                                      If the cause of the failure is a script from the last successful deployment that will never run successfully, create a new deployment and use <code>ignoreApplicationStopFailures</code> to specify that the <code>ApplicationStop</code> , <code>BeforeBlockTraffic</code> , and <code>AfterBlockTraffic</code> failures should be ignored.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ignoreApplicationStopFailures(java.lang.Boolean ignoreApplicationStopFailures) {
                this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentProperty#getIgnoreApplicationStopFailures}
             * @param ignoreApplicationStopFailures If true, then if an `ApplicationStop` , `BeforeBlockTraffic` , or `AfterBlockTraffic` deployment lifecycle event to an instance fails, then the deployment continues to the next deployment lifecycle event.
             *                                      For example, if <code>ApplicationStop</code> fails, the deployment continues with DownloadBundle. If <code>BeforeBlockTraffic</code> fails, the deployment continues with <code>BlockTraffic</code> . If <code>AfterBlockTraffic</code> fails, the deployment continues with <code>ApplicationStop</code> .
             *                                      <p>
             *                                      If false or not specified, then if a lifecycle event fails during a deployment to an instance, that deployment fails. If deployment to that instance is part of an overall deployment and the number of healthy hosts is not less than the minimum number of healthy hosts, then a deployment to the next instance is attempted.
             *                                      <p>
             *                                      During a deployment, the AWS CodeDeploy agent runs the scripts specified for <code>ApplicationStop</code> , <code>BeforeBlockTraffic</code> , and <code>AfterBlockTraffic</code> in the AppSpec file from the previous successful deployment. (All other scripts are run from the AppSpec file in the current deployment.) If one of these scripts contains an error and does not run successfully, the deployment can fail.
             *                                      <p>
             *                                      If the cause of the failure is a script from the last successful deployment that will never run successfully, create a new deployment and use <code>ignoreApplicationStopFailures</code> to specify that the <code>ApplicationStop</code> , <code>BeforeBlockTraffic</code> , and <code>AfterBlockTraffic</code> failures should be ignored.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ignoreApplicationStopFailures(software.amazon.awscdk.core.IResolvable ignoreApplicationStopFailures) {
                this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeploymentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeploymentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentProperty {
            private final java.lang.Object revision;
            private final java.lang.String description;
            private final java.lang.Object ignoreApplicationStopFailures;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.revision = software.amazon.jsii.Kernel.get(this, "revision", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ignoreApplicationStopFailures = software.amazon.jsii.Kernel.get(this, "ignoreApplicationStopFailures", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.revision = java.util.Objects.requireNonNull(builder.revision, "revision is required");
                this.description = builder.description;
                this.ignoreApplicationStopFailures = builder.ignoreApplicationStopFailures;
            }

            @Override
            public final java.lang.Object getRevision() {
                return this.revision;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getIgnoreApplicationStopFailures() {
                return this.ignoreApplicationStopFailures;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("revision", om.valueToTree(this.getRevision()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getIgnoreApplicationStopFailures() != null) {
                    data.set("ignoreApplicationStopFailures", om.valueToTree(this.getIgnoreApplicationStopFailures()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.CfnDeploymentGroup.DeploymentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeploymentProperty.Jsii$Proxy that = (DeploymentProperty.Jsii$Proxy) o;

                if (!revision.equals(that.revision)) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                return this.ignoreApplicationStopFailures != null ? this.ignoreApplicationStopFailures.equals(that.ignoreApplicationStopFailures) : that.ignoreApplicationStopFailures == null;
            }

            @Override
            public final int hashCode() {
                int result = this.revision.hashCode();
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.ignoreApplicationStopFailures != null ? this.ignoreApplicationStopFailures.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about how traffic is rerouted to instances in a replacement environment in a blue/green deployment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codedeploy.*;
     * DeploymentReadyOptionProperty deploymentReadyOptionProperty = DeploymentReadyOptionProperty.builder()
     *         .actionOnTimeout("actionOnTimeout")
     *         .waitTimeInMinutes(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroup.DeploymentReadyOptionProperty")
    @software.amazon.jsii.Jsii.Proxy(DeploymentReadyOptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeploymentReadyOptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information about when to reroute traffic from an original environment to a replacement environment in a blue/green deployment.
         * <p>
         * <ul>
         * <li>CONTINUE_DEPLOYMENT: Register new instances with the load balancer immediately after the new application revision is installed on the instances in the replacement environment.</li>
         * <li>STOP_DEPLOYMENT: Do not register new instances with a load balancer unless traffic rerouting is started using <a href="https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_ContinueDeployment.html">ContinueDeployment</a> . If traffic rerouting is not started before the end of the specified wait period, the deployment status is changed to Stopped.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getActionOnTimeout() {
            return null;
        }

        /**
         * The number of minutes to wait before the status of a blue/green deployment is changed to Stopped if rerouting is not started manually.
         * <p>
         * Applies only to the <code>STOP_DEPLOYMENT</code> option for <code>actionOnTimeout</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWaitTimeInMinutes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeploymentReadyOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeploymentReadyOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeploymentReadyOptionProperty> {
            java.lang.String actionOnTimeout;
            java.lang.Number waitTimeInMinutes;

            /**
             * Sets the value of {@link DeploymentReadyOptionProperty#getActionOnTimeout}
             * @param actionOnTimeout Information about when to reroute traffic from an original environment to a replacement environment in a blue/green deployment.
             *                        <ul>
             *                        <li>CONTINUE_DEPLOYMENT: Register new instances with the load balancer immediately after the new application revision is installed on the instances in the replacement environment.</li>
             *                        <li>STOP_DEPLOYMENT: Do not register new instances with a load balancer unless traffic rerouting is started using <a href="https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_ContinueDeployment.html">ContinueDeployment</a> . If traffic rerouting is not started before the end of the specified wait period, the deployment status is changed to Stopped.</li>
             *                        </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionOnTimeout(java.lang.String actionOnTimeout) {
                this.actionOnTimeout = actionOnTimeout;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentReadyOptionProperty#getWaitTimeInMinutes}
             * @param waitTimeInMinutes The number of minutes to wait before the status of a blue/green deployment is changed to Stopped if rerouting is not started manually.
             *                          Applies only to the <code>STOP_DEPLOYMENT</code> option for <code>actionOnTimeout</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder waitTimeInMinutes(java.lang.Number waitTimeInMinutes) {
                this.waitTimeInMinutes = waitTimeInMinutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentReadyOptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeploymentReadyOptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeploymentReadyOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentReadyOptionProperty {
            private final java.lang.String actionOnTimeout;
            private final java.lang.Number waitTimeInMinutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actionOnTimeout = software.amazon.jsii.Kernel.get(this, "actionOnTimeout", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.waitTimeInMinutes = software.amazon.jsii.Kernel.get(this, "waitTimeInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actionOnTimeout = builder.actionOnTimeout;
                this.waitTimeInMinutes = builder.waitTimeInMinutes;
            }

            @Override
            public final java.lang.String getActionOnTimeout() {
                return this.actionOnTimeout;
            }

            @Override
            public final java.lang.Number getWaitTimeInMinutes() {
                return this.waitTimeInMinutes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getActionOnTimeout() != null) {
                    data.set("actionOnTimeout", om.valueToTree(this.getActionOnTimeout()));
                }
                if (this.getWaitTimeInMinutes() != null) {
                    data.set("waitTimeInMinutes", om.valueToTree(this.getWaitTimeInMinutes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.CfnDeploymentGroup.DeploymentReadyOptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeploymentReadyOptionProperty.Jsii$Proxy that = (DeploymentReadyOptionProperty.Jsii$Proxy) o;

                if (this.actionOnTimeout != null ? !this.actionOnTimeout.equals(that.actionOnTimeout) : that.actionOnTimeout != null) return false;
                return this.waitTimeInMinutes != null ? this.waitTimeInMinutes.equals(that.waitTimeInMinutes) : that.waitTimeInMinutes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.actionOnTimeout != null ? this.actionOnTimeout.hashCode() : 0;
                result = 31 * result + (this.waitTimeInMinutes != null ? this.waitTimeInMinutes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codedeploy.*;
     * DeploymentStyleProperty deploymentStyleProperty = DeploymentStyleProperty.builder()
     *         .deploymentOption("deploymentOption")
     *         .deploymentType("deploymentType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroup.DeploymentStyleProperty")
    @software.amazon.jsii.Jsii.Proxy(DeploymentStyleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeploymentStyleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether to route deployment traffic behind a load balancer.
         * <p>
         * <blockquote>
         * <p>
         * An Amazon EC2 Application Load Balancer or Network Load Balancer is required for an Amazon ECS deployment.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDeploymentOption() {
            return null;
        }

        /**
         * Indicates whether to run an in-place or blue/green deployment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDeploymentType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeploymentStyleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeploymentStyleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeploymentStyleProperty> {
            java.lang.String deploymentOption;
            java.lang.String deploymentType;

            /**
             * Sets the value of {@link DeploymentStyleProperty#getDeploymentOption}
             * @param deploymentOption Indicates whether to route deployment traffic behind a load balancer.
             *                         <blockquote>
             *                         <p>
             *                         An Amazon EC2 Application Load Balancer or Network Load Balancer is required for an Amazon ECS deployment.
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deploymentOption(java.lang.String deploymentOption) {
                this.deploymentOption = deploymentOption;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentStyleProperty#getDeploymentType}
             * @param deploymentType Indicates whether to run an in-place or blue/green deployment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deploymentType(java.lang.String deploymentType) {
                this.deploymentType = deploymentType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentStyleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeploymentStyleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeploymentStyleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentStyleProperty {
            private final java.lang.String deploymentOption;
            private final java.lang.String deploymentType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deploymentOption = software.amazon.jsii.Kernel.get(this, "deploymentOption", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.deploymentType = software.amazon.jsii.Kernel.get(this, "deploymentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deploymentOption = builder.deploymentOption;
                this.deploymentType = builder.deploymentType;
            }

            @Override
            public final java.lang.String getDeploymentOption() {
                return this.deploymentOption;
            }

            @Override
            public final java.lang.String getDeploymentType() {
                return this.deploymentType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeploymentOption() != null) {
                    data.set("deploymentOption", om.valueToTree(this.getDeploymentOption()));
                }
                if (this.getDeploymentType() != null) {
                    data.set("deploymentType", om.valueToTree(this.getDeploymentType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.CfnDeploymentGroup.DeploymentStyleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeploymentStyleProperty.Jsii$Proxy that = (DeploymentStyleProperty.Jsii$Proxy) o;

                if (this.deploymentOption != null ? !this.deploymentOption.equals(that.deploymentOption) : that.deploymentOption != null) return false;
                return this.deploymentType != null ? this.deploymentType.equals(that.deploymentType) : that.deploymentType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deploymentOption != null ? this.deploymentOption.hashCode() : 0;
                result = 31 * result + (this.deploymentType != null ? this.deploymentType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about an Amazon EC2 tag filter.
     * <p>
     * For more information about using tags and tag groups to help manage your Amazon EC2 instances and on-premises instances, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-tagging.html">Tagging Instances for Deployment Groups in AWS CodeDeploy</a> in the <em>AWS CodeDeploy User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codedeploy.*;
     * EC2TagFilterProperty eC2TagFilterProperty = EC2TagFilterProperty.builder()
     *         .key("key")
     *         .type("type")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroup.EC2TagFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(EC2TagFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EC2TagFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The tag filter key.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * The tag filter type:.
         * <p>
         * <ul>
         * <li><code>KEY_ONLY</code> : Key only.</li>
         * <li><code>VALUE_ONLY</code> : Value only.</li>
         * <li><code>KEY_AND_VALUE</code> : Key and value.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * The tag filter value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EC2TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EC2TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EC2TagFilterProperty> {
            java.lang.String key;
            java.lang.String type;
            java.lang.String value;

            /**
             * Sets the value of {@link EC2TagFilterProperty#getKey}
             * @param key The tag filter key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link EC2TagFilterProperty#getType}
             * @param type The tag filter type:.
             *             <ul>
             *             <li><code>KEY_ONLY</code> : Key only.</li>
             *             <li><code>VALUE_ONLY</code> : Value only.</li>
             *             <li><code>KEY_AND_VALUE</code> : Key and value.</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link EC2TagFilterProperty#getValue}
             * @param value The tag filter value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EC2TagFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EC2TagFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EC2TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EC2TagFilterProperty {
            private final java.lang.String key;
            private final java.lang.String type;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = builder.key;
                this.type = builder.type;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.CfnDeploymentGroup.EC2TagFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EC2TagFilterProperty.Jsii$Proxy that = (EC2TagFilterProperty.Jsii$Proxy) o;

                if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
                if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key != null ? this.key.hashCode() : 0;
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `EC2TagSet` property type specifies information about groups of tags applied to Amazon EC2 instances.
     * <p>
     * The deployment group includes only Amazon EC2 instances identified by all the tag groups. Cannot be used in the same template as EC2TagFilters.
     * <p>
     * For more information about using tags and tag groups to help manage your Amazon EC2 instances and on-premises instances, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-tagging.html">Tagging Instances for Deployment Groups in AWS CodeDeploy</a> in the <em>AWS CodeDeploy User Guide</em> .
     * <p>
     * <code>EC2TagSet</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html">DeploymentGroup</a> resource type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codedeploy.*;
     * EC2TagSetListObjectProperty eC2TagSetListObjectProperty = EC2TagSetListObjectProperty.builder()
     *         .ec2TagGroup(List.of(EC2TagFilterProperty.builder()
     *                 .key("key")
     *                 .type("type")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroup.EC2TagSetListObjectProperty")
    @software.amazon.jsii.Jsii.Proxy(EC2TagSetListObjectProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EC2TagSetListObjectProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list that contains other lists of Amazon EC2 instance tag groups.
         * <p>
         * For an instance to be included in the deployment group, it must be identified by all of the tag groups in the list.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEc2TagGroup() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EC2TagSetListObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EC2TagSetListObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EC2TagSetListObjectProperty> {
            java.lang.Object ec2TagGroup;

            /**
             * Sets the value of {@link EC2TagSetListObjectProperty#getEc2TagGroup}
             * @param ec2TagGroup A list that contains other lists of Amazon EC2 instance tag groups.
             *                    For an instance to be included in the deployment group, it must be identified by all of the tag groups in the list.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ec2TagGroup(software.amazon.awscdk.core.IResolvable ec2TagGroup) {
                this.ec2TagGroup = ec2TagGroup;
                return this;
            }

            /**
             * Sets the value of {@link EC2TagSetListObjectProperty#getEc2TagGroup}
             * @param ec2TagGroup A list that contains other lists of Amazon EC2 instance tag groups.
             *                    For an instance to be included in the deployment group, it must be identified by all of the tag groups in the list.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ec2TagGroup(java.util.List<? extends java.lang.Object> ec2TagGroup) {
                this.ec2TagGroup = ec2TagGroup;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EC2TagSetListObjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EC2TagSetListObjectProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EC2TagSetListObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EC2TagSetListObjectProperty {
            private final java.lang.Object ec2TagGroup;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ec2TagGroup = software.amazon.jsii.Kernel.get(this, "ec2TagGroup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ec2TagGroup = builder.ec2TagGroup;
            }

            @Override
            public final java.lang.Object getEc2TagGroup() {
                return this.ec2TagGroup;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEc2TagGroup() != null) {
                    data.set("ec2TagGroup", om.valueToTree(this.getEc2TagGroup()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.CfnDeploymentGroup.EC2TagSetListObjectProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EC2TagSetListObjectProperty.Jsii$Proxy that = (EC2TagSetListObjectProperty.Jsii$Proxy) o;

                return this.ec2TagGroup != null ? this.ec2TagGroup.equals(that.ec2TagGroup) : that.ec2TagGroup == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ec2TagGroup != null ? this.ec2TagGroup.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The `EC2TagSet` property type specifies information about groups of tags applied to Amazon EC2 instances.
     * <p>
     * The deployment group includes only Amazon EC2 instances identified by all the tag groups. <code>EC2TagSet</code> cannot be used in the same template as <code>EC2TagFilter</code> .
     * <p>
     * For information about using tags and tag groups to help manage your Amazon EC2 instances and on-premises instances, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-tagging.html">Tagging Instances for Deployment Groups in AWS CodeDeploy</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codedeploy.*;
     * EC2TagSetProperty eC2TagSetProperty = EC2TagSetProperty.builder()
     *         .ec2TagSetList(List.of(EC2TagSetListObjectProperty.builder()
     *                 .ec2TagGroup(List.of(EC2TagFilterProperty.builder()
     *                         .key("key")
     *                         .type("type")
     *                         .value("value")
     *                         .build()))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroup.EC2TagSetProperty")
    @software.amazon.jsii.Jsii.Proxy(EC2TagSetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EC2TagSetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon EC2 tags that are already applied to Amazon EC2 instances that you want to include in the deployment group.
         * <p>
         * CodeDeploy includes all Amazon EC2 instances identified by any of the tags you specify in this deployment group.
         * <p>
         * Duplicates are not allowed.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEc2TagSetList() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EC2TagSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EC2TagSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EC2TagSetProperty> {
            java.lang.Object ec2TagSetList;

            /**
             * Sets the value of {@link EC2TagSetProperty#getEc2TagSetList}
             * @param ec2TagSetList The Amazon EC2 tags that are already applied to Amazon EC2 instances that you want to include in the deployment group.
             *                      CodeDeploy includes all Amazon EC2 instances identified by any of the tags you specify in this deployment group.
             *                      <p>
             *                      Duplicates are not allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ec2TagSetList(software.amazon.awscdk.core.IResolvable ec2TagSetList) {
                this.ec2TagSetList = ec2TagSetList;
                return this;
            }

            /**
             * Sets the value of {@link EC2TagSetProperty#getEc2TagSetList}
             * @param ec2TagSetList The Amazon EC2 tags that are already applied to Amazon EC2 instances that you want to include in the deployment group.
             *                      CodeDeploy includes all Amazon EC2 instances identified by any of the tags you specify in this deployment group.
             *                      <p>
             *                      Duplicates are not allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ec2TagSetList(java.util.List<? extends java.lang.Object> ec2TagSetList) {
                this.ec2TagSetList = ec2TagSetList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EC2TagSetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EC2TagSetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EC2TagSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EC2TagSetProperty {
            private final java.lang.Object ec2TagSetList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ec2TagSetList = software.amazon.jsii.Kernel.get(this, "ec2TagSetList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ec2TagSetList = builder.ec2TagSetList;
            }

            @Override
            public final java.lang.Object getEc2TagSetList() {
                return this.ec2TagSetList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEc2TagSetList() != null) {
                    data.set("ec2TagSetList", om.valueToTree(this.getEc2TagSetList()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.CfnDeploymentGroup.EC2TagSetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EC2TagSetProperty.Jsii$Proxy that = (EC2TagSetProperty.Jsii$Proxy) o;

                return this.ec2TagSetList != null ? this.ec2TagSetList.equals(that.ec2TagSetList) : that.ec2TagSetList == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ec2TagSetList != null ? this.ec2TagSetList.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Contains the service and cluster names used to identify an Amazon ECS deployment's target.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codedeploy.*;
     * ECSServiceProperty eCSServiceProperty = ECSServiceProperty.builder()
     *         .clusterName("clusterName")
     *         .serviceName("serviceName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroup.ECSServiceProperty")
    @software.amazon.jsii.Jsii.Proxy(ECSServiceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ECSServiceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the cluster that the Amazon ECS service is associated with.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClusterName();

        /**
         * The name of the target Amazon ECS service.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getServiceName();

        /**
         * @return a {@link Builder} of {@link ECSServiceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ECSServiceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ECSServiceProperty> {
            java.lang.String clusterName;
            java.lang.String serviceName;

            /**
             * Sets the value of {@link ECSServiceProperty#getClusterName}
             * @param clusterName The name of the cluster that the Amazon ECS service is associated with. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterName(java.lang.String clusterName) {
                this.clusterName = clusterName;
                return this;
            }

            /**
             * Sets the value of {@link ECSServiceProperty#getServiceName}
             * @param serviceName The name of the target Amazon ECS service. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceName(java.lang.String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ECSServiceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ECSServiceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ECSServiceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ECSServiceProperty {
            private final java.lang.String clusterName;
            private final java.lang.String serviceName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceName = software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clusterName = java.util.Objects.requireNonNull(builder.clusterName, "clusterName is required");
                this.serviceName = java.util.Objects.requireNonNull(builder.serviceName, "serviceName is required");
            }

            @Override
            public final java.lang.String getClusterName() {
                return this.clusterName;
            }

            @Override
            public final java.lang.String getServiceName() {
                return this.serviceName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clusterName", om.valueToTree(this.getClusterName()));
                data.set("serviceName", om.valueToTree(this.getServiceName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.CfnDeploymentGroup.ECSServiceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ECSServiceProperty.Jsii$Proxy that = (ECSServiceProperty.Jsii$Proxy) o;

                if (!clusterName.equals(that.clusterName)) return false;
                return this.serviceName.equals(that.serviceName);
            }

            @Override
            public final int hashCode() {
                int result = this.clusterName.hashCode();
                result = 31 * result + (this.serviceName.hashCode());
                return result;
            }
        }
    }
    /**
     * The `ELBInfo` property type specifies information about the Elastic Load Balancing load balancer used for an CodeDeploy deployment group.
     * <p>
     * If you specify the <code>ELBInfo</code> property, the <code>DeploymentStyle.DeploymentOption</code> property must be set to <code>WITH_TRAFFIC_CONTROL</code> for AWS CodeDeploy to route your traffic using the specified load balancers.
     * <p>
     * <code>ELBInfo</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html">AWS CodeDeploy DeploymentGroup LoadBalancerInfo</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codedeploy.*;
     * ELBInfoProperty eLBInfoProperty = ELBInfoProperty.builder()
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroup.ELBInfoProperty")
    @software.amazon.jsii.Jsii.Proxy(ELBInfoProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ELBInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * For blue/green deployments, the name of the load balancer that is used to route traffic from original instances to replacement instances in a blue/green deployment.
         * <p>
         * For in-place deployments, the name of the load balancer that instances are deregistered from so they are not serving traffic during a deployment, and then re-registered with after the deployment is complete.
         * <p>
         * <blockquote>
         * <p>
         * AWS CloudFormation supports blue/green deployments on AWS Lambda compute platforms only.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ELBInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ELBInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ELBInfoProperty> {
            java.lang.String name;

            /**
             * Sets the value of {@link ELBInfoProperty#getName}
             * @param name For blue/green deployments, the name of the load balancer that is used to route traffic from original instances to replacement instances in a blue/green deployment.
             *             For in-place deployments, the name of the load balancer that instances are deregistered from so they are not serving traffic during a deployment, and then re-registered with after the deployment is complete.
             *             <p>
             *             <blockquote>
             *             <p>
             *             AWS CloudFormation supports blue/green deployments on AWS Lambda compute platforms only.
             *             <p>
             *             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ELBInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ELBInfoProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ELBInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ELBInfoProperty {
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.CfnDeploymentGroup.ELBInfoProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ELBInfoProperty.Jsii$Proxy that = (ELBInfoProperty.Jsii$Proxy) o;

                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * `GitHubLocation` is a property of the [CodeDeploy DeploymentGroup Revision](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html) property that specifies the location of an application revision that is stored in GitHub.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codedeploy.*;
     * GitHubLocationProperty gitHubLocationProperty = GitHubLocationProperty.builder()
     *         .commitId("commitId")
     *         .repository("repository")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroup.GitHubLocationProperty")
    @software.amazon.jsii.Jsii.Proxy(GitHubLocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GitHubLocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The SHA1 commit ID of the GitHub commit that represents the bundled artifacts for the application revision.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCommitId();

        /**
         * The GitHub account and repository pair that stores a reference to the commit that represents the bundled artifacts for the application revision.
         * <p>
         * Specify the value as <code>account/repository</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRepository();

        /**
         * @return a {@link Builder} of {@link GitHubLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GitHubLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GitHubLocationProperty> {
            java.lang.String commitId;
            java.lang.String repository;

            /**
             * Sets the value of {@link GitHubLocationProperty#getCommitId}
             * @param commitId The SHA1 commit ID of the GitHub commit that represents the bundled artifacts for the application revision. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder commitId(java.lang.String commitId) {
                this.commitId = commitId;
                return this;
            }

            /**
             * Sets the value of {@link GitHubLocationProperty#getRepository}
             * @param repository The GitHub account and repository pair that stores a reference to the commit that represents the bundled artifacts for the application revision. This parameter is required.
             *                   Specify the value as <code>account/repository</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repository(java.lang.String repository) {
                this.repository = repository;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GitHubLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GitHubLocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GitHubLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GitHubLocationProperty {
            private final java.lang.String commitId;
            private final java.lang.String repository;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.commitId = software.amazon.jsii.Kernel.get(this, "commitId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.repository = software.amazon.jsii.Kernel.get(this, "repository", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.commitId = java.util.Objects.requireNonNull(builder.commitId, "commitId is required");
                this.repository = java.util.Objects.requireNonNull(builder.repository, "repository is required");
            }

            @Override
            public final java.lang.String getCommitId() {
                return this.commitId;
            }

            @Override
            public final java.lang.String getRepository() {
                return this.repository;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("commitId", om.valueToTree(this.getCommitId()));
                data.set("repository", om.valueToTree(this.getRepository()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.CfnDeploymentGroup.GitHubLocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GitHubLocationProperty.Jsii$Proxy that = (GitHubLocationProperty.Jsii$Proxy) o;

                if (!commitId.equals(that.commitId)) return false;
                return this.repository.equals(that.repository);
            }

            @Override
            public final int hashCode() {
                int result = this.commitId.hashCode();
                result = 31 * result + (this.repository.hashCode());
                return result;
            }
        }
    }
    /**
     * Information about the instances that belong to the replacement environment in a blue/green deployment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codedeploy.*;
     * GreenFleetProvisioningOptionProperty greenFleetProvisioningOptionProperty = GreenFleetProvisioningOptionProperty.builder()
     *         .action("action")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroup.GreenFleetProvisioningOptionProperty")
    @software.amazon.jsii.Jsii.Proxy(GreenFleetProvisioningOptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GreenFleetProvisioningOptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The method used to add instances to a replacement environment.
         * <p>
         * <ul>
         * <li><code>DISCOVER_EXISTING</code> : Use instances that already exist or will be created manually.</li>
         * <li><code>COPY_AUTO_SCALING_GROUP</code> : Use settings from a specified Auto Scaling group to define and create instances in a new Auto Scaling group.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAction() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GreenFleetProvisioningOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GreenFleetProvisioningOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GreenFleetProvisioningOptionProperty> {
            java.lang.String action;

            /**
             * Sets the value of {@link GreenFleetProvisioningOptionProperty#getAction}
             * @param action The method used to add instances to a replacement environment.
             *               <ul>
             *               <li><code>DISCOVER_EXISTING</code> : Use instances that already exist or will be created manually.</li>
             *               <li><code>COPY_AUTO_SCALING_GROUP</code> : Use settings from a specified Auto Scaling group to define and create instances in a new Auto Scaling group.</li>
             *               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GreenFleetProvisioningOptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GreenFleetProvisioningOptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GreenFleetProvisioningOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GreenFleetProvisioningOptionProperty {
            private final java.lang.String action;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = builder.action;
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAction() != null) {
                    data.set("action", om.valueToTree(this.getAction()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.CfnDeploymentGroup.GreenFleetProvisioningOptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GreenFleetProvisioningOptionProperty.Jsii$Proxy that = (GreenFleetProvisioningOptionProperty.Jsii$Proxy) o;

                return this.action != null ? this.action.equals(that.action) : that.action == null;
            }

            @Override
            public final int hashCode() {
                int result = this.action != null ? this.action.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The `LoadBalancerInfo` property type specifies information about the load balancer or target group used for an AWS CodeDeploy deployment group.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-elastic-load-balancing.html">Integrating CodeDeploy with Elastic Load Balancing</a> in the <em>AWS CodeDeploy User Guide</em> .
     * <p>
     * For AWS CloudFormation to use the properties specified in <code>LoadBalancerInfo</code> , the <code>DeploymentStyle.DeploymentOption</code> property must be set to <code>WITH_TRAFFIC_CONTROL</code> . If <code>DeploymentStyle.DeploymentOption</code> is not set to <code>WITH_TRAFFIC_CONTROL</code> , AWS CloudFormation ignores any settings specified in <code>LoadBalancerInfo</code> .
     * <p>
     * <blockquote>
     * <p>
     * AWS CloudFormation supports blue/green deployments on the AWS Lambda compute platform only.
     * <p>
     * </blockquote>
     * <p>
     * <code>LoadBalancerInfo</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html">DeploymentGroup</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codedeploy.*;
     * LoadBalancerInfoProperty loadBalancerInfoProperty = LoadBalancerInfoProperty.builder()
     *         .elbInfoList(List.of(ELBInfoProperty.builder()
     *                 .name("name")
     *                 .build()))
     *         .targetGroupInfoList(List.of(TargetGroupInfoProperty.builder()
     *                 .name("name")
     *                 .build()))
     *         .targetGroupPairInfoList(List.of(TargetGroupPairInfoProperty.builder()
     *                 .prodTrafficRoute(TrafficRouteProperty.builder()
     *                         .listenerArns(List.of("listenerArns"))
     *                         .build())
     *                 .targetGroups(List.of(TargetGroupInfoProperty.builder()
     *                         .name("name")
     *                         .build()))
     *                 .testTrafficRoute(TrafficRouteProperty.builder()
     *                         .listenerArns(List.of("listenerArns"))
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroup.LoadBalancerInfoProperty")
    @software.amazon.jsii.Jsii.Proxy(LoadBalancerInfoProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoadBalancerInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array that contains information about the load balancer to use for load balancing in a deployment.
         * <p>
         * In Elastic Load Balancing, load balancers are used with Classic Load Balancers.
         * <p>
         * <blockquote>
         * <p>
         * Adding more than one load balancer to the array is not supported.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getElbInfoList() {
            return null;
        }

        /**
         * An array that contains information about the target group to use for load balancing in a deployment.
         * <p>
         * In Elastic Load Balancing , target groups are used with Application Load Balancers .
         * <p>
         * <blockquote>
         * <p>
         * Adding more than one target group to the array is not supported.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTargetGroupInfoList() {
            return null;
        }

        /**
         * The target group pair information.
         * <p>
         * This is an array of <code>TargeGroupPairInfo</code> objects with a maximum size of one.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTargetGroupPairInfoList() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoadBalancerInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoadBalancerInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoadBalancerInfoProperty> {
            java.lang.Object elbInfoList;
            java.lang.Object targetGroupInfoList;
            java.lang.Object targetGroupPairInfoList;

            /**
             * Sets the value of {@link LoadBalancerInfoProperty#getElbInfoList}
             * @param elbInfoList An array that contains information about the load balancer to use for load balancing in a deployment.
             *                    In Elastic Load Balancing, load balancers are used with Classic Load Balancers.
             *                    <p>
             *                    <blockquote>
             *                    <p>
             *                    Adding more than one load balancer to the array is not supported.
             *                    <p>
             *                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elbInfoList(software.amazon.awscdk.core.IResolvable elbInfoList) {
                this.elbInfoList = elbInfoList;
                return this;
            }

            /**
             * Sets the value of {@link LoadBalancerInfoProperty#getElbInfoList}
             * @param elbInfoList An array that contains information about the load balancer to use for load balancing in a deployment.
             *                    In Elastic Load Balancing, load balancers are used with Classic Load Balancers.
             *                    <p>
             *                    <blockquote>
             *                    <p>
             *                    Adding more than one load balancer to the array is not supported.
             *                    <p>
             *                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elbInfoList(java.util.List<? extends java.lang.Object> elbInfoList) {
                this.elbInfoList = elbInfoList;
                return this;
            }

            /**
             * Sets the value of {@link LoadBalancerInfoProperty#getTargetGroupInfoList}
             * @param targetGroupInfoList An array that contains information about the target group to use for load balancing in a deployment.
             *                            In Elastic Load Balancing , target groups are used with Application Load Balancers .
             *                            <p>
             *                            <blockquote>
             *                            <p>
             *                            Adding more than one target group to the array is not supported.
             *                            <p>
             *                            </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroupInfoList(software.amazon.awscdk.core.IResolvable targetGroupInfoList) {
                this.targetGroupInfoList = targetGroupInfoList;
                return this;
            }

            /**
             * Sets the value of {@link LoadBalancerInfoProperty#getTargetGroupInfoList}
             * @param targetGroupInfoList An array that contains information about the target group to use for load balancing in a deployment.
             *                            In Elastic Load Balancing , target groups are used with Application Load Balancers .
             *                            <p>
             *                            <blockquote>
             *                            <p>
             *                            Adding more than one target group to the array is not supported.
             *                            <p>
             *                            </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroupInfoList(java.util.List<? extends java.lang.Object> targetGroupInfoList) {
                this.targetGroupInfoList = targetGroupInfoList;
                return this;
            }

            /**
             * Sets the value of {@link LoadBalancerInfoProperty#getTargetGroupPairInfoList}
             * @param targetGroupPairInfoList The target group pair information.
             *                                This is an array of <code>TargeGroupPairInfo</code> objects with a maximum size of one.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroupPairInfoList(software.amazon.awscdk.core.IResolvable targetGroupPairInfoList) {
                this.targetGroupPairInfoList = targetGroupPairInfoList;
                return this;
            }

            /**
             * Sets the value of {@link LoadBalancerInfoProperty#getTargetGroupPairInfoList}
             * @param targetGroupPairInfoList The target group pair information.
             *                                This is an array of <code>TargeGroupPairInfo</code> objects with a maximum size of one.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroupPairInfoList(java.util.List<? extends java.lang.Object> targetGroupPairInfoList) {
                this.targetGroupPairInfoList = targetGroupPairInfoList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoadBalancerInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoadBalancerInfoProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoadBalancerInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoadBalancerInfoProperty {
            private final java.lang.Object elbInfoList;
            private final java.lang.Object targetGroupInfoList;
            private final java.lang.Object targetGroupPairInfoList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.elbInfoList = software.amazon.jsii.Kernel.get(this, "elbInfoList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.targetGroupInfoList = software.amazon.jsii.Kernel.get(this, "targetGroupInfoList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.targetGroupPairInfoList = software.amazon.jsii.Kernel.get(this, "targetGroupPairInfoList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.elbInfoList = builder.elbInfoList;
                this.targetGroupInfoList = builder.targetGroupInfoList;
                this.targetGroupPairInfoList = builder.targetGroupPairInfoList;
            }

            @Override
            public final java.lang.Object getElbInfoList() {
                return this.elbInfoList;
            }

            @Override
            public final java.lang.Object getTargetGroupInfoList() {
                return this.targetGroupInfoList;
            }

            @Override
            public final java.lang.Object getTargetGroupPairInfoList() {
                return this.targetGroupPairInfoList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getElbInfoList() != null) {
                    data.set("elbInfoList", om.valueToTree(this.getElbInfoList()));
                }
                if (this.getTargetGroupInfoList() != null) {
                    data.set("targetGroupInfoList", om.valueToTree(this.getTargetGroupInfoList()));
                }
                if (this.getTargetGroupPairInfoList() != null) {
                    data.set("targetGroupPairInfoList", om.valueToTree(this.getTargetGroupPairInfoList()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.CfnDeploymentGroup.LoadBalancerInfoProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoadBalancerInfoProperty.Jsii$Proxy that = (LoadBalancerInfoProperty.Jsii$Proxy) o;

                if (this.elbInfoList != null ? !this.elbInfoList.equals(that.elbInfoList) : that.elbInfoList != null) return false;
                if (this.targetGroupInfoList != null ? !this.targetGroupInfoList.equals(that.targetGroupInfoList) : that.targetGroupInfoList != null) return false;
                return this.targetGroupPairInfoList != null ? this.targetGroupPairInfoList.equals(that.targetGroupPairInfoList) : that.targetGroupPairInfoList == null;
            }

            @Override
            public final int hashCode() {
                int result = this.elbInfoList != null ? this.elbInfoList.hashCode() : 0;
                result = 31 * result + (this.targetGroupInfoList != null ? this.targetGroupInfoList.hashCode() : 0);
                result = 31 * result + (this.targetGroupPairInfoList != null ? this.targetGroupPairInfoList.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `OnPremisesTagSetListObject` property type specifies lists of on-premises instance tag groups.
     * <p>
     * In order for an instance to be included in the deployment group, it must be identified by all the tag groups in the list.
     * <p>
     * <code>OnPremisesTagSetListObject</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisestagset.html">CodeDeploy DeploymentGroup OnPremisesTagSet</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codedeploy.*;
     * OnPremisesTagSetListObjectProperty onPremisesTagSetListObjectProperty = OnPremisesTagSetListObjectProperty.builder()
     *         .onPremisesTagGroup(List.of(TagFilterProperty.builder()
     *                 .key("key")
     *                 .type("type")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroup.OnPremisesTagSetListObjectProperty")
    @software.amazon.jsii.Jsii.Proxy(OnPremisesTagSetListObjectProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OnPremisesTagSetListObjectProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information about groups of on-premises instance tags.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOnPremisesTagGroup() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OnPremisesTagSetListObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OnPremisesTagSetListObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OnPremisesTagSetListObjectProperty> {
            java.lang.Object onPremisesTagGroup;

            /**
             * Sets the value of {@link OnPremisesTagSetListObjectProperty#getOnPremisesTagGroup}
             * @param onPremisesTagGroup Information about groups of on-premises instance tags.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onPremisesTagGroup(software.amazon.awscdk.core.IResolvable onPremisesTagGroup) {
                this.onPremisesTagGroup = onPremisesTagGroup;
                return this;
            }

            /**
             * Sets the value of {@link OnPremisesTagSetListObjectProperty#getOnPremisesTagGroup}
             * @param onPremisesTagGroup Information about groups of on-premises instance tags.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onPremisesTagGroup(java.util.List<? extends java.lang.Object> onPremisesTagGroup) {
                this.onPremisesTagGroup = onPremisesTagGroup;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OnPremisesTagSetListObjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OnPremisesTagSetListObjectProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OnPremisesTagSetListObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OnPremisesTagSetListObjectProperty {
            private final java.lang.Object onPremisesTagGroup;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.onPremisesTagGroup = software.amazon.jsii.Kernel.get(this, "onPremisesTagGroup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.onPremisesTagGroup = builder.onPremisesTagGroup;
            }

            @Override
            public final java.lang.Object getOnPremisesTagGroup() {
                return this.onPremisesTagGroup;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOnPremisesTagGroup() != null) {
                    data.set("onPremisesTagGroup", om.valueToTree(this.getOnPremisesTagGroup()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.CfnDeploymentGroup.OnPremisesTagSetListObjectProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OnPremisesTagSetListObjectProperty.Jsii$Proxy that = (OnPremisesTagSetListObjectProperty.Jsii$Proxy) o;

                return this.onPremisesTagGroup != null ? this.onPremisesTagGroup.equals(that.onPremisesTagGroup) : that.onPremisesTagGroup == null;
            }

            @Override
            public final int hashCode() {
                int result = this.onPremisesTagGroup != null ? this.onPremisesTagGroup.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The `OnPremisesTagSet` property type specifies a list containing other lists of on-premises instance tag groups.
     * <p>
     * In order for an instance to be included in the deployment group, it must be identified by all the tag groups in the list.
     * <p>
     * For more information about using tags and tag groups to help manage your Amazon EC2 instances and on-premises instances, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-tagging.html">Tagging Instances for Deployment Groups in AWS CodeDeploy</a> in the <em>AWS CodeDeploy User Guide</em> .
     * <p>
     * <code>OnPremisesTagSet</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html">DeploymentGroup</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codedeploy.*;
     * OnPremisesTagSetProperty onPremisesTagSetProperty = OnPremisesTagSetProperty.builder()
     *         .onPremisesTagSetList(List.of(OnPremisesTagSetListObjectProperty.builder()
     *                 .onPremisesTagGroup(List.of(TagFilterProperty.builder()
     *                         .key("key")
     *                         .type("type")
     *                         .value("value")
     *                         .build()))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroup.OnPremisesTagSetProperty")
    @software.amazon.jsii.Jsii.Proxy(OnPremisesTagSetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OnPremisesTagSetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list that contains other lists of on-premises instance tag groups.
         * <p>
         * For an instance to be included in the deployment group, it must be identified by all of the tag groups in the list.
         * <p>
         * Duplicates are not allowed.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOnPremisesTagSetList() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OnPremisesTagSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OnPremisesTagSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OnPremisesTagSetProperty> {
            java.lang.Object onPremisesTagSetList;

            /**
             * Sets the value of {@link OnPremisesTagSetProperty#getOnPremisesTagSetList}
             * @param onPremisesTagSetList A list that contains other lists of on-premises instance tag groups.
             *                             For an instance to be included in the deployment group, it must be identified by all of the tag groups in the list.
             *                             <p>
             *                             Duplicates are not allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onPremisesTagSetList(software.amazon.awscdk.core.IResolvable onPremisesTagSetList) {
                this.onPremisesTagSetList = onPremisesTagSetList;
                return this;
            }

            /**
             * Sets the value of {@link OnPremisesTagSetProperty#getOnPremisesTagSetList}
             * @param onPremisesTagSetList A list that contains other lists of on-premises instance tag groups.
             *                             For an instance to be included in the deployment group, it must be identified by all of the tag groups in the list.
             *                             <p>
             *                             Duplicates are not allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onPremisesTagSetList(java.util.List<? extends java.lang.Object> onPremisesTagSetList) {
                this.onPremisesTagSetList = onPremisesTagSetList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OnPremisesTagSetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OnPremisesTagSetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OnPremisesTagSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OnPremisesTagSetProperty {
            private final java.lang.Object onPremisesTagSetList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.onPremisesTagSetList = software.amazon.jsii.Kernel.get(this, "onPremisesTagSetList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.onPremisesTagSetList = builder.onPremisesTagSetList;
            }

            @Override
            public final java.lang.Object getOnPremisesTagSetList() {
                return this.onPremisesTagSetList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOnPremisesTagSetList() != null) {
                    data.set("onPremisesTagSetList", om.valueToTree(this.getOnPremisesTagSetList()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.CfnDeploymentGroup.OnPremisesTagSetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OnPremisesTagSetProperty.Jsii$Proxy that = (OnPremisesTagSetProperty.Jsii$Proxy) o;

                return this.onPremisesTagSetList != null ? this.onPremisesTagSetList.equals(that.onPremisesTagSetList) : that.onPremisesTagSetList == null;
            }

            @Override
            public final int hashCode() {
                int result = this.onPremisesTagSetList != null ? this.onPremisesTagSetList.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * `RevisionLocation` is a property that defines the location of the CodeDeploy application revision to deploy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codedeploy.*;
     * RevisionLocationProperty revisionLocationProperty = RevisionLocationProperty.builder()
     *         .gitHubLocation(GitHubLocationProperty.builder()
     *                 .commitId("commitId")
     *                 .repository("repository")
     *                 .build())
     *         .revisionType("revisionType")
     *         .s3Location(S3LocationProperty.builder()
     *                 .bucket("bucket")
     *                 .key("key")
     *                 // the properties below are optional
     *                 .bundleType("bundleType")
     *                 .eTag("eTag")
     *                 .version("version")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroup.RevisionLocationProperty")
    @software.amazon.jsii.Jsii.Proxy(RevisionLocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RevisionLocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information about the location of application artifacts stored in GitHub.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGitHubLocation() {
            return null;
        }

        /**
         * The type of application revision:.
         * <p>
         * <ul>
         * <li>S3: An application revision stored in Amazon S3.</li>
         * <li>GitHub: An application revision stored in GitHub (EC2/On-premises deployments only).</li>
         * <li>String: A YAML-formatted or JSON-formatted string ( AWS Lambda deployments only).</li>
         * <li>AppSpecContent: An <code>AppSpecContent</code> object that contains the contents of an AppSpec file for an AWS Lambda or Amazon ECS deployment. The content is formatted as JSON or YAML stored as a RawString.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRevisionType() {
            return null;
        }

        /**
         * Information about the location of a revision stored in Amazon S3.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Location() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RevisionLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RevisionLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RevisionLocationProperty> {
            java.lang.Object gitHubLocation;
            java.lang.String revisionType;
            java.lang.Object s3Location;

            /**
             * Sets the value of {@link RevisionLocationProperty#getGitHubLocation}
             * @param gitHubLocation Information about the location of application artifacts stored in GitHub.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gitHubLocation(software.amazon.awscdk.core.IResolvable gitHubLocation) {
                this.gitHubLocation = gitHubLocation;
                return this;
            }

            /**
             * Sets the value of {@link RevisionLocationProperty#getGitHubLocation}
             * @param gitHubLocation Information about the location of application artifacts stored in GitHub.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gitHubLocation(software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.GitHubLocationProperty gitHubLocation) {
                this.gitHubLocation = gitHubLocation;
                return this;
            }

            /**
             * Sets the value of {@link RevisionLocationProperty#getRevisionType}
             * @param revisionType The type of application revision:.
             *                     <ul>
             *                     <li>S3: An application revision stored in Amazon S3.</li>
             *                     <li>GitHub: An application revision stored in GitHub (EC2/On-premises deployments only).</li>
             *                     <li>String: A YAML-formatted or JSON-formatted string ( AWS Lambda deployments only).</li>
             *                     <li>AppSpecContent: An <code>AppSpecContent</code> object that contains the contents of an AppSpec file for an AWS Lambda or Amazon ECS deployment. The content is formatted as JSON or YAML stored as a RawString.</li>
             *                     </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder revisionType(java.lang.String revisionType) {
                this.revisionType = revisionType;
                return this;
            }

            /**
             * Sets the value of {@link RevisionLocationProperty#getS3Location}
             * @param s3Location Information about the location of a revision stored in Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Location(software.amazon.awscdk.core.IResolvable s3Location) {
                this.s3Location = s3Location;
                return this;
            }

            /**
             * Sets the value of {@link RevisionLocationProperty#getS3Location}
             * @param s3Location Information about the location of a revision stored in Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Location(software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.S3LocationProperty s3Location) {
                this.s3Location = s3Location;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RevisionLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RevisionLocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RevisionLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RevisionLocationProperty {
            private final java.lang.Object gitHubLocation;
            private final java.lang.String revisionType;
            private final java.lang.Object s3Location;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.gitHubLocation = software.amazon.jsii.Kernel.get(this, "gitHubLocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.revisionType = software.amazon.jsii.Kernel.get(this, "revisionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Location = software.amazon.jsii.Kernel.get(this, "s3Location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.gitHubLocation = builder.gitHubLocation;
                this.revisionType = builder.revisionType;
                this.s3Location = builder.s3Location;
            }

            @Override
            public final java.lang.Object getGitHubLocation() {
                return this.gitHubLocation;
            }

            @Override
            public final java.lang.String getRevisionType() {
                return this.revisionType;
            }

            @Override
            public final java.lang.Object getS3Location() {
                return this.s3Location;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGitHubLocation() != null) {
                    data.set("gitHubLocation", om.valueToTree(this.getGitHubLocation()));
                }
                if (this.getRevisionType() != null) {
                    data.set("revisionType", om.valueToTree(this.getRevisionType()));
                }
                if (this.getS3Location() != null) {
                    data.set("s3Location", om.valueToTree(this.getS3Location()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.CfnDeploymentGroup.RevisionLocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RevisionLocationProperty.Jsii$Proxy that = (RevisionLocationProperty.Jsii$Proxy) o;

                if (this.gitHubLocation != null ? !this.gitHubLocation.equals(that.gitHubLocation) : that.gitHubLocation != null) return false;
                if (this.revisionType != null ? !this.revisionType.equals(that.revisionType) : that.revisionType != null) return false;
                return this.s3Location != null ? this.s3Location.equals(that.s3Location) : that.s3Location == null;
            }

            @Override
            public final int hashCode() {
                int result = this.gitHubLocation != null ? this.gitHubLocation.hashCode() : 0;
                result = 31 * result + (this.revisionType != null ? this.revisionType.hashCode() : 0);
                result = 31 * result + (this.s3Location != null ? this.s3Location.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `S3Location` is a property of the [CodeDeploy DeploymentGroup Revision](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html) property that specifies the location of an application revision that is stored in Amazon Simple Storage Service ( Amazon S3 ).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codedeploy.*;
     * S3LocationProperty s3LocationProperty = S3LocationProperty.builder()
     *         .bucket("bucket")
     *         .key("key")
     *         // the properties below are optional
     *         .bundleType("bundleType")
     *         .eTag("eTag")
     *         .version("version")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroup.S3LocationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3LocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the Amazon S3 bucket where the application revision is stored.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * The name of the Amazon S3 object that represents the bundled artifacts for the application revision.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The file type of the application revision. Must be one of the following:.
         * <p>
         * <ul>
         * <li>JSON</li>
         * <li>tar: A tar archive file.</li>
         * <li>tgz: A compressed tar archive file.</li>
         * <li>YAML</li>
         * <li>zip: A zip archive file.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBundleType() {
            return null;
        }

        /**
         * The ETag of the Amazon S3 object that represents the bundled artifacts for the application revision.
         * <p>
         * If the ETag is not specified as an input parameter, ETag validation of the object is skipped.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getETag() {
            return null;
        }

        /**
         * A specific version of the Amazon S3 object that represents the bundled artifacts for the application revision.
         * <p>
         * If the version is not specified, the system uses the most recent version by default.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3LocationProperty> {
            java.lang.String bucket;
            java.lang.String key;
            java.lang.String bundleType;
            java.lang.String eTag;
            java.lang.String version;

            /**
             * Sets the value of {@link S3LocationProperty#getBucket}
             * @param bucket The name of the Amazon S3 bucket where the application revision is stored. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getKey}
             * @param key The name of the Amazon S3 object that represents the bundled artifacts for the application revision. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getBundleType}
             * @param bundleType The file type of the application revision. Must be one of the following:.
             *                   <ul>
             *                   <li>JSON</li>
             *                   <li>tar: A tar archive file.</li>
             *                   <li>tgz: A compressed tar archive file.</li>
             *                   <li>YAML</li>
             *                   <li>zip: A zip archive file.</li>
             *                   </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bundleType(java.lang.String bundleType) {
                this.bundleType = bundleType;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getETag}
             * @param eTag The ETag of the Amazon S3 object that represents the bundled artifacts for the application revision.
             *             If the ETag is not specified as an input parameter, ETag validation of the object is skipped.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eTag(java.lang.String eTag) {
                this.eTag = eTag;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getVersion}
             * @param version A specific version of the Amazon S3 object that represents the bundled artifacts for the application revision.
             *                If the version is not specified, the system uses the most recent version by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3LocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3LocationProperty {
            private final java.lang.String bucket;
            private final java.lang.String key;
            private final java.lang.String bundleType;
            private final java.lang.String eTag;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bundleType = software.amazon.jsii.Kernel.get(this, "bundleType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.eTag = software.amazon.jsii.Kernel.get(this, "eTag", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.bundleType = builder.bundleType;
                this.eTag = builder.eTag;
                this.version = builder.version;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getBundleType() {
                return this.bundleType;
            }

            @Override
            public final java.lang.String getETag() {
                return this.eTag;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                data.set("key", om.valueToTree(this.getKey()));
                if (this.getBundleType() != null) {
                    data.set("bundleType", om.valueToTree(this.getBundleType()));
                }
                if (this.getETag() != null) {
                    data.set("eTag", om.valueToTree(this.getETag()));
                }
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.CfnDeploymentGroup.S3LocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3LocationProperty.Jsii$Proxy that = (S3LocationProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (!key.equals(that.key)) return false;
                if (this.bundleType != null ? !this.bundleType.equals(that.bundleType) : that.bundleType != null) return false;
                if (this.eTag != null ? !this.eTag.equals(that.eTag) : that.eTag != null) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.key.hashCode());
                result = 31 * result + (this.bundleType != null ? this.bundleType.hashCode() : 0);
                result = 31 * result + (this.eTag != null ? this.eTag.hashCode() : 0);
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `TagFilter` is a property type of the [AWS::CodeDeploy::DeploymentGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html) resource that specifies which on-premises instances to associate with the deployment group. To register on-premise instances with AWS CodeDeploy , see [Configure Existing On-Premises Instances by Using AWS CodeDeploy](https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-on-premises.html) in the *AWS CodeDeploy User Guide* .
     * <p>
     * For more information about using tags and tag groups to help manage your Amazon EC2 instances and on-premises instances, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-tagging.html">Tagging Instances for Deployment Groups in AWS CodeDeploy</a> in the <em>AWS CodeDeploy User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codedeploy.*;
     * TagFilterProperty tagFilterProperty = TagFilterProperty.builder()
     *         .key("key")
     *         .type("type")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroup.TagFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(TagFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TagFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The on-premises instance tag filter key.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * The on-premises instance tag filter type:.
         * <p>
         * <ul>
         * <li>KEY_ONLY: Key only.</li>
         * <li>VALUE_ONLY: Value only.</li>
         * <li>KEY_AND_VALUE: Key and value.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * The on-premises instance tag filter value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TagFilterProperty> {
            java.lang.String key;
            java.lang.String type;
            java.lang.String value;

            /**
             * Sets the value of {@link TagFilterProperty#getKey}
             * @param key The on-premises instance tag filter key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link TagFilterProperty#getType}
             * @param type The on-premises instance tag filter type:.
             *             <ul>
             *             <li>KEY_ONLY: Key only.</li>
             *             <li>VALUE_ONLY: Value only.</li>
             *             <li>KEY_AND_VALUE: Key and value.</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link TagFilterProperty#getValue}
             * @param value The on-premises instance tag filter value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TagFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagFilterProperty {
            private final java.lang.String key;
            private final java.lang.String type;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = builder.key;
                this.type = builder.type;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.CfnDeploymentGroup.TagFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagFilterProperty.Jsii$Proxy that = (TagFilterProperty.Jsii$Proxy) o;

                if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
                if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key != null ? this.key.hashCode() : 0;
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `TargetGroupInfo` property type specifies information about a target group in Elastic Load Balancing to use in a deployment.
     * <p>
     * Instances are registered as targets in a target group, and traffic is routed to the target group. For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_TargetGroupInfo.html">TargetGroupInfo</a> in the <em>AWS CodeDeploy API Reference</em>
     * <p>
     * If you specify the <code>TargetGroupInfo</code> property, the <code>DeploymentStyle.DeploymentOption</code> property must be set to <code>WITH_TRAFFIC_CONTROL</code> for CodeDeploy to route your traffic using the specified target groups.
     * <p>
     * <code>TargetGroupInfo</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html">LoadBalancerInfo</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codedeploy.*;
     * TargetGroupInfoProperty targetGroupInfoProperty = TargetGroupInfoProperty.builder()
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroup.TargetGroupInfoProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetGroupInfoProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetGroupInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * For blue/green deployments, the name of the target group that instances in the original environment are deregistered from, and instances in the replacement environment registered with.
         * <p>
         * For in-place deployments, the name of the target group that instances are deregistered from, so they are not serving traffic during a deployment, and then re-registered with after the deployment completes. No duplicates allowed.
         * <p>
         * <blockquote>
         * <p>
         * AWS CloudFormation supports blue/green deployments on AWS Lambda compute platforms only.
         * <p>
         * </blockquote>
         * <p>
         * This value cannot exceed 32 characters, so you should use the <code>Name</code> property of the target group, or the <code>TargetGroupName</code> attribute with the <code>Fn::GetAtt</code> intrinsic function, as shown in the following example. Don't use the group's Amazon Resource Name (ARN) or <code>TargetGroupFullName</code> attribute.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetGroupInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetGroupInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetGroupInfoProperty> {
            java.lang.String name;

            /**
             * Sets the value of {@link TargetGroupInfoProperty#getName}
             * @param name For blue/green deployments, the name of the target group that instances in the original environment are deregistered from, and instances in the replacement environment registered with.
             *             For in-place deployments, the name of the target group that instances are deregistered from, so they are not serving traffic during a deployment, and then re-registered with after the deployment completes. No duplicates allowed.
             *             <p>
             *             <blockquote>
             *             <p>
             *             AWS CloudFormation supports blue/green deployments on AWS Lambda compute platforms only.
             *             <p>
             *             </blockquote>
             *             <p>
             *             This value cannot exceed 32 characters, so you should use the <code>Name</code> property of the target group, or the <code>TargetGroupName</code> attribute with the <code>Fn::GetAtt</code> intrinsic function, as shown in the following example. Don't use the group's Amazon Resource Name (ARN) or <code>TargetGroupFullName</code> attribute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetGroupInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetGroupInfoProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetGroupInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetGroupInfoProperty {
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.CfnDeploymentGroup.TargetGroupInfoProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetGroupInfoProperty.Jsii$Proxy that = (TargetGroupInfoProperty.Jsii$Proxy) o;

                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Information about two target groups and how traffic is routed during an Amazon ECS deployment.
     * <p>
     * An optional test traffic route can be specified.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codedeploy.*;
     * TargetGroupPairInfoProperty targetGroupPairInfoProperty = TargetGroupPairInfoProperty.builder()
     *         .prodTrafficRoute(TrafficRouteProperty.builder()
     *                 .listenerArns(List.of("listenerArns"))
     *                 .build())
     *         .targetGroups(List.of(TargetGroupInfoProperty.builder()
     *                 .name("name")
     *                 .build()))
     *         .testTrafficRoute(TrafficRouteProperty.builder()
     *                 .listenerArns(List.of("listenerArns"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroup.TargetGroupPairInfoProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetGroupPairInfoProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetGroupPairInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The path used by a load balancer to route production traffic when an Amazon ECS deployment is complete.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProdTrafficRoute() {
            return null;
        }

        /**
         * One pair of target groups.
         * <p>
         * One is associated with the original task set. The second is associated with the task set that serves traffic after the deployment is complete.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTargetGroups() {
            return null;
        }

        /**
         * An optional path used by a load balancer to route test traffic after an Amazon ECS deployment.
         * <p>
         * Validation can occur while test traffic is served during a deployment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTestTrafficRoute() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetGroupPairInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetGroupPairInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetGroupPairInfoProperty> {
            java.lang.Object prodTrafficRoute;
            java.lang.Object targetGroups;
            java.lang.Object testTrafficRoute;

            /**
             * Sets the value of {@link TargetGroupPairInfoProperty#getProdTrafficRoute}
             * @param prodTrafficRoute The path used by a load balancer to route production traffic when an Amazon ECS deployment is complete.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prodTrafficRoute(software.amazon.awscdk.core.IResolvable prodTrafficRoute) {
                this.prodTrafficRoute = prodTrafficRoute;
                return this;
            }

            /**
             * Sets the value of {@link TargetGroupPairInfoProperty#getProdTrafficRoute}
             * @param prodTrafficRoute The path used by a load balancer to route production traffic when an Amazon ECS deployment is complete.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prodTrafficRoute(software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.TrafficRouteProperty prodTrafficRoute) {
                this.prodTrafficRoute = prodTrafficRoute;
                return this;
            }

            /**
             * Sets the value of {@link TargetGroupPairInfoProperty#getTargetGroups}
             * @param targetGroups One pair of target groups.
             *                     One is associated with the original task set. The second is associated with the task set that serves traffic after the deployment is complete.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroups(software.amazon.awscdk.core.IResolvable targetGroups) {
                this.targetGroups = targetGroups;
                return this;
            }

            /**
             * Sets the value of {@link TargetGroupPairInfoProperty#getTargetGroups}
             * @param targetGroups One pair of target groups.
             *                     One is associated with the original task set. The second is associated with the task set that serves traffic after the deployment is complete.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroups(java.util.List<? extends java.lang.Object> targetGroups) {
                this.targetGroups = targetGroups;
                return this;
            }

            /**
             * Sets the value of {@link TargetGroupPairInfoProperty#getTestTrafficRoute}
             * @param testTrafficRoute An optional path used by a load balancer to route test traffic after an Amazon ECS deployment.
             *                         Validation can occur while test traffic is served during a deployment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder testTrafficRoute(software.amazon.awscdk.core.IResolvable testTrafficRoute) {
                this.testTrafficRoute = testTrafficRoute;
                return this;
            }

            /**
             * Sets the value of {@link TargetGroupPairInfoProperty#getTestTrafficRoute}
             * @param testTrafficRoute An optional path used by a load balancer to route test traffic after an Amazon ECS deployment.
             *                         Validation can occur while test traffic is served during a deployment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder testTrafficRoute(software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.TrafficRouteProperty testTrafficRoute) {
                this.testTrafficRoute = testTrafficRoute;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetGroupPairInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetGroupPairInfoProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetGroupPairInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetGroupPairInfoProperty {
            private final java.lang.Object prodTrafficRoute;
            private final java.lang.Object targetGroups;
            private final java.lang.Object testTrafficRoute;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.prodTrafficRoute = software.amazon.jsii.Kernel.get(this, "prodTrafficRoute", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.targetGroups = software.amazon.jsii.Kernel.get(this, "targetGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.testTrafficRoute = software.amazon.jsii.Kernel.get(this, "testTrafficRoute", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.prodTrafficRoute = builder.prodTrafficRoute;
                this.targetGroups = builder.targetGroups;
                this.testTrafficRoute = builder.testTrafficRoute;
            }

            @Override
            public final java.lang.Object getProdTrafficRoute() {
                return this.prodTrafficRoute;
            }

            @Override
            public final java.lang.Object getTargetGroups() {
                return this.targetGroups;
            }

            @Override
            public final java.lang.Object getTestTrafficRoute() {
                return this.testTrafficRoute;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getProdTrafficRoute() != null) {
                    data.set("prodTrafficRoute", om.valueToTree(this.getProdTrafficRoute()));
                }
                if (this.getTargetGroups() != null) {
                    data.set("targetGroups", om.valueToTree(this.getTargetGroups()));
                }
                if (this.getTestTrafficRoute() != null) {
                    data.set("testTrafficRoute", om.valueToTree(this.getTestTrafficRoute()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.CfnDeploymentGroup.TargetGroupPairInfoProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetGroupPairInfoProperty.Jsii$Proxy that = (TargetGroupPairInfoProperty.Jsii$Proxy) o;

                if (this.prodTrafficRoute != null ? !this.prodTrafficRoute.equals(that.prodTrafficRoute) : that.prodTrafficRoute != null) return false;
                if (this.targetGroups != null ? !this.targetGroups.equals(that.targetGroups) : that.targetGroups != null) return false;
                return this.testTrafficRoute != null ? this.testTrafficRoute.equals(that.testTrafficRoute) : that.testTrafficRoute == null;
            }

            @Override
            public final int hashCode() {
                int result = this.prodTrafficRoute != null ? this.prodTrafficRoute.hashCode() : 0;
                result = 31 * result + (this.targetGroups != null ? this.targetGroups.hashCode() : 0);
                result = 31 * result + (this.testTrafficRoute != null ? this.testTrafficRoute.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about a listener.
     * <p>
     * The listener contains the path used to route traffic that is received from the load balancer to a target group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codedeploy.*;
     * TrafficRouteProperty trafficRouteProperty = TrafficRouteProperty.builder()
     *         .listenerArns(List.of("listenerArns"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroup.TrafficRouteProperty")
    @software.amazon.jsii.Jsii.Proxy(TrafficRouteProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TrafficRouteProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of one listener.
         * <p>
         * The listener identifies the route between a target group and a load balancer. This is an array of strings with a maximum size of one.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getListenerArns() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TrafficRouteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TrafficRouteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TrafficRouteProperty> {
            java.util.List<java.lang.String> listenerArns;

            /**
             * Sets the value of {@link TrafficRouteProperty#getListenerArns}
             * @param listenerArns The Amazon Resource Name (ARN) of one listener.
             *                     The listener identifies the route between a target group and a load balancer. This is an array of strings with a maximum size of one.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder listenerArns(java.util.List<java.lang.String> listenerArns) {
                this.listenerArns = listenerArns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TrafficRouteProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TrafficRouteProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TrafficRouteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TrafficRouteProperty {
            private final java.util.List<java.lang.String> listenerArns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.listenerArns = software.amazon.jsii.Kernel.get(this, "listenerArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.listenerArns = builder.listenerArns;
            }

            @Override
            public final java.util.List<java.lang.String> getListenerArns() {
                return this.listenerArns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getListenerArns() != null) {
                    data.set("listenerArns", om.valueToTree(this.getListenerArns()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.CfnDeploymentGroup.TrafficRouteProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TrafficRouteProperty.Jsii$Proxy that = (TrafficRouteProperty.Jsii$Proxy) o;

                return this.listenerArns != null ? this.listenerArns.equals(that.listenerArns) : that.listenerArns == null;
            }

            @Override
            public final int hashCode() {
                int result = this.listenerArns != null ? this.listenerArns.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Information about notification triggers for the deployment group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codedeploy.*;
     * TriggerConfigProperty triggerConfigProperty = TriggerConfigProperty.builder()
     *         .triggerEvents(List.of("triggerEvents"))
     *         .triggerName("triggerName")
     *         .triggerTargetArn("triggerTargetArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroup.TriggerConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(TriggerConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TriggerConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The event type or types that trigger notifications.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTriggerEvents() {
            return null;
        }

        /**
         * The name of the notification trigger.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTriggerName() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service topic through which notifications about deployment or instance events are sent.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTriggerTargetArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TriggerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TriggerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TriggerConfigProperty> {
            java.util.List<java.lang.String> triggerEvents;
            java.lang.String triggerName;
            java.lang.String triggerTargetArn;

            /**
             * Sets the value of {@link TriggerConfigProperty#getTriggerEvents}
             * @param triggerEvents The event type or types that trigger notifications.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder triggerEvents(java.util.List<java.lang.String> triggerEvents) {
                this.triggerEvents = triggerEvents;
                return this;
            }

            /**
             * Sets the value of {@link TriggerConfigProperty#getTriggerName}
             * @param triggerName The name of the notification trigger.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder triggerName(java.lang.String triggerName) {
                this.triggerName = triggerName;
                return this;
            }

            /**
             * Sets the value of {@link TriggerConfigProperty#getTriggerTargetArn}
             * @param triggerTargetArn The Amazon Resource Name (ARN) of the Amazon Simple Notification Service topic through which notifications about deployment or instance events are sent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder triggerTargetArn(java.lang.String triggerTargetArn) {
                this.triggerTargetArn = triggerTargetArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TriggerConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TriggerConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TriggerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TriggerConfigProperty {
            private final java.util.List<java.lang.String> triggerEvents;
            private final java.lang.String triggerName;
            private final java.lang.String triggerTargetArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.triggerEvents = software.amazon.jsii.Kernel.get(this, "triggerEvents", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.triggerName = software.amazon.jsii.Kernel.get(this, "triggerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.triggerTargetArn = software.amazon.jsii.Kernel.get(this, "triggerTargetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.triggerEvents = builder.triggerEvents;
                this.triggerName = builder.triggerName;
                this.triggerTargetArn = builder.triggerTargetArn;
            }

            @Override
            public final java.util.List<java.lang.String> getTriggerEvents() {
                return this.triggerEvents;
            }

            @Override
            public final java.lang.String getTriggerName() {
                return this.triggerName;
            }

            @Override
            public final java.lang.String getTriggerTargetArn() {
                return this.triggerTargetArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTriggerEvents() != null) {
                    data.set("triggerEvents", om.valueToTree(this.getTriggerEvents()));
                }
                if (this.getTriggerName() != null) {
                    data.set("triggerName", om.valueToTree(this.getTriggerName()));
                }
                if (this.getTriggerTargetArn() != null) {
                    data.set("triggerTargetArn", om.valueToTree(this.getTriggerTargetArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.CfnDeploymentGroup.TriggerConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TriggerConfigProperty.Jsii$Proxy that = (TriggerConfigProperty.Jsii$Proxy) o;

                if (this.triggerEvents != null ? !this.triggerEvents.equals(that.triggerEvents) : that.triggerEvents != null) return false;
                if (this.triggerName != null ? !this.triggerName.equals(that.triggerName) : that.triggerName != null) return false;
                return this.triggerTargetArn != null ? this.triggerTargetArn.equals(that.triggerTargetArn) : that.triggerTargetArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.triggerEvents != null ? this.triggerEvents.hashCode() : 0;
                result = 31 * result + (this.triggerName != null ? this.triggerName.hashCode() : 0);
                result = 31 * result + (this.triggerTargetArn != null ? this.triggerTargetArn.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroupProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.codedeploy.CfnDeploymentGroupProps.Builder();
        }

        /**
         * The name of an existing CodeDeploy application to associate this deployment group with.
         * <p>
         * @return {@code this}
         * @param applicationName The name of an existing CodeDeploy application to associate this deployment group with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationName(final java.lang.String applicationName) {
            this.props.applicationName(applicationName);
            return this;
        }

        /**
         * A service role Amazon Resource Name (ARN) that grants CodeDeploy permission to make calls to AWS services on your behalf.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/getting-started-create-service-role.html">Create a Service Role for AWS CodeDeploy</a> in the <em>AWS CodeDeploy User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * In some cases, you might need to add a dependency on the service role's policy. For more information, see IAM role policy in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn Attribute</a> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param serviceRoleArn A service role Amazon Resource Name (ARN) that grants CodeDeploy permission to make calls to AWS services on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRoleArn(final java.lang.String serviceRoleArn) {
            this.props.serviceRoleArn(serviceRoleArn);
            return this;
        }

        /**
         * Information about the Amazon CloudWatch alarms that are associated with the deployment group.
         * <p>
         * @return {@code this}
         * @param alarmConfiguration Information about the Amazon CloudWatch alarms that are associated with the deployment group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmConfiguration(final software.amazon.awscdk.core.IResolvable alarmConfiguration) {
            this.props.alarmConfiguration(alarmConfiguration);
            return this;
        }
        /**
         * Information about the Amazon CloudWatch alarms that are associated with the deployment group.
         * <p>
         * @return {@code this}
         * @param alarmConfiguration Information about the Amazon CloudWatch alarms that are associated with the deployment group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmConfiguration(final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.AlarmConfigurationProperty alarmConfiguration) {
            this.props.alarmConfiguration(alarmConfiguration);
            return this;
        }

        /**
         * Information about the automatic rollback configuration that is associated with the deployment group.
         * <p>
         * If you specify this property, don't specify the <code>Deployment</code> property.
         * <p>
         * @return {@code this}
         * @param autoRollbackConfiguration Information about the automatic rollback configuration that is associated with the deployment group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoRollbackConfiguration(final software.amazon.awscdk.core.IResolvable autoRollbackConfiguration) {
            this.props.autoRollbackConfiguration(autoRollbackConfiguration);
            return this;
        }
        /**
         * Information about the automatic rollback configuration that is associated with the deployment group.
         * <p>
         * If you specify this property, don't specify the <code>Deployment</code> property.
         * <p>
         * @return {@code this}
         * @param autoRollbackConfiguration Information about the automatic rollback configuration that is associated with the deployment group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoRollbackConfiguration(final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.AutoRollbackConfigurationProperty autoRollbackConfiguration) {
            this.props.autoRollbackConfiguration(autoRollbackConfiguration);
            return this;
        }

        /**
         * A list of associated Auto Scaling groups that CodeDeploy automatically deploys revisions to when new instances are created.
         * <p>
         * Duplicates are not allowed.
         * <p>
         * @return {@code this}
         * @param autoScalingGroups A list of associated Auto Scaling groups that CodeDeploy automatically deploys revisions to when new instances are created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroups(final java.util.List<java.lang.String> autoScalingGroups) {
            this.props.autoScalingGroups(autoScalingGroups);
            return this;
        }

        /**
         * Information about blue/green deployment options for a deployment group.
         * <p>
         * @return {@code this}
         * @param blueGreenDeploymentConfiguration Information about blue/green deployment options for a deployment group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blueGreenDeploymentConfiguration(final software.amazon.awscdk.core.IResolvable blueGreenDeploymentConfiguration) {
            this.props.blueGreenDeploymentConfiguration(blueGreenDeploymentConfiguration);
            return this;
        }
        /**
         * Information about blue/green deployment options for a deployment group.
         * <p>
         * @return {@code this}
         * @param blueGreenDeploymentConfiguration Information about blue/green deployment options for a deployment group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blueGreenDeploymentConfiguration(final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.BlueGreenDeploymentConfigurationProperty blueGreenDeploymentConfiguration) {
            this.props.blueGreenDeploymentConfiguration(blueGreenDeploymentConfiguration);
            return this;
        }

        /**
         * The application revision to deploy to this deployment group.
         * <p>
         * If you specify this property, your target application revision is deployed as soon as the provisioning process is complete. If you specify this property, don't specify the <code>AutoRollbackConfiguration</code> property.
         * <p>
         * @return {@code this}
         * @param deployment The application revision to deploy to this deployment group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployment(final software.amazon.awscdk.core.IResolvable deployment) {
            this.props.deployment(deployment);
            return this;
        }
        /**
         * The application revision to deploy to this deployment group.
         * <p>
         * If you specify this property, your target application revision is deployed as soon as the provisioning process is complete. If you specify this property, don't specify the <code>AutoRollbackConfiguration</code> property.
         * <p>
         * @return {@code this}
         * @param deployment The application revision to deploy to this deployment group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployment(final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.DeploymentProperty deployment) {
            this.props.deployment(deployment);
            return this;
        }

        /**
         * A deployment configuration name or a predefined configuration name.
         * <p>
         * With predefined configurations, you can deploy application revisions to one instance at a time ( <code>CodeDeployDefault.OneAtATime</code> ), half of the instances at a time ( <code>CodeDeployDefault.HalfAtATime</code> ), or all the instances at once ( <code>CodeDeployDefault.AllAtOnce</code> ). For more information and valid values, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html">Working with Deployment Configurations</a> in the <em>AWS CodeDeploy User Guide</em> .
         * <p>
         * @return {@code this}
         * @param deploymentConfigName A deployment configuration name or a predefined configuration name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfigName(final java.lang.String deploymentConfigName) {
            this.props.deploymentConfigName(deploymentConfigName);
            return this;
        }

        /**
         * A name for the deployment group.
         * <p>
         * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the deployment group name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
         * <p>
         * <blockquote>
         * <p>
         * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param deploymentGroupName A name for the deployment group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentGroupName(final java.lang.String deploymentGroupName) {
            this.props.deploymentGroupName(deploymentGroupName);
            return this;
        }

        /**
         * Attributes that determine the type of deployment to run and whether to route deployment traffic behind a load balancer.
         * <p>
         * If you specify this property with a blue/green deployment type, don't specify the <code>AutoScalingGroups</code> , <code>LoadBalancerInfo</code> , or <code>Deployment</code> properties.
         * <p>
         * <blockquote>
         * <p>
         * For blue/green deployments, AWS CloudFormation supports deployments on Lambda compute platforms only. You can perform Amazon ECS blue/green deployments using <code>AWS::CodeDeploy::BlueGreen</code> hook. See <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/blue-green.html">Perform Amazon ECS blue/green deployments through CodeDeploy using AWS CloudFormation</a> for more information.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param deploymentStyle Attributes that determine the type of deployment to run and whether to route deployment traffic behind a load balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentStyle(final software.amazon.awscdk.core.IResolvable deploymentStyle) {
            this.props.deploymentStyle(deploymentStyle);
            return this;
        }
        /**
         * Attributes that determine the type of deployment to run and whether to route deployment traffic behind a load balancer.
         * <p>
         * If you specify this property with a blue/green deployment type, don't specify the <code>AutoScalingGroups</code> , <code>LoadBalancerInfo</code> , or <code>Deployment</code> properties.
         * <p>
         * <blockquote>
         * <p>
         * For blue/green deployments, AWS CloudFormation supports deployments on Lambda compute platforms only. You can perform Amazon ECS blue/green deployments using <code>AWS::CodeDeploy::BlueGreen</code> hook. See <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/blue-green.html">Perform Amazon ECS blue/green deployments through CodeDeploy using AWS CloudFormation</a> for more information.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param deploymentStyle Attributes that determine the type of deployment to run and whether to route deployment traffic behind a load balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentStyle(final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.DeploymentStyleProperty deploymentStyle) {
            this.props.deploymentStyle(deploymentStyle);
            return this;
        }

        /**
         * The Amazon EC2 tags that are already applied to Amazon EC2 instances that you want to include in the deployment group.
         * <p>
         * CodeDeploy includes all Amazon EC2 instances identified by any of the tags you specify in this deployment group. Duplicates are not allowed.
         * <p>
         * You can specify <code>EC2TagFilters</code> or <code>Ec2TagSet</code> , but not both.
         * <p>
         * @return {@code this}
         * @param ec2TagFilters The Amazon EC2 tags that are already applied to Amazon EC2 instances that you want to include in the deployment group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2TagFilters(final software.amazon.awscdk.core.IResolvable ec2TagFilters) {
            this.props.ec2TagFilters(ec2TagFilters);
            return this;
        }
        /**
         * The Amazon EC2 tags that are already applied to Amazon EC2 instances that you want to include in the deployment group.
         * <p>
         * CodeDeploy includes all Amazon EC2 instances identified by any of the tags you specify in this deployment group. Duplicates are not allowed.
         * <p>
         * You can specify <code>EC2TagFilters</code> or <code>Ec2TagSet</code> , but not both.
         * <p>
         * @return {@code this}
         * @param ec2TagFilters The Amazon EC2 tags that are already applied to Amazon EC2 instances that you want to include in the deployment group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2TagFilters(final java.util.List<? extends java.lang.Object> ec2TagFilters) {
            this.props.ec2TagFilters(ec2TagFilters);
            return this;
        }

        /**
         * Information about groups of tags applied to Amazon EC2 instances.
         * <p>
         * The deployment group includes only Amazon EC2 instances identified by all the tag groups. Cannot be used in the same call as <code>ec2TagFilter</code> .
         * <p>
         * @return {@code this}
         * @param ec2TagSet Information about groups of tags applied to Amazon EC2 instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2TagSet(final software.amazon.awscdk.core.IResolvable ec2TagSet) {
            this.props.ec2TagSet(ec2TagSet);
            return this;
        }
        /**
         * Information about groups of tags applied to Amazon EC2 instances.
         * <p>
         * The deployment group includes only Amazon EC2 instances identified by all the tag groups. Cannot be used in the same call as <code>ec2TagFilter</code> .
         * <p>
         * @return {@code this}
         * @param ec2TagSet Information about groups of tags applied to Amazon EC2 instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2TagSet(final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.EC2TagSetProperty ec2TagSet) {
            this.props.ec2TagSet(ec2TagSet);
            return this;
        }

        /**
         * The target Amazon ECS services in the deployment group.
         * <p>
         * This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code> .
         * <p>
         * @return {@code this}
         * @param ecsServices The target Amazon ECS services in the deployment group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ecsServices(final software.amazon.awscdk.core.IResolvable ecsServices) {
            this.props.ecsServices(ecsServices);
            return this;
        }
        /**
         * The target Amazon ECS services in the deployment group.
         * <p>
         * This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code> .
         * <p>
         * @return {@code this}
         * @param ecsServices The target Amazon ECS services in the deployment group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ecsServices(final java.util.List<? extends java.lang.Object> ecsServices) {
            this.props.ecsServices(ecsServices);
            return this;
        }

        /**
         * Information about the load balancer to use in a deployment.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-elastic-load-balancing.html">Integrating CodeDeploy with Elastic Load Balancing</a> in the <em>AWS CodeDeploy User Guide</em> .
         * <p>
         * @return {@code this}
         * @param loadBalancerInfo Information about the load balancer to use in a deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerInfo(final software.amazon.awscdk.core.IResolvable loadBalancerInfo) {
            this.props.loadBalancerInfo(loadBalancerInfo);
            return this;
        }
        /**
         * Information about the load balancer to use in a deployment.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-elastic-load-balancing.html">Integrating CodeDeploy with Elastic Load Balancing</a> in the <em>AWS CodeDeploy User Guide</em> .
         * <p>
         * @return {@code this}
         * @param loadBalancerInfo Information about the load balancer to use in a deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerInfo(final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.LoadBalancerInfoProperty loadBalancerInfo) {
            this.props.loadBalancerInfo(loadBalancerInfo);
            return this;
        }

        /**
         * The on-premises instance tags already applied to on-premises instances that you want to include in the deployment group.
         * <p>
         * CodeDeploy includes all on-premises instances identified by any of the tags you specify in this deployment group. To register on-premises instances with CodeDeploy , see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-on-premises.html">Working with On-Premises Instances for CodeDeploy</a> in the <em>AWS CodeDeploy User Guide</em> . Duplicates are not allowed.
         * <p>
         * You can specify <code>OnPremisesInstanceTagFilters</code> or <code>OnPremisesInstanceTagSet</code> , but not both.
         * <p>
         * @return {@code this}
         * @param onPremisesInstanceTagFilters The on-premises instance tags already applied to on-premises instances that you want to include in the deployment group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onPremisesInstanceTagFilters(final software.amazon.awscdk.core.IResolvable onPremisesInstanceTagFilters) {
            this.props.onPremisesInstanceTagFilters(onPremisesInstanceTagFilters);
            return this;
        }
        /**
         * The on-premises instance tags already applied to on-premises instances that you want to include in the deployment group.
         * <p>
         * CodeDeploy includes all on-premises instances identified by any of the tags you specify in this deployment group. To register on-premises instances with CodeDeploy , see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-on-premises.html">Working with On-Premises Instances for CodeDeploy</a> in the <em>AWS CodeDeploy User Guide</em> . Duplicates are not allowed.
         * <p>
         * You can specify <code>OnPremisesInstanceTagFilters</code> or <code>OnPremisesInstanceTagSet</code> , but not both.
         * <p>
         * @return {@code this}
         * @param onPremisesInstanceTagFilters The on-premises instance tags already applied to on-premises instances that you want to include in the deployment group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onPremisesInstanceTagFilters(final java.util.List<? extends java.lang.Object> onPremisesInstanceTagFilters) {
            this.props.onPremisesInstanceTagFilters(onPremisesInstanceTagFilters);
            return this;
        }

        /**
         * Information about groups of tags applied to on-premises instances.
         * <p>
         * The deployment group includes only on-premises instances identified by all the tag groups.
         * <p>
         * You can specify <code>OnPremisesInstanceTagFilters</code> or <code>OnPremisesInstanceTagSet</code> , but not both.
         * <p>
         * @return {@code this}
         * @param onPremisesTagSet Information about groups of tags applied to on-premises instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onPremisesTagSet(final software.amazon.awscdk.core.IResolvable onPremisesTagSet) {
            this.props.onPremisesTagSet(onPremisesTagSet);
            return this;
        }
        /**
         * Information about groups of tags applied to on-premises instances.
         * <p>
         * The deployment group includes only on-premises instances identified by all the tag groups.
         * <p>
         * You can specify <code>OnPremisesInstanceTagFilters</code> or <code>OnPremisesInstanceTagSet</code> , but not both.
         * <p>
         * @return {@code this}
         * @param onPremisesTagSet Information about groups of tags applied to on-premises instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onPremisesTagSet(final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.OnPremisesTagSetProperty onPremisesTagSet) {
            this.props.onPremisesTagSet(onPremisesTagSet);
            return this;
        }

        /**
         * Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed application revision.
         * <p>
         * If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update outdated instances' deployments to apply the deployed application revision to the new Amazon EC2 instances.
         * <p>
         * If this option is set to <code>IGNORE</code> , CodeDeploy does not initiate a deployment to update the new Amazon EC2 instances. This may result in instances having different revisions.
         * <p>
         * @return {@code this}
         * @param outdatedInstancesStrategy Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed application revision. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outdatedInstancesStrategy(final java.lang.String outdatedInstancesStrategy) {
            this.props.outdatedInstancesStrategy(outdatedInstancesStrategy);
            return this;
        }

        /**
         * The metadata that you apply to CodeDeploy deployment groups to help you organize and categorize them.
         * <p>
         * Each tag consists of a key and an optional value, both of which you define.
         * <p>
         * @return {@code this}
         * @param tags The metadata that you apply to CodeDeploy deployment groups to help you organize and categorize them. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * Information about triggers associated with the deployment group.
         * <p>
         * Duplicates are not allowed
         * <p>
         * @return {@code this}
         * @param triggerConfigurations Information about triggers associated with the deployment group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggerConfigurations(final software.amazon.awscdk.core.IResolvable triggerConfigurations) {
            this.props.triggerConfigurations(triggerConfigurations);
            return this;
        }
        /**
         * Information about triggers associated with the deployment group.
         * <p>
         * Duplicates are not allowed
         * <p>
         * @return {@code this}
         * @param triggerConfigurations Information about triggers associated with the deployment group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggerConfigurations(final java.util.List<? extends java.lang.Object> triggerConfigurations) {
            this.props.triggerConfigurations(triggerConfigurations);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup build() {
            return new software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
