package software.amazon.awscdk.services.codedeploy;

/**
 * An interface of an abstract load balancer, as needed by CodeDeploy.
 * <p>
 * Create instances using the static factory methods:
 * {&#64;link #classic}, {&#64;link #application} and {&#64;link #network}.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.elasticloadbalancing.*;
 * LoadBalancer lb;
 * lb.addListener(LoadBalancerListener.builder()
 *         .externalPort(80)
 *         .build());
 * ServerDeploymentGroup deploymentGroup = ServerDeploymentGroup.Builder.create(this, "DeploymentGroup")
 *         .loadBalancer(LoadBalancer.classic(lb))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-30T16:29:51.390Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.LoadBalancer")
public abstract class LoadBalancer extends software.amazon.jsii.JsiiObject {

    protected LoadBalancer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LoadBalancer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected LoadBalancer() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Creates a new CodeDeploy load balancer from an Application Load Balancer Target Group.
     * <p>
     * @param albTargetGroup an ALB Target Group. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.LoadBalancer application(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup albTargetGroup) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codedeploy.LoadBalancer.class, "application", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.LoadBalancer.class), new Object[] { java.util.Objects.requireNonNull(albTargetGroup, "albTargetGroup is required") });
    }

    /**
     * Creates a new CodeDeploy load balancer from a Classic ELB Load Balancer.
     * <p>
     * @param loadBalancer a classic ELB Load Balancer. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.LoadBalancer classic(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancing.LoadBalancer loadBalancer) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codedeploy.LoadBalancer.class, "classic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.LoadBalancer.class), new Object[] { java.util.Objects.requireNonNull(loadBalancer, "loadBalancer is required") });
    }

    /**
     * Creates a new CodeDeploy load balancer from a Network Load Balancer Target Group.
     * <p>
     * @param nlbTargetGroup an NLB Target Group. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.LoadBalancer network(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup nlbTargetGroup) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codedeploy.LoadBalancer.class, "network", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.LoadBalancer.class), new Object[] { java.util.Objects.requireNonNull(nlbTargetGroup, "nlbTargetGroup is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.LoadBalancerGeneration getGeneration();

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.codedeploy.LoadBalancer {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.LoadBalancerGeneration getGeneration() {
            return software.amazon.jsii.Kernel.get(this, "generation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.LoadBalancerGeneration.class));
        }

        /**
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getName() {
            return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }
}
