package software.amazon.awscdk.services.codedeploy;

/**
 * Construction properties for {@link LambdaDeploymentGroup}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.21.1 (build 9ff44cb)", date = "2020-01-07T23:11:00.038Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.LambdaDeploymentGroupProps")
@software.amazon.jsii.Jsii.Proxy(LambdaDeploymentGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LambdaDeploymentGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Lambda Alias to shift traffic. Updating the version of the alias will trigger a CodeDeploy deployment.
     * <p>
     * [disable-awslint:ref-via-interface] since we need to modify the alias CFN resource update policy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.lambda.Alias getAlias();

    /**
     * The CloudWatch alarms associated with this Deployment Group.
     * <p>
     * CodeDeploy will stop (and optionally roll back)
     * a deployment if during it any of the alarms trigger.
     * <p>
     * Alarms can also be added after the Deployment Group is created using the {&#64;link #addAlarm} method.
     * <p>
     * Default: []
     * <p>
     * @see https://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-create-alarms.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.util.List<software.amazon.awscdk.services.cloudwatch.IAlarm> getAlarms() {
        return null;
    }

    /**
     * The reference to the CodeDeploy Lambda Application that this Deployment Group belongs to.
     * <p>
     * Default: - One will be created for you.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.codedeploy.ILambdaApplication getApplication() {
        return null;
    }

    /**
     * The auto-rollback configuration for this Deployment Group.
     * <p>
     * Default: - default AutoRollbackConfig.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.codedeploy.AutoRollbackConfig getAutoRollback() {
        return null;
    }

    /**
     * The Deployment Configuration this Deployment Group uses.
     * <p>
     * Default: LambdaDeploymentConfig.CANARY_10PERCENT_5MINUTES
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig getDeploymentConfig() {
        return null;
    }

    /**
     * The physical, human-readable name of the CodeDeploy Deployment Group.
     * <p>
     * Default: - An auto-generated name will be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.String getDeploymentGroupName() {
        return null;
    }

    /**
     * Whether to continue a deployment even if fetching the alarm status from CloudWatch failed.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.Boolean getIgnorePollAlarmsFailure() {
        return null;
    }

    /**
     * The Lambda function to run after traffic routing starts.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.lambda.IFunction getPostHook() {
        return null;
    }

    /**
     * The Lambda function to run before traffic routing starts.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.lambda.IFunction getPreHook() {
        return null;
    }

    /**
     * The service Role of this Deployment Group.
     * <p>
     * Default: - A new Role will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LambdaDeploymentGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LambdaDeploymentGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.services.lambda.Alias alias;
        private java.util.List<software.amazon.awscdk.services.cloudwatch.IAlarm> alarms;
        private software.amazon.awscdk.services.codedeploy.ILambdaApplication application;
        private software.amazon.awscdk.services.codedeploy.AutoRollbackConfig autoRollback;
        private software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig deploymentConfig;
        private java.lang.String deploymentGroupName;
        private java.lang.Boolean ignorePollAlarmsFailure;
        private software.amazon.awscdk.services.lambda.IFunction postHook;
        private software.amazon.awscdk.services.lambda.IFunction preHook;
        private software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of {@link LambdaDeploymentGroupProps#getAlias}
         * @param alias Lambda Alias to shift traffic. Updating the version of the alias will trigger a CodeDeploy deployment. This parameter is required.
         *              [disable-awslint:ref-via-interface] since we need to modify the alias CFN resource update policy
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alias(software.amazon.awscdk.services.lambda.Alias alias) {
            this.alias = alias;
            return this;
        }

        /**
         * Sets the value of {@link LambdaDeploymentGroupProps#getAlarms}
         * @param alarms The CloudWatch alarms associated with this Deployment Group.
         *               CodeDeploy will stop (and optionally roll back)
         *               a deployment if during it any of the alarms trigger.
         *               <p>
         *               Alarms can also be added after the Deployment Group is created using the {&#64;link #addAlarm} method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarms(java.util.List<software.amazon.awscdk.services.cloudwatch.IAlarm> alarms) {
            this.alarms = alarms;
            return this;
        }

        /**
         * Sets the value of {@link LambdaDeploymentGroupProps#getApplication}
         * @param application The reference to the CodeDeploy Lambda Application that this Deployment Group belongs to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder application(software.amazon.awscdk.services.codedeploy.ILambdaApplication application) {
            this.application = application;
            return this;
        }

        /**
         * Sets the value of {@link LambdaDeploymentGroupProps#getAutoRollback}
         * @param autoRollback The auto-rollback configuration for this Deployment Group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoRollback(software.amazon.awscdk.services.codedeploy.AutoRollbackConfig autoRollback) {
            this.autoRollback = autoRollback;
            return this;
        }

        /**
         * Sets the value of {@link LambdaDeploymentGroupProps#getDeploymentConfig}
         * @param deploymentConfig The Deployment Configuration this Deployment Group uses.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfig(software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig deploymentConfig) {
            this.deploymentConfig = deploymentConfig;
            return this;
        }

        /**
         * Sets the value of {@link LambdaDeploymentGroupProps#getDeploymentGroupName}
         * @param deploymentGroupName The physical, human-readable name of the CodeDeploy Deployment Group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentGroupName(java.lang.String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        /**
         * Sets the value of {@link LambdaDeploymentGroupProps#getIgnorePollAlarmsFailure}
         * @param ignorePollAlarmsFailure Whether to continue a deployment even if fetching the alarm status from CloudWatch failed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignorePollAlarmsFailure(java.lang.Boolean ignorePollAlarmsFailure) {
            this.ignorePollAlarmsFailure = ignorePollAlarmsFailure;
            return this;
        }

        /**
         * Sets the value of {@link LambdaDeploymentGroupProps#getPostHook}
         * @param postHook The Lambda function to run after traffic routing starts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder postHook(software.amazon.awscdk.services.lambda.IFunction postHook) {
            this.postHook = postHook;
            return this;
        }

        /**
         * Sets the value of {@link LambdaDeploymentGroupProps#getPreHook}
         * @param preHook The Lambda function to run before traffic routing starts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preHook(software.amazon.awscdk.services.lambda.IFunction preHook) {
            this.preHook = preHook;
            return this;
        }

        /**
         * Sets the value of {@link LambdaDeploymentGroupProps#getRole}
         * @param role The service Role of this Deployment Group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LambdaDeploymentGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public LambdaDeploymentGroupProps build() {
            return new Jsii$Proxy(alias, alarms, application, autoRollback, deploymentConfig, deploymentGroupName, ignorePollAlarmsFailure, postHook, preHook, role);
        }
    }

    /**
     * An implementation for {@link LambdaDeploymentGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaDeploymentGroupProps {
        private final software.amazon.awscdk.services.lambda.Alias alias;
        private final java.util.List<software.amazon.awscdk.services.cloudwatch.IAlarm> alarms;
        private final software.amazon.awscdk.services.codedeploy.ILambdaApplication application;
        private final software.amazon.awscdk.services.codedeploy.AutoRollbackConfig autoRollback;
        private final software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig deploymentConfig;
        private final java.lang.String deploymentGroupName;
        private final java.lang.Boolean ignorePollAlarmsFailure;
        private final software.amazon.awscdk.services.lambda.IFunction postHook;
        private final software.amazon.awscdk.services.lambda.IFunction preHook;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.alias = this.jsiiGet("alias", software.amazon.awscdk.services.lambda.Alias.class);
            this.alarms = this.jsiiGet("alarms", java.util.List.class);
            this.application = this.jsiiGet("application", software.amazon.awscdk.services.codedeploy.ILambdaApplication.class);
            this.autoRollback = this.jsiiGet("autoRollback", software.amazon.awscdk.services.codedeploy.AutoRollbackConfig.class);
            this.deploymentConfig = this.jsiiGet("deploymentConfig", software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig.class);
            this.deploymentGroupName = this.jsiiGet("deploymentGroupName", java.lang.String.class);
            this.ignorePollAlarmsFailure = this.jsiiGet("ignorePollAlarmsFailure", java.lang.Boolean.class);
            this.postHook = this.jsiiGet("postHook", software.amazon.awscdk.services.lambda.IFunction.class);
            this.preHook = this.jsiiGet("preHook", software.amazon.awscdk.services.lambda.IFunction.class);
            this.role = this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.lambda.Alias alias, final java.util.List<software.amazon.awscdk.services.cloudwatch.IAlarm> alarms, final software.amazon.awscdk.services.codedeploy.ILambdaApplication application, final software.amazon.awscdk.services.codedeploy.AutoRollbackConfig autoRollback, final software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig deploymentConfig, final java.lang.String deploymentGroupName, final java.lang.Boolean ignorePollAlarmsFailure, final software.amazon.awscdk.services.lambda.IFunction postHook, final software.amazon.awscdk.services.lambda.IFunction preHook, final software.amazon.awscdk.services.iam.IRole role) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.alias = java.util.Objects.requireNonNull(alias, "alias is required");
            this.alarms = alarms;
            this.application = application;
            this.autoRollback = autoRollback;
            this.deploymentConfig = deploymentConfig;
            this.deploymentGroupName = deploymentGroupName;
            this.ignorePollAlarmsFailure = ignorePollAlarmsFailure;
            this.postHook = postHook;
            this.preHook = preHook;
            this.role = role;
        }

        @Override
        public software.amazon.awscdk.services.lambda.Alias getAlias() {
            return this.alias;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.cloudwatch.IAlarm> getAlarms() {
            return this.alarms;
        }

        @Override
        public software.amazon.awscdk.services.codedeploy.ILambdaApplication getApplication() {
            return this.application;
        }

        @Override
        public software.amazon.awscdk.services.codedeploy.AutoRollbackConfig getAutoRollback() {
            return this.autoRollback;
        }

        @Override
        public software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig getDeploymentConfig() {
            return this.deploymentConfig;
        }

        @Override
        public java.lang.String getDeploymentGroupName() {
            return this.deploymentGroupName;
        }

        @Override
        public java.lang.Boolean getIgnorePollAlarmsFailure() {
            return this.ignorePollAlarmsFailure;
        }

        @Override
        public software.amazon.awscdk.services.lambda.IFunction getPostHook() {
            return this.postHook;
        }

        @Override
        public software.amazon.awscdk.services.lambda.IFunction getPreHook() {
            return this.preHook;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("alias", om.valueToTree(this.getAlias()));
            if (this.getAlarms() != null) {
                data.set("alarms", om.valueToTree(this.getAlarms()));
            }
            if (this.getApplication() != null) {
                data.set("application", om.valueToTree(this.getApplication()));
            }
            if (this.getAutoRollback() != null) {
                data.set("autoRollback", om.valueToTree(this.getAutoRollback()));
            }
            if (this.getDeploymentConfig() != null) {
                data.set("deploymentConfig", om.valueToTree(this.getDeploymentConfig()));
            }
            if (this.getDeploymentGroupName() != null) {
                data.set("deploymentGroupName", om.valueToTree(this.getDeploymentGroupName()));
            }
            if (this.getIgnorePollAlarmsFailure() != null) {
                data.set("ignorePollAlarmsFailure", om.valueToTree(this.getIgnorePollAlarmsFailure()));
            }
            if (this.getPostHook() != null) {
                data.set("postHook", om.valueToTree(this.getPostHook()));
            }
            if (this.getPreHook() != null) {
                data.set("preHook", om.valueToTree(this.getPreHook()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.LambdaDeploymentGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LambdaDeploymentGroupProps.Jsii$Proxy that = (LambdaDeploymentGroupProps.Jsii$Proxy) o;

            if (!alias.equals(that.alias)) return false;
            if (this.alarms != null ? !this.alarms.equals(that.alarms) : that.alarms != null) return false;
            if (this.application != null ? !this.application.equals(that.application) : that.application != null) return false;
            if (this.autoRollback != null ? !this.autoRollback.equals(that.autoRollback) : that.autoRollback != null) return false;
            if (this.deploymentConfig != null ? !this.deploymentConfig.equals(that.deploymentConfig) : that.deploymentConfig != null) return false;
            if (this.deploymentGroupName != null ? !this.deploymentGroupName.equals(that.deploymentGroupName) : that.deploymentGroupName != null) return false;
            if (this.ignorePollAlarmsFailure != null ? !this.ignorePollAlarmsFailure.equals(that.ignorePollAlarmsFailure) : that.ignorePollAlarmsFailure != null) return false;
            if (this.postHook != null ? !this.postHook.equals(that.postHook) : that.postHook != null) return false;
            if (this.preHook != null ? !this.preHook.equals(that.preHook) : that.preHook != null) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public int hashCode() {
            int result = this.alias.hashCode();
            result = 31 * result + (this.alarms != null ? this.alarms.hashCode() : 0);
            result = 31 * result + (this.application != null ? this.application.hashCode() : 0);
            result = 31 * result + (this.autoRollback != null ? this.autoRollback.hashCode() : 0);
            result = 31 * result + (this.deploymentConfig != null ? this.deploymentConfig.hashCode() : 0);
            result = 31 * result + (this.deploymentGroupName != null ? this.deploymentGroupName.hashCode() : 0);
            result = 31 * result + (this.ignorePollAlarmsFailure != null ? this.ignorePollAlarmsFailure.hashCode() : 0);
            result = 31 * result + (this.postHook != null ? this.postHook.hashCode() : 0);
            result = 31 * result + (this.preHook != null ? this.preHook.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
