package software.amazon.awscdk.services.codedeploy;

/**
 * Properties of a reference to a CodeDeploy EC2/on-premise Deployment Group.
 * <p>
 * @see ServerDeploymentGroup#import
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.21.1 (build 9ff44cb)", date = "2020-01-16T18:34:15.626Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.ServerDeploymentGroupAttributes")
@software.amazon.jsii.Jsii.Proxy(ServerDeploymentGroupAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ServerDeploymentGroupAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The reference to the CodeDeploy EC2/on-premise Application that this Deployment Group belongs to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.codedeploy.IServerApplication getApplication();

    /**
     * The physical, human-readable name of the CodeDeploy EC2/on-premise Deployment Group that we are referencing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getDeploymentGroupName();

    /**
     * The Deployment Configuration this Deployment Group uses.
     * <p>
     * Default: ServerDeploymentConfig#OneAtATime
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig getDeploymentConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ServerDeploymentGroupAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ServerDeploymentGroupAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.services.codedeploy.IServerApplication application;
        private java.lang.String deploymentGroupName;
        private software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig deploymentConfig;

        /**
         * Sets the value of {@link ServerDeploymentGroupAttributes#getApplication}
         * @param application The reference to the CodeDeploy EC2/on-premise Application that this Deployment Group belongs to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder application(software.amazon.awscdk.services.codedeploy.IServerApplication application) {
            this.application = application;
            return this;
        }

        /**
         * Sets the value of {@link ServerDeploymentGroupAttributes#getDeploymentGroupName}
         * @param deploymentGroupName The physical, human-readable name of the CodeDeploy EC2/on-premise Deployment Group that we are referencing. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentGroupName(java.lang.String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        /**
         * Sets the value of {@link ServerDeploymentGroupAttributes#getDeploymentConfig}
         * @param deploymentConfig The Deployment Configuration this Deployment Group uses.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfig(software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig deploymentConfig) {
            this.deploymentConfig = deploymentConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServerDeploymentGroupAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ServerDeploymentGroupAttributes build() {
            return new Jsii$Proxy(application, deploymentGroupName, deploymentConfig);
        }
    }

    /**
     * An implementation for {@link ServerDeploymentGroupAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerDeploymentGroupAttributes {
        private final software.amazon.awscdk.services.codedeploy.IServerApplication application;
        private final java.lang.String deploymentGroupName;
        private final software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig deploymentConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.application = this.jsiiGet("application", software.amazon.awscdk.services.codedeploy.IServerApplication.class);
            this.deploymentGroupName = this.jsiiGet("deploymentGroupName", java.lang.String.class);
            this.deploymentConfig = this.jsiiGet("deploymentConfig", software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.codedeploy.IServerApplication application, final java.lang.String deploymentGroupName, final software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig deploymentConfig) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.application = java.util.Objects.requireNonNull(application, "application is required");
            this.deploymentGroupName = java.util.Objects.requireNonNull(deploymentGroupName, "deploymentGroupName is required");
            this.deploymentConfig = deploymentConfig;
        }

        @Override
        public software.amazon.awscdk.services.codedeploy.IServerApplication getApplication() {
            return this.application;
        }

        @Override
        public java.lang.String getDeploymentGroupName() {
            return this.deploymentGroupName;
        }

        @Override
        public software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig getDeploymentConfig() {
            return this.deploymentConfig;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("application", om.valueToTree(this.getApplication()));
            data.set("deploymentGroupName", om.valueToTree(this.getDeploymentGroupName()));
            if (this.getDeploymentConfig() != null) {
                data.set("deploymentConfig", om.valueToTree(this.getDeploymentConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.ServerDeploymentGroupAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServerDeploymentGroupAttributes.Jsii$Proxy that = (ServerDeploymentGroupAttributes.Jsii$Proxy) o;

            if (!application.equals(that.application)) return false;
            if (!deploymentGroupName.equals(that.deploymentGroupName)) return false;
            return this.deploymentConfig != null ? this.deploymentConfig.equals(that.deploymentConfig) : that.deploymentConfig == null;
        }

        @Override
        public int hashCode() {
            int result = this.application.hashCode();
            result = 31 * result + (this.deploymentGroupName.hashCode());
            result = 31 * result + (this.deploymentConfig != null ? this.deploymentConfig.hashCode() : 0);
            return result;
        }
    }
}
