/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codedeploy;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.codedeploy.ILambdaApplication;
import software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface LambdaDeploymentGroupAttributes
extends JsiiSerializable {
    public ILambdaApplication getApplication();

    public String getDeploymentGroupName();

    public ILambdaDeploymentConfig getDeploymentConfig();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ILambdaApplication _application;
        private String _deploymentGroupName;
        @Nullable
        private ILambdaDeploymentConfig _deploymentConfig;

        public Builder withApplication(ILambdaApplication value) {
            this._application = Objects.requireNonNull(value, "application is required");
            return this;
        }

        public Builder withDeploymentGroupName(String value) {
            this._deploymentGroupName = Objects.requireNonNull(value, "deploymentGroupName is required");
            return this;
        }

        public Builder withDeploymentConfig(@Nullable ILambdaDeploymentConfig value) {
            this._deploymentConfig = value;
            return this;
        }

        public LambdaDeploymentGroupAttributes build() {
            return new LambdaDeploymentGroupAttributes(){
                private final ILambdaApplication $application;
                private final String $deploymentGroupName;
                @Nullable
                private final ILambdaDeploymentConfig $deploymentConfig;
                {
                    this.$application = Objects.requireNonNull(_application, "application is required");
                    this.$deploymentGroupName = Objects.requireNonNull(_deploymentGroupName, "deploymentGroupName is required");
                    this.$deploymentConfig = _deploymentConfig;
                }

                @Override
                public ILambdaApplication getApplication() {
                    return this.$application;
                }

                @Override
                public String getDeploymentGroupName() {
                    return this.$deploymentGroupName;
                }

                @Override
                public ILambdaDeploymentConfig getDeploymentConfig() {
                    return this.$deploymentConfig;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("application", om.valueToTree((Object)this.getApplication()));
                    obj.set("deploymentGroupName", om.valueToTree((Object)this.getDeploymentGroupName()));
                    if (this.getDeploymentConfig() != null) {
                        obj.set("deploymentConfig", om.valueToTree((Object)this.getDeploymentConfig()));
                    }
                    return obj;
                }
            };
        }
    }
}

