package software.amazon.awscdk.services.codedeploy;

/**
 * The Deployment Configuration of an ECS Deployment Group.
 * <p>
 * The default, pre-defined Configurations are available as constants on the {&#64;link EcsDeploymentConfig} class
 * (for example, <code>EcsDeploymentConfig.AllAtOnce</code>).
 * <p>
 * Note: CloudFormation does not currently support creating custom ECS configs outside
 * of using a custom resource. You can import custom deployment config created outside the
 * CDK or via a custom resource with {&#64;link EcsDeploymentConfig#fromEcsDeploymentConfigName}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.22.0 (build 14afdde)", date = "2020-03-18T17:03:28.586Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.IEcsDeploymentConfig")
@software.amazon.jsii.Jsii.Proxy(IEcsDeploymentConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IEcsDeploymentConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getDeploymentConfigArn();

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getDeploymentConfigName();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getDeploymentConfigArn() {
            return this.jsiiGet("deploymentConfigArn", java.lang.String.class);
        }

        /**
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getDeploymentConfigName() {
            return this.jsiiGet("deploymentConfigName", java.lang.String.class);
        }
    }
}
