package software.amazon.awscdk.services.codedeploy;

/**
 * Properties of a reference to a CodeDeploy Lambda Deployment Configuration.
 * <p>
 * @see LambdaDeploymentConfig#import
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.5.0 (build 46538f8)", date = "2020-05-08T05:31:29.681Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.LambdaDeploymentConfigImportProps")
@software.amazon.jsii.Jsii.Proxy(LambdaDeploymentConfigImportProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LambdaDeploymentConfigImportProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The physical, human-readable name of the custom CodeDeploy Lambda Deployment Configuration that we are referencing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDeploymentConfigName();

    /**
     * @return a {@link Builder} of {@link LambdaDeploymentConfigImportProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LambdaDeploymentConfigImportProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String deploymentConfigName;

        /**
         * Sets the value of {@link LambdaDeploymentConfigImportProps#getDeploymentConfigName}
         * @param deploymentConfigName The physical, human-readable name of the custom CodeDeploy Lambda Deployment Configuration that we are referencing. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfigName(java.lang.String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LambdaDeploymentConfigImportProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public LambdaDeploymentConfigImportProps build() {
            return new Jsii$Proxy(deploymentConfigName);
        }
    }

    /**
     * An implementation for {@link LambdaDeploymentConfigImportProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaDeploymentConfigImportProps {
        private final java.lang.String deploymentConfigName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deploymentConfigName = this.jsiiGet("deploymentConfigName", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String deploymentConfigName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deploymentConfigName = java.util.Objects.requireNonNull(deploymentConfigName, "deploymentConfigName is required");
        }

        @Override
        public java.lang.String getDeploymentConfigName() {
            return this.deploymentConfigName;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("deploymentConfigName", om.valueToTree(this.getDeploymentConfigName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.LambdaDeploymentConfigImportProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LambdaDeploymentConfigImportProps.Jsii$Proxy that = (LambdaDeploymentConfigImportProps.Jsii$Proxy) o;

            return this.deploymentConfigName.equals(that.deploymentConfigName);
        }

        @Override
        public int hashCode() {
            int result = this.deploymentConfigName.hashCode();
            return result;
        }
    }
}
