package software.amazon.awscdk.services.codedeploy;

/**
 * Properties of a reference to a CodeDeploy Lambda Deployment Group.
 * 
 * @see LambdaDeploymentGroup#fromLambdaDeploymentGroupAttributes
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.3 (build 1b1062d)", date = "2019-08-14T08:25:49.610Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LambdaDeploymentGroupAttributes extends software.amazon.jsii.JsiiSerializable {
    /**
     * The reference to the CodeDeploy Lambda Application that this Deployment Group belongs to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.codedeploy.ILambdaApplication getApplication();
    /**
     * The physical, human-readable name of the CodeDeploy Lambda Deployment Group that we are referencing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getDeploymentGroupName();
    /**
     * The Deployment Configuration this Deployment Group uses.
     * 
     * Default: LambdaDeploymentConfig.CANARY_10PERCENT_5MINUTES
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig getDeploymentConfig();

    /**
     * @return a {@link Builder} of {@link LambdaDeploymentGroupAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link LambdaDeploymentGroupAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.services.codedeploy.ILambdaApplication _application;
        private java.lang.String _deploymentGroupName;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig _deploymentConfig;

        /**
         * Sets the value of Application
         * @param value The reference to the CodeDeploy Lambda Application that this Deployment Group belongs to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withApplication(final software.amazon.awscdk.services.codedeploy.ILambdaApplication value) {
            this._application = java.util.Objects.requireNonNull(value, "application is required");
            return this;
        }
        /**
         * Sets the value of DeploymentGroupName
         * @param value The physical, human-readable name of the CodeDeploy Lambda Deployment Group that we are referencing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDeploymentGroupName(final java.lang.String value) {
            this._deploymentGroupName = java.util.Objects.requireNonNull(value, "deploymentGroupName is required");
            return this;
        }
        /**
         * Sets the value of DeploymentConfig
         * @param value The Deployment Configuration this Deployment Group uses.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDeploymentConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig value) {
            this._deploymentConfig = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LambdaDeploymentGroupAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public LambdaDeploymentGroupAttributes build() {
            return new LambdaDeploymentGroupAttributes() {
                private final software.amazon.awscdk.services.codedeploy.ILambdaApplication $application = java.util.Objects.requireNonNull(_application, "application is required");
                private final java.lang.String $deploymentGroupName = java.util.Objects.requireNonNull(_deploymentGroupName, "deploymentGroupName is required");
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig $deploymentConfig = _deploymentConfig;

                @Override
                public software.amazon.awscdk.services.codedeploy.ILambdaApplication getApplication() {
                    return this.$application;
                }

                @Override
                public java.lang.String getDeploymentGroupName() {
                    return this.$deploymentGroupName;
                }

                @Override
                public software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig getDeploymentConfig() {
                    return this.$deploymentConfig;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("application", om.valueToTree(this.getApplication()));
                    obj.set("deploymentGroupName", om.valueToTree(this.getDeploymentGroupName()));
                    if (this.getDeploymentConfig() != null) {
                        obj.set("deploymentConfig", om.valueToTree(this.getDeploymentConfig()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.LambdaDeploymentGroupAttributes {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The reference to the CodeDeploy Lambda Application that this Deployment Group belongs to.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.codedeploy.ILambdaApplication getApplication() {
            return this.jsiiGet("application", software.amazon.awscdk.services.codedeploy.ILambdaApplication.class);
        }

        /**
         * The physical, human-readable name of the CodeDeploy Lambda Deployment Group that we are referencing.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getDeploymentGroupName() {
            return this.jsiiGet("deploymentGroupName", java.lang.String.class);
        }

        /**
         * The Deployment Configuration this Deployment Group uses.
         * 
         * Default: LambdaDeploymentConfig.CANARY_10PERCENT_5MINUTES
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig getDeploymentConfig() {
            return this.jsiiGet("deploymentConfig", software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig.class);
        }
    }
}
