package software.amazon.awscdk.services.codedeploy;

/**
 * An interface of an abstract load balancer, as needed by CodeDeploy.
 * <p>
 * Create instances using the static factory methods:
 * {&#64;link #classic}, {&#64;link #application} and {&#64;link #network}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.7.0 (build 179a3a5)", date = "2020-06-24T18:52:23.456Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.LoadBalancer")
public abstract class LoadBalancer extends software.amazon.jsii.JsiiObject {

    protected LoadBalancer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LoadBalancer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    protected LoadBalancer() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Creates a new CodeDeploy load balancer from an Application Load Balancer Target Group.
     * <p>
     * @param albTargetGroup an ALB Target Group. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.LoadBalancer application(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup albTargetGroup) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codedeploy.LoadBalancer.class, "application", software.amazon.awscdk.services.codedeploy.LoadBalancer.class, new Object[] { java.util.Objects.requireNonNull(albTargetGroup, "albTargetGroup is required") });
    }

    /**
     * Creates a new CodeDeploy load balancer from a Classic ELB Load Balancer.
     * <p>
     * @param loadBalancer a classic ELB Load Balancer. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.LoadBalancer classic(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancing.LoadBalancer loadBalancer) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codedeploy.LoadBalancer.class, "classic", software.amazon.awscdk.services.codedeploy.LoadBalancer.class, new Object[] { java.util.Objects.requireNonNull(loadBalancer, "loadBalancer is required") });
    }

    /**
     * Creates a new CodeDeploy load balancer from a Network Load Balancer Target Group.
     * <p>
     * @param nlbTargetGroup an NLB Target Group. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.LoadBalancer network(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup nlbTargetGroup) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codedeploy.LoadBalancer.class, "network", software.amazon.awscdk.services.codedeploy.LoadBalancer.class, new Object[] { java.util.Objects.requireNonNull(nlbTargetGroup, "nlbTargetGroup is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.LoadBalancerGeneration getGeneration();

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.codedeploy.LoadBalancer {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.LoadBalancerGeneration getGeneration() {
            return this.jsiiGet("generation", software.amazon.awscdk.services.codedeploy.LoadBalancerGeneration.class);
        }

        /**
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getName() {
            return this.jsiiGet("name", java.lang.String.class);
        }
    }
}
