package software.amazon.awscdk.services.codedeploy;

/**
 * The configuration for automatically rolling back deployments in a given Deployment Group.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-12T19:02:39.714Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.AutoRollbackConfig")
@software.amazon.jsii.Jsii.Proxy(AutoRollbackConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AutoRollbackConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether to automatically roll back a deployment during which one of the configured CloudWatch alarms for this Deployment Group went off.
     * <p>
     * Default: true if you've provided any Alarms with the `alarms` property, false otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDeploymentInAlarm() {
        return null;
    }

    /**
     * Whether to automatically roll back a deployment that fails.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getFailedDeployment() {
        return null;
    }

    /**
     * Whether to automatically roll back a deployment that was manually stopped.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getStoppedDeployment() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AutoRollbackConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AutoRollbackConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AutoRollbackConfig> {
        private java.lang.Boolean deploymentInAlarm;
        private java.lang.Boolean failedDeployment;
        private java.lang.Boolean stoppedDeployment;

        /**
         * Sets the value of {@link AutoRollbackConfig#getDeploymentInAlarm}
         * @param deploymentInAlarm Whether to automatically roll back a deployment during which one of the configured CloudWatch alarms for this Deployment Group went off.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentInAlarm(java.lang.Boolean deploymentInAlarm) {
            this.deploymentInAlarm = deploymentInAlarm;
            return this;
        }

        /**
         * Sets the value of {@link AutoRollbackConfig#getFailedDeployment}
         * @param failedDeployment Whether to automatically roll back a deployment that fails.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failedDeployment(java.lang.Boolean failedDeployment) {
            this.failedDeployment = failedDeployment;
            return this;
        }

        /**
         * Sets the value of {@link AutoRollbackConfig#getStoppedDeployment}
         * @param stoppedDeployment Whether to automatically roll back a deployment that was manually stopped.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stoppedDeployment(java.lang.Boolean stoppedDeployment) {
            this.stoppedDeployment = stoppedDeployment;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AutoRollbackConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AutoRollbackConfig build() {
            return new Jsii$Proxy(deploymentInAlarm, failedDeployment, stoppedDeployment);
        }
    }

    /**
     * An implementation for {@link AutoRollbackConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoRollbackConfig {
        private final java.lang.Boolean deploymentInAlarm;
        private final java.lang.Boolean failedDeployment;
        private final java.lang.Boolean stoppedDeployment;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deploymentInAlarm = this.jsiiGet("deploymentInAlarm", java.lang.Boolean.class);
            this.failedDeployment = this.jsiiGet("failedDeployment", java.lang.Boolean.class);
            this.stoppedDeployment = this.jsiiGet("stoppedDeployment", java.lang.Boolean.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Boolean deploymentInAlarm, final java.lang.Boolean failedDeployment, final java.lang.Boolean stoppedDeployment) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deploymentInAlarm = deploymentInAlarm;
            this.failedDeployment = failedDeployment;
            this.stoppedDeployment = stoppedDeployment;
        }

        @Override
        public java.lang.Boolean getDeploymentInAlarm() {
            return this.deploymentInAlarm;
        }

        @Override
        public java.lang.Boolean getFailedDeployment() {
            return this.failedDeployment;
        }

        @Override
        public java.lang.Boolean getStoppedDeployment() {
            return this.stoppedDeployment;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDeploymentInAlarm() != null) {
                data.set("deploymentInAlarm", om.valueToTree(this.getDeploymentInAlarm()));
            }
            if (this.getFailedDeployment() != null) {
                data.set("failedDeployment", om.valueToTree(this.getFailedDeployment()));
            }
            if (this.getStoppedDeployment() != null) {
                data.set("stoppedDeployment", om.valueToTree(this.getStoppedDeployment()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.AutoRollbackConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AutoRollbackConfig.Jsii$Proxy that = (AutoRollbackConfig.Jsii$Proxy) o;

            if (this.deploymentInAlarm != null ? !this.deploymentInAlarm.equals(that.deploymentInAlarm) : that.deploymentInAlarm != null) return false;
            if (this.failedDeployment != null ? !this.failedDeployment.equals(that.failedDeployment) : that.failedDeployment != null) return false;
            return this.stoppedDeployment != null ? this.stoppedDeployment.equals(that.stoppedDeployment) : that.stoppedDeployment == null;
        }

        @Override
        public int hashCode() {
            int result = this.deploymentInAlarm != null ? this.deploymentInAlarm.hashCode() : 0;
            result = 31 * result + (this.failedDeployment != null ? this.failedDeployment.hashCode() : 0);
            result = 31 * result + (this.stoppedDeployment != null ? this.stoppedDeployment.hashCode() : 0);
            return result;
        }
    }
}
