/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codedeploy;

import java.util.List;
import software.amazon.awscdk.services.cloudwatch.IAlarm;
import software.amazon.awscdk.services.codedeploy.AutoRollbackConfig;
import software.amazon.awscdk.services.codedeploy.ILambdaApplication;
import software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig;
import software.amazon.awscdk.services.codedeploy.LambdaDeploymentGroupProps;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.lambda.Alias;
import software.amazon.awscdk.services.lambda.IFunction;
import software.amazon.jsii.JsiiSerializable;

public interface LambdaDeploymentGroupProps
extends JsiiSerializable {
    public Alias getAlias();

    public List<IAlarm> getAlarms();

    public ILambdaApplication getApplication();

    public AutoRollbackConfig getAutoRollback();

    public ILambdaDeploymentConfig getDeploymentConfig();

    public String getDeploymentGroupName();

    public Boolean getIgnorePollAlarmsFailure();

    public IFunction getPostHook();

    public IFunction getPreHook();

    public IRole getRole();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Alias alias;
        private List<IAlarm> alarms;
        private ILambdaApplication application;
        private AutoRollbackConfig autoRollback;
        private ILambdaDeploymentConfig deploymentConfig;
        private String deploymentGroupName;
        private Boolean ignorePollAlarmsFailure;
        private IFunction postHook;
        private IFunction preHook;
        private IRole role;

        public Builder alias(Alias alias) {
            this.alias = alias;
            return this;
        }

        public Builder alarms(List<IAlarm> alarms) {
            this.alarms = alarms;
            return this;
        }

        public Builder application(ILambdaApplication application) {
            this.application = application;
            return this;
        }

        public Builder autoRollback(AutoRollbackConfig autoRollback) {
            this.autoRollback = autoRollback;
            return this;
        }

        public Builder deploymentConfig(ILambdaDeploymentConfig deploymentConfig) {
            this.deploymentConfig = deploymentConfig;
            return this;
        }

        public Builder deploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        public Builder ignorePollAlarmsFailure(Boolean ignorePollAlarmsFailure) {
            this.ignorePollAlarmsFailure = ignorePollAlarmsFailure;
            return this;
        }

        public Builder postHook(IFunction postHook) {
            this.postHook = postHook;
            return this;
        }

        public Builder preHook(IFunction preHook) {
            this.preHook = preHook;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public LambdaDeploymentGroupProps build() {
            return new Jsii.Proxy(this.alias, this.alarms, this.application, this.autoRollback, this.deploymentConfig, this.deploymentGroupName, this.ignorePollAlarmsFailure, this.postHook, this.preHook, this.role, null);
        }
    }
}

