/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codedeploy;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.codedeploy.$Module;
import software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup;
import software.amazon.awscdk.services.codedeploy.CfnDeploymentGroupProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-codedeploy.CfnDeploymentGroup")
public class CfnDeploymentGroup
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnDeploymentGroup.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnDeploymentGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDeploymentGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnDeploymentGroup(@NotNull Construct scope, @NotNull String id, @NotNull CfnDeploymentGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getApplicationName() {
        return (String)this.jsiiGet("applicationName", String.class);
    }

    public void setApplicationName(@NotNull String value) {
        this.jsiiSet("applicationName", Objects.requireNonNull(value, "applicationName is required"));
    }

    @NotNull
    public String getServiceRoleArn() {
        return (String)this.jsiiGet("serviceRoleArn", String.class);
    }

    public void setServiceRoleArn(@NotNull String value) {
        this.jsiiSet("serviceRoleArn", Objects.requireNonNull(value, "serviceRoleArn is required"));
    }

    @Nullable
    public Object getAlarmConfiguration() {
        return this.jsiiGet("alarmConfiguration", Object.class);
    }

    public void setAlarmConfiguration(@Nullable IResolvable value) {
        this.jsiiSet("alarmConfiguration", value);
    }

    public void setAlarmConfiguration(@Nullable AlarmConfigurationProperty value) {
        this.jsiiSet("alarmConfiguration", value);
    }

    @Nullable
    public Object getAutoRollbackConfiguration() {
        return this.jsiiGet("autoRollbackConfiguration", Object.class);
    }

    public void setAutoRollbackConfiguration(@Nullable IResolvable value) {
        this.jsiiSet("autoRollbackConfiguration", value);
    }

    public void setAutoRollbackConfiguration(@Nullable AutoRollbackConfigurationProperty value) {
        this.jsiiSet("autoRollbackConfiguration", value);
    }

    @Nullable
    public List<String> getAutoScalingGroups() {
        return Optional.ofNullable((List)this.jsiiGet("autoScalingGroups", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setAutoScalingGroups(@Nullable List<String> value) {
        this.jsiiSet("autoScalingGroups", value);
    }

    @Nullable
    public Object getDeployment() {
        return this.jsiiGet("deployment", Object.class);
    }

    public void setDeployment(@Nullable IResolvable value) {
        this.jsiiSet("deployment", value);
    }

    public void setDeployment(@Nullable DeploymentProperty value) {
        this.jsiiSet("deployment", value);
    }

    @Nullable
    public String getDeploymentConfigName() {
        return (String)this.jsiiGet("deploymentConfigName", String.class);
    }

    public void setDeploymentConfigName(@Nullable String value) {
        this.jsiiSet("deploymentConfigName", value);
    }

    @Nullable
    public String getDeploymentGroupName() {
        return (String)this.jsiiGet("deploymentGroupName", String.class);
    }

    public void setDeploymentGroupName(@Nullable String value) {
        this.jsiiSet("deploymentGroupName", value);
    }

    @Nullable
    public Object getDeploymentStyle() {
        return this.jsiiGet("deploymentStyle", Object.class);
    }

    public void setDeploymentStyle(@Nullable IResolvable value) {
        this.jsiiSet("deploymentStyle", value);
    }

    public void setDeploymentStyle(@Nullable DeploymentStyleProperty value) {
        this.jsiiSet("deploymentStyle", value);
    }

    @Nullable
    public Object getEc2TagFilters() {
        return this.jsiiGet("ec2TagFilters", Object.class);
    }

    public void setEc2TagFilters(@Nullable IResolvable value) {
        this.jsiiSet("ec2TagFilters", value);
    }

    public void setEc2TagFilters(@Nullable List<Object> value) {
        this.jsiiSet("ec2TagFilters", value);
    }

    @Nullable
    public Object getEc2TagSet() {
        return this.jsiiGet("ec2TagSet", Object.class);
    }

    public void setEc2TagSet(@Nullable IResolvable value) {
        this.jsiiSet("ec2TagSet", value);
    }

    public void setEc2TagSet(@Nullable EC2TagSetProperty value) {
        this.jsiiSet("ec2TagSet", value);
    }

    @Nullable
    public Object getLoadBalancerInfo() {
        return this.jsiiGet("loadBalancerInfo", Object.class);
    }

    public void setLoadBalancerInfo(@Nullable IResolvable value) {
        this.jsiiSet("loadBalancerInfo", value);
    }

    public void setLoadBalancerInfo(@Nullable LoadBalancerInfoProperty value) {
        this.jsiiSet("loadBalancerInfo", value);
    }

    @Nullable
    public Object getOnPremisesInstanceTagFilters() {
        return this.jsiiGet("onPremisesInstanceTagFilters", Object.class);
    }

    public void setOnPremisesInstanceTagFilters(@Nullable IResolvable value) {
        this.jsiiSet("onPremisesInstanceTagFilters", value);
    }

    public void setOnPremisesInstanceTagFilters(@Nullable List<Object> value) {
        this.jsiiSet("onPremisesInstanceTagFilters", value);
    }

    @Nullable
    public Object getOnPremisesTagSet() {
        return this.jsiiGet("onPremisesTagSet", Object.class);
    }

    public void setOnPremisesTagSet(@Nullable IResolvable value) {
        this.jsiiSet("onPremisesTagSet", value);
    }

    public void setOnPremisesTagSet(@Nullable OnPremisesTagSetProperty value) {
        this.jsiiSet("onPremisesTagSet", value);
    }

    @Nullable
    public Object getTriggerConfigurations() {
        return this.jsiiGet("triggerConfigurations", Object.class);
    }

    public void setTriggerConfigurations(@Nullable IResolvable value) {
        this.jsiiSet("triggerConfigurations", value);
    }

    public void setTriggerConfigurations(@Nullable List<Object> value) {
        this.jsiiSet("triggerConfigurations", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnDeploymentGroup> {
        private final Construct scope;
        private final String id;
        private final CfnDeploymentGroupProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnDeploymentGroupProps.Builder();
        }

        public Builder applicationName(String applicationName) {
            this.props.applicationName(applicationName);
            return this;
        }

        public Builder serviceRoleArn(String serviceRoleArn) {
            this.props.serviceRoleArn(serviceRoleArn);
            return this;
        }

        public Builder alarmConfiguration(IResolvable alarmConfiguration) {
            this.props.alarmConfiguration(alarmConfiguration);
            return this;
        }

        public Builder alarmConfiguration(AlarmConfigurationProperty alarmConfiguration) {
            this.props.alarmConfiguration(alarmConfiguration);
            return this;
        }

        public Builder autoRollbackConfiguration(IResolvable autoRollbackConfiguration) {
            this.props.autoRollbackConfiguration(autoRollbackConfiguration);
            return this;
        }

        public Builder autoRollbackConfiguration(AutoRollbackConfigurationProperty autoRollbackConfiguration) {
            this.props.autoRollbackConfiguration(autoRollbackConfiguration);
            return this;
        }

        public Builder autoScalingGroups(List<String> autoScalingGroups) {
            this.props.autoScalingGroups(autoScalingGroups);
            return this;
        }

        public Builder deployment(IResolvable deployment) {
            this.props.deployment(deployment);
            return this;
        }

        public Builder deployment(DeploymentProperty deployment) {
            this.props.deployment(deployment);
            return this;
        }

        public Builder deploymentConfigName(String deploymentConfigName) {
            this.props.deploymentConfigName(deploymentConfigName);
            return this;
        }

        public Builder deploymentGroupName(String deploymentGroupName) {
            this.props.deploymentGroupName(deploymentGroupName);
            return this;
        }

        public Builder deploymentStyle(IResolvable deploymentStyle) {
            this.props.deploymentStyle(deploymentStyle);
            return this;
        }

        public Builder deploymentStyle(DeploymentStyleProperty deploymentStyle) {
            this.props.deploymentStyle(deploymentStyle);
            return this;
        }

        public Builder ec2TagFilters(IResolvable ec2TagFilters) {
            this.props.ec2TagFilters(ec2TagFilters);
            return this;
        }

        public Builder ec2TagFilters(List<Object> ec2TagFilters) {
            this.props.ec2TagFilters(ec2TagFilters);
            return this;
        }

        public Builder ec2TagSet(IResolvable ec2TagSet) {
            this.props.ec2TagSet(ec2TagSet);
            return this;
        }

        public Builder ec2TagSet(EC2TagSetProperty ec2TagSet) {
            this.props.ec2TagSet(ec2TagSet);
            return this;
        }

        public Builder loadBalancerInfo(IResolvable loadBalancerInfo) {
            this.props.loadBalancerInfo(loadBalancerInfo);
            return this;
        }

        public Builder loadBalancerInfo(LoadBalancerInfoProperty loadBalancerInfo) {
            this.props.loadBalancerInfo(loadBalancerInfo);
            return this;
        }

        public Builder onPremisesInstanceTagFilters(IResolvable onPremisesInstanceTagFilters) {
            this.props.onPremisesInstanceTagFilters(onPremisesInstanceTagFilters);
            return this;
        }

        public Builder onPremisesInstanceTagFilters(List<Object> onPremisesInstanceTagFilters) {
            this.props.onPremisesInstanceTagFilters(onPremisesInstanceTagFilters);
            return this;
        }

        public Builder onPremisesTagSet(IResolvable onPremisesTagSet) {
            this.props.onPremisesTagSet(onPremisesTagSet);
            return this;
        }

        public Builder onPremisesTagSet(OnPremisesTagSetProperty onPremisesTagSet) {
            this.props.onPremisesTagSet(onPremisesTagSet);
            return this;
        }

        public Builder triggerConfigurations(IResolvable triggerConfigurations) {
            this.props.triggerConfigurations(triggerConfigurations);
            return this;
        }

        public Builder triggerConfigurations(List<Object> triggerConfigurations) {
            this.props.triggerConfigurations(triggerConfigurations);
            return this;
        }

        public CfnDeploymentGroup build() {
            return new CfnDeploymentGroup(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-codedeploy.CfnDeploymentGroup.TriggerConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TriggerConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getTriggerEvents() {
            return null;
        }

        @Nullable
        default public String getTriggerName() {
            return null;
        }

        @Nullable
        default public String getTriggerTargetArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TriggerConfigProperty> {
            private List<String> triggerEvents;
            private String triggerName;
            private String triggerTargetArn;

            public Builder triggerEvents(List<String> triggerEvents) {
                this.triggerEvents = triggerEvents;
                return this;
            }

            public Builder triggerName(String triggerName) {
                this.triggerName = triggerName;
                return this;
            }

            public Builder triggerTargetArn(String triggerTargetArn) {
                this.triggerTargetArn = triggerTargetArn;
                return this;
            }

            public TriggerConfigProperty build() {
                return new Jsii.Proxy(this.triggerEvents, this.triggerName, this.triggerTargetArn, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-codedeploy.CfnDeploymentGroup.TargetGroupInfoProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TargetGroupInfoProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TargetGroupInfoProperty> {
            private String name;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public TargetGroupInfoProperty build() {
                return new Jsii.Proxy(this.name, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-codedeploy.CfnDeploymentGroup.TagFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TagFilterProperty
    extends JsiiSerializable {
        @Nullable
        default public String getKey() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        @Nullable
        default public String getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TagFilterProperty> {
            private String key;
            private String type;
            private String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public TagFilterProperty build() {
                return new Jsii.Proxy(this.key, this.type, this.value, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-codedeploy.CfnDeploymentGroup.S3LocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3LocationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucket();

        @NotNull
        public String getKey();

        @Nullable
        default public String getBundleType() {
            return null;
        }

        @Nullable
        default public String getETag() {
            return null;
        }

        @Nullable
        default public String getVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3LocationProperty> {
            private String bucket;
            private String key;
            private String bundleType;
            private String eTag;
            private String version;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder bundleType(String bundleType) {
                this.bundleType = bundleType;
                return this;
            }

            public Builder eTag(String eTag) {
                this.eTag = eTag;
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public S3LocationProperty build() {
                return new Jsii.Proxy(this.bucket, this.key, this.bundleType, this.eTag, this.version, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-codedeploy.CfnDeploymentGroup.RevisionLocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RevisionLocationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getGitHubLocation() {
            return null;
        }

        @Nullable
        default public String getRevisionType() {
            return null;
        }

        @Nullable
        default public Object getS3Location() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RevisionLocationProperty> {
            private Object gitHubLocation;
            private String revisionType;
            private Object s3Location;

            public Builder gitHubLocation(IResolvable gitHubLocation) {
                this.gitHubLocation = gitHubLocation;
                return this;
            }

            public Builder gitHubLocation(GitHubLocationProperty gitHubLocation) {
                this.gitHubLocation = gitHubLocation;
                return this;
            }

            public Builder revisionType(String revisionType) {
                this.revisionType = revisionType;
                return this;
            }

            public Builder s3Location(IResolvable s3Location) {
                this.s3Location = s3Location;
                return this;
            }

            public Builder s3Location(S3LocationProperty s3Location) {
                this.s3Location = s3Location;
                return this;
            }

            public RevisionLocationProperty build() {
                return new Jsii.Proxy(this.gitHubLocation, this.revisionType, this.s3Location, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-codedeploy.CfnDeploymentGroup.OnPremisesTagSetProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OnPremisesTagSetProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getOnPremisesTagSetList() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OnPremisesTagSetProperty> {
            private Object onPremisesTagSetList;

            public Builder onPremisesTagSetList(IResolvable onPremisesTagSetList) {
                this.onPremisesTagSetList = onPremisesTagSetList;
                return this;
            }

            public Builder onPremisesTagSetList(List<Object> onPremisesTagSetList) {
                this.onPremisesTagSetList = onPremisesTagSetList;
                return this;
            }

            public OnPremisesTagSetProperty build() {
                return new Jsii.Proxy(this.onPremisesTagSetList, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-codedeploy.CfnDeploymentGroup.OnPremisesTagSetListObjectProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OnPremisesTagSetListObjectProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getOnPremisesTagGroup() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OnPremisesTagSetListObjectProperty> {
            private Object onPremisesTagGroup;

            public Builder onPremisesTagGroup(IResolvable onPremisesTagGroup) {
                this.onPremisesTagGroup = onPremisesTagGroup;
                return this;
            }

            public Builder onPremisesTagGroup(List<Object> onPremisesTagGroup) {
                this.onPremisesTagGroup = onPremisesTagGroup;
                return this;
            }

            public OnPremisesTagSetListObjectProperty build() {
                return new Jsii.Proxy(this.onPremisesTagGroup, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-codedeploy.CfnDeploymentGroup.LoadBalancerInfoProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LoadBalancerInfoProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getElbInfoList() {
            return null;
        }

        @Nullable
        default public Object getTargetGroupInfoList() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LoadBalancerInfoProperty> {
            private Object elbInfoList;
            private Object targetGroupInfoList;

            public Builder elbInfoList(IResolvable elbInfoList) {
                this.elbInfoList = elbInfoList;
                return this;
            }

            public Builder elbInfoList(List<Object> elbInfoList) {
                this.elbInfoList = elbInfoList;
                return this;
            }

            public Builder targetGroupInfoList(IResolvable targetGroupInfoList) {
                this.targetGroupInfoList = targetGroupInfoList;
                return this;
            }

            public Builder targetGroupInfoList(List<Object> targetGroupInfoList) {
                this.targetGroupInfoList = targetGroupInfoList;
                return this;
            }

            public LoadBalancerInfoProperty build() {
                return new Jsii.Proxy(this.elbInfoList, this.targetGroupInfoList, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-codedeploy.CfnDeploymentGroup.GitHubLocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GitHubLocationProperty
    extends JsiiSerializable {
        @NotNull
        public String getCommitId();

        @NotNull
        public String getRepository();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GitHubLocationProperty> {
            private String commitId;
            private String repository;

            public Builder commitId(String commitId) {
                this.commitId = commitId;
                return this;
            }

            public Builder repository(String repository) {
                this.repository = repository;
                return this;
            }

            public GitHubLocationProperty build() {
                return new Jsii.Proxy(this.commitId, this.repository, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-codedeploy.CfnDeploymentGroup.ELBInfoProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ELBInfoProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ELBInfoProperty> {
            private String name;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public ELBInfoProperty build() {
                return new Jsii.Proxy(this.name, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-codedeploy.CfnDeploymentGroup.EC2TagSetProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EC2TagSetProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEc2TagSetList() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EC2TagSetProperty> {
            private Object ec2TagSetList;

            public Builder ec2TagSetList(IResolvable ec2TagSetList) {
                this.ec2TagSetList = ec2TagSetList;
                return this;
            }

            public Builder ec2TagSetList(List<Object> ec2TagSetList) {
                this.ec2TagSetList = ec2TagSetList;
                return this;
            }

            public EC2TagSetProperty build() {
                return new Jsii.Proxy(this.ec2TagSetList, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-codedeploy.CfnDeploymentGroup.EC2TagSetListObjectProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EC2TagSetListObjectProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEc2TagGroup() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EC2TagSetListObjectProperty> {
            private Object ec2TagGroup;

            public Builder ec2TagGroup(IResolvable ec2TagGroup) {
                this.ec2TagGroup = ec2TagGroup;
                return this;
            }

            public Builder ec2TagGroup(List<Object> ec2TagGroup) {
                this.ec2TagGroup = ec2TagGroup;
                return this;
            }

            public EC2TagSetListObjectProperty build() {
                return new Jsii.Proxy(this.ec2TagGroup, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-codedeploy.CfnDeploymentGroup.EC2TagFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EC2TagFilterProperty
    extends JsiiSerializable {
        @Nullable
        default public String getKey() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        @Nullable
        default public String getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EC2TagFilterProperty> {
            private String key;
            private String type;
            private String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public EC2TagFilterProperty build() {
                return new Jsii.Proxy(this.key, this.type, this.value, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-codedeploy.CfnDeploymentGroup.DeploymentStyleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeploymentStyleProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDeploymentOption() {
            return null;
        }

        @Nullable
        default public String getDeploymentType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeploymentStyleProperty> {
            private String deploymentOption;
            private String deploymentType;

            public Builder deploymentOption(String deploymentOption) {
                this.deploymentOption = deploymentOption;
                return this;
            }

            public Builder deploymentType(String deploymentType) {
                this.deploymentType = deploymentType;
                return this;
            }

            public DeploymentStyleProperty build() {
                return new Jsii.Proxy(this.deploymentOption, this.deploymentType, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-codedeploy.CfnDeploymentGroup.DeploymentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeploymentProperty
    extends JsiiSerializable {
        @NotNull
        public Object getRevision();

        @Nullable
        default public String getDescription() {
            return null;
        }

        @Nullable
        default public Object getIgnoreApplicationStopFailures() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeploymentProperty> {
            private Object revision;
            private String description;
            private Object ignoreApplicationStopFailures;

            public Builder revision(IResolvable revision) {
                this.revision = revision;
                return this;
            }

            public Builder revision(RevisionLocationProperty revision) {
                this.revision = revision;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder ignoreApplicationStopFailures(Boolean ignoreApplicationStopFailures) {
                this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
                return this;
            }

            public Builder ignoreApplicationStopFailures(IResolvable ignoreApplicationStopFailures) {
                this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
                return this;
            }

            public DeploymentProperty build() {
                return new Jsii.Proxy(this.revision, this.description, this.ignoreApplicationStopFailures, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-codedeploy.CfnDeploymentGroup.AutoRollbackConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AutoRollbackConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEnabled() {
            return null;
        }

        @Nullable
        default public List<String> getEvents() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AutoRollbackConfigurationProperty> {
            private Object enabled;
            private List<String> events;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder events(List<String> events) {
                this.events = events;
                return this;
            }

            public AutoRollbackConfigurationProperty build() {
                return new Jsii.Proxy(this.enabled, this.events, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-codedeploy.CfnDeploymentGroup.AlarmProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AlarmProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AlarmProperty> {
            private String name;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public AlarmProperty build() {
                return new Jsii.Proxy(this.name, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-codedeploy.CfnDeploymentGroup.AlarmConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AlarmConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAlarms() {
            return null;
        }

        @Nullable
        default public Object getEnabled() {
            return null;
        }

        @Nullable
        default public Object getIgnorePollAlarmFailure() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AlarmConfigurationProperty> {
            private Object alarms;
            private Object enabled;
            private Object ignorePollAlarmFailure;

            public Builder alarms(IResolvable alarms) {
                this.alarms = alarms;
                return this;
            }

            public Builder alarms(List<Object> alarms) {
                this.alarms = alarms;
                return this;
            }

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder ignorePollAlarmFailure(Boolean ignorePollAlarmFailure) {
                this.ignorePollAlarmFailure = ignorePollAlarmFailure;
                return this;
            }

            public Builder ignorePollAlarmFailure(IResolvable ignorePollAlarmFailure) {
                this.ignorePollAlarmFailure = ignorePollAlarmFailure;
                return this;
            }

            public AlarmConfigurationProperty build() {
                return new Jsii.Proxy(this.alarms, this.enabled, this.ignorePollAlarmFailure, null);
            }
        }
    }
}

