package software.amazon.awscdk.services.codedeploy;

/**
 * The Deployment Configuration of an ECS Deployment Group.
 * <p>
 * The default, pre-defined Configurations are available as constants on the {&#64;link EcsDeploymentConfig} class
 * (for example, <code>EcsDeploymentConfig.AllAtOnce</code>).
 * <p>
 * Note: CloudFormation does not currently support creating custom ECS configs outside
 * of using a custom resource. You can import custom deployment config created outside the
 * CDK or via a custom resource with {&#64;link EcsDeploymentConfig#fromEcsDeploymentConfigName}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.13.0 (build 385c325)", date = "2020-10-02T20:11:16.526Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.IEcsDeploymentConfig")
@software.amazon.jsii.Jsii.Proxy(IEcsDeploymentConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IEcsDeploymentConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDeploymentConfigArn();

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDeploymentConfigName();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getDeploymentConfigArn() {
            return this.jsiiGet("deploymentConfigArn", java.lang.String.class);
        }

        /**
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getDeploymentConfigName() {
            return this.jsiiGet("deploymentConfigName", java.lang.String.class);
        }
    }
}
