package software.amazon.awscdk.services.codedeploy;

/**
 * Properties of a reference to a CodeDeploy Lambda Deployment Configuration.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.13.0 (build 385c325)", date = "2020-10-15T17:38:37.720Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CustomLambdaDeploymentConfigProps")
@software.amazon.jsii.Jsii.Proxy(CustomLambdaDeploymentConfigProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CustomLambdaDeploymentConfigProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The interval, in number of minutes: - For LINEAR, how frequently additional traffic is shifted - For CANARY, how long to shift traffic before the full deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Duration getInterval();

    /**
     * The integer percentage of traffic to shift: - For LINEAR, the percentage to shift every interval - For CANARY, the percentage to shift until the interval passes, before the full deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getPercentage();

    /**
     * The type of deployment config, either CANARY or LINEAR.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.CustomLambdaDeploymentConfigType getType();

    /**
     * The verbatim name of the deployment config.
     * <p>
     * Must be unique per account/region.
     * Other parameters cannot be updated if this name is provided.
     * <p>
     * Default: - automatically generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeploymentConfigName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CustomLambdaDeploymentConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CustomLambdaDeploymentConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CustomLambdaDeploymentConfigProps> {
        private software.amazon.awscdk.core.Duration interval;
        private java.lang.Number percentage;
        private software.amazon.awscdk.services.codedeploy.CustomLambdaDeploymentConfigType type;
        private java.lang.String deploymentConfigName;

        /**
         * Sets the value of {@link CustomLambdaDeploymentConfigProps#getInterval}
         * @param interval The interval, in number of minutes: - For LINEAR, how frequently additional traffic is shifted - For CANARY, how long to shift traffic before the full deployment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder interval(software.amazon.awscdk.core.Duration interval) {
            this.interval = interval;
            return this;
        }

        /**
         * Sets the value of {@link CustomLambdaDeploymentConfigProps#getPercentage}
         * @param percentage The integer percentage of traffic to shift: - For LINEAR, the percentage to shift every interval - For CANARY, the percentage to shift until the interval passes, before the full deployment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder percentage(java.lang.Number percentage) {
            this.percentage = percentage;
            return this;
        }

        /**
         * Sets the value of {@link CustomLambdaDeploymentConfigProps#getType}
         * @param type The type of deployment config, either CANARY or LINEAR. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(software.amazon.awscdk.services.codedeploy.CustomLambdaDeploymentConfigType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CustomLambdaDeploymentConfigProps#getDeploymentConfigName}
         * @param deploymentConfigName The verbatim name of the deployment config.
         *                             Must be unique per account/region.
         *                             Other parameters cannot be updated if this name is provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfigName(java.lang.String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CustomLambdaDeploymentConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CustomLambdaDeploymentConfigProps build() {
            return new Jsii$Proxy(interval, percentage, type, deploymentConfigName);
        }
    }

    /**
     * An implementation for {@link CustomLambdaDeploymentConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomLambdaDeploymentConfigProps {
        private final software.amazon.awscdk.core.Duration interval;
        private final java.lang.Number percentage;
        private final software.amazon.awscdk.services.codedeploy.CustomLambdaDeploymentConfigType type;
        private final java.lang.String deploymentConfigName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.interval = this.jsiiGet("interval", software.amazon.awscdk.core.Duration.class);
            this.percentage = this.jsiiGet("percentage", java.lang.Number.class);
            this.type = this.jsiiGet("type", software.amazon.awscdk.services.codedeploy.CustomLambdaDeploymentConfigType.class);
            this.deploymentConfigName = this.jsiiGet("deploymentConfigName", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.core.Duration interval, final java.lang.Number percentage, final software.amazon.awscdk.services.codedeploy.CustomLambdaDeploymentConfigType type, final java.lang.String deploymentConfigName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.interval = java.util.Objects.requireNonNull(interval, "interval is required");
            this.percentage = java.util.Objects.requireNonNull(percentage, "percentage is required");
            this.type = java.util.Objects.requireNonNull(type, "type is required");
            this.deploymentConfigName = deploymentConfigName;
        }

        @Override
        public software.amazon.awscdk.core.Duration getInterval() {
            return this.interval;
        }

        @Override
        public java.lang.Number getPercentage() {
            return this.percentage;
        }

        @Override
        public software.amazon.awscdk.services.codedeploy.CustomLambdaDeploymentConfigType getType() {
            return this.type;
        }

        @Override
        public java.lang.String getDeploymentConfigName() {
            return this.deploymentConfigName;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("interval", om.valueToTree(this.getInterval()));
            data.set("percentage", om.valueToTree(this.getPercentage()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getDeploymentConfigName() != null) {
                data.set("deploymentConfigName", om.valueToTree(this.getDeploymentConfigName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-codedeploy.CustomLambdaDeploymentConfigProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CustomLambdaDeploymentConfigProps.Jsii$Proxy that = (CustomLambdaDeploymentConfigProps.Jsii$Proxy) o;

            if (!interval.equals(that.interval)) return false;
            if (!percentage.equals(that.percentage)) return false;
            if (!type.equals(that.type)) return false;
            return this.deploymentConfigName != null ? this.deploymentConfigName.equals(that.deploymentConfigName) : that.deploymentConfigName == null;
        }

        @Override
        public int hashCode() {
            int result = this.interval.hashCode();
            result = 31 * result + (this.percentage.hashCode());
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.deploymentConfigName != null ? this.deploymentConfigName.hashCode() : 0);
            return result;
        }
    }
}
