/**
 * <h2>AWS CodeDeploy Construct Library</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * AWS CodeDeploy is a deployment service that automates application deployments to
 * Amazon EC2 instances, on-premises instances, serverless Lambda functions, or
 * Amazon ECS services.
 * <p>
 * The CDK currently supports Amazon EC2, on-premise and AWS Lambda applications.
 * <p>
 * <h3>EC2/on-premise Applications</h3>
 * <p>
 * To create a new CodeDeploy Application that deploys to EC2/on-premise instances:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.codedeploy.*;
 * 
 * ServerApplication application = new ServerApplication(this, "CodeDeployApplication", new ServerApplicationProps()
 *         .applicationName("MyApplication"));
 * </pre></blockquote>
 * <p>
 * To import an already existing Application:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var application = codedeploy.ServerApplication.fromServerApplicationName(this, "ExistingCodeDeployApplication", "MyExistingApplication");
 * </pre></blockquote>
 * <p>
 * <h3>EC2/on-premise Deployment Groups</h3>
 * <p>
 * To create a new CodeDeploy Deployment Group that deploys to EC2/on-premise instances:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var deploymentGroup = ServerDeploymentGroup.Builder.create(this, "CodeDeployDeploymentGroup")
 *         .application(application)
 *         .deploymentGroupName("MyDeploymentGroup")
 *         .autoScalingGroups(asList(asg1, asg2))
 *         // adds User Data that installs the CodeDeploy agent on your auto-scaling groups hosts
 *         // default: true
 *         .installAgent(true)
 *         // adds EC2 instances matching tags
 *         .ec2InstanceTags(InstanceTagSet.Builder.create()
 *                 // any instance with tags satisfying
 *                 // key1=v1 or key1=v2 or key2 (any value) or value v3 (any key)
 *                 // will match this group
 *                 .key1(asList("v1", "v2"))
 *                 .key2(asList())
 *                 .(asList("v3"))
 *                 .build())
 *         // adds on-premise instances matching tags
 *         .onPremiseInstanceTags(InstanceTagSet.Builder.create(Map.of(
 *                 "key1", asList("v1", "v2")))
 *                 .key2(asList("v3"))
 *                 .build())
 *         // CloudWatch alarms
 *         .alarms(asList(
 *             new Alarm()))
 *         // whether to ignore failure to fetch the status of alarms from CloudWatch
 *         // default: false
 *         .ignorePollAlarmsFailure(false)
 *         // auto-rollback configuration
 *         .autoRollback(Map.of(
 *                 "failedDeployment", true, // default: true
 *                 "stoppedDeployment", true, // default: false
 *                 "deploymentInAlarm", true))
 *         .build();
 * </pre></blockquote>
 * <p>
 * All properties are optional - if you don't provide an Application,
 * one will be automatically created.
 * <p>
 * To import an already existing Deployment Group:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var deploymentGroup = codedeploy.ServerDeploymentGroup.fromLambdaDeploymentGroupAttributes(this, "ExistingCodeDeployDeploymentGroup", Map.of(
 *         "application", application,
 *         "deploymentGroupName", "MyExistingDeploymentGroup"));
 * </pre></blockquote>
 * <p>
 * <h4>Load balancers</h4>
 * <p>
 * You can <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-elastic-load-balancing.html">specify a load balancer</a>
 * with the <code>loadBalancer</code> property when creating a Deployment Group.
 * <p>
 * <code>LoadBalancer</code> is an abstract class with static factory methods that allow you to create instances of it from various sources.
 * <p>
 * With Classic Elastic Load Balancer, you provide it directly:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.elasticloadbalancing.*;
 * 
 * LoadBalancer elb = new LoadBalancer(this, "ELB", new LoadBalancerProps());
 * elb.addTarget();
 * elb.addListener(new LoadBalancerListener());
 * 
 * var deploymentGroup = ServerDeploymentGroup.Builder.create(this, "DeploymentGroup")
 *         .loadBalancer(codedeploy.LoadBalancer.classic(elb))
 *         .build();
 * </pre></blockquote>
 * <p>
 * With Application Load Balancer or Network Load Balancer,
 * you provide a Target Group as the load balancer:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * 
 * ApplicationLoadBalancer alb = new ApplicationLoadBalancer(this, "ALB", new ApplicationLoadBalancerProps());
 * ApplicationListener listener = alb.addListener("Listener", new BaseApplicationListenerProps());
 * ApplicationTargetGroup targetGroup = listener.addTargets("Fleet", new AddApplicationTargetsProps());
 * 
 * var deploymentGroup = ServerDeploymentGroup.Builder.create(this, "DeploymentGroup")
 *         .loadBalancer(codedeploy.LoadBalancer.application(targetGroup))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Deployment Configurations</h3>
 * <p>
 * You can also pass a Deployment Configuration when creating the Deployment Group:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var deploymentGroup = ServerDeploymentGroup.Builder.create(this, "CodeDeployDeploymentGroup")
 *         .deploymentConfig(codedeploy.ServerDeploymentConfig.getALL_AT_ONCE())
 *         .build();
 * </pre></blockquote>
 * <p>
 * The default Deployment Configuration is <code>ServerDeploymentConfig.ONE_AT_A_TIME</code>.
 * <p>
 * You can also create a custom Deployment Configuration:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var deploymentConfig = ServerDeploymentConfig.Builder.create(this, "DeploymentConfiguration")
 *         .deploymentConfigName("MyDeploymentConfiguration")// optional property
 *         // one of these is required, but both cannot be specified at the same time
 *         .minHealthyHostCount(2)
 *         .minHealthyHostPercentage(75)
 *         .build();
 * </pre></blockquote>
 * <p>
 * Or import an existing one:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var deploymentConfig = codedeploy.ServerDeploymentConfig.fromServerDeploymentConfigName(this, "ExistingDeploymentConfiguration", "MyExistingDeploymentConfiguration");
 * </pre></blockquote>
 * <p>
 * <h3>Lambda Applications</h3>
 * <p>
 * To create a new CodeDeploy Application that deploys to a Lambda function:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.codedeploy.*;
 * 
 * LambdaApplication application = new LambdaApplication(this, "CodeDeployApplication", new LambdaApplicationProps()
 *         .applicationName("MyApplication"));
 * </pre></blockquote>
 * <p>
 * To import an already existing Application:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var application = codedeploy.LambdaApplication.fromLambdaApplicationName(this, "ExistingCodeDeployApplication", "MyExistingApplication");
 * </pre></blockquote>
 * <p>
 * <h3>Lambda Deployment Groups</h3>
 * <p>
 * To enable traffic shifting deployments for Lambda functions, CodeDeploy uses Lambda Aliases, which can balance incoming traffic between two different versions of your function.
 * Before deployment, the alias sends 100% of invokes to the version used in production.
 * When you publish a new version of the function to your stack, CodeDeploy will send a small percentage of traffic to the new version, monitor, and validate before shifting 100% of traffic to the new version.
 * <p>
 * To create a new CodeDeploy Deployment Group that deploys to a Lambda function:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.codedeploy.*;
 * import software.amazon.awscdk.services.lambda.*;
 * 
 * LambdaApplication myApplication = new LambdaApplication();
 * Function func = new Function();
 * Version version = func.addVersion("1");
 * Alias version1Alias = new Alias(this, "alias", new AliasProps()
 *         .aliasName("prod")
 *         .version(version));
 * 
 * LambdaDeploymentGroup deploymentGroup = new LambdaDeploymentGroup(stack, "BlueGreenDeployment", new LambdaDeploymentGroupProps()
 *         .application(myApplication)// optional property: one will be created for you if not provided
 *         .alias(version1Alias)
 *         .deploymentConfig(codedeploy.LambdaDeploymentConfig.getLINEAR_10PERCENT_EVERY_1MINUTE()));
 * </pre></blockquote>
 * <p>
 * In order to deploy a new version of this function:
 * <p>
 * <ol>
 * <li>Increment the version, e.g. <code>const version = func.addVersion('2')</code>.</li>
 * <li>Re-deploy the stack (this will trigger a deployment).</li>
 * <li>Monitor the CodeDeploy deployment as traffic shifts between the versions.</li>
 * </ol>
 * <p>
 * <h4>Create a custom Deployment Config</h4>
 * <p>
 * CodeDeploy for Lambda comes with built-in configurations for traffic shifting.
 * If you want to specify your own strategy,
 * you can do so with the CustomLambdaDeploymentConfig construct,
 * letting you specify precisely how fast a new function version is deployed.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var config = CustomLambdaDeploymentConfig.Builder.create(stack, "CustomConfig")
 *         .type(codedeploy.CustomLambdaDeploymentConfigType.getCANARY())
 *         .interval(Duration.minutes(1))
 *         .percentage(5)
 *         .build();
 * var deploymentGroup = LambdaDeploymentGroup.Builder.create(stack, "BlueGreenDeployment")
 *         .application(application)
 *         .alias(alias)
 *         .deploymentConfig(config)
 *         .build();
 * </pre></blockquote>
 * <p>
 * You can specify a custom name for your deployment config, but if you do you will not be able to update the interval/percentage through CDK.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var config = CustomLambdaDeploymentConfig.Builder.create(stack, "CustomConfig")
 *         .type(codedeploy.CustomLambdaDeploymentConfigType.getCANARY())
 *         .interval(Duration.minutes(1))
 *         .percentage(5)
 *         .deploymentConfigName("MyDeploymentConfig")
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h4>Rollbacks and Alarms</h4>
 * <p>
 * CodeDeploy will roll back if the deployment fails. You can optionally trigger a rollback when one or more alarms are in a failed state:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var deploymentGroup = LambdaDeploymentGroup.Builder.create(stack, "BlueGreenDeployment")
 *         .alias(alias)
 *         .deploymentConfig(codedeploy.LambdaDeploymentConfig.getLINEAR_10PERCENT_EVERY_1MINUTE())
 *         .alarms(asList(
 *             // pass some alarms when constructing the deployment group
 *             Alarm.Builder.create(stack, "Errors")
 *                     .comparisonOperator(cloudwatch.ComparisonOperator.getGREATER_THAN_THRESHOLD())
 *                     .threshold(1)
 *                     .evaluationPeriods(1)
 *                     .metric(alias.metricErrors())
 *                     .build()))
 *         .build();
 * 
 * // or add alarms to an existing group
 * deploymentGroup.addAlarm(Alarm.Builder.create(stack, "BlueGreenErrors")
 *         .comparisonOperator(cloudwatch.ComparisonOperator.getGREATER_THAN_THRESHOLD())
 *         .threshold(1)
 *         .evaluationPeriods(1)
 *         .metric(blueGreenAlias.metricErrors())
 *         .build());
 * </pre></blockquote>
 * <p>
 * <h4>Pre and Post Hooks</h4>
 * <p>
 * CodeDeploy allows you to run an arbitrary Lambda function before traffic shifting actually starts (PreTraffic Hook) and after it completes (PostTraffic Hook).
 * With either hook, you have the opportunity to run logic that determines whether the deployment must succeed or fail.
 * For example, with PreTraffic hook you could run integration tests against the newly created Lambda version (but not serving traffic). With PostTraffic hook, you could run end-to-end validation checks.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var warmUpUserCache = new Function();
 * var endToEndValidation = new Function();
 * 
 * // pass a hook whe creating the deployment group
 * var deploymentGroup = LambdaDeploymentGroup.Builder.create(stack, "BlueGreenDeployment")
 *         .alias(alias)
 *         .deploymentConfig(codedeploy.LambdaDeploymentConfig.getLINEAR_10PERCENT_EVERY_1MINUTE())
 *         .preHook(warmUpUserCache)
 *         .build();
 * 
 * // or configure one on an existing deployment group
 * deploymentGroup.onPostHook(endToEndValidation);
 * </pre></blockquote>
 * <p>
 * <h4>Import an existing Deployment Group</h4>
 * <p>
 * To import an already existing Deployment Group:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var deploymentGroup = codedeploy.LambdaDeploymentGroup.import(this, "ExistingCodeDeployDeploymentGroup", Map.of(
 *         "application", application,
 *         "deploymentGroupName", "MyExistingDeploymentGroup"));
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.codedeploy;
