/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codedeploy;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.codedeploy.;
import software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup;
import software.amazon.awscdk.services.codedeploy.CfnDeploymentGroupProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-codedeploy.CfnDeploymentGroup")
public class CfnDeploymentGroup
extends CfnResource {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnDeploymentGroup.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnDeploymentGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDeploymentGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnDeploymentGroup(Construct scope, String id, CfnDeploymentGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        this.setObjRef(JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")}));
    }

    protected Map<String, Object> renderProperties(Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", Map.class, new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", Map.class));
    }

    public String getApplicationName() {
        return (String)this.jsiiGet("applicationName", String.class);
    }

    public void setApplicationName(String value) {
        this.jsiiSet("applicationName", Objects.requireNonNull(value, "applicationName is required"));
    }

    public String getServiceRoleArn() {
        return (String)this.jsiiGet("serviceRoleArn", String.class);
    }

    public void setServiceRoleArn(String value) {
        this.jsiiSet("serviceRoleArn", Objects.requireNonNull(value, "serviceRoleArn is required"));
    }

    public Object getAlarmConfiguration() {
        return this.jsiiGet("alarmConfiguration", Object.class);
    }

    public void setAlarmConfiguration(AlarmConfigurationProperty value) {
        this.jsiiSet("alarmConfiguration", value);
    }

    public void setAlarmConfiguration(IResolvable value) {
        this.jsiiSet("alarmConfiguration", value);
    }

    public Object getAutoRollbackConfiguration() {
        return this.jsiiGet("autoRollbackConfiguration", Object.class);
    }

    public void setAutoRollbackConfiguration(IResolvable value) {
        this.jsiiSet("autoRollbackConfiguration", value);
    }

    public void setAutoRollbackConfiguration(AutoRollbackConfigurationProperty value) {
        this.jsiiSet("autoRollbackConfiguration", value);
    }

    public List<String> getAutoScalingGroups() {
        return Collections.unmodifiableList((List)this.jsiiGet("autoScalingGroups", List.class));
    }

    public void setAutoScalingGroups(List<String> value) {
        this.jsiiSet("autoScalingGroups", value);
    }

    public Object getDeployment() {
        return this.jsiiGet("deployment", Object.class);
    }

    public void setDeployment(IResolvable value) {
        this.jsiiSet("deployment", value);
    }

    public void setDeployment(DeploymentProperty value) {
        this.jsiiSet("deployment", value);
    }

    public String getDeploymentConfigName() {
        return (String)this.jsiiGet("deploymentConfigName", String.class);
    }

    public void setDeploymentConfigName(String value) {
        this.jsiiSet("deploymentConfigName", value);
    }

    public String getDeploymentGroupName() {
        return (String)this.jsiiGet("deploymentGroupName", String.class);
    }

    public void setDeploymentGroupName(String value) {
        this.jsiiSet("deploymentGroupName", value);
    }

    public Object getDeploymentStyle() {
        return this.jsiiGet("deploymentStyle", Object.class);
    }

    public void setDeploymentStyle(IResolvable value) {
        this.jsiiSet("deploymentStyle", value);
    }

    public void setDeploymentStyle(DeploymentStyleProperty value) {
        this.jsiiSet("deploymentStyle", value);
    }

    public Object getEc2TagFilters() {
        return this.jsiiGet("ec2TagFilters", Object.class);
    }

    public void setEc2TagFilters(IResolvable value) {
        this.jsiiSet("ec2TagFilters", value);
    }

    public void setEc2TagFilters(List<Object> value) {
        this.jsiiSet("ec2TagFilters", value);
    }

    public Object getEc2TagSet() {
        return this.jsiiGet("ec2TagSet", Object.class);
    }

    public void setEc2TagSet(IResolvable value) {
        this.jsiiSet("ec2TagSet", value);
    }

    public void setEc2TagSet(EC2TagSetProperty value) {
        this.jsiiSet("ec2TagSet", value);
    }

    public Object getLoadBalancerInfo() {
        return this.jsiiGet("loadBalancerInfo", Object.class);
    }

    public void setLoadBalancerInfo(IResolvable value) {
        this.jsiiSet("loadBalancerInfo", value);
    }

    public void setLoadBalancerInfo(LoadBalancerInfoProperty value) {
        this.jsiiSet("loadBalancerInfo", value);
    }

    public Object getOnPremisesInstanceTagFilters() {
        return this.jsiiGet("onPremisesInstanceTagFilters", Object.class);
    }

    public void setOnPremisesInstanceTagFilters(IResolvable value) {
        this.jsiiSet("onPremisesInstanceTagFilters", value);
    }

    public void setOnPremisesInstanceTagFilters(List<Object> value) {
        this.jsiiSet("onPremisesInstanceTagFilters", value);
    }

    public Object getOnPremisesTagSet() {
        return this.jsiiGet("onPremisesTagSet", Object.class);
    }

    public void setOnPremisesTagSet(IResolvable value) {
        this.jsiiSet("onPremisesTagSet", value);
    }

    public void setOnPremisesTagSet(OnPremisesTagSetProperty value) {
        this.jsiiSet("onPremisesTagSet", value);
    }

    public Object getTriggerConfigurations() {
        return this.jsiiGet("triggerConfigurations", Object.class);
    }

    public void setTriggerConfigurations(IResolvable value) {
        this.jsiiSet("triggerConfigurations", value);
    }

    public void setTriggerConfigurations(List<Object> value) {
        this.jsiiSet("triggerConfigurations", value);
    }

    public static interface TriggerConfigProperty
    extends JsiiSerializable {
        public List<String> getTriggerEvents();

        public String getTriggerName();

        public String getTriggerTargetArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private List<String> triggerEvents;
            private String triggerName;
            private String triggerTargetArn;

            public Builder triggerEvents(List<String> triggerEvents) {
                this.triggerEvents = triggerEvents;
                return this;
            }

            public Builder triggerName(String triggerName) {
                this.triggerName = triggerName;
                return this;
            }

            public Builder triggerTargetArn(String triggerTargetArn) {
                this.triggerTargetArn = triggerTargetArn;
                return this;
            }

            public TriggerConfigProperty build() {
                return new Jsii.Proxy(this.triggerEvents, this.triggerName, this.triggerTargetArn, null);
            }
        }
    }

    public static interface TargetGroupInfoProperty
    extends JsiiSerializable {
        public String getName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String name;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public TargetGroupInfoProperty build() {
                return new Jsii.Proxy(this.name, null);
            }
        }
    }

    public static interface TagFilterProperty
    extends JsiiSerializable {
        public String getKey();

        public String getType();

        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String key;
            private String type;
            private String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public TagFilterProperty build() {
                return new Jsii.Proxy(this.key, this.type, this.value, null);
            }
        }
    }

    public static interface S3LocationProperty
    extends JsiiSerializable {
        public String getBucket();

        public String getKey();

        public String getBundleType();

        public String getETag();

        public String getVersion();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String bucket;
            private String key;
            private String bundleType;
            private String eTag;
            private String version;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder bundleType(String bundleType) {
                this.bundleType = bundleType;
                return this;
            }

            public Builder eTag(String eTag) {
                this.eTag = eTag;
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public S3LocationProperty build() {
                return new Jsii.Proxy(this.bucket, this.key, this.bundleType, this.eTag, this.version, null);
            }
        }
    }

    public static interface RevisionLocationProperty
    extends JsiiSerializable {
        public Object getGitHubLocation();

        public String getRevisionType();

        public Object getS3Location();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object gitHubLocation;
            private String revisionType;
            private Object s3Location;

            public Builder gitHubLocation(IResolvable gitHubLocation) {
                this.gitHubLocation = gitHubLocation;
                return this;
            }

            public Builder gitHubLocation(GitHubLocationProperty gitHubLocation) {
                this.gitHubLocation = gitHubLocation;
                return this;
            }

            public Builder revisionType(String revisionType) {
                this.revisionType = revisionType;
                return this;
            }

            public Builder s3Location(IResolvable s3Location) {
                this.s3Location = s3Location;
                return this;
            }

            public Builder s3Location(S3LocationProperty s3Location) {
                this.s3Location = s3Location;
                return this;
            }

            public RevisionLocationProperty build() {
                return new Jsii.Proxy(this.gitHubLocation, this.revisionType, this.s3Location, null);
            }
        }
    }

    public static interface OnPremisesTagSetProperty
    extends JsiiSerializable {
        public Object getOnPremisesTagSetList();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object onPremisesTagSetList;

            public Builder onPremisesTagSetList(IResolvable onPremisesTagSetList) {
                this.onPremisesTagSetList = onPremisesTagSetList;
                return this;
            }

            public Builder onPremisesTagSetList(List<Object> onPremisesTagSetList) {
                this.onPremisesTagSetList = onPremisesTagSetList;
                return this;
            }

            public OnPremisesTagSetProperty build() {
                return new Jsii.Proxy(this.onPremisesTagSetList, null);
            }
        }
    }

    public static interface OnPremisesTagSetListObjectProperty
    extends JsiiSerializable {
        public Object getOnPremisesTagGroup();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object onPremisesTagGroup;

            public Builder onPremisesTagGroup(IResolvable onPremisesTagGroup) {
                this.onPremisesTagGroup = onPremisesTagGroup;
                return this;
            }

            public Builder onPremisesTagGroup(List<Object> onPremisesTagGroup) {
                this.onPremisesTagGroup = onPremisesTagGroup;
                return this;
            }

            public OnPremisesTagSetListObjectProperty build() {
                return new Jsii.Proxy(this.onPremisesTagGroup, null);
            }
        }
    }

    public static interface LoadBalancerInfoProperty
    extends JsiiSerializable {
        public Object getElbInfoList();

        public Object getTargetGroupInfoList();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object elbInfoList;
            private Object targetGroupInfoList;

            public Builder elbInfoList(IResolvable elbInfoList) {
                this.elbInfoList = elbInfoList;
                return this;
            }

            public Builder elbInfoList(List<Object> elbInfoList) {
                this.elbInfoList = elbInfoList;
                return this;
            }

            public Builder targetGroupInfoList(IResolvable targetGroupInfoList) {
                this.targetGroupInfoList = targetGroupInfoList;
                return this;
            }

            public Builder targetGroupInfoList(List<Object> targetGroupInfoList) {
                this.targetGroupInfoList = targetGroupInfoList;
                return this;
            }

            public LoadBalancerInfoProperty build() {
                return new Jsii.Proxy(this.elbInfoList, this.targetGroupInfoList, null);
            }
        }
    }

    public static interface GitHubLocationProperty
    extends JsiiSerializable {
        public String getCommitId();

        public String getRepository();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String commitId;
            private String repository;

            public Builder commitId(String commitId) {
                this.commitId = commitId;
                return this;
            }

            public Builder repository(String repository) {
                this.repository = repository;
                return this;
            }

            public GitHubLocationProperty build() {
                return new Jsii.Proxy(this.commitId, this.repository, null);
            }
        }
    }

    public static interface ELBInfoProperty
    extends JsiiSerializable {
        public String getName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String name;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public ELBInfoProperty build() {
                return new Jsii.Proxy(this.name, null);
            }
        }
    }

    public static interface EC2TagSetProperty
    extends JsiiSerializable {
        public Object getEc2TagSetList();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object ec2TagSetList;

            public Builder ec2TagSetList(IResolvable ec2TagSetList) {
                this.ec2TagSetList = ec2TagSetList;
                return this;
            }

            public Builder ec2TagSetList(List<Object> ec2TagSetList) {
                this.ec2TagSetList = ec2TagSetList;
                return this;
            }

            public EC2TagSetProperty build() {
                return new Jsii.Proxy(this.ec2TagSetList, null);
            }
        }
    }

    public static interface EC2TagSetListObjectProperty
    extends JsiiSerializable {
        public Object getEc2TagGroup();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object ec2TagGroup;

            public Builder ec2TagGroup(IResolvable ec2TagGroup) {
                this.ec2TagGroup = ec2TagGroup;
                return this;
            }

            public Builder ec2TagGroup(List<Object> ec2TagGroup) {
                this.ec2TagGroup = ec2TagGroup;
                return this;
            }

            public EC2TagSetListObjectProperty build() {
                return new Jsii.Proxy(this.ec2TagGroup, null);
            }
        }
    }

    public static interface EC2TagFilterProperty
    extends JsiiSerializable {
        public String getKey();

        public String getType();

        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String key;
            private String type;
            private String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public EC2TagFilterProperty build() {
                return new Jsii.Proxy(this.key, this.type, this.value, null);
            }
        }
    }

    public static interface DeploymentStyleProperty
    extends JsiiSerializable {
        public String getDeploymentOption();

        public String getDeploymentType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String deploymentOption;
            private String deploymentType;

            public Builder deploymentOption(String deploymentOption) {
                this.deploymentOption = deploymentOption;
                return this;
            }

            public Builder deploymentType(String deploymentType) {
                this.deploymentType = deploymentType;
                return this;
            }

            public DeploymentStyleProperty build() {
                return new Jsii.Proxy(this.deploymentOption, this.deploymentType, null);
            }
        }
    }

    public static interface DeploymentProperty
    extends JsiiSerializable {
        public Object getRevision();

        public String getDescription();

        public Object getIgnoreApplicationStopFailures();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object revision;
            private String description;
            private Object ignoreApplicationStopFailures;

            public Builder revision(IResolvable revision) {
                this.revision = revision;
                return this;
            }

            public Builder revision(RevisionLocationProperty revision) {
                this.revision = revision;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder ignoreApplicationStopFailures(Boolean ignoreApplicationStopFailures) {
                this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
                return this;
            }

            public Builder ignoreApplicationStopFailures(IResolvable ignoreApplicationStopFailures) {
                this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
                return this;
            }

            public DeploymentProperty build() {
                return new Jsii.Proxy(this.revision, this.description, this.ignoreApplicationStopFailures, null);
            }
        }
    }

    public static interface AutoRollbackConfigurationProperty
    extends JsiiSerializable {
        public Object getEnabled();

        public List<String> getEvents();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object enabled;
            private List<String> events;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder events(List<String> events) {
                this.events = events;
                return this;
            }

            public AutoRollbackConfigurationProperty build() {
                return new Jsii.Proxy(this.enabled, this.events, null);
            }
        }
    }

    public static interface AlarmProperty
    extends JsiiSerializable {
        public String getName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String name;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public AlarmProperty build() {
                return new Jsii.Proxy(this.name, null);
            }
        }
    }

    public static interface AlarmConfigurationProperty
    extends JsiiSerializable {
        public Object getAlarms();

        public Object getEnabled();

        public Object getIgnorePollAlarmFailure();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object alarms;
            private Object enabled;
            private Object ignorePollAlarmFailure;

            public Builder alarms(IResolvable alarms) {
                this.alarms = alarms;
                return this;
            }

            public Builder alarms(List<Object> alarms) {
                this.alarms = alarms;
                return this;
            }

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder ignorePollAlarmFailure(Boolean ignorePollAlarmFailure) {
                this.ignorePollAlarmFailure = ignorePollAlarmFailure;
                return this;
            }

            public Builder ignorePollAlarmFailure(IResolvable ignorePollAlarmFailure) {
                this.ignorePollAlarmFailure = ignorePollAlarmFailure;
                return this;
            }

            public AlarmConfigurationProperty build() {
                return new Jsii.Proxy(this.alarms, this.enabled, this.ignorePollAlarmFailure, null);
            }
        }
    }
}

