package software.amazon.awscdk.services.cognito.identitypool.alpha;

/**
 * (experimental) Keys for Login Providers - correspond to client id's of respective federation identity providers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cognito.UserPool;
 * import software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl;
 * UserPool userPool;
 * IdentityPool.Builder.create(this, "myidentitypool")
 *         .identityPoolName("myidentitypool")
 *         .roleMappings(List.of(IdentityPoolRoleMapping.builder()
 *                 .mappingKey("cognito")
 *                 .providerUrl(IdentityPoolProviderUrl.userPool(userPool.getUserPoolProviderUrl()))
 *                 .useToken(true)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-13T02:49:33.832Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.identitypool.alpha.$Module.class, fqn = "@aws-cdk/aws-cognito-identitypool-alpha.IdentityPoolProviderUrl")
public class IdentityPoolProviderUrl extends software.amazon.jsii.JsiiObject {

    protected IdentityPoolProviderUrl(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected IdentityPoolProviderUrl(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        AMAZON = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl.class, "AMAZON", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl.class));
        APPLE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl.class, "APPLE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl.class));
        DIGITS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl.class, "DIGITS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl.class));
        FACEBOOK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl.class, "FACEBOOK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl.class));
        GOOGLE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl.class, "GOOGLE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl.class));
        TWITTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl.class, "TWITTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl.class));
    }

    /**
     * @param type type of Provider Url. This parameter is required.
     * @param value value of Provider Url. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public IdentityPoolProviderUrl(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderType type, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(type, "type is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) Custom Provider Url.
     * <p>
     * @param url This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl custom(final @org.jetbrains.annotations.NotNull java.lang.String url) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl.class, "custom", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl.class), new Object[] { java.util.Objects.requireNonNull(url, "url is required") });
    }

    /**
     * (experimental) OpenId Provider Url.
     * <p>
     * @param url This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl openId(final @org.jetbrains.annotations.NotNull java.lang.String url) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl.class, "openId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl.class), new Object[] { java.util.Objects.requireNonNull(url, "url is required") });
    }

    /**
     * (experimental) Saml Provider Url.
     * <p>
     * @param url This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl saml(final @org.jetbrains.annotations.NotNull java.lang.String url) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl.class, "saml", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl.class), new Object[] { java.util.Objects.requireNonNull(url, "url is required") });
    }

    /**
     * (experimental) User Pool Provider Url.
     * <p>
     * @param url This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl userPool(final @org.jetbrains.annotations.NotNull java.lang.String url) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl.class, "userPool", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl.class), new Object[] { java.util.Objects.requireNonNull(url, "url is required") });
    }

    /**
     * (experimental) Amazon Provider Url.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl AMAZON;

    /**
     * (experimental) Apple Provider Url.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl APPLE;

    /**
     * (experimental) Digits Provider Url.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl DIGITS;

    /**
     * (experimental) Facebook Provider Url.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl FACEBOOK;

    /**
     * (experimental) Google Provider Url.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl GOOGLE;

    /**
     * (experimental) Twitter Provider Url.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl TWITTER;

    /**
     * (experimental) type of Provider Url.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderType getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderType.class));
    }

    /**
     * (experimental) value of Provider Url.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getValue() {
        return software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
