package software.amazon.awscdk.services.cognito.identitypool.alpha;

/**
 * (experimental) Types of matches allowed for Role Mapping.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cognito.identitypool.alpha.IdentityPoolProviderUrl;
 * import software.amazon.awscdk.services.cognito.identitypool.alpha.RoleMappingMatchType;
 * Role adminRole;
 * Role nonAdminRole;
 * IdentityPool.Builder.create(this, "myidentitypool")
 *         .identityPoolName("myidentitypool")
 *         // Assign specific roles to users based on whether or not the custom admin claim is passed from the identity provider
 *         .roleMappings(List.of(IdentityPoolRoleMapping.builder()
 *                 .providerUrl(IdentityPoolProviderUrl.AMAZON)
 *                 .rules(List.of(RoleMappingRule.builder()
 *                         .claim("custom:admin")
 *                         .claimValue("admin")
 *                         .mappedRole(adminRole)
 *                         .build(), RoleMappingRule.builder()
 *                         .claim("custom:admin")
 *                         .claimValue("admin")
 *                         .matchType(RoleMappingMatchType.NOTEQUAL)
 *                         .mappedRole(nonAdminRole)
 *                         .build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-13T02:49:33.835Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.identitypool.alpha.$Module.class, fqn = "@aws-cdk/aws-cognito-identitypool-alpha.RoleMappingMatchType")
public enum RoleMappingMatchType {
    /**
     * (experimental) The Claim from the token must equal the given value in order for a match.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    EQUALS,
    /**
     * (experimental) The Claim from the token must contain the given value in order for a match.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    CONTAINS,
    /**
     * (experimental) The Claim from the token must start with the given value in order for a match.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    STARTS_WITH,
    /**
     * (experimental) The Claim from the token must not equal the given value in order for a match.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    NOTEQUAL,
}
