package software.amazon.awscdk.services.cognito.identitypool.alpha;

/**
 * (experimental) Represents an Identity Pool Role Attachment Role Mapping Rule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.identitypool.alpha.*;
 * import software.amazon.awscdk.services.iam.*;
 * Role role;
 * RoleMappingRule roleMappingRule = RoleMappingRule.builder()
 *         .claim("claim")
 *         .claimValue("claimValue")
 *         .mappedRole(role)
 *         // the properties below are optional
 *         .matchType(RoleMappingMatchType.EQUALS)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-13T02:49:33.835Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.identitypool.alpha.$Module.class, fqn = "@aws-cdk/aws-cognito-identitypool-alpha.RoleMappingRule")
@software.amazon.jsii.Jsii.Proxy(RoleMappingRule.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface RoleMappingRule extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The key sent in the token by the federated identity provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getClaim();

    /**
     * (experimental) The value of the claim that must be matched.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getClaimValue();

    /**
     * (experimental) The Role to be assumed when Claim Value is matched.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getMappedRole();

    /**
     * (experimental) How to match with the Claim value.
     * <p>
     * Default: RoleMappingMatchType.EQUALS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.identitypool.alpha.RoleMappingMatchType getMatchType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RoleMappingRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RoleMappingRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<RoleMappingRule> {
        java.lang.String claim;
        java.lang.String claimValue;
        software.amazon.awscdk.services.iam.IRole mappedRole;
        software.amazon.awscdk.services.cognito.identitypool.alpha.RoleMappingMatchType matchType;

        /**
         * Sets the value of {@link RoleMappingRule#getClaim}
         * @param claim The key sent in the token by the federated identity provider. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder claim(java.lang.String claim) {
            this.claim = claim;
            return this;
        }

        /**
         * Sets the value of {@link RoleMappingRule#getClaimValue}
         * @param claimValue The value of the claim that must be matched. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder claimValue(java.lang.String claimValue) {
            this.claimValue = claimValue;
            return this;
        }

        /**
         * Sets the value of {@link RoleMappingRule#getMappedRole}
         * @param mappedRole The Role to be assumed when Claim Value is matched. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mappedRole(software.amazon.awscdk.services.iam.IRole mappedRole) {
            this.mappedRole = mappedRole;
            return this;
        }

        /**
         * Sets the value of {@link RoleMappingRule#getMatchType}
         * @param matchType How to match with the Claim value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder matchType(software.amazon.awscdk.services.cognito.identitypool.alpha.RoleMappingMatchType matchType) {
            this.matchType = matchType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RoleMappingRule}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public RoleMappingRule build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RoleMappingRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RoleMappingRule {
        private final java.lang.String claim;
        private final java.lang.String claimValue;
        private final software.amazon.awscdk.services.iam.IRole mappedRole;
        private final software.amazon.awscdk.services.cognito.identitypool.alpha.RoleMappingMatchType matchType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.claim = software.amazon.jsii.Kernel.get(this, "claim", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.claimValue = software.amazon.jsii.Kernel.get(this, "claimValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.mappedRole = software.amazon.jsii.Kernel.get(this, "mappedRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.matchType = software.amazon.jsii.Kernel.get(this, "matchType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.alpha.RoleMappingMatchType.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.claim = java.util.Objects.requireNonNull(builder.claim, "claim is required");
            this.claimValue = java.util.Objects.requireNonNull(builder.claimValue, "claimValue is required");
            this.mappedRole = java.util.Objects.requireNonNull(builder.mappedRole, "mappedRole is required");
            this.matchType = builder.matchType;
        }

        @Override
        public final java.lang.String getClaim() {
            return this.claim;
        }

        @Override
        public final java.lang.String getClaimValue() {
            return this.claimValue;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getMappedRole() {
            return this.mappedRole;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.identitypool.alpha.RoleMappingMatchType getMatchType() {
            return this.matchType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("claim", om.valueToTree(this.getClaim()));
            data.set("claimValue", om.valueToTree(this.getClaimValue()));
            data.set("mappedRole", om.valueToTree(this.getMappedRole()));
            if (this.getMatchType() != null) {
                data.set("matchType", om.valueToTree(this.getMatchType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito-identitypool-alpha.RoleMappingRule"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RoleMappingRule.Jsii$Proxy that = (RoleMappingRule.Jsii$Proxy) o;

            if (!claim.equals(that.claim)) return false;
            if (!claimValue.equals(that.claimValue)) return false;
            if (!mappedRole.equals(that.mappedRole)) return false;
            return this.matchType != null ? this.matchType.equals(that.matchType) : that.matchType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.claim.hashCode();
            result = 31 * result + (this.claimValue.hashCode());
            result = 31 * result + (this.mappedRole.hashCode());
            result = 31 * result + (this.matchType != null ? this.matchType.hashCode() : 0);
            return result;
        }
    }
}
