package software.amazon.awscdk.services.cognito.identitypool.alpha;

/**
 * (experimental) Props for the User Pool Authentication Provider.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IdentityPool identityPool;
 * UserPool userPool = new UserPool(this, "Pool");
 * identityPool.addUserPoolAuthentication(UserPoolAuthenticationProvider.Builder.create()
 *         .userPool(userPool)
 *         .disableServerSideTokenCheck(true)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-13T02:49:33.837Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.identitypool.alpha.$Module.class, fqn = "@aws-cdk/aws-cognito-identitypool-alpha.UserPoolAuthenticationProviderProps")
@software.amazon.jsii.Jsii.Proxy(UserPoolAuthenticationProviderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface UserPoolAuthenticationProviderProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The User Pool of the Associated Identity Providers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.IUserPool getUserPool();

    /**
     * (experimental) Setting this to true turns off identity pool checks for this user pool to make sure the user has not been globally signed out or deleted before the identity pool provides an OIDC token or AWS credentials for the user.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitoidentityprovider.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitoidentityprovider.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDisableServerSideTokenCheck() {
        return null;
    }

    /**
     * (experimental) The User Pool Client for the provided User Pool.
     * <p>
     * Default: - A default user pool client will be added to User Pool
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.IUserPoolClient getUserPoolClient() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UserPoolAuthenticationProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserPoolAuthenticationProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<UserPoolAuthenticationProviderProps> {
        software.amazon.awscdk.services.cognito.IUserPool userPool;
        java.lang.Boolean disableServerSideTokenCheck;
        software.amazon.awscdk.services.cognito.IUserPoolClient userPoolClient;

        /**
         * Sets the value of {@link UserPoolAuthenticationProviderProps#getUserPool}
         * @param userPool The User Pool of the Associated Identity Providers. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userPool(software.amazon.awscdk.services.cognito.IUserPool userPool) {
            this.userPool = userPool;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolAuthenticationProviderProps#getDisableServerSideTokenCheck}
         * @param disableServerSideTokenCheck Setting this to true turns off identity pool checks for this user pool to make sure the user has not been globally signed out or deleted before the identity pool provides an OIDC token or AWS credentials for the user.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder disableServerSideTokenCheck(java.lang.Boolean disableServerSideTokenCheck) {
            this.disableServerSideTokenCheck = disableServerSideTokenCheck;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolAuthenticationProviderProps#getUserPoolClient}
         * @param userPoolClient The User Pool Client for the provided User Pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userPoolClient(software.amazon.awscdk.services.cognito.IUserPoolClient userPoolClient) {
            this.userPoolClient = userPoolClient;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserPoolAuthenticationProviderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public UserPoolAuthenticationProviderProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link UserPoolAuthenticationProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPoolAuthenticationProviderProps {
        private final software.amazon.awscdk.services.cognito.IUserPool userPool;
        private final java.lang.Boolean disableServerSideTokenCheck;
        private final software.amazon.awscdk.services.cognito.IUserPoolClient userPoolClient;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.userPool = software.amazon.jsii.Kernel.get(this, "userPool", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.IUserPool.class));
            this.disableServerSideTokenCheck = software.amazon.jsii.Kernel.get(this, "disableServerSideTokenCheck", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.userPoolClient = software.amazon.jsii.Kernel.get(this, "userPoolClient", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.IUserPoolClient.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.userPool = java.util.Objects.requireNonNull(builder.userPool, "userPool is required");
            this.disableServerSideTokenCheck = builder.disableServerSideTokenCheck;
            this.userPoolClient = builder.userPoolClient;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.IUserPool getUserPool() {
            return this.userPool;
        }

        @Override
        public final java.lang.Boolean getDisableServerSideTokenCheck() {
            return this.disableServerSideTokenCheck;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.IUserPoolClient getUserPoolClient() {
            return this.userPoolClient;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("userPool", om.valueToTree(this.getUserPool()));
            if (this.getDisableServerSideTokenCheck() != null) {
                data.set("disableServerSideTokenCheck", om.valueToTree(this.getDisableServerSideTokenCheck()));
            }
            if (this.getUserPoolClient() != null) {
                data.set("userPoolClient", om.valueToTree(this.getUserPoolClient()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito-identitypool-alpha.UserPoolAuthenticationProviderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserPoolAuthenticationProviderProps.Jsii$Proxy that = (UserPoolAuthenticationProviderProps.Jsii$Proxy) o;

            if (!userPool.equals(that.userPool)) return false;
            if (this.disableServerSideTokenCheck != null ? !this.disableServerSideTokenCheck.equals(that.disableServerSideTokenCheck) : that.disableServerSideTokenCheck != null) return false;
            return this.userPoolClient != null ? this.userPoolClient.equals(that.userPoolClient) : that.userPoolClient == null;
        }

        @Override
        public final int hashCode() {
            int result = this.userPool.hashCode();
            result = 31 * result + (this.disableServerSideTokenCheck != null ? this.disableServerSideTokenCheck.hashCode() : 0);
            result = 31 * result + (this.userPoolClient != null ? this.userPoolClient.hashCode() : 0);
            return result;
        }
    }
}
