package software.amazon.awscdk.services.cognito;

/**
 * Types of authentication flow.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool pool = new UserPool(this, "pool");
 * pool.addClient("app-client", UserPoolClientOptions.builder()
 *         .authFlows(AuthFlow.builder()
 *                 .userPassword(true)
 *                 .userSrp(true)
 *                 .build())
 *         .build());
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow.html">https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:44.458Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.AuthFlow")
@software.amazon.jsii.Jsii.Proxy(AuthFlow.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AuthFlow extends software.amazon.jsii.JsiiSerializable {

    /**
     * Enable admin based user password authentication flow.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAdminUserPassword() {
        return null;
    }

    /**
     * Enable custom authentication flow.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCustom() {
        return null;
    }

    /**
     * Enable auth using username & password.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUserPassword() {
        return null;
    }

    /**
     * Enable SRP based authentication.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUserSrp() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AuthFlow}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AuthFlow}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AuthFlow> {
        java.lang.Boolean adminUserPassword;
        java.lang.Boolean custom;
        java.lang.Boolean userPassword;
        java.lang.Boolean userSrp;

        /**
         * Sets the value of {@link AuthFlow#getAdminUserPassword}
         * @param adminUserPassword Enable admin based user password authentication flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adminUserPassword(java.lang.Boolean adminUserPassword) {
            this.adminUserPassword = adminUserPassword;
            return this;
        }

        /**
         * Sets the value of {@link AuthFlow#getCustom}
         * @param custom Enable custom authentication flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder custom(java.lang.Boolean custom) {
            this.custom = custom;
            return this;
        }

        /**
         * Sets the value of {@link AuthFlow#getUserPassword}
         * @param userPassword Enable auth using username & password.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPassword(java.lang.Boolean userPassword) {
            this.userPassword = userPassword;
            return this;
        }

        /**
         * Sets the value of {@link AuthFlow#getUserSrp}
         * @param userSrp Enable SRP based authentication.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userSrp(java.lang.Boolean userSrp) {
            this.userSrp = userSrp;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AuthFlow}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AuthFlow build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AuthFlow}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthFlow {
        private final java.lang.Boolean adminUserPassword;
        private final java.lang.Boolean custom;
        private final java.lang.Boolean userPassword;
        private final java.lang.Boolean userSrp;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.adminUserPassword = software.amazon.jsii.Kernel.get(this, "adminUserPassword", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.custom = software.amazon.jsii.Kernel.get(this, "custom", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.userPassword = software.amazon.jsii.Kernel.get(this, "userPassword", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.userSrp = software.amazon.jsii.Kernel.get(this, "userSrp", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.adminUserPassword = builder.adminUserPassword;
            this.custom = builder.custom;
            this.userPassword = builder.userPassword;
            this.userSrp = builder.userSrp;
        }

        @Override
        public final java.lang.Boolean getAdminUserPassword() {
            return this.adminUserPassword;
        }

        @Override
        public final java.lang.Boolean getCustom() {
            return this.custom;
        }

        @Override
        public final java.lang.Boolean getUserPassword() {
            return this.userPassword;
        }

        @Override
        public final java.lang.Boolean getUserSrp() {
            return this.userSrp;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAdminUserPassword() != null) {
                data.set("adminUserPassword", om.valueToTree(this.getAdminUserPassword()));
            }
            if (this.getCustom() != null) {
                data.set("custom", om.valueToTree(this.getCustom()));
            }
            if (this.getUserPassword() != null) {
                data.set("userPassword", om.valueToTree(this.getUserPassword()));
            }
            if (this.getUserSrp() != null) {
                data.set("userSrp", om.valueToTree(this.getUserSrp()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.AuthFlow"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AuthFlow.Jsii$Proxy that = (AuthFlow.Jsii$Proxy) o;

            if (this.adminUserPassword != null ? !this.adminUserPassword.equals(that.adminUserPassword) : that.adminUserPassword != null) return false;
            if (this.custom != null ? !this.custom.equals(that.custom) : that.custom != null) return false;
            if (this.userPassword != null ? !this.userPassword.equals(that.userPassword) : that.userPassword != null) return false;
            return this.userSrp != null ? this.userSrp.equals(that.userSrp) : that.userSrp == null;
        }

        @Override
        public final int hashCode() {
            int result = this.adminUserPassword != null ? this.adminUserPassword.hashCode() : 0;
            result = 31 * result + (this.custom != null ? this.custom.hashCode() : 0);
            result = 31 * result + (this.userPassword != null ? this.userPassword.hashCode() : 0);
            result = 31 * result + (this.userSrp != null ? this.userSrp.hashCode() : 0);
            return result;
        }
    }
}
