package software.amazon.awscdk.services.cognito;

/**
 * OAuth settings to configure the interaction between the app and this client.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool pool = new UserPool(this, "Pool");
 * ResourceServerScope readOnlyScope = ResourceServerScope.Builder.create().scopeName("read").scopeDescription("Read-only access").build();
 * ResourceServerScope fullAccessScope = ResourceServerScope.Builder.create().scopeName("*").scopeDescription("Full access").build();
 * UserPoolResourceServer userServer = pool.addResourceServer("ResourceServer", UserPoolResourceServerOptions.builder()
 *         .identifier("users")
 *         .scopes(List.of(readOnlyScope, fullAccessScope))
 *         .build());
 * UserPoolClient readOnlyClient = pool.addClient("read-only-client", UserPoolClientOptions.builder()
 *         // ...
 *         .oAuth(OAuthSettings.builder()
 *                 // ...
 *                 .scopes(List.of(OAuthScope.resourceServer(userServer, readOnlyScope)))
 *                 .build())
 *         .build());
 * UserPoolClient fullAccessClient = pool.addClient("full-access-client", UserPoolClientOptions.builder()
 *         // ...
 *         .oAuth(OAuthSettings.builder()
 *                 // ...
 *                 .scopes(List.of(OAuthScope.resourceServer(userServer, fullAccessScope)))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:44.592Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.OAuthSettings")
@software.amazon.jsii.Jsii.Proxy(OAuthSettings.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OAuthSettings extends software.amazon.jsii.JsiiSerializable {

    /**
     * List of allowed redirect URLs for the identity providers.
     * <p>
     * Default: - ['https://example.com'] if either authorizationCodeGrant or implicitCodeGrant flows are enabled, no callback URLs otherwise.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCallbackUrls() {
        return null;
    }

    /**
     * OAuth flows that are allowed with this client.
     * <p>
     * Default: {authorizationCodeGrant:true,implicitCodeGrant:true}
     * <p>
     * @see <a href="- the 'Allowed OAuth Flows' section at https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-app-idp-settings.html">- the 'Allowed OAuth Flows' section at https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-app-idp-settings.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.OAuthFlows getFlows() {
        return null;
    }

    /**
     * List of allowed logout URLs for the identity providers.
     * <p>
     * Default: - no logout URLs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLogoutUrls() {
        return null;
    }

    /**
     * OAuth scopes that are allowed with this client.
     * <p>
     * Default: [OAuthScope.PHONE,OAuthScope.EMAIL,OAuthScope.OPENID,OAuthScope.PROFILE,OAuthScope.COGNITO_ADMIN]
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-app-idp-settings.html">https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-app-idp-settings.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cognito.OAuthScope> getScopes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link OAuthSettings}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OAuthSettings}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OAuthSettings> {
        java.util.List<java.lang.String> callbackUrls;
        software.amazon.awscdk.services.cognito.OAuthFlows flows;
        java.util.List<java.lang.String> logoutUrls;
        java.util.List<software.amazon.awscdk.services.cognito.OAuthScope> scopes;

        /**
         * Sets the value of {@link OAuthSettings#getCallbackUrls}
         * @param callbackUrls List of allowed redirect URLs for the identity providers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder callbackUrls(java.util.List<java.lang.String> callbackUrls) {
            this.callbackUrls = callbackUrls;
            return this;
        }

        /**
         * Sets the value of {@link OAuthSettings#getFlows}
         * @param flows OAuth flows that are allowed with this client.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flows(software.amazon.awscdk.services.cognito.OAuthFlows flows) {
            this.flows = flows;
            return this;
        }

        /**
         * Sets the value of {@link OAuthSettings#getLogoutUrls}
         * @param logoutUrls List of allowed logout URLs for the identity providers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logoutUrls(java.util.List<java.lang.String> logoutUrls) {
            this.logoutUrls = logoutUrls;
            return this;
        }

        /**
         * Sets the value of {@link OAuthSettings#getScopes}
         * @param scopes OAuth scopes that are allowed with this client.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder scopes(java.util.List<? extends software.amazon.awscdk.services.cognito.OAuthScope> scopes) {
            this.scopes = (java.util.List<software.amazon.awscdk.services.cognito.OAuthScope>)scopes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OAuthSettings}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OAuthSettings build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OAuthSettings}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OAuthSettings {
        private final java.util.List<java.lang.String> callbackUrls;
        private final software.amazon.awscdk.services.cognito.OAuthFlows flows;
        private final java.util.List<java.lang.String> logoutUrls;
        private final java.util.List<software.amazon.awscdk.services.cognito.OAuthScope> scopes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.callbackUrls = software.amazon.jsii.Kernel.get(this, "callbackUrls", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.flows = software.amazon.jsii.Kernel.get(this, "flows", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.OAuthFlows.class));
            this.logoutUrls = software.amazon.jsii.Kernel.get(this, "logoutUrls", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.scopes = software.amazon.jsii.Kernel.get(this, "scopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.OAuthScope.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.callbackUrls = builder.callbackUrls;
            this.flows = builder.flows;
            this.logoutUrls = builder.logoutUrls;
            this.scopes = (java.util.List<software.amazon.awscdk.services.cognito.OAuthScope>)builder.scopes;
        }

        @Override
        public final java.util.List<java.lang.String> getCallbackUrls() {
            return this.callbackUrls;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.OAuthFlows getFlows() {
            return this.flows;
        }

        @Override
        public final java.util.List<java.lang.String> getLogoutUrls() {
            return this.logoutUrls;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cognito.OAuthScope> getScopes() {
            return this.scopes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCallbackUrls() != null) {
                data.set("callbackUrls", om.valueToTree(this.getCallbackUrls()));
            }
            if (this.getFlows() != null) {
                data.set("flows", om.valueToTree(this.getFlows()));
            }
            if (this.getLogoutUrls() != null) {
                data.set("logoutUrls", om.valueToTree(this.getLogoutUrls()));
            }
            if (this.getScopes() != null) {
                data.set("scopes", om.valueToTree(this.getScopes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.OAuthSettings"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OAuthSettings.Jsii$Proxy that = (OAuthSettings.Jsii$Proxy) o;

            if (this.callbackUrls != null ? !this.callbackUrls.equals(that.callbackUrls) : that.callbackUrls != null) return false;
            if (this.flows != null ? !this.flows.equals(that.flows) : that.flows != null) return false;
            if (this.logoutUrls != null ? !this.logoutUrls.equals(that.logoutUrls) : that.logoutUrls != null) return false;
            return this.scopes != null ? this.scopes.equals(that.scopes) : that.scopes == null;
        }

        @Override
        public final int hashCode() {
            int result = this.callbackUrls != null ? this.callbackUrls.hashCode() : 0;
            result = 31 * result + (this.flows != null ? this.flows.hashCode() : 0);
            result = 31 * result + (this.logoutUrls != null ? this.logoutUrls.hashCode() : 0);
            result = 31 * result + (this.scopes != null ? this.scopes.hashCode() : 0);
            return result;
        }
    }
}
