package software.amazon.awscdk.services.cognito;

/**
 * Represents a identity provider that integrates with 'Login with Amazon'.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool pool = new UserPool(this, "Pool");
 * UserPoolIdentityProviderAmazon provider = UserPoolIdentityProviderAmazon.Builder.create(this, "Amazon")
 *         .userPool(pool)
 *         .clientId("amzn-client-id")
 *         .clientSecret("amzn-client-secret")
 *         .build();
 * UserPoolClient client = pool.addClient("app-client", UserPoolClientOptions.builder()
 *         // ...
 *         .supportedIdentityProviders(List.of(UserPoolClientIdentityProvider.AMAZON))
 *         .build());
 * client.node.addDependency(provider);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:44.634Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.UserPoolIdentityProviderAmazon")
public class UserPoolIdentityProviderAmazon extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.cognito.IUserPoolIdentityProvider {

    protected UserPoolIdentityProviderAmazon(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected UserPoolIdentityProviderAmazon(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public UserPoolIdentityProviderAmazon(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolIdentityProviderAmazonProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Object configureAttributeMapping() {
        return software.amazon.jsii.Kernel.call(this, "configureAttributeMapping", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The primary identifier of this identity provider.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProviderName() {
        return software.amazon.jsii.Kernel.get(this, "providerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cognito.UserPoolIdentityProviderAmazon}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cognito.UserPoolIdentityProviderAmazon> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cognito.UserPoolIdentityProviderAmazonProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cognito.UserPoolIdentityProviderAmazonProps.Builder();
        }

        /**
         * The user pool to which this construct provides identities.
         * <p>
         * @return {@code this}
         * @param userPool The user pool to which this construct provides identities. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPool(final software.amazon.awscdk.services.cognito.IUserPool userPool) {
            this.props.userPool(userPool);
            return this;
        }

        /**
         * Mapping attributes from the identity provider to standard and custom attributes of the user pool.
         * <p>
         * Default: - no attribute mapping
         * <p>
         * @return {@code this}
         * @param attributeMapping Mapping attributes from the identity provider to standard and custom attributes of the user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributeMapping(final software.amazon.awscdk.services.cognito.AttributeMapping attributeMapping) {
            this.props.attributeMapping(attributeMapping);
            return this;
        }

        /**
         * The client id recognized by 'Login with Amazon' APIs.
         * <p>
         * @return {@code this}
         * @see <a href="https://developer.amazon.com/docs/login-with-amazon/security-profile.html#client-identifier">https://developer.amazon.com/docs/login-with-amazon/security-profile.html#client-identifier</a>
         * @param clientId The client id recognized by 'Login with Amazon' APIs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientId(final java.lang.String clientId) {
            this.props.clientId(clientId);
            return this;
        }

        /**
         * The client secret to be accompanied with clientId for 'Login with Amazon' APIs to authenticate the client.
         * <p>
         * @return {@code this}
         * @see <a href="https://developer.amazon.com/docs/login-with-amazon/security-profile.html#client-identifier">https://developer.amazon.com/docs/login-with-amazon/security-profile.html#client-identifier</a>
         * @param clientSecret The client secret to be accompanied with clientId for 'Login with Amazon' APIs to authenticate the client. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientSecret(final java.lang.String clientSecret) {
            this.props.clientSecret(clientSecret);
            return this;
        }

        /**
         * The types of user profile data to obtain for the Amazon profile.
         * <p>
         * Default: [ profile ]
         * <p>
         * @return {@code this}
         * @see <a href="https://developer.amazon.com/docs/login-with-amazon/customer-profile.html">https://developer.amazon.com/docs/login-with-amazon/customer-profile.html</a>
         * @param scopes The types of user profile data to obtain for the Amazon profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scopes(final java.util.List<java.lang.String> scopes) {
            this.props.scopes(scopes);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cognito.UserPoolIdentityProviderAmazon}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cognito.UserPoolIdentityProviderAmazon build() {
            return new software.amazon.awscdk.services.cognito.UserPoolIdentityProviderAmazon(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
