/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cognito;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.cognito.;
import software.amazon.awscdk.services.cognito.AuthFlow;
import software.amazon.awscdk.services.cognito.IUserPool;
import software.amazon.awscdk.services.cognito.OAuthSettings;
import software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider;
import software.amazon.awscdk.services.cognito.UserPoolClientOptions;
import software.amazon.awscdk.services.cognito.UserPoolClientProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-cognito.UserPoolClientProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface UserPoolClientProps
extends JsiiSerializable,
UserPoolClientOptions {
    @NotNull
    public IUserPool getUserPool();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<UserPoolClientProps> {
        private IUserPool userPool;
        private Duration accessTokenValidity;
        private AuthFlow authFlows;
        private Boolean disableOAuth;
        private Boolean generateSecret;
        private Duration idTokenValidity;
        private OAuthSettings oAuth;
        private Boolean preventUserExistenceErrors;
        private Duration refreshTokenValidity;
        private List<UserPoolClientIdentityProvider> supportedIdentityProviders;
        private String userPoolClientName;

        public Builder userPool(IUserPool userPool) {
            this.userPool = userPool;
            return this;
        }

        public Builder accessTokenValidity(Duration accessTokenValidity) {
            this.accessTokenValidity = accessTokenValidity;
            return this;
        }

        public Builder authFlows(AuthFlow authFlows) {
            this.authFlows = authFlows;
            return this;
        }

        public Builder disableOAuth(Boolean disableOAuth) {
            this.disableOAuth = disableOAuth;
            return this;
        }

        public Builder generateSecret(Boolean generateSecret) {
            this.generateSecret = generateSecret;
            return this;
        }

        public Builder idTokenValidity(Duration idTokenValidity) {
            this.idTokenValidity = idTokenValidity;
            return this;
        }

        public Builder oAuth(OAuthSettings oAuth) {
            this.oAuth = oAuth;
            return this;
        }

        public Builder preventUserExistenceErrors(Boolean preventUserExistenceErrors) {
            this.preventUserExistenceErrors = preventUserExistenceErrors;
            return this;
        }

        public Builder refreshTokenValidity(Duration refreshTokenValidity) {
            this.refreshTokenValidity = refreshTokenValidity;
            return this;
        }

        public Builder supportedIdentityProviders(List<? extends UserPoolClientIdentityProvider> supportedIdentityProviders) {
            this.supportedIdentityProviders = supportedIdentityProviders;
            return this;
        }

        public Builder userPoolClientName(String userPoolClientName) {
            this.userPoolClientName = userPoolClientName;
            return this;
        }

        public UserPoolClientProps build() {
            return new Jsii.Proxy(this.userPool, this.accessTokenValidity, this.authFlows, this.disableOAuth, this.generateSecret, this.idTokenValidity, this.oAuth, this.preventUserExistenceErrors, this.refreshTokenValidity, this.supportedIdentityProviders, this.userPoolClientName);
        }
    }
}

