package software.amazon.awscdk.services.customresources;
/**
 * Properties to provide a Lambda-backed custom resource
 */
public interface CustomResourceProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The Lambda provider that implements this custom resource.
     * 
     * We recommend using a SingletonLambda for this.
     * 
     * Optional, exactly one of lamdaProvider or topicProvider must be set.
     */
    software.amazon.awscdk.services.lambda.LambdaRef getLambdaProvider();
    /**
     * The Lambda provider that implements this custom resource.
     * 
     * We recommend using a SingletonLambda for this.
     * 
     * Optional, exactly one of lamdaProvider or topicProvider must be set.
     */
    void setLambdaProvider(final software.amazon.awscdk.services.lambda.LambdaRef value);
    /**
     * The SNS Topic for the provider that implements this custom resource.
     * 
     * Optional, exactly one of lamdaProvider or topicProvider must be set.
     */
    software.amazon.awscdk.services.sns.TopicRef getTopicProvider();
    /**
     * The SNS Topic for the provider that implements this custom resource.
     * 
     * Optional, exactly one of lamdaProvider or topicProvider must be set.
     */
    void setTopicProvider(final software.amazon.awscdk.services.sns.TopicRef value);
    /**
     * Properties to pass to the Lambda
     */
    java.util.Map<java.lang.String, java.lang.Object> getProperties();
    /**
     * Properties to pass to the Lambda
     */
    void setProperties(final java.util.Map<java.lang.String, java.lang.Object> value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }

    /**
     * A fluent builder class for {@link CustomResourceProps}.
     */
    public static final class Builder {
        private Jsii$Pojo instance = new Jsii$Pojo();

        /**
         * The Lambda provider that implements this custom resource.
         * 
         * We recommend using a SingletonLambda for this.
         * 
         * Optional, exactly one of lamdaProvider or topicProvider must be set.
         */
        public Builder withLambdaProvider(final software.amazon.awscdk.services.lambda.LambdaRef value) {
            this.instance._lambdaProvider = value;
            return this;
        }
        /**
         * The SNS Topic for the provider that implements this custom resource.
         * 
         * Optional, exactly one of lamdaProvider or topicProvider must be set.
         */
        public Builder withTopicProvider(final software.amazon.awscdk.services.sns.TopicRef value) {
            this.instance._topicProvider = value;
            return this;
        }
        /**
         * Properties to pass to the Lambda
         */
        public Builder withProperties(final java.util.Map<java.lang.String, java.lang.Object> value) {
            this.instance._properties = value;
            return this;
        }
        public CustomResourceProps build() {
            CustomResourceProps result = this.instance;
            this.instance = new Jsii$Pojo();
            return result;
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link CustomResourceProps}.
     */
    final class Jsii$Pojo implements CustomResourceProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected software.amazon.awscdk.services.lambda.LambdaRef _lambdaProvider;

        public software.amazon.awscdk.services.lambda.LambdaRef getLambdaProvider() {
            return this._lambdaProvider;
        }
        public void setLambdaProvider(final software.amazon.awscdk.services.lambda.LambdaRef value) {
            this._lambdaProvider = value;
        }

        protected software.amazon.awscdk.services.sns.TopicRef _topicProvider;

        public software.amazon.awscdk.services.sns.TopicRef getTopicProvider() {
            return this._topicProvider;
        }
        public void setTopicProvider(final software.amazon.awscdk.services.sns.TopicRef value) {
            this._topicProvider = value;
        }

        protected java.util.Map<java.lang.String, java.lang.Object> _properties;

        public java.util.Map<java.lang.String, java.lang.Object> getProperties() {
            return this._properties;
        }
        public void setProperties(final java.util.Map<java.lang.String, java.lang.Object> value) {
            this._properties = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.customresources.CustomResourceProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * The Lambda provider that implements this custom resource.
         * 
         * We recommend using a SingletonLambda for this.
         * 
         * Optional, exactly one of lamdaProvider or topicProvider must be set.
         */
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.lambda.LambdaRef getLambdaProvider() {
            return this.jsiiGet("lambdaProvider", software.amazon.awscdk.services.lambda.LambdaRef.class);
        }
        /**
         * The Lambda provider that implements this custom resource.
         * 
         * We recommend using a SingletonLambda for this.
         * 
         * Optional, exactly one of lamdaProvider or topicProvider must be set.
         */
        public void setLambdaProvider(@javax.annotation.Nullable final software.amazon.awscdk.services.lambda.LambdaRef value) {
            this.jsiiSet("lambdaProvider", value);
        }
        /**
         * The SNS Topic for the provider that implements this custom resource.
         * 
         * Optional, exactly one of lamdaProvider or topicProvider must be set.
         */
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.sns.TopicRef getTopicProvider() {
            return this.jsiiGet("topicProvider", software.amazon.awscdk.services.sns.TopicRef.class);
        }
        /**
         * The SNS Topic for the provider that implements this custom resource.
         * 
         * Optional, exactly one of lamdaProvider or topicProvider must be set.
         */
        public void setTopicProvider(@javax.annotation.Nullable final software.amazon.awscdk.services.sns.TopicRef value) {
            this.jsiiSet("topicProvider", value);
        }
        /**
         * Properties to pass to the Lambda
         */
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.Object> getProperties() {
            return this.jsiiGet("properties", java.util.Map.class);
        }
        /**
         * Properties to pass to the Lambda
         */
        public void setProperties(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
            this.jsiiSet("properties", value);
        }
    }
}
