package software.amazon.awscdk.services.customresources;
/**
 * A Lambda that will only ever be added to a stack once.
 * 
 * The lambda is identified using the value of 'uuid'. Run 'uuidgen'
 * for every SingletonLambda you create.
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.customresources.$Module.class, fqn = "@aws-cdk/aws-custom-resources.SingletonLambda")
public class SingletonLambda extends software.amazon.awscdk.services.lambda.LambdaRef {
    protected SingletonLambda(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public SingletonLambda(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.customresources.SingletonLambdaProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }
    /**
     * Adds a permission to the Lambda resource policy.
     */
    public void addPermission(final java.lang.String name, final software.amazon.awscdk.services.lambda.LambdaPermission permission) {
        this.jsiiCall("addPermission", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(permission, "permission is required"))).toArray());
    }
    /**
     * The name of the function.
     */
    public software.amazon.awscdk.services.lambda.FunctionName getFunctionName() {
        return this.jsiiGet("functionName", software.amazon.awscdk.services.lambda.FunctionName.class);
    }
    /**
     * The ARN fo the function.
     */
    public software.amazon.awscdk.services.lambda.FunctionArn getFunctionArn() {
        return this.jsiiGet("functionArn", software.amazon.awscdk.services.lambda.FunctionArn.class);
    }
    /**
     * The IAM role associated with this function.
     */
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.iam.Role getRole() {
        return this.jsiiGet("role", software.amazon.awscdk.services.iam.Role.class);
    }
    /**
     * Whether the addPermission() call adds any permissions
     * 
     * True for new Lambdas, false for imported Lambdas (they might live in different accounts).
     */
    protected java.lang.Boolean getCanCreatePermissions() {
        return this.jsiiGet("canCreatePermissions", java.lang.Boolean.class);
    }
}
