package software.amazon.awscdk.services.customresources;
/**
 * Properties for a newly created singleton Lambda
 */
public interface SingletonLambdaProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.lambda.LambdaProps {
    /**
     * A unique identifier to identify this lambda
     * 
     * The identifier should be unique across all custom resource providers.
     * We recommend generating a UUID per provider.
     */
    java.lang.String getUuid();
    /**
     * A unique identifier to identify this lambda
     * 
     * The identifier should be unique across all custom resource providers.
     * We recommend generating a UUID per provider.
     */
    void setUuid(final java.lang.String value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link SingletonLambdaProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * A unique identifier to identify this lambda
         * 
         * The identifier should be unique across all custom resource providers.
         * We recommend generating a UUID per provider.
         */
        public CodeStep withUuid(final java.lang.String value) {
            return new FullBuilder().withUuid(value);
        }

        public interface CodeStep {
            /**
             * The source code of your Lambda function. You can point to a file in an
             * Amazon Simple Storage Service (Amazon S3) bucket or specify your source
             * code as inline text.
             */
            HandlerStep withCode(final software.amazon.awscdk.services.lambda.LambdaCode value);
        }

        public interface HandlerStep {
            /**
             * The name of the function (within your source code) that Lambda calls to
             * start running your code. For more information, see the Handler property
             * in the AWS Lambda Developer Guide.
             * 
             * NOTE: If you specify your source code as inline text by specifying the
             * ZipFile property within the Code property, specify index.function_name as
             * the handler.
             */
            RuntimeStep withHandler(final java.lang.String value);
        }

        public interface RuntimeStep {
            /**
             * The runtime environment for the Lambda function that you are uploading.
             * For valid values, see the Runtime property in the AWS Lambda Developer
             * Guide.
             */
            Build withRuntime(final software.amazon.awscdk.services.lambda.LambdaRuntime value);
        }

        public interface Build {
            /**
             * @return a new {@link SingletonLambdaProps} object, initialized with the values set on this builder.
             */
            SingletonLambdaProps build();
            /**
             * A description of the function.
             */
            Build withDescription(final java.lang.String value);
            /**
             * The function execution time (in seconds) after which Lambda terminates
             * the function. Because the execution time affects cost, set this value
             * based on the function's expected execution time.
             * @default 3 seconds.
             */
            Build withTimeout(final java.lang.Number value);
            /**
             * Key-value pairs that Lambda caches and makes available for your Lambda
             * functions. Use environment variables to apply configuration changes, such
             * as test and production environment configurations, without changing your
             * Lambda function source code.
             */
            Build withEnvironment(final java.util.Map<java.lang.String, java.lang.Object> value);
            /**
             * A name for the function. If you don't specify a name, AWS CloudFormation
             * generates a unique physical ID and uses that ID for the function's name.
             * For more information, see Name Type.
             */
            Build withFunctionName(final java.lang.String value);
            /**
             * The amount of memory, in MB, that is allocated to your Lambda function.
             * Lambda uses this value to proportionally allocate the amount of CPU
             * power. For more information, see Resource Model in the AWS Lambda
             * Developer Guide.
             * @default The default value is 128 MB
             */
            Build withMemorySize(final java.lang.Number value);
            /**
             * Initial policy statements to add to the created Lambda Role.
             * 
             * You can call `addToRolePolicy` to the created lambda to add statements post creation.
             */
            Build withInitialPolicy(final java.util.List<software.amazon.awscdk.PolicyStatement> value);
            /**
             * Lambda execution role.
             * 
             * This is the role that will be assumed by the function upon execution.
             * It controls the permissions that the function will have. The Role must
             * be assumable by the 'lambda.amazonaws.com' service principal.
             * @default a unique role will be generated for this lambda function. Both supplied and generated roles can always be changed by calling `addToRolePolicy`.
             */
            Build withRole(final software.amazon.awscdk.services.iam.Role value);
        }

        final class FullBuilder implements CodeStep, HandlerStep, RuntimeStep, Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * A unique identifier to identify this lambda
             * 
             * The identifier should be unique across all custom resource providers.
             * We recommend generating a UUID per provider.
             */
            public CodeStep withUuid(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "SingletonLambdaProps#uuid is required");
                this.instance._uuid = value;
                return this;
            }
            /**
             * The source code of your Lambda function. You can point to a file in an
             * Amazon Simple Storage Service (Amazon S3) bucket or specify your source
             * code as inline text.
             */
            public HandlerStep withCode(final software.amazon.awscdk.services.lambda.LambdaCode value) {
                java.util.Objects.requireNonNull(value, "SingletonLambdaProps#code is required");
                this.instance._code = value;
                return this;
            }
            /**
             * A description of the function.
             */
            public Build withDescription(final java.lang.String value) {
                this.instance._description = value;
                return this;
            }
            /**
             * The name of the function (within your source code) that Lambda calls to
             * start running your code. For more information, see the Handler property
             * in the AWS Lambda Developer Guide.
             * 
             * NOTE: If you specify your source code as inline text by specifying the
             * ZipFile property within the Code property, specify index.function_name as
             * the handler.
             */
            public RuntimeStep withHandler(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "SingletonLambdaProps#handler is required");
                this.instance._handler = value;
                return this;
            }
            /**
             * The function execution time (in seconds) after which Lambda terminates
             * the function. Because the execution time affects cost, set this value
             * based on the function's expected execution time.
             * @default 3 seconds.
             */
            public Build withTimeout(final java.lang.Number value) {
                this.instance._timeout = value;
                return this;
            }
            /**
             * Key-value pairs that Lambda caches and makes available for your Lambda
             * functions. Use environment variables to apply configuration changes, such
             * as test and production environment configurations, without changing your
             * Lambda function source code.
             */
            public Build withEnvironment(final java.util.Map<java.lang.String, java.lang.Object> value) {
                this.instance._environment = value;
                return this;
            }
            /**
             * The runtime environment for the Lambda function that you are uploading.
             * For valid values, see the Runtime property in the AWS Lambda Developer
             * Guide.
             */
            public Build withRuntime(final software.amazon.awscdk.services.lambda.LambdaRuntime value) {
                java.util.Objects.requireNonNull(value, "SingletonLambdaProps#runtime is required");
                this.instance._runtime = value;
                return this;
            }
            /**
             * A name for the function. If you don't specify a name, AWS CloudFormation
             * generates a unique physical ID and uses that ID for the function's name.
             * For more information, see Name Type.
             */
            public Build withFunctionName(final java.lang.String value) {
                this.instance._functionName = value;
                return this;
            }
            /**
             * The amount of memory, in MB, that is allocated to your Lambda function.
             * Lambda uses this value to proportionally allocate the amount of CPU
             * power. For more information, see Resource Model in the AWS Lambda
             * Developer Guide.
             * @default The default value is 128 MB
             */
            public Build withMemorySize(final java.lang.Number value) {
                this.instance._memorySize = value;
                return this;
            }
            /**
             * Initial policy statements to add to the created Lambda Role.
             * 
             * You can call `addToRolePolicy` to the created lambda to add statements post creation.
             */
            public Build withInitialPolicy(final java.util.List<software.amazon.awscdk.PolicyStatement> value) {
                this.instance._initialPolicy = value;
                return this;
            }
            /**
             * Lambda execution role.
             * 
             * This is the role that will be assumed by the function upon execution.
             * It controls the permissions that the function will have. The Role must
             * be assumable by the 'lambda.amazonaws.com' service principal.
             * @default a unique role will be generated for this lambda function. Both supplied and generated roles can always be changed by calling `addToRolePolicy`.
             */
            public Build withRole(final software.amazon.awscdk.services.iam.Role value) {
                this.instance._role = value;
                return this;
            }
            public SingletonLambdaProps build() {
                SingletonLambdaProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link SingletonLambdaProps}.
     */
    final class Jsii$Pojo implements SingletonLambdaProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.String _uuid;

        public java.lang.String getUuid() {
            return this._uuid;
        }
        public void setUuid(final java.lang.String value) {
            this._uuid = value;
        }

        protected software.amazon.awscdk.services.lambda.LambdaCode _code;

        public software.amazon.awscdk.services.lambda.LambdaCode getCode() {
            return this._code;
        }
        public void setCode(final software.amazon.awscdk.services.lambda.LambdaCode value) {
            this._code = value;
        }

        protected java.lang.String _description;

        public java.lang.String getDescription() {
            return this._description;
        }
        public void setDescription(final java.lang.String value) {
            this._description = value;
        }

        protected java.lang.String _handler;

        public java.lang.String getHandler() {
            return this._handler;
        }
        public void setHandler(final java.lang.String value) {
            this._handler = value;
        }

        protected java.lang.Number _timeout;

        public java.lang.Number getTimeout() {
            return this._timeout;
        }
        public void setTimeout(final java.lang.Number value) {
            this._timeout = value;
        }

        protected java.util.Map<java.lang.String, java.lang.Object> _environment;

        public java.util.Map<java.lang.String, java.lang.Object> getEnvironment() {
            return this._environment;
        }
        public void setEnvironment(final java.util.Map<java.lang.String, java.lang.Object> value) {
            this._environment = value;
        }

        protected software.amazon.awscdk.services.lambda.LambdaRuntime _runtime;

        public software.amazon.awscdk.services.lambda.LambdaRuntime getRuntime() {
            return this._runtime;
        }
        public void setRuntime(final software.amazon.awscdk.services.lambda.LambdaRuntime value) {
            this._runtime = value;
        }

        protected java.lang.String _functionName;

        public java.lang.String getFunctionName() {
            return this._functionName;
        }
        public void setFunctionName(final java.lang.String value) {
            this._functionName = value;
        }

        protected java.lang.Number _memorySize;

        public java.lang.Number getMemorySize() {
            return this._memorySize;
        }
        public void setMemorySize(final java.lang.Number value) {
            this._memorySize = value;
        }

        protected java.util.List<software.amazon.awscdk.PolicyStatement> _initialPolicy;

        public java.util.List<software.amazon.awscdk.PolicyStatement> getInitialPolicy() {
            return this._initialPolicy;
        }
        public void setInitialPolicy(final java.util.List<software.amazon.awscdk.PolicyStatement> value) {
            this._initialPolicy = value;
        }

        protected software.amazon.awscdk.services.iam.Role _role;

        public software.amazon.awscdk.services.iam.Role getRole() {
            return this._role;
        }
        public void setRole(final software.amazon.awscdk.services.iam.Role value) {
            this._role = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.customresources.SingletonLambdaProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * A unique identifier to identify this lambda
         * 
         * The identifier should be unique across all custom resource providers.
         * We recommend generating a UUID per provider.
         */
        public java.lang.String getUuid() {
            return this.jsiiGet("uuid", java.lang.String.class);
        }
        /**
         * A unique identifier to identify this lambda
         * 
         * The identifier should be unique across all custom resource providers.
         * We recommend generating a UUID per provider.
         */
        public void setUuid(final java.lang.String value) {
            this.jsiiSet("uuid", java.util.Objects.requireNonNull(value, "uuid is required"));
        }
        /**
         * The source code of your Lambda function. You can point to a file in an
         * Amazon Simple Storage Service (Amazon S3) bucket or specify your source
         * code as inline text.
         */
        public software.amazon.awscdk.services.lambda.LambdaCode getCode() {
            return this.jsiiGet("code", software.amazon.awscdk.services.lambda.LambdaCode.class);
        }
        /**
         * The source code of your Lambda function. You can point to a file in an
         * Amazon Simple Storage Service (Amazon S3) bucket or specify your source
         * code as inline text.
         */
        public void setCode(final software.amazon.awscdk.services.lambda.LambdaCode value) {
            this.jsiiSet("code", java.util.Objects.requireNonNull(value, "code is required"));
        }
        /**
         * A description of the function.
         */
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }
        /**
         * A description of the function.
         */
        public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("description", value);
        }
        /**
         * The name of the function (within your source code) that Lambda calls to
         * start running your code. For more information, see the Handler property
         * in the AWS Lambda Developer Guide.
         * 
         * NOTE: If you specify your source code as inline text by specifying the
         * ZipFile property within the Code property, specify index.function_name as
         * the handler.
         */
        public java.lang.String getHandler() {
            return this.jsiiGet("handler", java.lang.String.class);
        }
        /**
         * The name of the function (within your source code) that Lambda calls to
         * start running your code. For more information, see the Handler property
         * in the AWS Lambda Developer Guide.
         * 
         * NOTE: If you specify your source code as inline text by specifying the
         * ZipFile property within the Code property, specify index.function_name as
         * the handler.
         */
        public void setHandler(final java.lang.String value) {
            this.jsiiSet("handler", java.util.Objects.requireNonNull(value, "handler is required"));
        }
        /**
         * The function execution time (in seconds) after which Lambda terminates
         * the function. Because the execution time affects cost, set this value
         * based on the function's expected execution time.
         * @default 3 seconds.
         */
        @javax.annotation.Nullable
        public java.lang.Number getTimeout() {
            return this.jsiiGet("timeout", java.lang.Number.class);
        }
        /**
         * The function execution time (in seconds) after which Lambda terminates
         * the function. Because the execution time affects cost, set this value
         * based on the function's expected execution time.
         * @default 3 seconds.
         */
        public void setTimeout(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("timeout", value);
        }
        /**
         * Key-value pairs that Lambda caches and makes available for your Lambda
         * functions. Use environment variables to apply configuration changes, such
         * as test and production environment configurations, without changing your
         * Lambda function source code.
         */
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.Object> getEnvironment() {
            return this.jsiiGet("environment", java.util.Map.class);
        }
        /**
         * Key-value pairs that Lambda caches and makes available for your Lambda
         * functions. Use environment variables to apply configuration changes, such
         * as test and production environment configurations, without changing your
         * Lambda function source code.
         */
        public void setEnvironment(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
            this.jsiiSet("environment", value);
        }
        /**
         * The runtime environment for the Lambda function that you are uploading.
         * For valid values, see the Runtime property in the AWS Lambda Developer
         * Guide.
         */
        public software.amazon.awscdk.services.lambda.LambdaRuntime getRuntime() {
            return this.jsiiGet("runtime", software.amazon.awscdk.services.lambda.LambdaRuntime.class);
        }
        /**
         * The runtime environment for the Lambda function that you are uploading.
         * For valid values, see the Runtime property in the AWS Lambda Developer
         * Guide.
         */
        public void setRuntime(final software.amazon.awscdk.services.lambda.LambdaRuntime value) {
            this.jsiiSet("runtime", java.util.Objects.requireNonNull(value, "runtime is required"));
        }
        /**
         * A name for the function. If you don't specify a name, AWS CloudFormation
         * generates a unique physical ID and uses that ID for the function's name.
         * For more information, see Name Type.
         */
        @javax.annotation.Nullable
        public java.lang.String getFunctionName() {
            return this.jsiiGet("functionName", java.lang.String.class);
        }
        /**
         * A name for the function. If you don't specify a name, AWS CloudFormation
         * generates a unique physical ID and uses that ID for the function's name.
         * For more information, see Name Type.
         */
        public void setFunctionName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("functionName", value);
        }
        /**
         * The amount of memory, in MB, that is allocated to your Lambda function.
         * Lambda uses this value to proportionally allocate the amount of CPU
         * power. For more information, see Resource Model in the AWS Lambda
         * Developer Guide.
         * @default The default value is 128 MB
         */
        @javax.annotation.Nullable
        public java.lang.Number getMemorySize() {
            return this.jsiiGet("memorySize", java.lang.Number.class);
        }
        /**
         * The amount of memory, in MB, that is allocated to your Lambda function.
         * Lambda uses this value to proportionally allocate the amount of CPU
         * power. For more information, see Resource Model in the AWS Lambda
         * Developer Guide.
         * @default The default value is 128 MB
         */
        public void setMemorySize(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("memorySize", value);
        }
        /**
         * Initial policy statements to add to the created Lambda Role.
         * 
         * You can call `addToRolePolicy` to the created lambda to add statements post creation.
         */
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.PolicyStatement> getInitialPolicy() {
            return this.jsiiGet("initialPolicy", java.util.List.class);
        }
        /**
         * Initial policy statements to add to the created Lambda Role.
         * 
         * You can call `addToRolePolicy` to the created lambda to add statements post creation.
         */
        public void setInitialPolicy(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.PolicyStatement> value) {
            this.jsiiSet("initialPolicy", value);
        }
        /**
         * Lambda execution role.
         * 
         * This is the role that will be assumed by the function upon execution.
         * It controls the permissions that the function will have. The Role must
         * be assumable by the 'lambda.amazonaws.com' service principal.
         * @default a unique role will be generated for this lambda function. Both supplied and generated roles can always be changed by calling `addToRolePolicy`.
         */
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.iam.Role getRole() {
            return this.jsiiGet("role", software.amazon.awscdk.services.iam.Role.class);
        }
        /**
         * Lambda execution role.
         * 
         * This is the role that will be assumed by the function upon execution.
         * It controls the permissions that the function will have. The Role must
         * be assumable by the 'lambda.amazonaws.com' service principal.
         * @default a unique role will be generated for this lambda function. Both supplied and generated roles can always be changed by calling `addToRolePolicy`.
         */
        public void setRole(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.Role value) {
            this.jsiiSet("role", value);
        }
    }
}
