/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.dax;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.dax.;
import software.amazon.awscdk.services.dax.CfnCluster;
import software.amazon.awscdk.services.dax.CfnClusterProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-dax.CfnCluster")
public class CfnCluster
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnCluster.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnCluster(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCluster(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnCluster(@NotNull Construct scope, @NotNull String id, @NotNull CfnClusterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrClusterDiscoveryEndpoint() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrClusterDiscoveryEndpoint", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)Kernel.get((Object)((Object)this), (String)"tags", (NativeType)NativeType.forClass(TagManager.class));
    }

    @NotNull
    public String getIamRoleArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"iamRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setIamRoleArn(@NotNull String value) {
        Kernel.set((Object)((Object)this), (String)"iamRoleArn", (Object)Objects.requireNonNull(value, "iamRoleArn is required"));
    }

    @NotNull
    public String getNodeType() {
        return (String)Kernel.get((Object)((Object)this), (String)"nodeType", (NativeType)NativeType.forClass(String.class));
    }

    public void setNodeType(@NotNull String value) {
        Kernel.set((Object)((Object)this), (String)"nodeType", (Object)Objects.requireNonNull(value, "nodeType is required"));
    }

    @NotNull
    public Number getReplicationFactor() {
        return (Number)Kernel.get((Object)((Object)this), (String)"replicationFactor", (NativeType)NativeType.forClass(Number.class));
    }

    public void setReplicationFactor(@NotNull Number value) {
        Kernel.set((Object)((Object)this), (String)"replicationFactor", (Object)Objects.requireNonNull(value, "replicationFactor is required"));
    }

    @Nullable
    public List<String> getAvailabilityZones() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"availabilityZones", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setAvailabilityZones(@Nullable List<String> value) {
        Kernel.set((Object)((Object)this), (String)"availabilityZones", value);
    }

    @Nullable
    public String getClusterName() {
        return (String)Kernel.get((Object)((Object)this), (String)"clusterName", (NativeType)NativeType.forClass(String.class));
    }

    public void setClusterName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"clusterName", (Object)value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)((Object)this), (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"description", (Object)value);
    }

    @Nullable
    public String getNotificationTopicArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"notificationTopicArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setNotificationTopicArn(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"notificationTopicArn", (Object)value);
    }

    @Nullable
    public String getParameterGroupName() {
        return (String)Kernel.get((Object)((Object)this), (String)"parameterGroupName", (NativeType)NativeType.forClass(String.class));
    }

    public void setParameterGroupName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"parameterGroupName", (Object)value);
    }

    @Nullable
    public String getPreferredMaintenanceWindow() {
        return (String)Kernel.get((Object)((Object)this), (String)"preferredMaintenanceWindow", (NativeType)NativeType.forClass(String.class));
    }

    public void setPreferredMaintenanceWindow(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"preferredMaintenanceWindow", (Object)value);
    }

    @Nullable
    public List<String> getSecurityGroupIds() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"securityGroupIds", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setSecurityGroupIds(@Nullable List<String> value) {
        Kernel.set((Object)((Object)this), (String)"securityGroupIds", value);
    }

    @Nullable
    public Object getSseSpecification() {
        return Kernel.get((Object)((Object)this), (String)"sseSpecification", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSseSpecification(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"sseSpecification", (Object)value);
    }

    public void setSseSpecification(@Nullable SSESpecificationProperty value) {
        Kernel.set((Object)((Object)this), (String)"sseSpecification", (Object)value);
    }

    @Nullable
    public String getSubnetGroupName() {
        return (String)Kernel.get((Object)((Object)this), (String)"subnetGroupName", (NativeType)NativeType.forClass(String.class));
    }

    public void setSubnetGroupName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"subnetGroupName", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnCluster> {
        private final Construct scope;
        private final String id;
        private final CfnClusterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnClusterProps.Builder();
        }

        public Builder iamRoleArn(String iamRoleArn) {
            this.props.iamRoleArn(iamRoleArn);
            return this;
        }

        public Builder nodeType(String nodeType) {
            this.props.nodeType(nodeType);
            return this;
        }

        public Builder replicationFactor(Number replicationFactor) {
            this.props.replicationFactor(replicationFactor);
            return this;
        }

        public Builder availabilityZones(List<String> availabilityZones) {
            this.props.availabilityZones(availabilityZones);
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.props.clusterName(clusterName);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder notificationTopicArn(String notificationTopicArn) {
            this.props.notificationTopicArn(notificationTopicArn);
            return this;
        }

        public Builder parameterGroupName(String parameterGroupName) {
            this.props.parameterGroupName(parameterGroupName);
            return this;
        }

        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.props.preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        public Builder securityGroupIds(List<String> securityGroupIds) {
            this.props.securityGroupIds(securityGroupIds);
            return this;
        }

        public Builder sseSpecification(IResolvable sseSpecification) {
            this.props.sseSpecification(sseSpecification);
            return this;
        }

        public Builder sseSpecification(SSESpecificationProperty sseSpecification) {
            this.props.sseSpecification(sseSpecification);
            return this;
        }

        public Builder subnetGroupName(String subnetGroupName) {
            this.props.subnetGroupName(subnetGroupName);
            return this;
        }

        public Builder tags(Object tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnCluster build() {
            return new CfnCluster(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-dax.CfnCluster.SSESpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SSESpecificationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getSseEnabled() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SSESpecificationProperty> {
            private Object sseEnabled;

            public Builder sseEnabled(Boolean sseEnabled) {
                this.sseEnabled = sseEnabled;
                return this;
            }

            public Builder sseEnabled(IResolvable sseEnabled) {
                this.sseEnabled = sseEnabled;
                return this;
            }

            public SSESpecificationProperty build() {
                return new Jsii.Proxy(this.sseEnabled);
            }
        }
    }
}

